/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKeyFactory;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class NonPrintableAsciiEncryptDecrypt {
    public static byte[] encrypt(char[] password, PrivateKey pk, AlgorithmId algid) throws PKCSException {
        if (password == null || password.length == 0) {
            throw new InvalidParameterException("password is null or empty");
        }
        if (pk == null) {
            throw new InvalidParameterException("private key is null");
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(password);
            NonPrintableAsciiPBEKeyFactory factory = new NonPrintableAsciiPBEKeyFactory();
            SecretKey key = factory.engineGenerateSecret(spec);
            Cipher cipher = Cipher.getInstance(algid.getName());
            cipher.init(1, key);
            byte[] encryptedKey = cipher.doFinal(pk.getEncoded());
            if (algid.getParameters() == null) {
                algid = new AlgorithmId(algid.getOID(), cipher.getParameters());
            }
            DerOutputStream stream1 = new DerOutputStream();
            DerOutputStream stream2 = new DerOutputStream();
            algid.derEncode((OutputStream)stream1);
            stream1.putOctetString(encryptedKey);
            stream2.write((byte)48, stream1);
            return stream2.toByteArray();
        }
        catch (InvalidKeyException e) {
            throw new PKCSException((Exception)e, "Error initialising cipher");
        }
        catch (InvalidKeySpecException e) {
            throw new PKCSException((Exception)e, "Error generating encryption key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKCSException((Exception)e, "Error initialising cipher");
        }
        catch (NoSuchPaddingException e) {
            throw new PKCSException((Exception)e, "Error initialising cipher");
        }
        catch (IllegalBlockSizeException e) {
            throw new PKCSException((Exception)e, "Error encrypting key");
        }
        catch (BadPaddingException e) {
            throw new PKCSException((Exception)e, "Error encrypting key");
        }
        catch (IOException e) {
            throw new PKCSException((Exception)e, e.toString());
        }
    }

    public static byte[] decrypt(byte[] encryptedKey, char[] password, AlgorithmId algid) throws PKCSException {
        if (password == null || password.length == 0) {
            throw new InvalidParameterException("password is null or empty");
        }
        if (encryptedKey == null) {
            throw new InvalidParameterException("encrypted key is null");
        }
        try {
            AlgorithmParameters params = algid.getAlgParameters();
            PBEKeySpec keySpec = new PBEKeySpec(password);
            NonPrintableAsciiPBEKeyFactory factory = new NonPrintableAsciiPBEKeyFactory();
            SecretKey key = factory.engineGenerateSecret(keySpec);
            Cipher cipher = Cipher.getInstance(algid.getName());
            cipher.init(2, (Key)key, params);
            return cipher.doFinal(encryptedKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Error initialising cipher", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Error generating decryption key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error initialising cipher", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Error initialising cipher", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Error initialising cipher", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Error decrypting data", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Error decrypting data", e);
        }
    }
}

