/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spi;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.MSCertificateStore;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.spi.CertificateAlreadyExistsException;
import com.ibm.spi.CopyFile;
import com.ibm.spi.IBMKeyStoreSpi;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CMSKeyStoreSpi
extends KeyStoreSpi
implements IBMKeyStoreSpi {
    private static final int KEY_STORE_TYPE_CMS = 1;
    private static final int KEY_STORE_TYPE_MSCSP = 2;
    private CMSKeyDatabase cmsKeyDatabase = null;
    private MSCertificateStore msCertificateStore = null;
    private File writeFile;
    private File rdbFile;
    private File crlFile;
    private int type;
    private String cspName;
    private boolean jniStatus = false;
    private boolean fileStatus = false;
    private String keyDBPassword;
    boolean initialized;

    public CMSKeyStoreSpi() {
        KMUtil.debugMsg("CMSKeyStoreSpi::CMSKeyStoreSpi() 0000");
        this.initialized = false;
        KMSystem.init();
        if (KMSystem.isJNIEnabled()) {
            this.jniStatus = true;
        }
        try {
            this.fileStatus = false;
            this.writeFile = File.createTempFile("CMSdb", null, null);
            this.rdbFile = new File(this.writeFile.getPath().substring(0, this.writeFile.getPath().lastIndexOf(46) + 1) + "rdb");
            this.crlFile = new File(this.writeFile.getPath().substring(0, this.writeFile.getPath().lastIndexOf(46) + 1) + "crl");
            this.fileStatus = true;
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::CMSKeyStoreSpi() 0100, Exception=" + exception);
        }
        if (this.fileStatus) {
            this.writeFile.deleteOnExit();
            this.rdbFile.deleteOnExit();
            this.crlFile.deleteOnExit();
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::CMSKeyStoreSpi() 9999");
    }

    public String toString() {
        return "CMSKeyStoreSpi with CMS database\n" + this.cmsKeyDatabase + "\nJNI ready: " + this.jniStatus + "\nFile Status: " + this.fileStatus;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyItem keyItem = null;
        if (!this.keyDBPassword.equals(new String(cArray)) && cArray != null) {
            throw new UnrecoverableKeyException("The password supplied is invalid, it must be either null or match the KeyStore password");
        }
        try {
            if (this.type == 1) {
                keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            } else if (this.type == 2) {
                keyItem = this.msCertificateStore.getKeyItemByLabel(string);
            }
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Error during KeyItem extraction");
        }
        try {
            EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
            if (encryptedPrivateKeyInfoItem != null) {
                PrivateKeyInfoItem privateKeyInfoItem = CMSKeyDatabase.c_DecryptPrivateKey(encryptedPrivateKeyInfoItem.getLength(), encryptedPrivateKeyInfoItem.getEncoded(), this.keyDBPassword);
                byte[] byArray = privateKeyInfoItem.getEncoded();
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", KeyStoreManager.JCEProvider);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                return privateKey;
            }
            return null;
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Error recovering key:" + exception.getMessage());
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 0000, alias=" + string);
        KeyItem[] keyItemArray = null;
        if (!this.engineContainsAlias(string)) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 9999-1");
            return null;
        }
        try {
            if (this.type == 1) {
                keyItemArray = this.cmsKeyDatabase.getKeyItemListByLabel(string);
            } else if (this.type == 2) {
                keyItemArray = this.msCertificateStore.getKeyItemListByLabel(string);
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 9999-2, Exception=" + exception);
            return null;
        }
        int n = keyItemArray.length;
        CertificateItem[] certificateItemArray = new CertificateItem[n];
        int n2 = 0;
        while (n2 < n) {
            if (!keyItemArray[n2].hasCertificate()) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 9999-3");
                return null;
            }
            certificateItemArray[n2] = (CertificateItem)keyItemArray[n2].getCertificateChain().elementAt(0);
            ++n2;
        }
        CertificateItem[] certificateItemArray2 = new CertificateItem[n];
        certificateItemArray2[0] = certificateItemArray[0];
        n2 = 1;
        while (n2 < n) {
            certificateItemArray2[n2] = certificateItemArray[n - n2];
            ++n2;
        }
        X509CertImpl[] x509CertImplArray = new X509CertImpl[n];
        try {
            n2 = 0;
            while (n2 < n) {
                x509CertImplArray[n2] = new X509CertImpl(certificateItemArray2[n2].getEncoded());
                ++n2;
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 9999-4, Exception=" + exception);
            return null;
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineGetCertificateChain 9999-5");
        return x509CertImplArray;
    }

    public Certificate engineGetCertificate(String string) {
        if (!this.engineContainsAlias(string)) {
            return null;
        }
        KeyItem keyItem = null;
        try {
            if (this.type == 1) {
                keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            } else if (this.type == 2) {
                keyItem = this.msCertificateStore.getKeyItemByLabel(string);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (!keyItem.hasCertificate()) {
            return null;
        }
        Vector vector = keyItem.getCertificateChain();
        try {
            CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
            return new X509CertImpl(certificateItem.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date engineGetCreationDate(String string) {
        return new Date(this.writeFile.lastModified());
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem;
        Object object;
        int n;
        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0000");
        if (!key.getAlgorithm().equals("RSA") && !key.getAlgorithm().equals("DSA")) {
            throw new KeyStoreException("Algorithm not RSA or DSA.");
        }
        if (!key.getFormat().equals("PKCS#8")) {
            throw new KeyStoreException("This key does not support encoding to PKCS#8");
        }
        if (cArray != null && !this.keyDBPassword.equals(new String(cArray))) {
            throw new KeyStoreException("Password must be the same as the DB password or null!");
        }
        if (certificateArray != null) {
            n = 0;
            while (n < certificateArray.length) {
                if (!(certificateArray[n] instanceof X509Certificate)) {
                    throw new KeyStoreException("One of the chain elements is not an X509Certificate");
                }
                ++n;
            }
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0100");
        try {
            byte[] byArray = key.getEncoded();
            object = new PrivateKeyInfoItem(byArray);
            encryptedPrivateKeyInfoItem = CMSKeyDatabase.encryptPrivateKey((PrivateKeyInfoItem)object, this.keyDBPassword);
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0200, Exception=" + exception);
            throw new KeyStoreException("Error during encryption of PKCS#8 " + exception.toString());
        }
        short s = 0;
        object = null;
        CertificateItem[] certificateItemArray = new CertificateItem[1];
        if (certificateArray != null) {
            n = certificateArray.length - 1;
            while (n >= 0) {
                if (this.engineGetCertificateAlias(certificateArray[n]) == null || n == 0) {
                    try {
                        certificateItemArray[0] = new CertificateItem(((X509Certificate)certificateArray[n]).getEncoded());
                        if (certificateItemArray[0] == null) {
                            throw new Exception("null reference");
                        }
                    }
                    catch (Exception exception) {
                        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0400, Exception=" + exception);
                        throw new KeyStoreException("Error during conversion of X509Certificate #" + n + ", " + exception.toString());
                    }
                    s = certificateItemArray[0].getKeySize();
                    if (n != 0) {
                        String string2 = ((X509Certificate)certificateArray[n]).getSubjectDN().getName();
                        int n2 = string2.indexOf("cn=");
                        if (n2 == -1 && (n2 = string2.indexOf("CN=")) == -1 && (n2 = string2.indexOf("ou=")) == -1 && (n2 = string2.indexOf("OU=")) == -1) {
                            throw new KeyStoreException("Cannot find a suitable string for signer alias, " + string2);
                        }
                        int n3 = string2.indexOf(", ", n2);
                        object = n3 == -1 ? string2.substring(n2 + 3) : string2.substring(n2 + 3, n3);
                        if (this.engineContainsAlias((String)object)) {
                            throw new KeyStoreException("Alias \"" + (String)object + "\" for signer cert already exists");
                        }
                        KeyItem keyItem = new KeyItem((String)object, 1, s, null, certificateItemArray, null, true, false);
                        try {
                            if (this.type == 1) {
                                this.cmsKeyDatabase.insertKey(keyItem);
                            } else if (this.type == 2) {
                                this.msCertificateStore.importCertificate(keyItem);
                            }
                        }
                        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
                            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0600, CMSKeyDatabaseException=" + cMSKeyDatabaseException);
                            int n4 = cMSKeyDatabaseException.getErrCode();
                            String string3 = CMSKeyDatabaseException.getErrKey(n4);
                            if (!string3.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                                throw new KeyStoreException("Insertion error " + cMSKeyDatabaseException.toString());
                            }
                        }
                        catch (KMException kMException) {
                            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0610, KMException=" + kMException);
                            if (kMException.getErrCodeName().equals("GSKKM_ERR_IO")) {
                                throw new KeyStoreException("User canceled");
                            }
                            throw new KeyStoreException("Insertion error " + kMException.toString());
                        }
                        catch (Exception exception) {
                            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0620, Exception=" + exception);
                            throw new KeyStoreException("Insertion error " + exception.toString());
                        }
                    }
                }
                --n;
            }
        }
        KeyItem keyItem = new KeyItem(string, 1, s, encryptedPrivateKeyInfoItem, certificateItemArray, null, true, false);
        if (this.engineContainsAlias(string)) {
            this.engineDeleteEntry(string);
        }
        try {
            if (this.type == 1) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0720");
                this.cmsKeyDatabase.insertKey(keyItem);
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0730");
            } else if (this.type == 2) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0740");
                this.msCertificateStore.importCertificate(keyItem);
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 0750");
            }
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 1000, CMSKeyDatabaseException=" + cMSKeyDatabaseException);
            int n5 = cMSKeyDatabaseException.getErrCode();
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 1001, errCode=" + n5);
            String string4 = CMSKeyDatabaseException.getErrKey(n5);
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 1002, errKey=" + string4);
            if (string4.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                throw new CertificateAlreadyExistsException("User certificate already exists in the key database");
            }
            if (string4.equals("GSKKM_ERR_INVALID_CERT_CHAIN")) {
                throw new KeyStoreException("INVALID_CERT_CHAIN");
            }
            throw new KeyStoreException("Insertion error " + cMSKeyDatabaseException.toString());
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 1010, Exception=" + exception);
            throw new KeyStoreException("Insertion error " + exception.toString());
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetKeyEntry 9999");
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("CMS cannot accept externally encoded PKCS#8 objects");
    }

    public CertificateItem parseCertificate(Certificate certificate, byte[] byArray) throws KeyStoreException {
        try {
            if (certificate == null) {
                return null;
            }
            X509CertImpl x509CertImpl = new X509CertImpl(certificate.getEncoded());
            PublicKey publicKey = certificate.getPublicKey();
            int n = 0;
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
            if (n % 2 != 0) {
                ++n;
            }
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
            try {
                string = x500Name.getCommonName();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8000, Exception=" + exception);
                string = "<invalid issuer cn>";
            }
            try {
                string2 = x500Name.getOrganizationalUnit();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8010, Exception=" + exception);
                string2 = "<invalid issuer ou>";
            }
            try {
                string3 = x500Name.getOrganization();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8020, Exception=" + exception);
                string3 = "<invalid orgnanization name>";
            }
            try {
                string4 = x500Name.getCountry();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8030, Exception=" + exception);
                string4 = "<invalid country name>";
            }
            X500Name x500Name2 = (X500Name)x509CertImpl.getSubjectDN();
            try {
                string5 = x500Name2.getCommonName();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8040, Exception=" + exception);
                string5 = "<invalid subject cn>";
            }
            try {
                string6 = x500Name2.getOrganizationalUnit();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8050, Exception=" + exception);
                string6 = "<invalid subject ou>";
            }
            try {
                string7 = x500Name2.getOrganization();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8060, Exception=" + exception);
                string7 = "<invalid subject origination name>";
            }
            try {
                string8 = x500Name2.getCountry();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 8070, Exception=" + exception);
                string8 = "<invalid subject country name>";
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            DNItem dNItem2 = new DNItem(string5, string6, string7, string8);
            AlgorithmId algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
            X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
            CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
            CertificateItem certificateItem = null;
            if (certificateExtensions != null) {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 0200");
                DerOutputStream derOutputStream = new DerOutputStream();
                certificateExtensions.encode((OutputStream)derOutputStream);
                certificateItem = new CertificateItem((short)((X509Certificate)certificate).getVersion(), (short)n, ((X509Certificate)certificate).getSerialNumber().toString(), dNItem, dNItem2, ((X509Certificate)certificate).getNotBefore(), ((X509Certificate)certificate).getNotAfter(), new BERObject(certificate.getPublicKey().getEncoded()), new BERObject(derOutputStream.toByteArray()), ((X509Certificate)certificate).getSignature(), new BERObject(algorithmId.encode()), x509CertImpl.getSigAlgOID(), x509CertImpl.getSigAlgName(), byArray);
            } else {
                KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 0300");
                certificateItem = new CertificateItem((short)((X509Certificate)certificate).getVersion(), (short)n, ((X509Certificate)certificate).getSerialNumber().toString(), dNItem, dNItem2, ((X509Certificate)certificate).getNotBefore(), ((X509Certificate)certificate).getNotAfter(), new BERObject(certificate.getPublicKey().getEncoded()), null, ((X509Certificate)certificate).getSignature(), new BERObject(algorithmId.encode()), x509CertImpl.getSigAlgOID(), x509CertImpl.getSigAlgName(), byArray);
            }
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999");
            return certificateItem;
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999-1, IOException=" + iOException);
            throw new KeyStoreException("IOException");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999-2, InvalidKeySpecException=" + invalidKeySpecException);
            throw new KeyStoreException(invalidKeySpecException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999-3, CertificateEncodingException=" + certificateEncodingException);
            throw new KeyStoreException(certificateEncodingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999-4, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw new KeyStoreException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::parseCertificate() 9999-5, CertificateException=" + certificateException);
            throw new KeyStoreException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string)) {
            if (!this.engineIsCertificateEntry(string)) {
                throw new KeyStoreException("Alias already exists and is not a trusted entry");
            }
            this.engineDeleteEntry(string);
        }
        KeyItem keyItem = new KeyItem();
        keyItem.setKeyLabel(string);
        try {
            if (certificate != null) {
                byte[] byArray = certificate.getEncoded();
                CertificateItem certificateItem = new CertificateItem(byArray);
                CertificateItem certificateItem2 = this.parseCertificate(certificate, byArray);
                keyItem.addCertificate(certificateItem2);
                keyItem.setTrusted(true);
            }
            if (this.type == 1) {
                this.cmsKeyDatabase.insertKey(keyItem);
            } else if (this.type == 2) {
                this.msCertificateStore.importCertificate(keyItem);
            }
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            int n = cMSKeyDatabaseException.getErrCode();
            String string2 = CMSKeyDatabaseException.getErrKey(n);
            if (string2.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                throw new CertificateAlreadyExistsException("Certificate already exists in the key database");
            }
            if (string2.equals("GSKKM_ERR_INVALID_CERT_CHAIN")) {
                throw new KeyStoreException("INVALID_CERT_CHAIN");
            }
            throw new KeyStoreException("Insertion error " + cMSKeyDatabaseException.toString());
        }
        catch (KMException kMException) {
            if (kMException.getErrCodeName().equals("GSKKM_ERR_IO")) {
                throw new KeyStoreException("User canceled");
            }
            throw new KeyStoreException("Insertion error " + kMException.toString());
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("An ASN1Exception occurred: " + keyStoreException.getMessage());
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key Insertion Failed: " + exception.toString());
        }
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        try {
            if (this.type == 1) {
                this.cmsKeyDatabase.deleteKeyByLabel(string);
            } else if (this.type == 2) {
                this.msCertificateStore.deleteKeyItemByLabel(string);
            }
        }
        catch (KMException kMException) {
            if (kMException.getErrCodeName().equals("GSKKM_ERR_IO")) {
                throw new KeyStoreException("User canceled");
            }
            throw new KeyStoreException("Insertion error " + kMException.toString());
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage());
        }
    }

    public Enumeration engineAliases() {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineAliases() 0000");
        Enumeration enumeration = null;
        try {
            if (this.type == 1) {
                this.cmsKeyDatabase.buildKeyLabelList();
            } else if (this.type == 2) {
                this.msCertificateStore.buildKeyLabelList();
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineAliases() 8000, Exception=" + exception);
        }
        Vector<String> vector = new Vector<String>(this.engineSize());
        if (this.type == 1) {
            enumeration = this.cmsKeyDatabase.getKeyLabelList().elements();
        } else if (this.type == 2) {
            enumeration = this.msCertificateStore.getKeyLabelList().elements();
        }
        try {
            Object object;
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                vector.add((String)object);
            }
            if (this.type == 1 && this.cmsKeyDatabase.getReqKeyLabelList() != null) {
                object = this.cmsKeyDatabase.getReqKeyLabelList().elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    vector.add(string);
                }
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineAliases() 8050, Exception=" + exception);
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineAliases() 9999");
        return vector.elements();
    }

    public boolean engineContainsAlias(String string) {
        try {
            if (this.type == 1) {
                return this.cmsKeyDatabase.getKeyLabelList().contains(string);
            }
            if (this.type == 2) {
                return this.msCertificateStore.getKeyLabelList().contains(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int engineSize() {
        try {
            if (this.type == 1) {
                this.cmsKeyDatabase.buildKeyLabelList();
                return this.cmsKeyDatabase.getKeyLabelList().size();
            }
            if (this.type == 2) {
                this.msCertificateStore.buildKeyLabelList();
                return this.msCertificateStore.getKeyLabelList().size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public boolean engineIsKeyEntry(String string) {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineIsKeyEntry 0000, alias=" + string);
        boolean bl = false;
        if (this.type == 1) {
            bl = this.cmsKeyDatabase.isPrivateKeyPresent(string);
        } else if (this.type == 2) {
            bl = this.msCertificateStore.getPersonalKeyLabelList().contains(string);
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineIsKeyEntry 9999, isKeyEntry=" + bl);
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (!this.engineContainsAlias(string)) {
            return false;
        }
        if (this.type == 1) {
            KeyItem keyItem = null;
            try {
                keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            }
            catch (Exception exception) {
                return false;
            }
            return keyItem.isTrusted();
        }
        return true;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        KeyItem keyItem = null;
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        try {
            Vector vector = null;
            X509CertImpl x509CertImpl = certificate instanceof X509CertImpl ? (X509CertImpl)certificate : new X509CertImpl(certificate.getEncoded());
            byte[] byArray = x509CertImpl.getPublicKey().getEncoded();
            if (byArray == null) {
                return null;
            }
            if (this.type == 1) {
                vector = this.cmsKeyDatabase.getKeyItemsByPublicKey(new BERObject(byArray));
            } else if (this.type == 2) {
                vector = this.msCertificateStore.getKeyItemsByPublicKey(new BERObject(byArray));
            }
            keyItem = (KeyItem)vector.elementAt(0);
        }
        catch (Exception exception) {
            return null;
        }
        if (keyItem != null) {
            return keyItem.getKeyLabel();
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (this.type == 1) {
            int n;
            if (outputStream == null) {
                return;
            }
            try {
                if (cArray != null && !this.keyDBPassword.equals(new String(cArray))) {
                    this.keyDBPassword = new String(cArray);
                    this.cmsKeyDatabase.changeKeyDbPwd(this.keyDBPassword, 0L);
                }
            }
            catch (Exception exception) {
                throw new IOException("Error in password changing");
            }
            this.cmsKeyDatabase.save();
            FileInputStream fileInputStream = new FileInputStream(this.writeFile);
            while ((n = fileInputStream.read()) != -1) {
                outputStream.write(n);
            }
        }
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 0000");
        if (inputStream == null && cArray == null) {
            this.initialized = true;
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 9999-1");
            return;
        }
        this.type = 1;
        try {
            this.engineLoadCMS(inputStream, null, null, cArray);
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 9999-2, IOException=" + iOException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 9999-3, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw noSuchAlgorithmException;
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 9999-4, CertificateException=" + certificateException);
            throw certificateException;
        }
        this.initialized = true;
        KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad() 9999");
    }

    public void engineLoad(String string, String string2) throws IOException {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad(aCspName) 0000");
        if (string == null || string2 == null) {
            this.initialized = true;
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad(aCspName) 9999-1");
            throw new IOException("Null MSCSP arguments");
        }
        this.type = 2;
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cspName = string;
        this.keyDBPassword = string2;
        try {
            this.msCertificateStore = new MSCertificateStore(string, string2);
            this.msCertificateStore.open();
            this.initialized = true;
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad(aCspName) 9999-2, Exception=" + exception);
            throw new IOException("Error opening MSCSP");
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineLoad(aCspName) 9999");
    }

    public boolean engineIsDefaultKeyEntry(String string) {
        try {
            KeyItem keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            if (keyItem != null) {
                return keyItem.isDefault();
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String engineGetDefaultKeyEntry() throws KeyStoreException {
        try {
            KeyItem keyItem = this.cmsKeyDatabase.getDefaultKeyItem();
            if (keyItem != null) {
                return keyItem.getKeyLabel();
            }
            return null;
        }
        catch (Exception exception) {
            if (exception.getMessage().equals(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_DEFAULT_KEY"))) {
                return null;
            }
            throw new KeyStoreException("An error occured while extracting the default KeyItem: " + exception.getMessage());
        }
    }

    public void engineSetDefaultKeyEntry(String string) throws KeyStoreException {
        try {
            this.cmsKeyDatabase.setDefaultKey(string);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Error setting default key");
        }
    }

    public boolean engineIsSiteCertificateEntry(String string) throws KeyStoreException {
        return false;
    }

    public void engineSetSiteCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public void engineLoadFromClass(InputStream inputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("CMS does not support loading from a class");
    }

    public void engineStoreAsClass(OutputStream outputStream, char[] cArray, String string) throws IOException, CertificateException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("CMS does not support storing to a class");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void engineLoadCMS(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 0000");
        this.type = 1;
        if (!this.writeFile.canWrite()) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999-1");
            throw new IOException("Cannot write to the temp file.");
        }
        this.writeFile.delete();
        this.rdbFile.delete();
        this.crlFile.delete();
        if (cArray == null) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999-2");
            throw new IOException("Password invalid, CMS *requires* password to load.");
        }
        this.keyDBPassword = new String(cArray);
        try {
            int n;
            Object object;
            Object object2;
            FileDescriptor fileDescriptor = null;
            if (inputStream != null) {
                if (inputStream instanceof FileInputStream) {
                    fileDescriptor = ((FileInputStream)inputStream).getFD();
                    KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 0010, fdOfKdb=" + fileDescriptor.toString());
                } else {
                    KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 0015, kdbStream=" + inputStream.toString());
                }
                object2 = new FileOutputStream(this.writeFile);
                object = null;
                FileOutputStream fileOutputStream = null;
                while ((n = inputStream.read()) != -1) {
                    ((FileOutputStream)object2).write(n);
                }
                ((FileOutputStream)object2).close();
                inputStream.close();
                if (inputStream2 != null) {
                    object = new FileOutputStream(this.rdbFile);
                    while ((n = inputStream2.read()) != -1) {
                        ((FileOutputStream)object).write(n);
                    }
                    ((FileOutputStream)object).close();
                    inputStream2.close();
                }
                if (inputStream3 != null) {
                    fileOutputStream = new FileOutputStream(this.crlFile);
                    while ((n = inputStream3.read()) != -1) {
                        fileOutputStream.write(n);
                    }
                    fileOutputStream.close();
                    inputStream3.close();
                }
            }
            if (this.cmsKeyDatabase != null) {
                this.cmsKeyDatabase.close();
                this.cmsKeyDatabase.setKeyDbFileName(this.writeFile.getPath());
            } else {
                this.cmsKeyDatabase = new CMSKeyDatabase(this.writeFile.getPath(), this.keyDBPassword);
            }
            if (inputStream == null) {
                this.cmsKeyDatabase.create();
                object2 = this.cmsKeyDatabase.getKeyLabelList();
                object = new String[30];
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    object[n2] = (String)((Vector)object2).elementAt(n2);
                    ++n2;
                }
                n = 0;
                while (n < ((String[])object).length) {
                    this.cmsKeyDatabase.deleteKeyByLabel(object[n]);
                    ++n;
                }
            } else {
                this.cmsKeyDatabase.open();
            }
            this.initialized = true;
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999");
            return;
        }
        catch (KMException kMException) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 8000, KMException=" + kMException);
            if (kMException.getErrCodeName().equals("GSKKM_ERR_PASSWORD_EXPIRATION_TIME")) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999-3");
                throw new IOException(KMSystem.getNLSErrString("GSKKM_ERR_PASSWORD_EXPIRATION_TIME"));
            }
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999-4");
            throw new IOException("Error opening database from file " + this.writeFile.getPath() + kMException.toString());
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineLoadCMS() 9999-5, KMException=" + exception);
            throw new IOException("Error opening database from file " + this.writeFile.getPath() + exception.toString());
        }
    }

    public void engineStoreCMS(OutputStream outputStream, OutputStream outputStream2, OutputStream outputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0000");
        if (outputStream == null) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 9999-1");
            return;
        }
        try {
            if (cArray != null && !this.keyDBPassword.equals(new String(cArray))) {
                this.keyDBPassword = new String(cArray);
                this.cmsKeyDatabase.changeKeyDbPwd(this.keyDBPassword, 0L);
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 9999-2, Exception=" + exception);
            throw new IOException("Error in password changing");
        }
        try {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0100");
            this.cmsKeyDatabase.save();
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0110, kdb filename=" + this.writeFile.getName());
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0120");
            new CopyFile(this.writeFile).to(outputStream);
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0150, rdb");
            new CopyFile(this.rdbFile).to(outputStream2);
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 0160 crl");
            new CopyFile(this.crlFile).to(outputStream3);
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 9999-3, Exception=" + exception);
            throw new IOException(exception.toString());
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineStoreCMS() 9999");
    }

    public void engineSetExpireTime(long l) throws KeyStoreException, NoSuchAlgorithmException {
        try {
            String string = this.keyDBPassword + "tmp";
            this.cmsKeyDatabase.changeKeyDbPwd(string, l);
            this.cmsKeyDatabase.changeKeyDbPwd(this.keyDBPassword, l);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.toString());
        }
    }

    public boolean engineIsCertReqEntry(String string) {
        Vector vector = this.cmsKeyDatabase.getReqKeyLabelList();
        if (vector == null) {
            return false;
        }
        return vector.contains(string);
    }

    public void engineSetCertReqEntry(String string, CertificationRequest certificationRequest, Key key) throws KeyStoreException {
        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 0000, alias=" + string);
        if (!key.getAlgorithm().equals("RSA") && !key.getAlgorithm().equals("DSA")) {
            throw new KeyStoreException("Algorithm not RSA or DSA.");
        }
        if (!key.getFormat().equals("PKCS#8")) {
            throw new KeyStoreException("This key does not support encoding to PKCS#8");
        }
        try {
            EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem;
            CertificateRequestItem certificateRequestItem = null;
            KeyItem keyItem = null;
            try {
                certificateRequestItem = new CertificateRequestItem(certificationRequest.encode());
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 8060, Exception=" + exception);
                throw new KeyStoreException(exception.toString());
            }
            try {
                byte[] byArray = key.getEncoded();
                PrivateKeyInfoItem privateKeyInfoItem = new PrivateKeyInfoItem(byArray);
                encryptedPrivateKeyInfoItem = this.cmsKeyDatabase.encryptPrivateKey(privateKeyInfoItem);
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 8080, Exception=" + exception);
                throw new KeyStoreException("Error during encryption of PKCS#8 " + exception.toString());
            }
            try {
                keyItem = new KeyItem(string, 1, certificateRequestItem.getKeySize(), encryptedPrivateKeyInfoItem, certificateRequestItem, null);
            }
            catch (Exception exception) {
                KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 8090, Exception=" + exception);
            }
            this.cmsKeyDatabase.insertKey(keyItem);
        }
        catch (Exception exception) {
            KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 8100, Exception=" + exception);
            throw new KeyStoreException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
        }
        KMUtil.debugMsg("CMSKeyStoreSpi::engineSetCertReqEntry 9999");
    }

    public CertificationRequest engineGetCertReqEntry(String string) throws KeyStoreException {
        try {
            KeyItem keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            return new CertificationRequest(keyItem.getCertificateRequestItem().getEncoded());
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.toString());
        }
    }

    public boolean engineIsTrusted(String string) {
        boolean bl = false;
        try {
            KeyItem keyItem = this.cmsKeyDatabase.getKeyItemByLabel(string);
            bl = keyItem.isTrusted();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void engineSetTrusted(String string, boolean bl) {
        try {
            this.cmsKeyDatabase.setKeyTrust(string, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void engineStashKeydbPwd(OutputStream outputStream) throws IOException, NoSuchAlgorithmException {
        if (outputStream == null) {
            return;
        }
        try {
            File file = new File(this.writeFile.getPath().substring(0, this.writeFile.getPath().lastIndexOf(46) + 1) + "sth");
            CMSKeyDatabase.stashKeyDbPwd(this.cmsKeyDatabase.getKeyDbFileName(), this.cmsKeyDatabase.getKeyDbPwd());
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int n;
                while ((n = fileInputStream.read()) != -1) {
                    outputStream.write(n);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fileInputStream.close();
                file.delete();
                throw throwable;
            }
            fileInputStream.close();
            file.delete();
            {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void engineCreateNewSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4, Vector vector) throws KeyStoreException {
        try {
            if (this.type == 1) {
                this.cmsKeyDatabase.createNewSelfSignedCertificate(n, string, false, n2, dNItem, n3, n4, null, true, vector);
            } else if (this.type == 2) {
                this.msCertificateStore.createNewSelfSignedCertificate(n, string, n2, dNItem, n3, n4, vector);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.toString());
        }
    }
}

