/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CryptographicToken;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseInfo;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class CLIDatabaseManager
implements CLIConstants {
    public static void keyDbCreate(CLIDatabaseInfo cLIDatabaseInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getExtension();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        ikeycmd.debugMsg("Entered CLIDatabaseManager.keyDbCreate");
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        if (string3 != null && string.indexOf(".") == -1) {
            string = string + "." + string3;
        }
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        File file = new File(string);
        ikeycmd.debugMsg("Checking to see if database " + string + " already exists\n");
        if (file.exists()) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_ALREADY_EXISTS"));
        }
        keyDatabase.getKeyDatabaseOperator().create();
        ikeycmd.debugMsg("Checking to see if we should stash the password....");
        if (cLIDatabaseInfo.getStash()) {
            ikeycmd.debugMsg("Stash = true\n");
            ikeycmd.debugMsg("Calling stash API: keyDbStashPw()");
            CLIDatabaseManager.keyDbStashPw(cLIDatabaseInfo);
        }
        ikeycmd.debugMsg("Stash = false\n");
    }

    public static void keyDbChangePw(CLIDatabaseInfo cLIDatabaseInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getNewPassword();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        boolean bl = cLIDatabaseInfo.getStash();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        if (n == 1 && bl) {
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2);
            cMSKeyDatabase.getKeyDatabaseOperator().open();
            cMSKeyDatabase.getKeyDatabaseOperator().changeKeyDbPwd(string2, string3, l);
            CMSKeyDatabase.stashKeyDbPwd(string, string3);
            cMSKeyDatabase.getKeyDatabaseOperator().close();
        } else if (!bl) {
            KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
            keyDatabase.getKeyDatabaseOperator().open();
            keyDatabase.getKeyDatabaseOperator().changeKeyDbPwd(string2, string3, l);
            keyDatabase.getKeyDatabaseOperator().close();
        } else {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_STASH_DB_TYPE"));
        }
    }

    public static void keyDbStashPw(CLIDatabaseInfo cLIDatabaseInfo) throws KeyDatabaseOperatorNullException, KeyDatabaseException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        int n = cLIDatabaseInfo.getDbType();
        long l = cLIDatabaseInfo.getExpire();
        if (n != 1) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_STASH_DB_TYPE"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = string3 + ".sth";
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2);
        cMSKeyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling stashKeyDbPw(" + string + ", " + string2 + ")\n");
        CMSKeyDatabase.stashKeyDbPwd(string, string2);
        cMSKeyDatabase.getKeyDatabaseOperator().close();
    }

    public static void keyDbConvert(CLIDatabaseInfo cLIDatabaseInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, IOException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        int n = cLIDatabaseInfo.getDbType();
        int n2 = cLIDatabaseInfo.getNewDbType();
        long l = cLIDatabaseInfo.getExpire();
        String string3 = cLIDatabaseInfo.getNewExtension();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string4 = string.substring(0, string.indexOf("."));
        string4 = string4 + "." + string3;
        ikeycmd.debugMsg("\nnewName: " + string4);
        ikeycmd.debugMsg("newDbType: " + n2);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase2 = CLIDatabaseManager.makeKeyDatabase(n2, string4, string2, l);
        keyDatabase.getKeyDatabaseOperator().open();
        keyDatabase.getKeyDatabaseOperator().save();
        ikeycmd.debugMsg("Recreating keyDb: " + string + "\n");
        ((KeyDatabaseOperator)((Object)keyDatabase2)).reCreate(keyDatabase);
        ikeycmd.debugMsg("Verifying that " + string4 + " is functioning properly\n");
        keyDatabase2.getKeyDatabaseOperator().open();
        keyDatabase2.getKeyDatabaseOperator().close();
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void keyDbDelete(CLIDatabaseInfo cLIDatabaseInfo) throws KeyDatabaseException, IOException {
        String string;
        File file;
        cLIDatabaseInfo.init();
        String string2 = cLIDatabaseInfo.getName();
        String string3 = cLIDatabaseInfo.getPassword();
        int n = cLIDatabaseInfo.getDbType();
        long l = cLIDatabaseInfo.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string2);
        ikeycmd.debugMsg("keyDbPassword: " + string3);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string2, string3, l);
        ikeycmd.debugMsg("Deleteing " + string2 + "\n");
        keyDatabase.delete();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (string5 != null && string5.compareTo("kdb") == 0 && (file = new File(string = string4 + ".sth")).exists()) {
            ikeycmd.debugMsg("Deleting the stash file\n");
            file.delete();
        }
    }

    protected static boolean cryptographicTokenExists() {
        try {
            return CryptographicToken.exists();
        }
        catch (KMException kMException) {
            return false;
        }
    }

    protected static CryptographicToken cryptoOpen(CryptographicToken cryptographicToken, String string, String string2) {
        Vector vector = null;
        String string3 = null;
        try {
            vector = CryptographicToken.getTokenLabelList();
            if (vector == null || vector.size() == 0) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_ERROR"));
                return cryptographicToken;
            }
            string3 = string;
            if (CryptographicToken.tokenLabelExists(string3)) {
                cryptographicToken = new CryptographicToken(string3);
                if (cryptographicToken != null) {
                    if (cryptographicToken.isPasswordRequired() && !cryptographicToken.isOpen()) {
                        cryptographicToken.open(string2);
                    } else {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_PASSWORD_NOT_REQUIRED"));
                        cryptographicToken.open();
                    }
                }
            } else {
                String string4 = KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LABEL_NOT_EXIST");
                Object[] objectArray = new Object[]{string3};
                String string5 = MessageFormat.format(string4, objectArray);
                System.out.println(string5);
            }
            return cryptographicToken;
        }
        catch (KMException kMException) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_NO_TOKEN_PRESENT"));
            return cryptographicToken;
        }
    }

    public static CryptographicToken makeCryptoDatabase(int n, String string, String string2, String string3) throws KeyDatabaseException {
        CryptographicToken cryptographicToken = null;
        Object var5_5 = null;
        try {
            if (CLIDatabaseManager.cryptographicTokenExists()) {
                cryptographicToken = CLIDatabaseManager.cryptoOpen(cryptographicToken, string, string3);
                return cryptographicToken;
            }
            CryptographicToken.init(string2);
            cryptographicToken = CLIDatabaseManager.cryptoOpen(cryptographicToken, string, string3);
            return cryptographicToken;
        }
        catch (KMException kMException) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_NO_TOKEN_PRESENT"));
            return null;
        }
    }

    public static KeyDatabase makeKeyDatabase(int n, String string, String string2, long l) throws KeyDatabaseException {
        KeyDatabase keyDatabase;
        ikeycmd.debugMsg("makeKeyDatabase: Making a new database of type: " + n + "\n");
        switch (n) {
            case 1: {
                keyDatabase = new CMSKeyDatabase(string, string2, l);
                break;
            }
            case 2: {
                keyDatabase = new WEBDBKeyDatabase(string, string2, l);
                break;
            }
            case 3: {
                keyDatabase = new SSLightKeyDatabase(string, string2, l);
                break;
            }
            default: {
                Object var5_5 = null;
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
            }
        }
        return keyDatabase;
    }
}

