/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.asn1.ASN1OID;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequest;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequestInfo;
import com.ibm.cfwk.tools.cr.pkcs10.SubjectPublicKeyInfo;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLICryptoDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLIRequestInfo;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.util.BitString;
import com.ibm.util.x500name.RDNAttribute;
import com.ibm.util.x500name.X500Name;
import java.util.Vector;

public class CLICryptoRequestManager
implements CLIConstants {
    public static void create(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoRequestManager::create, 0000");
        KeyStoreManager keyStoreManager = null;
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        String string3 = cLIRequestInfo.cliDb.getTokenLabel();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        int n2 = cLIRequestInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            String string4 = cLIRequestInfo.dn.getCommonName();
            String string5 = cLIRequestInfo.dn.getOrgUnit();
            String string6 = cLIRequestInfo.dn.getOrg();
            String string7 = cLIRequestInfo.dn.getLocality();
            String string8 = cLIRequestInfo.dn.getState();
            String string9 = cLIRequestInfo.dn.getZipCode();
            String string10 = cLIRequestInfo.dn.getCountry();
            String string11 = cLIRequestInfo.dn.getEmail();
            Vector vector = cLIRequestInfo.dn.getOptions();
            DNItem dNItem = new DNItem(string4, string5, string6, string7, string8, string9, string10, string11);
            String string12 = cLIRequestInfo.getLabel();
            int n3 = cLIRequestInfo.getKeySize();
            int n4 = 1;
            String string13 = cLIRequestInfo.getFileName();
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            } else {
                keyStoreManager.open(string2);
                keyStoreManager.createPersonalCertificateRequest(string12, n3, dNItem, n4, string13);
                keyStoreManager.close();
            }
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoRequestManager::create, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void recreate(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
    }

    public static void list(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoRequestManager::list, 0000");
        KeyStoreManager keyStoreManager = null;
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        String string3 = cLIRequestInfo.cliDb.getTokenLabel();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        int n2 = cLIRequestInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            } else {
                keyStoreManager.open(string2);
                Vector vector = keyStoreManager.getRequestKeyLabelList();
                if (vector == null || vector.size() == 0) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
                }
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_LIST_MSG") + " " + string);
                int n3 = 0;
                while (n3 < vector.size()) {
                    String string4 = (String)vector.elementAt(n3);
                    System.out.println(string4);
                    ++n3;
                }
                keyStoreManager.close();
            }
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoRequestManager::list, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void moreDetails(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoRequestManager::moreDetails, 0000");
        String string = "  ";
        String string2 = "    ";
        String string3 = "      ";
        String string4 = "        ";
        cLIRequestInfo.init();
        String string5 = cLIRequestInfo.cliDb.getName();
        String string6 = cLIRequestInfo.cliDb.getPassword();
        String string7 = cLIRequestInfo.cliDb.getTokenLabel();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        int n2 = cLIRequestInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string5);
        ikeycmd.debugMsg("TokenPassword: " + string6);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string7);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            KeyStoreManager keyStoreManager = null;
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string7, n2, n, string5);
            keyStoreManager.open(string6);
            String string8 = cLIRequestInfo.getLabel();
            KeyItem keyItem = null;
            keyItem = keyStoreManager.getKeyItemByLabel(string8);
            if (keyItem == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
            }
            CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
            if (null == certificateRequestItem) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
            }
            System.out.println("\n\n");
            System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + string8);
            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_CERTREQ_INFO"));
            System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " 00");
            byte[] byArray = certificateRequestItem.getEncoded();
            CertificationRequest certificationRequest = null;
            try {
                certificationRequest = KeyCertGen.generateCertificationRequest((byte[])byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (certificationRequest != null) {
                String string9;
                Object object;
                Object object2;
                Object object3;
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
                CertificationRequestInfo certificationRequestInfo = certificationRequest.certificationRequestInfo;
                X500Name x500Name = certificationRequestInfo.subject;
                RDNAttribute[][] rDNAttributeArray = x500Name.attributes();
                if (rDNAttributeArray != null) {
                    int n3 = 0;
                    while (n3 < rDNAttributeArray.length) {
                        int n4 = 0;
                        while (n4 < rDNAttributeArray[n3].length) {
                            object3 = rDNAttributeArray[n3][n4].keyToASN1OID();
                            object2 = object3.toString();
                            object = rDNAttributeArray[n3][n4].valueToString();
                            string9 = CLICryptoRequestManager.getAttributeName(object3);
                            System.out.println(string3 + string9);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object2);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)object);
                            ++n4;
                        }
                        ++n3;
                    }
                }
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
                SubjectPublicKeyInfo subjectPublicKeyInfo = certificationRequestInfo.subjectPublicKeyInfo;
                AlgId algId = subjectPublicKeyInfo.algorithm;
                object3 = null;
                object2 = subjectPublicKeyInfo.subjectPublicKey;
                object3 = CLICryptoRequestManager.getByteArrayFrom(object2);
                if (algId != null) {
                    object = algId.asn1oid();
                    if (object != null && (string9 = object.toString()) != null && string9.length() > 0) {
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string9);
                    }
                    switch (algId.parameterStatus()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                            break;
                        }
                        case 2: {
                            string9 = algId.toString();
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string9);
                            break;
                        }
                    }
                }
                if (object3 != null && ((ASN1OID)object3).length > 0) {
                    object = CLICryptoRequestManager.getHexDumpForMoreDetails((byte[])object3);
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string3 + (String)object);
                }
                if ((object = certificationRequestInfo.attributes) != null) {
                    // empty if block
                }
                string9 = certificationRequest.signatureAlgorithm;
                byte[] byArray2 = CLICryptoRequestManager.getByteArrayFrom(certificationRequest.signature);
                System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
                if (string9 != null) {
                    String string10;
                    ASN1OID aSN1OID = string9.asn1oid();
                    if (aSN1OID != null && (string10 = aSN1OID.toString()) != null && string10.length() > 0) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string10);
                    }
                    switch (string9.parameterStatus()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                            break;
                        }
                        case 2: {
                            string10 = string9.toString();
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string10);
                            break;
                        }
                    }
                }
                if (byArray2 != null) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string3 + CLICryptoRequestManager.getHexDumpForMoreDetails(byArray2));
                }
                System.out.println("\n");
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoRequestManager::moreDetails, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
        catch (Exception exception) {
            System.out.println("e init failed  " + exception);
            exception.printStackTrace();
        }
    }

    private static String getAttributeName(ASN1OID aSN1OID) {
        String string = null;
        if (aSN1OID != null) {
            string = aSN1OID.equals((Object)X500Name.COMMON_NAME) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (aSN1OID.equals((Object)X500Name.SERIAL_NUMBER) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (aSN1OID.equals((Object)X500Name.COUNTRY) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (aSN1OID.equals((Object)X500Name.LOCATION) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (aSN1OID.equals((Object)X500Name.STATE) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (aSN1OID.equals((Object)X500Name.STREET) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (aSN1OID.equals((Object)X500Name.ORGANIZATION) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (aSN1OID.equals((Object)X500Name.ORGANIZATIONAL_UNIT) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (aSN1OID.equals((Object)X500Name.TITLE) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (aSN1OID.equals((Object)X500Name.ZIP) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (aSN1OID.equals((Object)X500Name.EMAIL) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : aSN1OID.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    private static byte[] getByteArrayFrom(BitString bitString) {
        int n;
        byte[] byArray = null;
        if (bitString != null && (n = bitString.length()) > 0) {
            int n2 = n / 8;
            if (n % 8 != 0) {
                ++n2;
            }
            byArray = new byte[n2];
            bitString.writeTo(byArray, 0, true);
        }
        return byArray;
    }

    public static void details(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoRequestManager::details, 0000");
        KeyStoreManager keyStoreManager = null;
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        String string3 = cLIRequestInfo.cliDb.getTokenLabel();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        int n2 = cLIRequestInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            } else {
                String string4;
                String string5;
                keyStoreManager.open(string2);
                String string6 = cLIRequestInfo.getLabel();
                KeyItem keyItem = null;
                keyItem = keyStoreManager.getKeyItemByLabel(string6);
                if (null == keyItem) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
                }
                CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
                if (null == certificateRequestItem) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
                }
                System.out.println("\n\n");
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_LABEL") + " " + string6);
                short s = certificateRequestItem.getKeySize();
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_KEYSIZE") + " " + s);
                DNItem dNItem = certificateRequestItem.getSubject();
                if (dNItem != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SUBJECT") + " " + dNItem.toStringWithoutTag());
                }
                if ((string5 = certificateRequestItem.getFingerPrint()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_FINGER") + " " + string5);
                }
                if ((string4 = certificateRequestItem.getSigAlgorithmIdOID()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SIG") + " " + string4);
                }
                System.out.println("\n\n");
                keyStoreManager.close();
            }
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoRequestManager::details, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void extract(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoRequestManager::extract, 0000");
        KeyStoreManager keyStoreManager = null;
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        String string3 = cLIRequestInfo.cliDb.getTokenLabel();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        int n2 = cLIRequestInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("label:  " + cLIRequestInfo.getLabel());
        ikeycmd.debugMsg("\n");
        try {
            String string4 = cLIRequestInfo.getLabel();
            int n3 = 1;
            String string5 = cLIRequestInfo.getExtractTarget();
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            } else {
                keyStoreManager.open(string2);
                keyStoreManager.extractPersonalCertificateRequest(string4, n3, string5);
                keyStoreManager.close();
            }
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoRequestManager::extract, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void delete(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        block7: {
            ikeycmd.debugMsg("CLICryptoRequestManager::delete, 0000");
            KeyStoreManager keyStoreManager = null;
            cLIRequestInfo.init();
            String string = cLIRequestInfo.cliDb.getName();
            String string2 = cLIRequestInfo.cliDb.getPassword();
            String string3 = cLIRequestInfo.cliDb.getTokenLabel();
            int n = cLIRequestInfo.cliDb.getDbType();
            long l = cLIRequestInfo.cliDb.getExpire();
            int n2 = cLIRequestInfo.cliDb.getSlotID();
            ikeycmd.debugMsg("TokenModuleName: " + string);
            ikeycmd.debugMsg("TokenPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("TokenLabel: " + string3);
            ikeycmd.debugMsg("SlotID:  " + n2);
            ikeycmd.debugMsg("\n");
            try {
                String string4 = cLIRequestInfo.getLabel();
                ikeycmd.debugMsg("Deleteing Label: " + string4 + "\n");
                keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
                if (keyStoreManager == null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
                    break block7;
                }
                keyStoreManager.open(string2);
                try {
                    KeyItem keyItem = null;
                    keyItem = keyStoreManager.getKeyItemByLabel(string4);
                    if (null == keyItem) {
                        throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
                    }
                }
                catch (Exception exception) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
                }
                keyStoreManager.deleteKeyItemByLabel(string4);
                keyStoreManager.close();
            }
            catch (KMException kMException) {
                if (ikeycmd.DEBUG) {
                    ikeycmd.debugMsg("CLICryptoRequestManager::delete, 9900, KMException");
                    ikeycmd.debugMsg(kMException.getMessage());
                }
                throw kMException;
            }
        }
    }
}

