/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class KeyRenameDialog
extends JDialog
implements ActionListener,
ItemListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton resetButton;
    private KMButton helpButton;
    private JLabel promptLabel;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private String newLabel = null;
    private JDialog diagInstance = this;
    private JLabel inputLabel;
    private JTextField inputField;

    public KeyRenameDialog(JFrame jFrame) {
        this(jFrame, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_RENAME_KEY"), Ikeyman.getNLSResString("GUI_LABEL_RENAME_KEY_PROMPT"), Ikeyman.getNLSResString("GUI_LABEL_RENAME_KEY_LABEL"), null, null);
    }

    public KeyRenameDialog(JFrame jFrame, String string, String string2, String string3, String string4, String string5) {
        super(jFrame, string, true);
        this.populateInputFields(string2, string3, string4, string5);
        this.populateButtons();
        this.setToolTips();
        this.mainPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        gridBagLayout.setConstraints(this.promptLabel, gridBagConstraints);
        this.mainPanel.add(this.promptLabel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        gridBagLayout.setConstraints(this.inputLabel, gridBagConstraints);
        this.mainPanel.add(this.inputLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        gridBagLayout.setConstraints(this.inputField, gridBagConstraints);
        this.mainPanel.add(this.inputField);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 5, 10, 5);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.mainPanel.add(jSeparator);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.resetButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(kMHorizontalButtonPanel, gridBagConstraints);
        this.mainPanel.add(kMHorizontalButtonPanel);
        BevelBorder bevelBorder = new BevelBorder(0);
        this.mainPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.inputField.requestFocus();
    }

    protected void populateInputFields(String string, String string2, String string3, String string4) {
        this.promptLabel = new JLabel(string + "  " + string3);
        this.inputLabel = new JLabel(string2);
        this.inputField = new JTextField(string4, 25);
    }

    protected void setToolTips() {
        this.inputField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_RENAME_KEY"));
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.resetButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CLEAR"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.okButton.setActionCommand("OK");
        this.resetButton.setActionCommand("Reset");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("ActionEvent: source = " + object + ", arg=" + string);
        }
        if (string.equals("OK")) {
            this.newLabel = this.inputField.getText();
            if (this.newLabel.equals("")) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_LABEL_NULL"));
                this.inputField.setText("");
                this.inputField.requestFocus();
            } else {
                ((Component)this).setVisible(false);
            }
        } else if (string.equals("Cancel")) {
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("Cancel button is hit\n");
            }
            this.newLabel = null;
            ((Component)this).setVisible(false);
        } else if (string.equals("Reset")) {
            this.inputField.setText("");
            this.inputField.requestFocus();
        } else if (string.equals("Help")) {
            String string2 = "packages.html";
            Ikeyman.showHelpWindow(this, string2);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange());
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.inputField.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KeyRenameDialog.this.newLabel = null;
            ((Component)KeyRenameDialog.this).setVisible(false);
        }
    }
}

