/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KeyInfoDetailsDialog;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.security.x509.X509CertImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class KeyInfoDialog
extends JDialog
implements ActionListener {
    private KeyInfoPanel keyInfoPanel;
    private KMButton okButton;
    private KMButton viewDetailsButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_VIEW_DETAILS"));
    private DateFormat dateFmt;
    private JCheckBox cbox = new JCheckBox();
    private static final int HEX_DUMP_WIDTH = 16;
    private boolean reuse = false;
    private boolean propertyChanged = false;
    private JFrame parent;
    private KeyItem keyItem;
    private boolean isCryptoTokenOpen = false;
    private boolean isCMS = false;

    public KeyInfoDialog(JFrame jFrame, String string) {
        this(jFrame, string, true, (KeyItem)null);
    }

    public KeyInfoDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, bl, (KeyItem)null);
    }

    public KeyInfoDialog(JFrame jFrame, String string, KeyItem keyItem) {
        this(jFrame, string, true, keyItem);
    }

    public KeyInfoDialog(JFrame jFrame, String string, boolean bl, KeyItem keyItem) {
        this(jFrame, string, true, keyItem, false, false);
    }

    public KeyInfoDialog(JFrame jFrame, String string, KeyItem keyItem, boolean bl) {
        this(jFrame, string, true, keyItem, bl, false);
    }

    public KeyInfoDialog(JFrame jFrame, String string, KeyItem keyItem, boolean bl, boolean bl2) {
        this(jFrame, string, true, keyItem, bl, bl2);
    }

    public KeyInfoDialog(JFrame jFrame, String string, boolean bl, KeyItem keyItem, boolean bl2, boolean bl3) {
        super(jFrame, string, true);
        KMUtil.debugMsg("KeyInfoDialog::KeyInfoDialog() 0000");
        this.parent = jFrame;
        this.keyItem = keyItem;
        this.reuse = bl;
        this.isCryptoTokenOpen = bl2;
        this.isCMS = bl3;
        this.dateFmt = DateFormat.getDateInstance(1, KMSystem.getLocale());
        KMUtil.debugMsg("KeyInfoDialog::KeyInfoDialog() 0050, dateFmt=" + this.dateFmt);
        this.keyInfoPanel = new KeyInfoPanel(keyItem);
        JPanel jPanel = new JPanel();
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.okButton.setNextFocusableComponent(this.viewDetailsButton);
        jPanel.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.keyInfoPanel, "Center");
        container.add((Component)jPanel, "South");
        this.addWindowListener(new DiagAdapter());
        if (!bl) {
            this.setDefaultCloseOperation(2);
        }
        this.pack();
        this.setResizable(false);
        if (this.cbox != null && this.cbox.isEnabled() && this.cbox.isShowing()) {
            this.cbox.requestFocus();
        } else {
            this.viewDetailsButton.requestFocus();
        }
        KMUtil.debugMsg("KeyInfoDialog::KeyInfoDialog() 9999");
    }

    public void reduceFontSize() {
        this.setResizable(true);
        this.reduceFontSize(this.keyInfoPanel);
        this.keyInfoPanel.validate();
        this.keyInfoPanel.repaint();
        this.pack();
        this.setResizable(false);
    }

    public void reduceFontSize(Container container) {
        KMUtil.debugMsg("KeyInfoDialog::reduceFontSize() 0000");
        Font font = container.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        container.setFont(font2);
        KMUtil.debugMsg("KeyInfoDialog::reduceFontSize() 0050, comp=" + container + ", f=" + font + ", nf=" + font2);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.reduceFontSize((Container)componentArray[n]);
            } else {
                font = componentArray[n].getFont();
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                componentArray[n].setFont(font2);
                KMUtil.debugMsg("KeyInfoDialog::reduceFontSize() 0250, comp=" + container + ", f=" + font + ", nf=" + font2);
            }
            ++n;
        }
        KMUtil.debugMsg("KeyInfoDialog::reduceFontSize() 9999");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        KMUtil.debugMsg("KeyInfoDialog::actionPerformed() 0000, source=" + object + ", arg=" + string);
        if (string.equals("OK")) {
            if (this.reuse) {
                ((Component)this).setVisible(false);
            } else {
                this.dispose();
            }
        }
        KMUtil.debugMsg("KeyInfoDialog::actionPerformed() 9999");
    }

    public boolean isPropertyChanged() {
        return this.propertyChanged;
    }

    public void displayKeyItem(KeyItem keyItem) {
        this.keyInfoPanel.populateLabelsWithKeyItem(keyItem);
        this.keyInfoPanel.validate();
        this.pack();
        if (this.cbox != null && this.cbox.isEnabled() && this.cbox.isShowing()) {
            this.cbox.requestFocus();
        } else {
            this.viewDetailsButton.requestFocus();
        }
    }

    public void setCheckBoxEnabled(boolean bl) {
        this.keyInfoPanel.setCheckBoxEnabled(bl);
    }

    public String getTitle() {
        return super.getTitle();
    }

    private String getHexDump(byte[] byArray) {
        String string = new String("");
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n";
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    public DateFormat getDateFormat() {
        return this.dateFmt;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFmt = dateFormat;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.viewDetailsButton.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KeyInfoDialog.this.propertyChanged = false;
            ((Component)KeyInfoDialog.this).setVisible(false);
        }
    }

    class KeyInfoDialogTextAreaJTextArea
    extends JTextArea {
        KeyInfoDialogTextAreaJTextArea(int n, int n2) {
            super(n, n2);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    class CheckBoxItemListener
    implements ItemListener {
        CheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getItem();
            KMUtil.debugMsg("KeyInfoDialog::CheckBoxItemListener::itemStateChanged() 0000, obj=" + object);
            KeyInfoDialog.this.propertyChanged = !KeyInfoDialog.this.propertyChanged;
            KMUtil.debugMsg("KeyInfoDialog::CheckBoxItemListener::itemStateChanged() 9999");
        }
    }

    class KeyInfoPanel
    extends JPanel
    implements ActionListener {
        JLabel titleLabel = new JLabel("Information for the currently selected key");
        JLabel keySizeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE") + ":");
        JLabel certLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_PROPERTY"));
        JLabel versionLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
        JLabel serialNoLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SERIALNO"));
        JLabel subjectLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_TO"));
        JLabel issuerLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_BY"));
        JLabel validityLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY"));
        JLabel fingerPrintLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FINGERPRINT"));
        JLabel sigNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SIG_ALG"));
        JLabel subjectAlternativeNamesLabel;
        JLabel emailAddressLabel;
        JLabel ipAddressLabel;
        JLabel dnsNameLabel;
        JLabel keySizeValue = new JLabel("");
        JLabel versionValue = new JLabel("");
        JLabel serialNoValue = new JLabel("");
        KeyInfoDialogTextAreaJTextArea issuerValue = new KeyInfoDialogTextAreaJTextArea(4, 30);
        KeyInfoDialogTextAreaJTextArea subjectValue = new KeyInfoDialogTextAreaJTextArea(4, 30);
        JLabel validityValue = new JLabel("");
        JLabel fingerPrintValue = new JLabel("");
        JLabel sigNameValue = new JLabel("");
        KeyInfoDialogTextAreaJTextArea emailAddressValue;
        KeyInfoDialogTextAreaJTextArea ipAddressValue;
        KeyInfoDialogTextAreaJTextArea dnsNameValue;
        boolean includeSubjectAlternativeName;

        public KeyInfoPanel() {
            this(null);
        }

        public KeyInfoPanel(KeyItem keyItem) {
            super(true);
            if (keyItem != null) {
                KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::KeyInfoPanel() 0000, KeyItem Label=" + keyItem.getKeyLabel());
            } else {
                KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::KeyInfoPanel() 0000, KeyItem = null");
            }
            String string = KMSystem.getInitSetting("DEFAULT_SUBJECT_ALTERNATIVE_NAME_SUPPORT");
            if (string == null) {
                string = "false";
            }
            this.includeSubjectAlternativeName = string.equalsIgnoreCase("true");
            if (keyItem != null) {
                this.populateLabelsWithKeyItem(keyItem);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
            jPanel.setBorder(compoundBorder);
            Font font = new Font(Ikeyman.defaultFont.getName(), 0, Ikeyman.defaultFont.getSize() + 2);
            this.titleLabel.setFont(font);
            this.titleLabel.setHorizontalAlignment(0);
            jPanel.add((Component)this.titleLabel, "Center");
            JSeparator jSeparator = new JSeparator();
            InfoPane infoPane = new InfoPane(keyItem);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)infoPane, "Center");
            CompoundBorder compoundBorder2 = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
            jPanel2.setBorder(compoundBorder2);
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::KeyInfoPanel() 0500, HPolicy=" + jScrollPane.getHorizontalScrollBarPolicy() + ", HORIZONTAL_SCROLLBAR_AS_NEEDED=" + 30);
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::KeyInfoPanel() 0500, infoScrollPane.getViewportBorder==" + jScrollPane.getViewportBorder());
            JSeparator jSeparator2 = new JSeparator();
            KeyInfoDialog.this.viewDetailsButton.setActionCommand("View Details");
            KeyInfoDialog.this.viewDetailsButton.addActionListener(this);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(10, 10));
            jPanel3.add((Component)jSeparator, "North");
            jPanel3.add((Component)jScrollPane, "Center");
            JPanel jPanel4 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel4.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagLayout.setConstraints(KeyInfoDialog.this.viewDetailsButton, gridBagConstraints);
            jPanel4.add(KeyInfoDialog.this.viewDetailsButton);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(jSeparator2, gridBagConstraints);
            jPanel4.add(jSeparator2);
            jPanel3.add((Component)jPanel4, "South");
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel3, "Center");
            if (keyItem != null && keyItem.hasCertificate()) {
                this.add((Component)KeyInfoDialog.this.cbox, "South");
            }
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::KeyInfoPanel() 9999");
        }

        public void populateLabelsWithKeyItem(KeyItem keyItem) {
            if (keyItem != null) {
                KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::populateLabelsWithKeyItem() 0000, KeyItem Label=" + keyItem.getKeyLabel());
            } else {
                KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::populateLabelsWithKeyItem() 0000, KeyItem = null");
            }
            if (keyItem == null) {
                KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::populateLabelsWithKeyItem() 9999-1, KeyItem = null");
                return;
            }
            if (keyItem != null && keyItem.hasCertificate() && this.includeSubjectAlternativeName) {
                this.subjectAlternativeNamesLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAMES2"));
                this.subjectAlternativeNamesLabel.setFont(Ikeyman.defaultBoldFont);
                this.emailAddressLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_EMAIL_ADDRESS2"));
                this.emailAddressLabel.setFont(Ikeyman.defaultBoldFont);
                this.ipAddressLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_IP_ADDRESS2"));
                this.ipAddressLabel.setFont(Ikeyman.defaultBoldFont);
                this.dnsNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_DNS_NAME2"));
                this.dnsNameLabel.setFont(Ikeyman.defaultBoldFont);
                this.emailAddressValue = new KeyInfoDialogTextAreaJTextArea(1, 30);
                this.emailAddressValue.setEditable(false);
                this.ipAddressValue = new KeyInfoDialogTextAreaJTextArea(1, 30);
                this.ipAddressValue.setEditable(false);
                this.dnsNameValue = new KeyInfoDialogTextAreaJTextArea(1, 30);
                this.dnsNameValue.setEditable(false);
                this.emailAddressValue.setRequestFocusEnabled(false);
                this.ipAddressValue.setRequestFocusEnabled(false);
                this.dnsNameValue.setRequestFocusEnabled(false);
            }
            String string = keyItem.getKeyLabel();
            this.titleLabel.setText(KMFrame.getMSTrimString(string, 2, 3));
            this.keySizeValue.setText("" + keyItem.getKeySize());
            if (keyItem.hasCertificate()) {
                Vector vector = keyItem.getCertificateChain();
                if (vector != null && vector.size() > 0) {
                    String string2;
                    Object object;
                    Object object2;
                    CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                    this.versionValue.setText("X509 V" + certificateItem.getVersion());
                    try {
                        object2 = new X509CertImpl(certificateItem.getEncoded());
                        object = object2.getSerialNumber().toByteArray();
                        if (object != null && ((byte[])object).length > 0) {
                            string2 = KeyInfoDialog.this.getHexDump(object);
                            this.serialNoValue.setText(new String(string2));
                        } else {
                            this.serialNoValue.setText("");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.issuerValue.setRequestFocusEnabled(false);
                    this.subjectValue.setRequestFocusEnabled(false);
                    if (certificateItem.getIssuer() != null) {
                        this.issuerValue.setText(certificateItem.getIssuer().toStringWithoutTagForKeyInfo());
                    }
                    if (certificateItem.getSubject() != null) {
                        this.subjectValue.setText(certificateItem.getSubject().toStringWithoutTagForKeyInfo());
                    }
                    this.issuerValue.setEditable(false);
                    this.subjectValue.setEditable(false);
                    object2 = certificateItem.getValidNotBefore();
                    object = certificateItem.getValidNotAfter();
                    string2 = Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY_FORMAT");
                    if (object2 != null && object != null) {
                        Object[] objectArray = new Object[]{KeyInfoDialog.this.dateFmt.format((Date)object2), KeyInfoDialog.this.dateFmt.format((Date)object)};
                        String string3 = MessageFormat.format(string2, objectArray);
                        this.validityValue.setText(string3);
                    }
                    this.fingerPrintValue.setText(certificateItem.getFingerPrint());
                    if (certificateItem.getSigAlgorithmIdOIDName() == null) {
                        this.sigNameValue.setText(certificateItem.getSigAlgorithmIdOID());
                    } else {
                        this.sigNameValue.setText(certificateItem.getSigAlgorithmIdOIDName() + "(" + certificateItem.getSigAlgorithmIdOID() + ")");
                    }
                    if (this.includeSubjectAlternativeName) {
                        this.emailAddressValue.setText(keyItem.getSubAltEmail());
                        this.ipAddressValue.setText(keyItem.getSubAltIP());
                        this.dnsNameValue.setText(keyItem.getSubAltDNS());
                    }
                    if (keyItem.hasPrivateKey()) {
                        KeyInfoDialog.this.cbox.setText(Ikeyman.getNLSResString("GUI_LABEL_SET_DEFAULT"));
                        KeyInfoDialog.this.cbox.setSelected(keyItem.isDefault());
                        if (keyItem.isDefault() && !keyItem.containExpiredCertificate()) {
                            KeyInfoDialog.this.cbox.setEnabled(false);
                        }
                        KeyInfoDialog.this.cbox.setVisible(!KeyInfoDialog.this.isCryptoTokenOpen && KeyInfoDialog.this.isCMS);
                    } else {
                        KeyInfoDialog.this.cbox.setText(Ikeyman.getNLSResString("GUI_LABEL_SET_TRUST"));
                        KeyInfoDialog.this.cbox.setSelected(keyItem.isTrusted());
                        KeyInfoDialog.this.cbox.setVisible(!KeyInfoDialog.this.isCryptoTokenOpen && KeyInfoDialog.this.isCMS);
                    }
                    KeyInfoDialog.this.cbox.setFont(Ikeyman.defaultBoldFont);
                    KeyInfoDialog.this.cbox.addItemListener(new CheckBoxItemListener());
                }
            } else {
                this.certLabel.setText(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_PROPERTY"));
                this.subjectLabel.setText(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_REQUESTED_BY"));
                CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
                this.subjectValue.setText(certificateRequestItem.getSubject().toStringWithoutTagForKeyInfo());
                this.subjectValue.setEditable(false);
                this.fingerPrintValue.setText(certificateRequestItem.getFingerPrint());
                if (certificateRequestItem.getSigAlgorithmIdOIDName() == null) {
                    this.sigNameValue.setText(certificateRequestItem.getSigAlgorithmIdOID());
                } else {
                    this.sigNameValue.setText(certificateRequestItem.getSigAlgorithmIdOIDName() + "(" + certificateRequestItem.getSigAlgorithmIdOID() + ")");
                }
            }
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::populateLabelsWithKeyItem() 9999");
        }

        public void setCheckBoxEnabled(boolean bl) {
            KeyInfoDialog.this.cbox.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::actionPerformed() 0000, source=" + object + ", arg=" + string);
            if (string.equals("View Details")) {
                String string2 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_KEYINFO_DETAILS");
                Object[] objectArray = new Object[]{KeyInfoDialog.this.keyItem.getKeyLabel()};
                String string3 = MessageFormat.format(string2, objectArray);
                string3 = KMFrame.getMSTrimString(KeyInfoDialog.this.keyItem.getKeyLabel(), 2, 3);
                KeyInfoDetailsDialog keyInfoDetailsDialog = new KeyInfoDetailsDialog(KeyInfoDialog.this.parent, string3, KeyInfoDialog.this.keyItem);
                ((Component)keyInfoDetailsDialog).setVisible(true);
            }
            KMUtil.debugMsg("KeyInfoDialog::KeyInfoPanel::actionPerformed() 9999");
        }

        class InfoPane
        extends JPanel {
            public InfoPane(KeyItem keyItem) {
                super(true);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.keySizeLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.keySizeLabel);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.keySizeValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.keySizeValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.certLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.certLabel);
                if (keyItem != null && keyItem.hasCertificate()) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.versionLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.versionLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.versionValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.versionValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.serialNoLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.serialNoLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.serialNoValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.serialNoValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.subjectLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.subjectLabel);
                gridBagConstraints.gridheight = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.subjectValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.subjectValue);
                if (keyItem != null && keyItem.hasCertificate()) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.issuerLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.issuerLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 2;
                    gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.issuerValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.issuerValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.validityLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.validityLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.validityValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.validityValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.fingerPrintLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.fingerPrintLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.fingerPrintValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.fingerPrintValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 1;
                gridBagLayout.setConstraints(KeyInfoPanel.this.sigNameLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.sigNameLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.sigNameValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.sigNameValue);
                if (keyItem != null && keyItem.hasCertificate() && KeyInfoPanel.this.includeSubjectAlternativeName) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.subjectAlternativeNamesLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.subjectAlternativeNamesLabel);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.emailAddressLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.emailAddressLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(0, 35, 2, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.emailAddressValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.emailAddressValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.ipAddressLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.ipAddressLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(0, 35, 2, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.ipAddressValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.ipAddressValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.dnsNameLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.dnsNameLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(0, 35, 2, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.dnsNameValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.dnsNameValue);
                }
            }
        }
    }
}

