/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFilenameFilter;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;

public class KeyDbFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel typeLabel;
    private IkeymanCombox typeChoice;
    private int[] types;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private String currWorkingDirName;
    private int mode;
    private int dbType = 0;
    private String browserFileName;
    private String browserDirName;
    private String getTitle;
    private int KeyStoreIndex;
    private int pastKeyStoreIndex;
    private String fileName = null;
    private String dirName = null;
    private int keyDbTypeSelected;
    private static int cryptoType = 0;
    private JPanel fileNamePanel;
    private JDialog diagInstance;
    private String currentFileName = null;
    protected boolean isMSOpenCancelled = false;
    private KeyTypedListener keyTypedListener;

    public KeyDbFileDialog(JFrame jFrame, String string) {
        this(jFrame, string, 0);
    }

    public KeyDbFileDialog(JFrame jFrame, String string, int n) {
        this(jFrame, string, n, 0);
    }

    public KeyDbFileDialog(JFrame jFrame, String string, int n, int n2, int n3) {
        this(jFrame, string, n, n2);
        cryptoType = n3;
    }

    public KeyDbFileDialog(JFrame jFrame, String string, int n, int n2) {
        super(jFrame, string, true);
        KMUtil.debugMsg("KeyDbFileDialog::KeyDbFileDialog(4args) 0000, title=" + string + ", mode=" + n + ", dbType=" + n2);
        this.getTitle = string;
        this.mode = n;
        this.dbType = n2;
        this.diagInstance = this;
        this.populateFields();
        this.fileNamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.typeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.typeChoice, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add(this.typeLabel);
        this.fileNamePanel.add(this.typeChoice);
        this.fileNamePanel.add(this.fileNameLabel);
        this.fileNamePanel.add(this.fileNameField);
        this.fileNamePanel.add(this.browseButton);
        this.fileNamePanel.add(this.dirNameLabel);
        this.fileNamePanel.add(this.dirNameField);
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fileNamePanel, "Center");
        jPanel.add((Component)kMHorizontalButtonPanel, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.fileNameField.requestFocus();
        KMUtil.debugMsg("KeyDbFileDialog::KeyDbFileDialog(4args) 9999");
    }

    protected void populateFields() {
        KMUtil.debugMsg("KeyDbFileDialog::populateFields() 0000");
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
        KMUtil.debugMsg("KeyDbFileDialog::populateFields() 9999");
    }

    protected void populateInputFields() {
        int n;
        boolean bl = false;
        KMUtil.debugMsg("KeyDbFileDialog::populateInputFields() 0000");
        this.typeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
        this.typeChoice = new IkeymanCombox();
        this.typeChoice.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
        if (KeyStoreManager.isCMSCryptokiOpened && cryptoType == 1) {
            this.types = new int[1];
            this.types[0] = 1;
            this.typeChoice.addItem(KeyStoreManager.getKeyStoreName(1));
        } else {
            this.types = KeyStoreManager.getSupportedDatabaseTypes();
            n = 0;
            while (n < this.types.length) {
                if (this.getTitle.equalsIgnoreCase(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_OPEN"))) {
                    if (this.types[n] == 1 || this.types[n] == 4 || this.types[n] == 2) {
                        bl = true;
                    }
                    if (KMSystem.isMSKeyStoreOS()) {
                        this.typeChoice.addItem(KeyStoreManager.getKeyStoreName(this.types[n]));
                    } else if (this.types[n] != 2) {
                        this.typeChoice.addItem(KeyStoreManager.getKeyStoreName(this.types[n]));
                    }
                } else if (this.types[n] != 2 && this.types[n] != 4 && this.types[n] != 3) {
                    this.typeChoice.addItem(KeyStoreManager.getKeyStoreName(this.types[n]));
                    if (this.types[n] == 1) {
                        bl = true;
                    }
                }
                ++n;
            }
            if (!bl && !Ikeyman.javaOnly) {
                this.typeChoice.insertItemAt("CMS", 1);
                if (!this.getTitle.equalsIgnoreCase(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_NEW"))) {
                    this.typeChoice.addItem("CMS Cryptographic Token");
                    if (KMSystem.isMSKeyStoreOS()) {
                        this.typeChoice.addItem("Microsoft Certificate Store");
                    }
                }
            }
        }
        this.typeChoice.addItemListener(this);
        this.pastKeyStoreIndex = this.keyDbTypeSelected = this.types[0];
        n = 35;
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            n *= 2;
        }
        this.fileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FILENAME"));
        this.fileNameField = new JTextField(KeyStoreManager.getDefaultKeyDbFileName(this.typeChoice.getItemAt(0).toString()), n);
        this.fileNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_FILENAME"));
        this.currWorkingDirName = KMSystem.getWorkingDirName(this.keyDbTypeSelected);
        KMUtil.debugMsg("KeyDbFileDialog::populateInputFields() 0020 cwd=" + this.currWorkingDirName);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n);
        this.dirNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        if (string.equals("ko") || string.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
        this.currentFileName = this.fileNameField.getText();
        this.keyTypedListener = new KeyTypedListener();
        this.fileNameField.addKeyListener(this.keyTypedListener);
        this.dirNameField.addKeyListener(this.keyTypedListener);
        KMUtil.debugMsg("KeyDbFileDialog::populateInputFields() 9999");
    }

    protected void populateButtons() {
        KMUtil.debugMsg("KeyDbFileDialog::populateButtons() 0000");
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
        KMUtil.debugMsg("KeyDbFileDialog::populateButtons() 9999");
    }

    protected void setToolTips() {
        KMUtil.debugMsg("KeyDbFileDialog::setToolTips() 0000");
        this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DBFILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
        KMUtil.debugMsg("KeyDbFileDialog::setToolTips() 9999");
    }

    public String getFileName() {
        KMUtil.debugMsg("KeyDbFileDialog::getFileName(), fileName=" + this.fileName);
        return KMUtil.trimBlankSpace(this.fileName);
    }

    public String getDirName() {
        KMUtil.debugMsg("KeyDbFileDialog::getDirName(), dirName=" + this.dirName);
        return KMUtil.trimBlankSpace(this.dirName);
    }

    public int[] getKeyDbTypes() {
        return this.types;
    }

    public static String getKeyDbTypeNLSName(int n) {
        return Ikeyman.getDatabaseNLSTypeName(n);
    }

    public int getSelectedKeyDbType() {
        String string = this.typeChoice.getUnTranslatedItem().toString();
        this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(string);
        if (this.KeyStoreIndex == 0 && KeyStoreManager.loadCMSProvider() && !Ikeyman.jniLoadErr()) {
            int[] nArray = KeyStoreManager.getSupportedDatabaseTypes();
            this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(string);
        }
        KMUtil.debugMsg("KeyDbFileDialog::getSelectedKeyDbType(), KeyStoreIndex=" + this.KeyStoreIndex);
        return this.KeyStoreIndex;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 0000, source=" + object + ", arg=" + string);
        if (string.equals("OK")) {
            this.fileName = this.fileNameField.getText();
            this.dirName = this.dirNameField.getText();
            if (KMUtil.trimBlankSpace(this.fileName) != null) {
                if (this.dirName == null) {
                    this.dirName = this.currWorkingDirName;
                }
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                if (!(Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1)) {
                    KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 1000");
                    File file = new File(this.dirName + this.fileName);
                    KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 1010");
                    if (file.exists()) {
                        KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 1020");
                        int n = KMFrame.showConfirmDialog(KMAWTUtil.getFrame(this), Ikeyman.getNLSResString("GUI_DIALOG_QST_OVERWRITE_KDB_FILE"), 0);
                        if (n != 0) {
                            this.fileNameField.requestFocus();
                            return;
                        }
                    }
                }
                ((Component)this).setVisible(false);
            } else {
                if (this.KeyStoreIndex != 2) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_FILE_PATH_NAME"));
                }
                this.fileNameField.requestFocus();
                ((Component)this).setVisible(false);
            }
        } else if (string.equals("Cancel")) {
            KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 0700, Cancel button is hit");
            this.fileName = null;
            this.dirName = null;
            ((Component)this).setVisible(false);
            this.isMSOpenCancelled = true;
        } else if (string.equals("Browse")) {
            Object object2;
            String string2;
            KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 0800, Browse button is hit");
            int n = KeyStoreManager.getDbTypeFromKeyStore(this.typeChoice.getUnTranslatedItem().toString());
            JFileChooser jFileChooser = new JFileChooser(KMSystem.getWorkingDirName());
            jFileChooser.setFileHidingEnabled(KMFrame.hideHiddenFiles);
            if (KMFrame.isWindowLookAndFeel()) {
                jFileChooser.setPreferredSize(new Dimension(((JComponent)object).getWidth() * 6, ((JComponent)object).getHeight() * 10));
            }
            if ((string2 = KeyStoreManager.getKeyDbFileExtensionWithType(this.typeChoice.getUnTranslatedItem().toString())) != null && n != 4 && n != 3) {
                object2 = new KMFilenameFilter(string2, Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
                jFileChooser.addChoosableFileFilter((FileFilter)object2);
                jFileChooser.setSelectedFile(new File("*" + string2));
            } else if (this.fileNameField.getText() != null && this.fileNameField.getText().lastIndexOf(".") != -1) {
                object2 = this.fileNameField.getText().substring(this.fileNameField.getText().lastIndexOf("."));
                KMFilenameFilter kMFilenameFilter = new KMFilenameFilter((String)object2, Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
                jFileChooser.addChoosableFileFilter(kMFilenameFilter);
                jFileChooser.setSelectedFile(new File("*" + (String)object2));
            }
            object2 = jFileChooser.getSize();
            jFileChooser.setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
            if (this.dirNameField.getText() != null && this.dirNameField.getText() != "") {
                jFileChooser.setCurrentDirectory(new File(this.dirNameField.getText()));
            }
            int n2 = 0;
            n2 = this.mode == 0 ? jFileChooser.showOpenDialog(null) : jFileChooser.showSaveDialog(null);
            if (n2 == 0) {
                File file = jFileChooser.getSelectedFile();
                this.fileName = file.getName();
                this.fileNameField.setText(this.fileName);
                this.dirName = jFileChooser.getCurrentDirectory().toString();
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                this.dirNameField.setText(this.dirName);
                KMSystem.setCurrentWorkingDirName(this.dirName, n);
            } else if (n2 != 1 && n2 == -1) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_NOT_OPENED"));
            }
        } else if (string.equals("Help")) {
            String string3 = "packages.html";
            Ikeyman.showHelpWindow(this, string3);
        }
        KMUtil.debugMsg("KeyDbFileDialog::actionPerformed() 9999");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        Object object2 = itemEvent.getItem();
        Object object3 = itemEvent.getSource();
        if (object2 != null) {
            if (object2.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11"))) {
                object2 = "Java Cryptographic Token";
            }
            if (object2.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11"))) {
                object2 = "CMS Cryptographic Token";
            }
        }
        KMUtil.debugMsg("KeyDbFileDialog::itemStateChanged() 0000, item=" + object2 + ", source=" + object3);
        int n = this.typeChoice.getSelectedIndex();
        KMUtil.debugMsg("KeyDbFileDialog::itemStateChanged() 0030, selectedIndex=" + n);
        int[] nArray = KeyStoreManager.dbTypes;
        this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(object2.toString());
        if (this.KeyStoreIndex == 0 && KeyStoreManager.loadCMSProvider()) {
            Ikeyman.jniLoadErr();
            object = KeyStoreManager.getSupportedDatabaseTypes();
            this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(object2.toString());
            KMUtil.debugMsg("KeyDbFileDialog::itemStateChanged() 0035 selection=" + object2.toString() + " KeyStoreIndex=" + this.KeyStoreIndex);
        }
        this.fileNameField.setEditable(true);
        this.dirNameField.setEditable(true);
        this.browseButton.setEnabled(true);
        if (this.KeyStoreIndex == 4 || this.KeyStoreIndex == 3) {
            object = new String(KeyStoreManager.getDefaultKeyDbFileName(object2.toString()));
            File file = new File((String)object);
            if (file.exists()) {
                String string = file.getName();
                String string2 = file.getPath();
                String string3 = string2.substring(0, string2.lastIndexOf(string));
                this.fileNameField.setText(string);
                this.dirNameField.setText(string3);
            } else {
                this.fileNameField.setText((String)object);
                this.dirNameField.setText(this.currWorkingDirName);
            }
        } else if (this.KeyStoreIndex == 2) {
            KMUtil.debugMsg("KeyDbFileDialog::itemStateChanged() 0040");
            this.fileNameField.setText("");
            this.dirNameField.setText("");
            this.fileNameField.setEditable(false);
            this.dirNameField.setEditable(false);
            this.browseButton.setEnabled(false);
        } else {
            object = KMSystem.getWorkingDirName(KeyStoreManager.getDbTypeFromKeyStore(object2.toString()));
            String string = KeyStoreManager.getDefaultKeyDbFileName(object2.toString());
            String string4 = this.fileNameField.getText();
            if (this.keyTypedListener.isTextFieldTyped() && this.KeyStoreIndex == this.pastKeyStoreIndex) {
                String string5 = new String(string4.substring(0, string4.lastIndexOf(".")) + string.substring(string.lastIndexOf(".")));
                this.fileNameField.setText(string5);
            } else {
                this.pastKeyStoreIndex = this.KeyStoreIndex;
                this.fileNameField.setText(string);
                this.dirNameField.setText((String)object);
            }
        }
        KMUtil.debugMsg("KeyFileDialog::itemStateChanged() 9999");
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class KeyTypedListener
    extends KeyAdapter {
        boolean isTextFieldTyped;

        KeyTypedListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.setTextFieldTyped(true);
        }

        public boolean isTextFieldTyped() {
            return this.isTextFieldTyped;
        }

        public void setTextFieldTyped(boolean bl) {
            this.isTextFieldTyped = bl;
        }
    }

    class IkeymanCombox
    extends JComboBox {
        IkeymanCombox() {
        }

        public void insertItemAt(Object object, int n) {
            Object object2 = object;
            if (object2 != null) {
                if (object2.toString().equalsIgnoreCase("Java Cryptographic Token")) {
                    object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11");
                } else if (object2.toString().equalsIgnoreCase("CMS Cryptographic Token")) {
                    object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11");
                }
            }
            super.insertItemAt(object2.toString(), n);
        }

        public void addItem(Object object) {
            Object object2 = object;
            if (object2 != null && object2.toString().equalsIgnoreCase("Java Cryptographic Token")) {
                object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11");
            } else if (object2 != null && object2.toString().equalsIgnoreCase("CMS Cryptographic Token")) {
                object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11");
            }
            super.addItem(object2.toString());
        }

        public Object getUnTranslatedItem() {
            Object object = super.getSelectedItem();
            if (object != null && object.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11"))) {
                object = "Java Cryptographic Token";
            } else if (object != null && object.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11"))) {
                object = "CMS Cryptographic Token";
            }
            return object;
        }

        public Object getItemAt(int n) {
            Object object = super.getItemAt(n);
            if (object != null && object.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11"))) {
                object = "Java Cryptographic Token";
            } else if (object != null && object.toString().equalsIgnoreCase(Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11"))) {
                object = "CMS Cryptographic Token";
            }
            return object;
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                super.setSelectedItem(null);
            } else {
                Object object2 = object;
                if (object2 != null && object2.toString().equalsIgnoreCase("Java Cryptographic Token")) {
                    object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JAVA_PKCS11");
                } else if (object2 != null && object2.toString().equalsIgnoreCase("CMS Cryptographic Token")) {
                    object2 = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS_PKCS11");
                }
                super.setSelectedItem(object2.toString());
            }
        }
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KeyDbFileDialog.this.fileName = null;
            KeyDbFileDialog.this.dirName = null;
            ((Component)KeyDbFileDialog.this).setVisible(false);
        }
    }
}

