/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.JavawsFactory;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLFormat;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class LaunchDescFactory {
    public static LaunchDesc buildDescriptor(byte[] byArray) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return XMLFormat.parse(byArray);
    }

    public static LaunchDesc buildDescriptor(InputStream inputStream) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(inputStream, -1L));
    }

    public static LaunchDesc buildDescriptor(InputStream inputStream, long l) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(inputStream, l));
    }

    public static LaunchDesc buildDescriptor(File file) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(new FileInputStream(file), file.length());
    }

    public static LaunchDesc buildDescriptor(URL uRL) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        File file = Cache.getCachedLaunchedFile(uRL);
        if (file != null) {
            return LaunchDescFactory.buildDescriptor(file);
        }
        HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
        HttpResponse httpResponse = httpRequest.doGetRequest(uRL);
        BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
        int n = httpResponse.getContentLength();
        LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(bufferedInputStream, n);
        ((InputStream)bufferedInputStream).close();
        return launchDesc;
    }

    public static LaunchDesc buildDescriptor(String string) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        FileInputStream fileInputStream = null;
        int n = -1;
        try {
            URL uRL = new URL(string);
            return LaunchDescFactory.buildDescriptor(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists() && malformedURLException.getMessage().indexOf("https") != -1) {
                throw new BadFieldException(ResourceManager.getString((String)"launch.error.badfield.download.https"), "<jnlp>", "https");
            }
            fileInputStream = new FileInputStream(string);
            long l = new File(string).length();
            if (l > 0x100000L) {
                throw new IOException("File too large");
            }
            n = (int)l;
            return LaunchDescFactory.buildDescriptor(fileInputStream, n);
        }
    }

    public static LaunchDesc buildInternalLaunchDesc(String string, String string2, String string3) {
        return new LaunchDesc("0.1", null, null, null, null, 1, null, 5, null, null, null, null, string3 == null ? string : string3, string2, null);
    }

    public static byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray;
        if (l > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        if (l <= 0L) {
            l = 10240L;
        }
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        int n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        while (n2 != -1) {
            if (byArray2.length == (n += n2)) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        }
        bufferedInputStream.close();
        inputStream.close();
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }
}

