/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Serializable,
Comparable<BigDecimal> {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final ThreadLocal thLocalToString = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new char[22];
        }
    };
    private static final long[] powersOfTenLL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final BigInteger[] powersOfTenBI = new BigInteger[]{BigInteger.valueOf(1L), BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final char[] doubleDigitsTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] doubleDigitsOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static byte[] doubleDFPComboField = BigDecimal.comboinit();
    private static short[] DPD2BCD = BigDecimal.dpd2bcdinit();
    private static final long dfpZERO = 2465720795985346560L;
    private static final BigInteger MAXBYTE = BigInteger.valueOf(127L);
    private static final BigInteger MINBYTE = BigInteger.valueOf(-128L);
    private static final BigInteger MAXSHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MINSHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAXINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MININT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAXLONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MINLONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAXDFP64 = BigInteger.valueOf(9999999999999999L);
    private static final BigInteger MINDFP64 = BigInteger.valueOf(-9999999999999999L);
    public static final BigDecimal ZERO = new BigDecimal(0);
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final BigDecimal TEN = new BigDecimal(10);
    private BigInteger bi;
    private transient int flags;
    private transient long laside;
    private transient int exp;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("intLong", Long.TYPE), new ObjectStreamField("scale", Integer.TYPE), new ObjectStreamField("intVal", BigInteger.class)};

    private BigDecimal() {
        this.flags = 0;
        this.exp = 0;
        this.bi = null;
        this.laside = 0L;
    }

    public BigDecimal(BigInteger bigInteger) {
        this(bigInteger, 0, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this(bigInteger, n, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this(bigInteger, 0, mathContext);
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        this.bigIntegerConstructor(bigInteger, n, mathContext);
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] cArray, int n, int n2) {
        this(cArray, n, n2, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        this.charParser(cArray, n, n2, mathContext);
    }

    public BigDecimal(double d) {
        this(d, MathContext.UNLIMITED);
    }

    public BigDecimal(double d, MathContext mathContext) {
        long l = Double.doubleToLongBits(d);
        long l2 = (l & Long.MIN_VALUE) >> 63;
        long l3 = (l & 0x7FF0000000000000L) >> 52;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        int n = 0;
        l2 = l2 == 0L ? 1L : -1L;
        if (l3 == 2047L) {
            throw new NumberFormatException("Initializing with infinity, or NaN");
        }
        if (l3 == 0L) {
            if (l4 == 0L) {
                if (BigDecimal.DFPHWAvailable()) {
                    this.constructDFPZero();
                    return;
                }
                this.laside = 0L;
                this.flags |= 1;
                this.flags |= 0x10;
                this.flags |= 0x80;
                return;
            }
            n = (int)(l3 - 1075L + 1L);
        } else {
            l4 |= 0x10000000000000L;
            n = (int)(l3 - 1075L);
        }
        while ((l4 & 1L) == 0L) {
            l4 >>= 1;
            ++n;
        }
        BigInteger bigInteger = null;
        long l5 = l2 * l4;
        long l6 = 1L;
        if (n < 0 && n > -27) {
            for (int i = n; i < 0; ++i) {
                l6 *= 5L;
            }
            if (!BigDecimal.overflowMultiply(l5, l6)) {
                l5 *= l6;
            } else {
                bigInteger = BigInteger.valueOf(l5).multiply(BigInteger.valueOf(l6));
            }
        } else if (n > 0 && n < 63) {
            if (!BigDecimal.overflowMultiply(l5, l6 <<= n)) {
                l5 *= l6;
            } else {
                bigInteger = BigInteger.valueOf(l5).multiply(BigInteger.valueOf(l6));
            }
            n = 0;
        } else if (n != 0) {
            bigInteger = BigInteger.valueOf(l5);
            if (n < 0) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(5L).pow(-n));
            } else if (n > 0) {
                bigInteger = bigInteger.shiftLeft(n);
                n = 0;
            }
        }
        if (bigInteger == null) {
            this.longConstructor(l5, -n, mathContext);
        } else {
            this.bigIntegerConstructor(bigInteger, -n, mathContext);
        }
    }

    public BigDecimal(int n) {
        this(n, MathContext.UNLIMITED);
    }

    public BigDecimal(int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable()) {
            if (n == 0) {
                this.constructDFPZero();
                return;
            }
            this.flags |= 8;
            this.flags |= 4;
            if (n < 0) {
                this.flags |= 0x60;
            } else if (n > 0) {
                this.flags |= 0x20;
            }
            int n2 = mathContext.getPrecision();
            int n3 = mathContext.getRoundingMode().ordinal();
            if (n2 == 16 && n3 == 6 && this.DFPIntConstructor(n, 64, 0, 0)) {
                this.flags |= 0x10;
                this.flags |= BigDecimal.numDigits(n) << 7;
                return;
            }
            if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
                this.DFPIntConstructor(n, 0, 0, 0);
                if (n2 > 0 && n3 == 7) {
                    this.finish(n2, n3);
                } else {
                    this.flags |= 0x10;
                    this.flags |= BigDecimal.numDigits(n) << 7;
                }
                return;
            }
            if (n2 <= 16) {
                if (n3 == 6) {
                    n3 = 0;
                } else if (n3 == 0) {
                    n3 = 6;
                }
                if (this.DFPIntConstructor(n, 1, n2, n3)) {
                    this.flags &= 0xFFFFFFF7;
                    return;
                }
            }
        }
        this.flags |= 1;
        this.laside = n;
        this.flags |= 0x10;
        this.flags |= BigDecimal.numDigits(n) << 7;
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    public BigDecimal(long l) {
        this(l, MathContext.UNLIMITED);
    }

    public BigDecimal(long l, MathContext mathContext) {
        this.longConstructor(l, 0, mathContext);
    }

    public BigDecimal(String string) {
        this(string, MathContext.UNLIMITED);
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string.toCharArray(), 0, string.length(), mathContext);
    }

    private final void longConstructor(long l, int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable()) {
            int n2;
            if (l == 0L) {
                this.constructDFPZero();
                return;
            }
            if (l <= 9999999999999999L && l >= -9999999999999999L && -n >= -398 && -n < 369) {
                this.flags |= 4;
                if (l < 0L) {
                    this.flags |= 0x60;
                } else if (l > 0L) {
                    this.flags |= 0x20;
                }
                n2 = mathContext.getPrecision();
                int n3 = mathContext.getRoundingMode().ordinal();
                if (n2 == 16 && n3 == 6 && this.DFPLongExpConstructor(l, -n + 398, 64, 0, 0, false)) {
                    this.flags |= 0x10;
                    this.flags |= BigDecimal.numDigits(l) << 7;
                    this.flags |= 8;
                    this.exp = -n;
                    return;
                }
                if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
                    this.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false);
                    if (n2 > 0 && n3 == 7) {
                        this.finish(n2, n3);
                    } else {
                        this.flags |= 8;
                        this.exp = -n;
                        this.flags |= 0x10;
                        this.flags |= BigDecimal.numDigits(l) << 7;
                    }
                    return;
                }
                if (n2 <= 16) {
                    if (n3 == 6) {
                        n3 = 0;
                    } else if (n3 == 0) {
                        n3 = 6;
                    }
                    if (this.DFPLongExpConstructor(l, -n + 398, 1, n2, n3, false)) {
                        this.flags &= 0xFFFFFFF7;
                        return;
                    }
                }
            }
            this.flags |= 2;
            this.bi = BigInteger.valueOf(l);
            n2 = BigDecimal.precisionBI(this.bi);
            if (n2 <= 0x1FFFFFF) {
                this.flags |= 0x10;
                this.flags |= n2 << 7;
            }
            this.exp = -n;
        } else if (l != Long.MIN_VALUE) {
            this.laside = l;
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(l) << 7;
            this.flags |= 1;
            this.exp = -n;
        } else {
            this.flags |= 2;
            this.bi = BigInteger.valueOf(l);
            this.flags |= 0x10;
            this.flags |= 0x980;
            this.exp = -n;
        }
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    private final void charParser(char[] cArray, int n, int n2, MathContext mathContext) {
        int n3;
        int n4;
        int n5;
        int n6 = n2;
        boolean bl = false;
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        char c = '\u0000';
        int n10 = 0;
        char c2 = '\u0000';
        int n11 = 0;
        long l = 0L;
        long l2 = 0L;
        int n12 = 32;
        int n13 = 0;
        if (n2 <= 0) {
            this.bad(cArray);
        }
        if (n < 0 || n > cArray.length - 1) {
            this.bad(cArray);
        }
        if (n2 > cArray.length) {
            this.bad(cArray);
        }
        int n14 = n;
        int n15 = n2;
        while (n15 > 0) {
            c = cArray[n14];
            if (c >= '0' && c <= '9') {
                n9 = n14;
                l2 <<= 4;
                l2 |= (long)(c & 0xF);
                ++n7;
            } else if (c == '.') {
                if (n8 >= 0) {
                    this.bad(cArray);
                }
                n8 = n14 - n;
            } else if (c == '-') {
                if (n15 != n6) {
                    this.bad(cArray);
                }
                n12 = 96;
                ++n;
                --n2;
            } else if (c == '+') {
                if (n15 != n6) {
                    this.bad(cArray);
                }
                ++n;
                --n2;
            } else {
                if (c == 'e' || c == 'E') {
                    int n16;
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    if (n14 - n > n2 - 2) {
                        this.bad(cArray);
                    }
                    n3 = 0;
                    if (cArray[n14 + 1] == '-') {
                        n3 = 1;
                        n5 = n14 + 2;
                    } else {
                        n5 = cArray[n14 + 1] == '+' ? n14 + 2 : n14 + 1;
                    }
                    n4 = n2 - (n5 - n);
                    if (n4 == 0 | n4 > 10) {
                        throw new NumberFormatException("Invalid exponent");
                    }
                    char[] cArray2 = new char[]{'2', '1', '4', '7', '4', '8', '3', '6', '4', '7'};
                    if (n4 == 10) {
                        n16 = 1;
                        for (int i = 0; i < 10 && cArray[n5 + i] >= cArray2[i]; ++i) {
                            if (cArray[n5 + i] <= cArray2[i]) continue;
                            n16 = 0;
                            break;
                        }
                        if (n16 == 0) {
                            throw new NumberFormatException("Invalid scale, must be between 2147483647 and -2147483647");
                        }
                    }
                    n16 = n4;
                    n10 = n5;
                    while (n16 > 0) {
                        c2 = cArray[n10];
                        if (c2 < '0') {
                            this.bad(cArray);
                        }
                        if (c2 > '9') {
                            if (!Character.isDigit(c2)) {
                                this.bad(cArray);
                            }
                            if ((n11 = Character.digit(c2, 10)) < 0) {
                                this.bad(cArray);
                            }
                        } else {
                            n11 = c2 - 48;
                        }
                        n13 = n13 * 10 + n11;
                        --n16;
                        ++n10;
                    }
                    if (n3 == 0) break;
                    n13 = -n13;
                    break;
                }
                if (!Character.isDigit(c)) {
                    this.bad(cArray);
                }
                bl = true;
                n9 = n14;
                ++n7;
            }
            --n15;
            ++n14;
        }
        if (n7 == 0) {
            this.bad(cArray);
        }
        if (n8 >= 0) {
            l = (long)n13 + (long)n8 - (long)n7;
            if (-l < Integer.MIN_VALUE || -l > Integer.MAX_VALUE) {
                throw new NumberFormatException("BigDecimal scale outside legal range: " + -l);
            }
            n13 = n13 + n8 - n7;
        }
        n15 = n9 - 1;
        for (n14 = n; n14 <= n15; ++n14) {
            c = cArray[n14];
            if (c == '0') {
                ++n;
                --n8;
                --n7;
                continue;
            }
            if (c == '.') {
                ++n;
                --n8;
                continue;
            }
            if (c <= '9' || Character.digit(c, 10) != 0) break;
            ++n;
            --n8;
            --n7;
        }
        n5 = 1;
        if (BigDecimal.DFPHWAvailable() && n7 < 17 && n13 >= -398 && n13 < 369) {
            n4 = mathContext.getPrecision();
            n3 = mathContext.getRoundingMode().ordinal();
            if (l2 == 0L && n13 == 0) {
                this.constructDFPZero();
                return;
            }
            this.flags |= 4;
            if (l2 != 0L) {
                this.flags |= n12;
            }
            this.flags |= 8;
            this.exp = n13;
            if (n4 == 16 && n3 == 6) {
                if (n12 == 96) {
                    if (this.DFPLongExpConstructor(l2, n13 + 398, 64, 0, 0, true)) {
                        if (n12 == 96) {
                            this.laside |= Long.MIN_VALUE;
                        }
                        this.flags |= 0x10;
                        this.flags |= n7 << 7;
                        this.finish(n4, n3);
                        return;
                    }
                } else if (this.DFPLongExpConstructor(l2, n13 + 398, 64, 0, 0, true)) {
                    this.flags |= 0x10;
                    this.flags |= n7 << 7;
                    return;
                }
            }
            if (n4 == 0 || n4 > 0 && n3 == 7 || n4 > 16) {
                if (this.DFPLongExpConstructor(l2, n13 + 398, 0, 0, 0, true)) {
                    if (n12 == 96) {
                        this.laside |= Long.MIN_VALUE;
                    }
                    if (n4 > 0 && n3 == 7) {
                        if (n12 == 96) {
                            this.laside |= Long.MIN_VALUE;
                        }
                        this.finish(n4, n3);
                    } else {
                        this.flags |= 0x10;
                        this.flags |= n7 << 7;
                    }
                    return;
                }
            } else if (n4 <= 16) {
                if (n12 == 96) {
                    if (this.DFPLongExpConstructor(l2, n13 + 398, 0, 0, 0, true)) {
                        this.laside |= Long.MIN_VALUE;
                        this.finish(n4, n3);
                        return;
                    }
                } else {
                    if (n3 == 6) {
                        n3 = 0;
                    } else if (n3 == 0) {
                        n3 = 6;
                    }
                    if (this.DFPLongExpConstructor(l2, n13 + 398, 1, n4, n3, true)) {
                        this.flags &= 0xFFFFFFF7;
                        return;
                    }
                }
            }
            n5 = 0;
        }
        char[] cArray3 = new char[n7];
        n10 = n;
        if (bl) {
            n14 = 0;
            n3 = n7;
            while (n3 > 0) {
                if (n14 == n8) {
                    ++n10;
                }
                if ((c2 = cArray[n10]) <= '9') {
                    cArray3[n14] = c2;
                } else {
                    n11 = Character.digit(c2, 10);
                    if (n11 < 0) {
                        this.bad(cArray);
                    }
                    cArray3[n14] = (char)n11;
                }
                ++n10;
                --n3;
                ++n14;
            }
        } else {
            n3 = n7;
            n14 = 0;
            while (n3 > 0) {
                if (n14 == n8) {
                    ++n10;
                }
                cArray3[n14] = cArray[n10];
                ++n10;
                --n3;
                ++n14;
            }
        }
        if (cArray3[0] == '0') {
            n12 = 0;
        }
        this.charConstructor(cArray3, n13, n12, mathContext, n5 != 0);
    }

    private final void charConstructor(char[] cArray, int n, int n2, MathContext mathContext, boolean bl) {
        if (bl && cArray.length < 19) {
            this.flags |= 1;
            this.laside = BigDecimal.toLongForm(cArray);
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            if (n2 == 96) {
                this.laside *= -1L;
            }
            this.exp = n;
        } else {
            this.flags |= 2;
            this.bi = n2 == 96 ? new BigInteger("-" + new String(cArray)) : new BigInteger(new String(cArray));
            this.exp = n;
            if (cArray.length <= 0x1FFFFFF) {
                this.flags |= 0x10;
                this.flags |= cArray.length << 7;
            }
        }
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void bigIntegerConstructor(BigInteger bigInteger, int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable()) {
            block15: {
                if (BigDecimal.precisionBI(bigInteger) < 17 && -n <= 369 && -n >= -398) {
                    long l = bigInteger.longValue();
                    if (l == 0L && n == 0) {
                        this.constructDFPZero();
                        return;
                    }
                    int n2 = mathContext.getPrecision();
                    int n3 = mathContext.getRoundingMode().ordinal();
                    if (n2 == 16 && n3 == 6 && this.DFPLongExpConstructor(l, -n + 398, 64, 0, 0, false)) {
                        this.flags |= 0x10;
                        this.flags |= BigDecimal.numDigits(l) << 7;
                        this.flags |= 4;
                        this.flags |= bigInteger.signum() << 5 & 0x60;
                        this.flags |= 8;
                        this.exp = -n;
                        return;
                    }
                    if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
                        this.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false);
                        this.flags |= 4;
                        this.flags |= bigInteger.signum() << 5 & 0x60;
                        if (n2 > 0 && n3 == 7) {
                            this.finish(n2, n3);
                            break block15;
                        } else {
                            this.flags |= 0x10;
                            this.flags |= BigDecimal.numDigits(l) << 7;
                            this.flags |= 8;
                            this.exp = -n;
                            return;
                        }
                    }
                    if (n2 <= 16) {
                        if (n3 == 6) {
                            n3 = 0;
                        } else if (n3 == 0) {
                            n3 = 6;
                        }
                        if (this.DFPLongExpConstructor(l, -n + 398, 1, n2, n3, false)) {
                            this.flags |= 4;
                            this.flags |= bigInteger.signum() << 5 & 0x60;
                            return;
                        }
                    }
                }
            }
            this.flags |= 2;
            this.bi = bigInteger;
            this.exp = -n;
            int n4 = BigDecimal.precisionBI(bigInteger);
            if (n4 <= 0x1FFFFFF) {
                this.flags |= 0x10;
                this.flags |= n4 << 7;
            }
            if (mathContext == MathContext.UNLIMITED) return;
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            return;
        }
        if (bigInteger.bitLength() < 63) {
            this.flags |= 1;
            this.laside = bigInteger.longValue();
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.exp = -n;
            if (mathContext == MathContext.UNLIMITED) return;
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            return;
        }
        this.flags |= 2;
        this.bi = bigInteger;
        this.exp = -n;
        int n5 = BigDecimal.precisionBI(bigInteger);
        if (n5 <= 0x1FFFFFF) {
            this.flags |= 0x10;
            this.flags |= n5 << 7;
        }
        if (mathContext == MathContext.UNLIMITED) return;
        this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
    }

    private final void bad(char[] cArray) {
        throw new NumberFormatException("Not a valid char constructor input  " + String.valueOf(cArray));
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        int n;
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (((this.flags | bigDecimal.flags) & 3) == 0 && (n = -Math.max(this.scale(), bigDecimal.scale())) >= -398 && n <= 369 && bigDecimal2.DFPScaledAdd(bigDecimal.laside, this.laside, n + 398)) {
            if (bigDecimal2.isDFPZero()) {
                bigDecimal2.laside &= Long.MAX_VALUE;
            }
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal2 = bigDecimal3.longAdd(bigDecimal4, bigDecimal2, MathContext.UNLIMITED, false);
        return bigDecimal2;
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = null;
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        boolean bl = false;
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            int n;
            int n2 = mathContext.getPrecision();
            int n3 = mathContext.getRoundingMode().ordinal();
            if (n2 != 0 && mathContext.getRoundingMode().ordinal() != 7) {
                n = this.isDFPZero();
                boolean bl2 = bigDecimal.isDFPZero();
                if (n != 0 && bl2) {
                    bigDecimal2 = BigDecimal.valueOf(0L, Math.max(this.scale(), bigDecimal.scale()));
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
                if (n != 0) {
                    bigDecimal2 = BigDecimal.clone(bigDecimal);
                    if (this.scale() > bigDecimal.scale()) {
                        int n4 = -bigDecimal.scale() + this.scale();
                        if (mathContext.getPrecision() - bigDecimal.precision() > 0) {
                            bigDecimal2 = bigDecimal2.setScale(Math.abs(-bigDecimal.scale() - n4), true);
                        }
                    }
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
                if (bl2) {
                    bigDecimal2 = BigDecimal.clone(this);
                    if (bigDecimal.scale() > this.scale()) {
                        int n5 = -this.scale() + bigDecimal.scale();
                        if (mathContext.getPrecision() - bigDecimal.precision() > 0) {
                            bigDecimal2 = bigDecimal2.setScale(Math.abs(-this.scale() - n5), true);
                        }
                    }
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
            }
            bigDecimal2 = new BigDecimal();
            if (n2 == 16 && n3 == 6) {
                if (bigDecimal2.DFPAdd(bigDecimal.laside, this.laside, 64, 0, 0)) {
                    bl = true;
                }
            } else if (n2 == 0) {
                n = -Math.max(this.scale(), bigDecimal.scale());
                if (n >= -398 && n <= 369 && bigDecimal2.DFPScaledAdd(bigDecimal.laside, this.laside, n + 398)) {
                    bl = true;
                }
            } else if (n2 > 0 && n3 == 7) {
                if (bigDecimal2.DFPAdd(bigDecimal.laside, this.laside, 0, 0, 0)) {
                    bigDecimal2.finish(n2, n3);
                    bl = true;
                }
            } else if (n2 <= 16) {
                if (n3 == 6) {
                    n3 = 0;
                } else if (n3 == 0) {
                    n3 = 6;
                }
                if (bigDecimal2.DFPAdd(bigDecimal.laside, this.laside, 1, n2, n3)) {
                    bl = true;
                }
            }
            if (bl) {
                if (bigDecimal2.isDFPZero()) {
                    bigDecimal2.laside &= Long.MAX_VALUE;
                }
                return bigDecimal2;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = new BigDecimal();
        }
        bigDecimal2 = bigDecimal3.longAdd(bigDecimal4, bigDecimal2, mathContext, false);
        return bigDecimal2;
    }

    private final BigDecimal longAdd(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = this;
        int n = bigDecimal4.exp;
        int n2 = bigDecimal.exp;
        int n3 = 0;
        boolean bl2 = false;
        if ((bigDecimal4.flags & bigDecimal.flags & 1) == 1) {
            boolean bl3;
            boolean bl4;
            long l;
            long l2;
            long l3;
            long l4;
            if (mathContext.getPrecision() != 0 && mathContext.getRoundingMode().ordinal() != 7) {
                if (n != n2 && bigDecimal4.laside != 0L && bigDecimal.laside != 0L) {
                    BigDecimal bigDecimal5;
                    BigDecimal bigDecimal6;
                    if (-((long)n) + (long)n2 < 0L) {
                        bigDecimal6 = bigDecimal4;
                        bigDecimal5 = bigDecimal;
                    } else {
                        bigDecimal6 = bigDecimal;
                        bigDecimal5 = bigDecimal4;
                    }
                    l4 = -((long)bigDecimal6.exp) - (long)bigDecimal6.precision() + (long)mathContext.getPrecision();
                    l3 = -((long)bigDecimal5.exp) - (long)bigDecimal5.precision() + 1L;
                    if (l3 > -((long)bigDecimal6.exp) + 2L && l3 > l4 + 2L) {
                        int n4 = bigDecimal5.signum();
                        if (bigDecimal5 == bigDecimal) {
                            bigDecimal = new BigDecimal();
                            bigDecimal.laside = n4;
                            bigDecimal.exp = (int)(-(Math.max(-((long)bigDecimal6.exp), l4) + 3L));
                            bigDecimal.flags |= 1;
                        } else {
                            bigDecimal4 = new BigDecimal();
                            bigDecimal4.laside = n4;
                            bigDecimal4.exp = (int)(-(Math.max(-((long)bigDecimal6.exp), l4) + 3L));
                            bigDecimal4.flags |= 1;
                        }
                    }
                }
                l2 = bigDecimal4.laside;
                l = bigDecimal.laside;
                bl4 = l2 == 0L;
                boolean bl5 = bl3 = l == 0L;
                if (bl4 && bl3) {
                    if (!bl) {
                        BigDecimal.clone(bigDecimal2, bigDecimal);
                        bigDecimal3 = bigDecimal2;
                    }
                    bigDecimal3.laside = 0L;
                    bigDecimal3.exp = Math.min(bigDecimal4.exp, bigDecimal.exp);
                    bigDecimal3.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    return bigDecimal3;
                }
                if (bl4) {
                    if (!bl) {
                        BigDecimal.clone(bigDecimal2, bigDecimal);
                        bigDecimal3 = bigDecimal2;
                    }
                    bigDecimal3.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    int n5 = Math.min(bigDecimal4.exp, bigDecimal.exp);
                    int n6 = mathContext.getPrecision() - bigDecimal3.precision();
                    l3 = -n5 + bigDecimal3.exp;
                    bigDecimal3 = (long)n6 >= l3 ? bigDecimal3.longSetScale(-n5, true) : bigDecimal3.longSetScale(bigDecimal3.scale() + n6, true);
                    return bigDecimal3;
                }
                if (bl3) {
                    BigDecimal.clone(bigDecimal2, bigDecimal4);
                    bigDecimal3 = bigDecimal2;
                    bigDecimal3.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    int n7 = Math.min(bigDecimal4.exp, bigDecimal.exp);
                    int n8 = mathContext.getPrecision() - bigDecimal3.precision();
                    l3 = -n7 + bigDecimal3.exp;
                    bigDecimal3 = (long)n8 >= l3 ? bigDecimal3.longSetScale(-n7, true) : bigDecimal3.setScale(bigDecimal3.scale() + n8, true);
                    return bigDecimal3;
                }
            }
            l2 = bigDecimal4.laside;
            l = bigDecimal.laside;
            n = bigDecimal4.exp;
            n2 = bigDecimal.exp;
            bl4 = l2 == 0L;
            boolean bl6 = bl3 = l == 0L;
            if (!bl2) {
                if (!bl) {
                    bigDecimal3 = bigDecimal2;
                }
                n3 = bigDecimal3.flags;
                if (n == n2) {
                    if (!BigDecimal.overflowAdd(l2, l)) {
                        bigDecimal3.laside = l2 + l;
                        bigDecimal3.exp = n;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 1;
                        bl2 = true;
                    } else {
                        BigInteger bigInteger = BigInteger.valueOf(l2);
                        BigInteger bigInteger2 = BigInteger.valueOf(l);
                        bigDecimal3.bi = bigInteger.add(bigInteger2);
                        bigDecimal3.exp = n;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 2;
                        bl2 = true;
                    }
                } else if (n < n2) {
                    l4 = (long)n2 - (long)n;
                    l3 = BigDecimal.powerOfTenLL(l4);
                    if (l3 != -1L && !BigDecimal.overflowMultiply(l, l3)) {
                        if (!BigDecimal.overflowAdd(l2, l *= l3)) {
                            bigDecimal3.laside = l2 + l;
                            bigDecimal3.exp = n;
                            n3 &= 0xFFFFFFFC;
                            n3 |= 1;
                            bl2 = true;
                        }
                    } else {
                        BigInteger bigInteger = BigInteger.valueOf(l2);
                        BigInteger bigInteger3 = BigInteger.valueOf(l);
                        if (!bl3) {
                            if (l4 > Integer.MAX_VALUE) {
                                throw new ArithmeticException("Scale oveflow");
                            }
                            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l4));
                        }
                        bigDecimal3.bi = bigInteger.add(bigInteger3);
                        bigDecimal3.exp = n;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 2;
                        bl2 = true;
                    }
                } else {
                    l4 = (long)n - (long)n2;
                    l3 = BigDecimal.powerOfTenLL(l4);
                    if (l3 != -1L && !BigDecimal.overflowMultiply(l2, l3)) {
                        if (!BigDecimal.overflowAdd(l2 *= l3, l)) {
                            bigDecimal3.laside = l2 + l;
                            bigDecimal3.exp = n2;
                            n3 &= 0xFFFFFFFC;
                            n3 |= 1;
                            bl2 = true;
                        }
                    } else {
                        BigInteger bigInteger = BigInteger.valueOf(l2);
                        BigInteger bigInteger4 = BigInteger.valueOf(l);
                        if (!bl4) {
                            if (l4 > Integer.MAX_VALUE) {
                                throw new ArithmeticException("Scale oveflow");
                            }
                            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l4));
                        }
                        bigDecimal3.bi = bigInteger.add(bigInteger4);
                        bigDecimal3.exp = n2;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 2;
                        bl2 = true;
                    }
                }
            }
            bigDecimal3.flags = n3;
        }
        bigDecimal3.flags &= 0xFFFFFFEF;
        if (bl2) {
            if (mathContext != MathContext.UNLIMITED) {
                bigDecimal3.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            }
            return bigDecimal3;
        }
        return this.slAdd(bigDecimal, bigDecimal2, mathContext, bl);
    }

    private BigDecimal slAdd(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        boolean bl2;
        boolean bl3;
        long l;
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = this;
        boolean bl4 = false;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        int n = bigDecimal4.exp;
        int n2 = bigDecimal.exp;
        int n3 = 0;
        if (mathContext.getPrecision() != 0 && mathContext.getRoundingMode().ordinal() != 7) {
            long l2;
            if (n != n2 && bigDecimal4.signum() != 0 && bigDecimal.signum() != 0) {
                BigDecimal bigDecimal5;
                BigDecimal bigDecimal6;
                if (-((long)n) + (long)n2 < 0L) {
                    bigDecimal6 = bigDecimal4;
                    bigDecimal5 = bigDecimal;
                } else {
                    bigDecimal6 = bigDecimal;
                    bigDecimal5 = bigDecimal4;
                }
                l = -((long)bigDecimal6.exp) - (long)bigDecimal6.precision() + (long)mathContext.getPrecision();
                l2 = -((long)bigDecimal5.exp) - (long)bigDecimal5.precision() + 1L;
                if (l2 > -((long)bigDecimal6.exp) + 2L && l2 > l + 2L) {
                    int n4 = bigDecimal5.signum();
                    if (bigDecimal5 == bigDecimal) {
                        bigDecimal = new BigDecimal();
                        bigDecimal.bi = BigInteger.valueOf(n4);
                        bigDecimal.exp = (int)(-(Math.max(-((long)bigDecimal6.exp), l) + 3L));
                        bigDecimal.flags |= 2;
                    } else {
                        bigDecimal4 = new BigDecimal();
                        bigDecimal4.bi = BigInteger.valueOf(n4);
                        bigDecimal4.exp = -(Math.max(-bigDecimal6.exp, (int)l) + 3);
                        bigDecimal4.flags |= 2;
                    }
                }
            }
            bigInteger = bigDecimal4.bi;
            bigInteger2 = bigDecimal.bi;
            if ((bigDecimal4.flags & 3) != 2) {
                bigInteger = BigInteger.valueOf(bigDecimal4.laside);
            }
            if ((bigDecimal.flags & 3) != 2) {
                bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
            }
            n = bigDecimal4.exp;
            n2 = bigDecimal.exp;
            bl3 = bigInteger.signum() == 0;
            boolean bl5 = bl2 = bigInteger2.signum() == 0;
            if (bl3 && bl2) {
                if (!bl) {
                    BigDecimal.clone(bigDecimal2, bigDecimal);
                    bigDecimal3 = bigDecimal2;
                }
                bigDecimal3.laside = 0L;
                bigDecimal3.exp = Math.min(n, n2);
                bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                return bigDecimal3;
            }
            if (bl3) {
                if (!bl) {
                    BigDecimal.clone(bigDecimal2, bigDecimal);
                    bigDecimal3 = bigDecimal2;
                }
                bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                int n5 = Math.min(n, n2);
                int n6 = mathContext.getPrecision() - bigDecimal3.precision();
                l2 = -n5 + bigDecimal3.exp;
                bigDecimal3 = (long)n6 >= l2 ? bigDecimal3.slSetScale(-n5, true) : bigDecimal3.slSetScale(bigDecimal3.scale() + n6, true);
                return bigDecimal3;
            }
            if (bl2) {
                BigDecimal.clone(bigDecimal2, bigDecimal4);
                bigDecimal3 = bigDecimal2;
                bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                int n7 = Math.min(n, n2);
                int n8 = mathContext.getPrecision() - bigDecimal3.precision();
                l2 = -n7 + bigDecimal3.exp;
                bigDecimal3 = (long)n8 >= l2 ? bigDecimal3.slSetScale(-n7, true) : bigDecimal3.slSetScale(bigDecimal3.scale() + n8, true);
                return bigDecimal3;
            }
        }
        bigInteger = bigDecimal4.bi;
        bigInteger2 = bigDecimal.bi;
        if ((bigDecimal4.flags & 3) != 2) {
            bigInteger = BigInteger.valueOf(bigDecimal4.laside);
        }
        if ((bigDecimal.flags & 3) != 2) {
            bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
        }
        n = bigDecimal4.exp;
        n2 = bigDecimal.exp;
        bl3 = bigInteger.signum() == 0;
        boolean bl6 = bl2 = bigInteger2.signum() == 0;
        if (!bl4) {
            if (!bl) {
                bigDecimal3 = bigDecimal2;
            }
            n3 = bigDecimal3.flags;
            if (n == n2) {
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.exp = bigDecimal4.exp;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            } else if (n < n2) {
                if (!bl2) {
                    l = (long)n2 - (long)n;
                    if (l > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale oveflow");
                    }
                    bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(l));
                }
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.exp = n;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            } else {
                if (!bl3) {
                    l = (long)n - (long)n2;
                    if (l > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale oveflow");
                    }
                    bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l));
                }
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.exp = n2;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            }
            bigDecimal3.flags = n3;
        }
        bigDecimal3.flags &= 0xFFFFFFEF;
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal3.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal3;
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        int n;
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (((this.flags | bigDecimal.flags) & 3) == 0 && (n = -Math.max(this.scale(), bigDecimal.scale())) >= -398 && n <= 369 && bigDecimal2.DFPScaledSubtract(bigDecimal.laside, this.laside, n + 398)) {
            if (bigDecimal2.isDFPZero()) {
                bigDecimal2.laside &= Long.MAX_VALUE;
            }
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal2 = bigDecimal3.subtract(bigDecimal4, bigDecimal2, MathContext.UNLIMITED);
        return bigDecimal2;
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = null;
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        boolean bl = false;
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            int n;
            int n2 = mathContext.getPrecision();
            int n3 = mathContext.getRoundingMode().ordinal();
            if (n2 != 0 && mathContext.getRoundingMode().ordinal() != 7) {
                n = this.isDFPZero();
                boolean bl2 = bigDecimal.isDFPZero();
                if (n != 0 && bl2) {
                    bigDecimal2 = BigDecimal.valueOf(0L, Math.max(this.scale(), bigDecimal.scale()));
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
                if (n != 0) {
                    bigDecimal2 = bigDecimal.negate();
                    if (this.scale() > bigDecimal.scale()) {
                        int n4 = -bigDecimal.scale() + this.scale();
                        if (mathContext.getPrecision() - bigDecimal.precision() > 0) {
                            bigDecimal2 = bigDecimal2.setScale(Math.abs(-bigDecimal.scale() - n4), true);
                        }
                    }
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
                if (bl2) {
                    bigDecimal2 = BigDecimal.clone(this);
                    if (bigDecimal.scale() > this.scale()) {
                        int n5 = -this.scale() + bigDecimal.scale();
                        if (mathContext.getPrecision() - bigDecimal.precision() > 0) {
                            bigDecimal2 = bigDecimal2.setScale(Math.abs(-this.scale() - n5), true);
                        }
                    }
                    if (mathContext != MathContext.UNLIMITED) {
                        bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                    }
                    return bigDecimal2;
                }
            }
            bigDecimal2 = new BigDecimal();
            if (n2 == 16 && n3 == 6) {
                if (bigDecimal2.DFPSubtract(bigDecimal.laside, this.laside, 64, 0, 0)) {
                    bl = true;
                }
            } else if (n2 == 0) {
                n = -Math.max(this.scale(), bigDecimal.scale());
                if (n >= -398 && n <= 369 && bigDecimal2.DFPScaledSubtract(bigDecimal.laside, this.laside, n + 398)) {
                    bl = true;
                }
            } else if (n2 > 0 && n3 == 7) {
                if (bigDecimal2.DFPSubtract(bigDecimal.laside, this.laside, 0, 0, 0)) {
                    bigDecimal2.finish(n2, n3);
                    bl = true;
                }
            } else if (n2 <= 16) {
                if (n3 == 6) {
                    n3 = 0;
                } else if (n3 == 0) {
                    n3 = 6;
                }
                if (bigDecimal2.DFPSubtract(bigDecimal.laside, this.laside, 1, n2, n3)) {
                    bl = true;
                }
            }
            if (bl) {
                if (bigDecimal2.isDFPZero()) {
                    bigDecimal2.laside &= Long.MAX_VALUE;
                }
                return bigDecimal2;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = new BigDecimal();
        }
        bigDecimal2 = bigDecimal3.subtract(bigDecimal4, bigDecimal2, mathContext);
        return bigDecimal2;
    }

    private final BigDecimal subtract(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimal bigDecimal3 = BigDecimal.clone(bigDecimal);
        if ((bigDecimal.flags & 1) == 1) {
            bigDecimal3.laside *= -1L;
        } else {
            bigDecimal3.bi = bigDecimal3.bi.negate();
        }
        return this.longAdd(bigDecimal3, bigDecimal2, mathContext, true);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        int n;
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (((this.flags | bigDecimal.flags) & 3) == 0 && (n = -(this.scale() + bigDecimal.scale())) >= -398 && n <= 369 && bigDecimal2.DFPScaledMultiply(bigDecimal.laside, this.laside, n + 398)) {
            if (bigDecimal2.isDFPZero()) {
                bigDecimal2.laside &= Long.MAX_VALUE;
            }
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal3.longMultiply(bigDecimal4, bigDecimal2, MathContext.UNLIMITED, false);
        return bigDecimal2;
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        boolean bl = false;
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            int n = mathContext.getPrecision();
            int n2 = mathContext.getRoundingMode().ordinal();
            if (n == 16 && n2 == 6) {
                if (bigDecimal2.DFPMultiply(bigDecimal.laside, this.laside, 64, 0, 0)) {
                    bl = true;
                }
            } else if (n == 0) {
                int n3 = -(this.scale() + bigDecimal.scale());
                if (n3 >= -398 && n3 <= 369 && bigDecimal2.DFPScaledMultiply(bigDecimal.laside, this.laside, n3 + 398)) {
                    bl = true;
                }
            } else if (n > 0 && n2 == 7) {
                if (bigDecimal2.DFPMultiply(bigDecimal.laside, this.laside, 0, 0, 0)) {
                    bigDecimal2.finish(n, n2);
                    bl = true;
                }
            } else if (n <= 16) {
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
                if (bigDecimal2.DFPMultiply(bigDecimal.laside, this.laside, 1, n, n2)) {
                    bl = true;
                }
            }
            if (bl) {
                if (bigDecimal2.isDFPZero()) {
                    bigDecimal2.laside &= Long.MAX_VALUE;
                }
                return bigDecimal2;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal3.longMultiply(bigDecimal4, bigDecimal2, mathContext, false);
        return bigDecimal2;
    }

    private final void longMultiply(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        BigDecimal bigDecimal3 = this;
        long l = 0L;
        boolean bl2 = false;
        if (!bl) {
            bigDecimal3 = bigDecimal2;
        }
        int n = bigDecimal3.flags;
        n &= 0xFFFFFFEF;
        l = (long)this.scale() + (long)bigDecimal.scale();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + l);
            }
        }
        bigDecimal3.exp = -((int)l);
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            if (!BigDecimal.overflowMultiply(this.laside, bigDecimal.laside)) {
                long l2;
                bigDecimal3.laside = l2 = this.laside * bigDecimal.laside;
                n &= 0xFFFFFFFC;
                n |= 1;
                bl2 = true;
            } else {
                BigInteger bigInteger = BigInteger.valueOf(this.laside);
                BigInteger bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
                bigDecimal3.bi = bigInteger2.multiply(bigInteger);
                n &= 0xFFFFFFFC;
                n |= 2;
                bl2 = true;
            }
            bigDecimal3.flags = n;
        }
        if (bl2) {
            if (mathContext != MathContext.UNLIMITED) {
                bigDecimal3.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            }
        } else {
            this.slMultiply(bigDecimal, bigDecimal3, mathContext, bl);
        }
    }

    private final void slMultiply(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = bigDecimal3 = this;
        if (bl) {
            bigDecimal4 = BigDecimal.clone(bigDecimal3);
        }
        BigInteger bigInteger = bigDecimal4.bi;
        BigInteger bigInteger2 = bigDecimal.bi;
        bigInteger = bigDecimal3.bi;
        bigInteger2 = bigDecimal.bi;
        if ((bigDecimal4.flags & 3) != 2) {
            bigInteger = BigInteger.valueOf(bigDecimal4.laside);
        }
        if ((bigDecimal.flags & 3) != 2) {
            bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
        }
        int n = bigDecimal2.flags;
        n &= 0xFFFFFFFC;
        n |= 2;
        bigDecimal2.bi = bigInteger.multiply(bigInteger2);
        bigDecimal2.flags = n &= 0xFFFFFFEF;
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale(), n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return this.divide(bigDecimal, this.scale(), roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return this.divide(bigDecimal, n, roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        RoundingMode.valueOf(n2);
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            boolean bl = false;
            int n3 = 0;
            if (-n >= -398 && -n < 369) {
                if (bigDecimal.isDFPZero()) {
                    throw new ArithmeticException("Divide by zero.");
                }
                if (n2 == 6) {
                    n3 = bigDecimal2.DFPScaledDivide(bigDecimal.laside, this.laside, -n + 398, 0, 0);
                } else {
                    if (n2 == 0) {
                        n2 = 6;
                    }
                    n3 = bigDecimal2.DFPScaledDivide(bigDecimal.laside, this.laside, -n + 398, 1, n2);
                    if (n2 == 6) {
                        n2 = 0;
                    }
                }
                if (n3 == 0 && n2 == 7) {
                    throw new ArithmeticException("Scale not large enough, rounding required");
                }
                if (n3 == 1 || n3 == 0) {
                    bl = true;
                }
            }
            if (bl) {
                if (bigDecimal2.isDFPZero()) {
                    bigDecimal2.laside &= Long.MAX_VALUE;
                }
                return bigDecimal2;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal3.divide(bigDecimal4, bigDecimal2, n, n2);
        return bigDecimal2;
    }

    private final void divide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        BigDecimal bigDecimal3 = null;
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            bigDecimal3 = this.longScaledDivide(bigDecimal, bigDecimal2, n, n2);
        }
        if (bigDecimal3 == null) {
            this.LLToBI();
            bigDecimal.LLToBI();
            this.slScaledDivide(bigDecimal, bigDecimal2, n2, n);
        }
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = new BigDecimal();
        BigDecimal bigDecimal4 = bigDecimal2;
        BigDecimal bigDecimal5 = bigDecimal;
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            if (bigDecimal.isDFPZero()) {
                throw new ArithmeticException("Divide by zero.");
            }
            int n = (int)Math.min((double)bigDecimal2.precision() + Math.ceil(10 * bigDecimal.precision() / 3), 2.147483647E9);
            boolean bl = false;
            int n2 = bigDecimal3.DFPDivide(bigDecimal.laside, this.laside, true, 0, 0, 0);
            if (n2 == 1) {
                if (bigDecimal3.precision() > n) {
                    throw new ArithmeticException("Non-terminating decimal expansion");
                }
                bl = true;
            }
            if (bl) {
                if (bigDecimal3.isDFPZero()) {
                    bigDecimal3.laside &= Long.MAX_VALUE;
                }
                return bigDecimal3;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal4.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal5.DFPToBI();
        }
        bigDecimal4.divide(bigDecimal5, bigDecimal3, MathContext.UNLIMITED);
        return bigDecimal3;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = new BigDecimal();
        BigDecimal bigDecimal4 = bigDecimal2;
        BigDecimal bigDecimal5 = bigDecimal;
        int n = mathContext.getPrecision();
        if (n == 0) {
            return bigDecimal2.divide(bigDecimal);
        }
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            if (bigDecimal.isDFPZero()) {
                throw new ArithmeticException("Divide by zero.");
            }
            int n2 = mathContext.getRoundingMode().ordinal();
            boolean bl = false;
            if (n == 16 && n2 == 6) {
                int n3 = bigDecimal3.DFPDivide(bigDecimal.laside, this.laside, false, 64, 0, 0);
                if (n3 == 1) {
                    bl = true;
                }
            } else if (n <= 16) {
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
                int n4 = bigDecimal3.DFPDivide(bigDecimal.laside, this.laside, true, 1, n, n2);
                if (n4 == 0 && n2 == 7) {
                    throw new ArithmeticException("Inexact result required rounding");
                }
                if (n4 == 1) {
                    bl = true;
                }
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
            }
            if (bl) {
                if (bigDecimal3.isDFPZero()) {
                    bigDecimal3.laside &= Long.MAX_VALUE;
                }
                return bigDecimal3;
            }
        }
        if ((this.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal4.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal5.DFPToBI();
        }
        bigDecimal4.divide(bigDecimal5, bigDecimal3, mathContext);
        return bigDecimal3;
    }

    private final void divide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimal bigDecimal3 = null;
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            bigDecimal3 = this.longPrecisionDivide(bigDecimal, bigDecimal2, mathContext);
        }
        if (bigDecimal3 == null) {
            this.LLToBI();
            bigDecimal.LLToBI();
            this.slPrecisionDivide(bigDecimal, bigDecimal2, mathContext);
        }
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.divideToIntegralValue(bigDecimal);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
        BigDecimal bigDecimal4 = this.subtract(bigDecimal3);
        return bigDecimal4;
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this.divideToIntegralValue(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
        BigDecimal bigDecimal4 = this.subtract(bigDecimal3);
        return bigDecimal4;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal, mathContext), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.signum() == 0) {
            throw new ArithmeticException("Dividing by 0");
        }
        int n = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal bigDecimal3 = this.abs();
        if (bigDecimal3.compareTo(bigDecimal2 = bigDecimal.abs()) < 0) {
            return BigDecimal.valueOf(0L, n);
        }
        int n2 = this.precision();
        int n3 = bigDecimal.precision();
        long l = (long)Math.min((double)n2 + Math.ceil(10.0 * (double)n3 / 3.0), 2.147483647E9);
        if ((l += Math.min(Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L + l, Integer.MAX_VALUE)) > Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale overflow");
        }
        MathContext mathContext = new MathContext((int)l, RoundingMode.DOWN);
        BigDecimal bigDecimal4 = this.divide(bigDecimal, mathContext);
        int n4 = bigDecimal4.scale();
        if (n4 > 0) {
            bigDecimal4 = bigDecimal4.setScale(0, RoundingMode.DOWN);
        }
        if (n > 0) {
            bigDecimal4 = bigDecimal4.setScale(n);
        } else {
            int n5 = Math.abs(n - bigDecimal4.scale());
            if (n5 != 0) {
                if ((bigDecimal4.flags & 3) == 0) {
                    bigDecimal4.DFPToLL();
                }
                if ((bigDecimal4.flags & 1) == 1) {
                    long l2 = bigDecimal4.laside;
                    int n6 = -bigDecimal4.exp;
                    while (l2 % 10L == 0L && n5 > 0) {
                        l2 /= 10L;
                        --n6;
                        --n5;
                    }
                    bigDecimal4.laside = l2;
                    bigDecimal4.exp = -n6;
                } else {
                    BigInteger bigInteger = bigDecimal4.bi;
                    int n7 = -bigDecimal4.exp;
                    while (bigInteger.mod(BigInteger.TEN).equals(BigInteger.ZERO) && n5 > 0) {
                        bigInteger = bigInteger.divide(BigInteger.TEN);
                        --n7;
                        --n5;
                    }
                    bigDecimal4.bi = bigInteger;
                    bigDecimal4.exp = -n7;
                }
                bigDecimal4.flags &= 0xFFFFFFEF;
            }
        }
        return bigDecimal4;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        BigDecimal bigDecimal2;
        int n2 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal bigDecimal3 = this.abs();
        if (bigDecimal3.compareTo(bigDecimal2 = bigDecimal.abs()) < 0) {
            return BigDecimal.valueOf(0L, n2);
        }
        int n3 = this.precision();
        int n4 = bigDecimal.precision();
        long l = (long)Math.min((double)n3 + Math.ceil(10.0 * (double)n4 / 3.0), 2.147483647E9);
        if (mathContext.getPrecision() == 0) {
            l += Math.min(Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L + l, Integer.MAX_VALUE);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale overflow");
        }
        MathContext mathContext2 = new MathContext((int)l, RoundingMode.DOWN);
        BigDecimal bigDecimal4 = this.divide(bigDecimal, mathContext2);
        int n5 = bigDecimal4.scale();
        if (n5 > 0) {
            bigDecimal4 = bigDecimal4.setScale(0, RoundingMode.DOWN);
        }
        if (n2 > 0 && mathContext.getPrecision() == 0) {
            bigDecimal4 = bigDecimal4.setScale(n2);
        } else if (n2 > 0) {
            n = mathContext.getPrecision() - bigDecimal4.precision();
            if (n > 0) {
                bigDecimal4 = bigDecimal4.setScale(Math.min(n, n2));
            }
        } else {
            n = Math.abs(n2 - bigDecimal4.scale());
            if (n != 0) {
                if ((bigDecimal4.flags & 3) == 0) {
                    bigDecimal4.DFPToLL();
                }
                if ((bigDecimal4.flags & 1) == 1) {
                    long l2 = bigDecimal4.laside;
                    int n6 = -bigDecimal4.exp;
                    while (l2 % 10L == 0L && n > 0) {
                        l2 /= 10L;
                        --n6;
                        --n;
                    }
                    bigDecimal4.laside = l2;
                    bigDecimal4.exp = -n6;
                } else {
                    BigInteger bigInteger = bigDecimal4.bi;
                    int n7 = -bigDecimal4.exp;
                    while (bigInteger.mod(BigInteger.TEN).equals(BigInteger.ZERO) && n > 0) {
                        bigInteger = bigInteger.divide(BigInteger.TEN);
                        --n7;
                        --n;
                    }
                    bigDecimal4.bi = bigInteger;
                    bigDecimal4.exp = -n7;
                }
                bigDecimal4.flags &= 0xFFFFFFEF;
            }
        }
        BigDecimal bigDecimal5 = this.subtract(bigDecimal.multiply(bigDecimal4));
        if (bigDecimal5.abs().compareTo(bigDecimal2) >= 0) {
            throw new ArithmeticException("Integral division is inexact");
        }
        if (mathContext.getPrecision() > 0 && bigDecimal4.precision() > mathContext.getPrecision()) {
            throw new ArithmeticException("Requires more than prec digits");
        }
        return bigDecimal4;
    }

    private final BigDecimal longPrecisionDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        long l;
        long l2;
        BigDecimal bigDecimal3 = null;
        long l3 = -this.exp;
        long l4 = -bigDecimal.exp;
        long l5 = l3;
        long l6 = l4;
        int n = this.signum() * bigDecimal.signum();
        long l7 = this.laside;
        long l8 = bigDecimal.laside;
        if (l7 < 0L) {
            l7 *= -1L;
        }
        if (l8 < 0L) {
            l8 *= -1L;
        }
        long l9 = this.precision();
        long l10 = bigDecimal.precision();
        long l11 = 0L;
        long l12 = 0L;
        boolean bl = false;
        int n2 = mathContext.getPrecision();
        boolean bl2 = true;
        long l13 = 0L;
        if (bigDecimal.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (n2 == 0) {
            l13 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            n2 = (int)Math.min((double)l9 + Math.ceil(10.0 * (double)l10 / 3.0), 2.147483647E9);
            bl = true;
        } else {
            l13 = l5 - l6;
        }
        if (this.laside == 0L) {
            BigDecimal.clone(bigDecimal2, this);
            bigDecimal2.exp = -((int)Math.max(Math.min(l13, Integer.MAX_VALUE), Integer.MIN_VALUE));
            return bigDecimal2;
        }
        if (l9 > l10) {
            l11 = l9 - l10;
            l12 = BigDecimal.powerOfTenLL(l11);
            if (l12 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l8, l12)) {
                return null;
            }
            l8 *= l12;
            l4 += l11;
        } else if (l9 < l10) {
            l11 = l10 - l9;
            l12 = BigDecimal.powerOfTenLL(l11);
            if (l12 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l7, l12)) {
                return null;
            }
            l7 *= l12;
            l3 += l11;
        }
        if (l7 > l8) {
            if (BigDecimal.overflowMultiply(l8, 10L)) {
                return null;
            }
            l8 *= 10L;
            ++l4;
        }
        if ((l12 = BigDecimal.powerOfTenLL(n2)) == -1L) {
            return null;
        }
        if (BigDecimal.overflowMultiply(l7, l12)) {
            return null;
        }
        if ((l2 = (l7 *= l12) - (l = l7 / l8) * l8) != 0L) {
            bl2 = false;
        }
        if (bl && l2 != 0L) {
            throw new ArithmeticException("Non-terminating decimal expansion.");
        }
        if (n2 != 0 && mathContext.getRoundingMode().ordinal() == 7 && l2 != 0L) {
            throw new ArithmeticException("Inexact result requires rounding.");
        }
        long l14 = l;
        long l15 = l2;
        long l16 = l8;
        if (l14 < 0L) {
            l14 *= -1L;
        }
        if (l15 < 0L) {
            l15 *= -1L;
        }
        if (l8 < 0L) {
            l16 *= -1L;
        }
        int n3 = BigDecimal.numDigits(l14);
        boolean bl3 = false;
        long l17 = BigDecimal.roundPostLLDivision(l14, n, l16, l15, mathContext.getRoundingMode().ordinal());
        long l18 = l3 - l4 + (long)n2;
        if (l17 != l14 && l17 % 10L == 0L && l14 % 10L != 0L) {
            bl3 = true;
        }
        if (l17 == -1L) {
            return null;
        }
        int n4 = BigDecimal.numDigits(l17);
        if (n3 < n4 && n4 > n2) {
            l17 /= 10L;
            --l18;
        }
        long l19 = l18 - l13;
        if (bl && l18 < l13) {
            l19 = l13 - l18;
            l12 = BigDecimal.powerOfTenLL(l19);
            if (l12 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l17, l12)) {
                return null;
            }
            l18 += l19;
            l17 *= l12;
        }
        if (l18 > l13 && !bl3 && bl2) {
            while (l17 % 10L == 0L && l19 > 0L) {
                l17 /= 10L;
                --l18;
                --l19;
            }
            if (l17 == 0L && l19 > 0L) {
                l18 -= l19;
            }
        }
        if (l18 < Integer.MIN_VALUE || l18 > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + l18);
        }
        if (n == -1) {
            l17 *= -1L;
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.laside = l17;
        bigDecimal3.exp = (int)(-l18);
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 1;
        bigDecimal3.flags &= 0x7F;
        bigDecimal3.flags |= BigDecimal.numDigits(bigDecimal3.laside) << 7;
        return bigDecimal3;
    }

    private final BigDecimal longScaledDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        long l;
        BigDecimal bigDecimal3 = null;
        if (bigDecimal.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (this.laside == 0L) {
            bigDecimal3 = bigDecimal2;
            bigDecimal3.laside = 0L;
            bigDecimal3.exp = -n;
            bigDecimal3.flags &= 0xFFFFFFFC;
            bigDecimal3.flags |= 1;
            bigDecimal3.flags &= 0x7F;
            bigDecimal3.flags |= 0x80;
        }
        int n3 = this.signum() * bigDecimal.signum();
        long l2 = this.laside;
        long l3 = bigDecimal.laside;
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if (l3 < 0L) {
            l3 *= -1L;
        }
        long l4 = -((long)this.exp) + (long)bigDecimal.exp;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        long l8 = l3;
        if (l4 < (long)n) {
            l6 = (long)n - l4;
            l5 = BigDecimal.powerOfTenLL(l6);
            if (l5 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l7, l5)) {
                return null;
            }
            l7 *= l5;
        } else if (l4 > (long)n) {
            l6 = l4 - (long)n;
            l5 = BigDecimal.powerOfTenLL(l6);
            if (l5 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l8, l5)) {
                return null;
            }
            l8 *= l5;
        }
        long l9 = l7 / l8;
        long l10 = l7 - l9 * l8;
        long l11 = l9;
        long l12 = l10;
        long l13 = l8;
        if (l11 < 0L) {
            l11 *= -1L;
        }
        if (l12 < 0L) {
            l12 *= -1L;
        }
        if (l8 < 0L) {
            l13 *= -1L;
        }
        if ((l = BigDecimal.roundPostLLDivision(l11, n3, l13, l12, n2)) == -1L) {
            return null;
        }
        if (n3 == -1) {
            l *= -1L;
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.laside = l;
        bigDecimal3.exp = -n;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 1;
        bigDecimal3.flags &= 0x7F;
        bigDecimal3.flags |= BigDecimal.numDigits(bigDecimal3.laside) << 7;
        return bigDecimal3;
    }

    private final BigDecimal slPrecisionDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        int n;
        BigDecimal bigDecimal3 = null;
        long l = -this.exp;
        long l2 = -bigDecimal.exp;
        long l3 = l;
        long l4 = l2;
        int n2 = bigDecimal.signum() * this.signum();
        int n3 = this.precision();
        int n4 = bigDecimal.precision();
        long l5 = 0L;
        boolean bl = false;
        int n5 = mathContext.getPrecision();
        boolean bl2 = true;
        long l6 = 0L;
        if (bigDecimal.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if (n5 == 0) {
            l6 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            n5 = (int)Math.min((double)n3 + Math.ceil(10.0 * (double)n4 / 3.0), 2.147483647E9);
            bl = true;
        } else {
            l6 = l3 - l4;
        }
        if ((long)this.bi.signum() == 0L) {
            BigDecimal.clone(bigDecimal2, this);
            bigDecimal2.exp = -((int)Math.max(Math.min(l6, Integer.MAX_VALUE), Integer.MIN_VALUE));
            return bigDecimal2;
        }
        BigInteger bigInteger = this.bi.abs();
        BigInteger bigInteger2 = bigDecimal.bi.abs();
        if (n3 > n4) {
            l5 = n3 - n4;
            if (l5 >= Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(l5));
            l2 += l5;
        } else if (n3 < n4) {
            l5 = n4 - n3;
            if (l5 >= Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l5));
            l += l5;
        }
        if (bigInteger.compareTo(bigInteger2) > 0) {
            bigInteger2 = bigInteger2.multiply(BigInteger.TEN);
            ++l2;
        }
        if (n5 >= Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale oveflow");
        }
        BigInteger[] bigIntegerArray = (bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(n5))).divideAndRemainder(bigInteger2);
        if (bigIntegerArray[1].signum() != 0) {
            bl2 = false;
        }
        if (bl && bigIntegerArray[1].signum() != 0) {
            throw new ArithmeticException("Non-terminating decimal expansion.");
        }
        if (n5 != 0 && mathContext.getRoundingMode().ordinal() == 7 && bigIntegerArray[1].signum() != 0) {
            throw new ArithmeticException("Inexact result requires rounding.");
        }
        int n6 = BigDecimal.precisionBI(bigIntegerArray[0]);
        boolean bl3 = false;
        BigInteger bigInteger3 = BigDecimal.roundPostSlowDivision(bigIntegerArray[0], n2, bigInteger2, bigIntegerArray[1], mathContext.getRoundingMode().ordinal());
        long l7 = l - l2 + (long)n5;
        if (!bigInteger3.equals(bigIntegerArray[0]) && bigInteger3.mod(BigInteger.TEN).equals(BigInteger.ZERO) && !bigIntegerArray[1].mod(BigInteger.TEN).equals(BigInteger.ZERO)) {
            bl3 = true;
        }
        if (n6 < (n = BigDecimal.precisionBI(bigInteger3)) && n > n5) {
            bigInteger3 = bigInteger3.divide(BigInteger.TEN);
            --l7;
        }
        long l8 = l7 - l6;
        if (bl && l7 < l6) {
            l8 = l6 - l7;
            if (l8 >= Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l8));
            l7 += l8;
        }
        if (l7 > l6 && !bl3 && bl2) {
            while (bigInteger3.mod(BigInteger.TEN).equals(BigInteger.ZERO) && l8 > 0L) {
                bigInteger3 = bigInteger3.divide(BigInteger.TEN);
                --l7;
                --l8;
            }
            if (bigInteger3.equals(BigInteger.ZERO) && l8 > 0L) {
                l7 -= l8;
            }
        }
        if (l7 < Integer.MIN_VALUE || l7 > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + l7);
        }
        if (n2 == -1) {
            bigInteger3 = bigInteger3.negate();
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.bi = bigInteger3;
        bigDecimal3.exp = (int)(-l7);
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 2;
        bigDecimal3.flags |= 4;
        bigDecimal3.flags &= 0xFFFFFF9F;
        bigDecimal3.flags |= n2 << 5 & 0x60;
        return bigDecimal3;
    }

    private final void slScaledDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        BigDecimal bigDecimal3 = null;
        if (bigDecimal.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException("Division is undefined");
            }
            throw new ArithmeticException("Dividing by 0");
        }
        if ((long)this.bi.signum() == 0L) {
            bigDecimal3 = bigDecimal2;
            bigDecimal3.bi = BigInteger.ZERO;
            bigDecimal3.exp = -n2;
            bigDecimal3.flags &= 0xFFFFFFFC;
            bigDecimal3.flags |= 2;
            bigDecimal3.flags |= 4;
            bigDecimal3.flags &= 0xFFFFFF9F;
            return;
        }
        int n3 = this.bi.signum() * bigDecimal.bi.signum();
        BigInteger bigInteger = this.bi.abs();
        BigInteger bigInteger2 = bigDecimal.bi.abs();
        long l = -((long)this.exp) + (long)bigDecimal.exp;
        long l2 = 0L;
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        if (l < (long)n2) {
            l2 = (long)n2 - l;
            if (l2 > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l2));
        } else if (l > (long)n2) {
            l2 = l - (long)n2;
            if (l2 > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigInteger4 = bigInteger4.multiply(BigDecimal.powerOfTenBI(l2));
        }
        BigInteger[] bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger4);
        BigInteger bigInteger5 = BigDecimal.roundPostSlowDivision(bigIntegerArray[0], n3, bigInteger4, bigIntegerArray[1], n);
        if (n3 == -1) {
            bigInteger5 = bigInteger5.negate();
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.bi = bigInteger5;
        bigDecimal3.exp = -n2;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 2;
        bigDecimal3.flags |= 4;
        bigDecimal3.flags &= 0xFFFFFF9F;
        bigDecimal3.flags |= n3 << 5 & 0x60;
    }

    public BigDecimal abs() {
        return this.abs(MathContext.UNLIMITED);
    }

    public BigDecimal abs(MathContext mathContext) {
        if (this.signum() < 0) {
            return this.negate(mathContext);
        }
        return this.plus(mathContext);
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        int n = this.compareTo(bigDecimal);
        if (n > 0) {
            return this.plus();
        }
        if (n == 0) {
            return this;
        }
        return bigDecimal.plus();
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        int n = this.compareTo(bigDecimal);
        if (n < 0) {
            return this.plus();
        }
        if (n == 0) {
            return this;
        }
        return bigDecimal.plus();
    }

    public BigDecimal negate() {
        return this.negate(MathContext.UNLIMITED);
    }

    public BigDecimal negate(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if ((bigDecimal.flags & 3) == 0) {
            int n = this.signum();
            bigDecimal.flags |= 4;
            if (n == -1) {
                bigDecimal.laside &= Long.MAX_VALUE;
                bigDecimal.flags &= 0xFFFFFF9F;
                bigDecimal.flags |= 0x20;
            } else if (n == 1) {
                bigDecimal.laside |= (bigDecimal.laside |= Long.MIN_VALUE);
                bigDecimal.flags &= 0xFFFFFF9F;
                bigDecimal.flags |= 0x60;
            }
        } else if ((this.flags & 3) == 2) {
            bigDecimal.bi = this.bi.negate();
        } else {
            bigDecimal.laside *= -1L;
        }
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal;
    }

    public BigDecimal plus() {
        return this.plus(MathContext.UNLIMITED);
    }

    public BigDecimal plus(MathContext mathContext) {
        if (mathContext == MathContext.UNLIMITED) {
            return this;
        }
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal;
    }

    public byte byteValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((long)bigDecimal.precision() + (long)bigDecimal.exp > 3L) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1 ? -bigDecimal.exp > 0 && ((l = BigDecimal.powerOfTenLL(-bigDecimal.exp)) != -1L ? bigDecimal.laside % l != 0L : bigDecimal.laside != 0L) : -bigDecimal.exp > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(-bigDecimal.exp)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + bigDecimal);
        }
        BigInteger bigInteger2 = bigDecimal.toBigInteger();
        if (bigInteger2.compareTo(MAXBYTE) > 0 || bigInteger2.compareTo(MINBYTE) < 0) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        return bigInteger2.byteValue();
    }

    public short shortValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((long)bigDecimal.precision() + (long)bigDecimal.exp > 5L) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1 ? -bigDecimal.exp > 0 && ((l = BigDecimal.powerOfTenLL(-bigDecimal.exp)) != -1L ? bigDecimal.laside % l != 0L : bigDecimal.laside != 0L) : -bigDecimal.exp > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(-bigDecimal.exp)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + bigDecimal);
        }
        BigInteger bigInteger2 = bigDecimal.toBigInteger();
        if (bigInteger2.compareTo(MAXSHORT) > 0 || bigInteger2.compareTo(MINSHORT) < 0) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        return bigInteger2.shortValue();
    }

    public int intValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((long)bigDecimal.precision() + (long)bigDecimal.exp > 10L) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1 ? -bigDecimal.exp > 0 && ((l = BigDecimal.powerOfTenLL(-bigDecimal.exp)) != -1L ? bigDecimal.laside % l != 0L : bigDecimal.laside != 0L) : -bigDecimal.exp > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(-bigDecimal.exp)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + bigDecimal);
        }
        BigInteger bigInteger2 = bigDecimal.toBigInteger();
        if (bigInteger2.compareTo(MAXINT) > 0 || bigInteger2.compareTo(MININT) < 0) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        return bigInteger2.intValue();
    }

    public long longValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0L;
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((long)bigDecimal.precision() + (long)bigDecimal.exp > 19L) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1 ? -bigDecimal.exp > 0 && ((l = BigDecimal.powerOfTenLL(-bigDecimal.exp)) != -1L ? bigDecimal.laside % l != 0L : bigDecimal.laside != 0L) : -bigDecimal.exp > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(-bigDecimal.exp)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + bigDecimal);
        }
        BigInteger bigInteger2 = bigDecimal.toBigInteger();
        if (bigInteger2.compareTo(MAXLONG) > 0 || bigInteger2.compareTo(MINLONG) < 0) {
            throw new ArithmeticException("Conversion overflow: " + bigDecimal);
        }
        return bigInteger2.longValue();
    }

    public BigInteger toBigIntegerExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return BigInteger.valueOf(0L);
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((bigDecimal.flags & 1) == 1 ? -bigDecimal.exp > 0 && ((l = BigDecimal.powerOfTenLL(-bigDecimal.exp)) != -1L ? bigDecimal.laside % l != 0L : bigDecimal.laside != 0L) : -bigDecimal.exp > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(-bigDecimal.exp)).compareTo(BigInteger.ZERO) != 0) {
            throw new ArithmeticException("Non-zero decimal digits: " + bigDecimal);
        }
        bigDecimal = bigDecimal.setScale(0);
        if ((bigDecimal.flags & 3) == 1) {
            return BigInteger.valueOf(bigDecimal.laside);
        }
        return bigDecimal.bi;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public BigInteger toBigInteger() {
        BigDecimal bigDecimal = this.setScale(0, RoundingMode.DOWN);
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal.DFPToLL();
        }
        if ((bigDecimal.flags & 1) == 1) {
            return BigInteger.valueOf(bigDecimal.laside);
        }
        return bigDecimal.bi;
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        if (((this.flags | bigDecimal.flags) & 3) == 0) {
            int n = BigDecimal.DFPCompareTo(this.laside, bigDecimal.laside);
            if (n != -2) {
                return n;
            }
            BigDecimal bigDecimal2 = BigDecimal.clone(this);
            bigDecimal2.DFPToLL();
            BigDecimal bigDecimal3 = BigDecimal.clone(bigDecimal);
            bigDecimal3.DFPToLL();
            return BigDecimal.longCompareTo(bigDecimal2, bigDecimal3);
        }
        if ((this.flags & bigDecimal.flags & 1) == 1 && this.exp == bigDecimal.exp) {
            if (this.laside > bigDecimal.laside) {
                return 1;
            }
            if (this.laside < bigDecimal.laside) {
                return -1;
            }
            return 0;
        }
        BigDecimal bigDecimal4 = this;
        BigDecimal bigDecimal5 = bigDecimal;
        if ((this.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal4.DFPToLL();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal5.DFPToLL();
        }
        if ((bigDecimal4.flags & bigDecimal5.flags & 1) == 1) {
            return BigDecimal.longCompareTo(bigDecimal4, bigDecimal5);
        }
        if ((bigDecimal4.flags & 3) == 1) {
            bigDecimal4 = BigDecimal.clone(bigDecimal4);
            bigDecimal4.LLToBI();
        }
        if ((bigDecimal5.flags & 3) == 1) {
            bigDecimal5 = BigDecimal.clone(bigDecimal5);
            bigDecimal5.LLToBI();
        }
        return BigDecimal.slCompareTo(bigDecimal4, bigDecimal5);
    }

    private static final int longCompareTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        long l;
        long l2;
        int n = bigDecimal.signum();
        int n2 = bigDecimal2.signum();
        if ((long)n == 0L && (long)n2 == 0L) {
            return 0;
        }
        if ((long)n == 0L && (long)n2 < 0L) {
            return 1;
        }
        if ((long)n == 0L && (long)n2 > 0L) {
            return -1;
        }
        if ((long)n < 0L && (long)n2 >= 0L) {
            return -1;
        }
        if ((long)n > 0L && (long)n2 <= 0L) {
            return 1;
        }
        boolean bl = n == 1 && n2 == 1;
        long l3 = bigDecimal.precision();
        long l4 = bigDecimal2.precision();
        long l5 = bigDecimal.exp;
        long l6 = bigDecimal2.exp;
        if (l3 == l4) {
            if (l5 > l6) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l5 < l6) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            if (bigDecimal.laside == bigDecimal2.laside) {
                return 0;
            }
            if (bigDecimal.laside < bigDecimal2.laside) {
                return -1;
            }
            return 1;
        }
        if (l3 + l5 <= 0L && l4 + l6 > 0L) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        if (l3 + l5 > 0L && l4 + l6 <= 0L) {
            if (bl) {
                return 1;
            }
            return -1;
        }
        if (l3 + l5 <= 0L && l4 + l6 <= 0L) {
            long l7 = -(l3 + l5);
            long l8 = -(l4 + l6);
            if (l7 > l8) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            if (l7 < l8) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            long l9 = bigDecimal.laside;
            long l10 = bigDecimal2.laside;
            if (l3 < l4) {
                l9 *= BigDecimal.powerOfTenLL(l4 - l3);
            } else if (l3 > l4) {
                l10 *= BigDecimal.powerOfTenLL(l3 - l4);
            }
            if (l9 > l10) {
                return 1;
            }
            if (l9 < l10) {
                return -1;
            }
            return 0;
        }
        if (l5 >= 0L && l6 >= 0L) {
            if (l3 + l5 > l4 + l6) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l3 + l5 < l4 + l6) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            l2 = 0L;
            l = 0L;
            if (l5 < 19L && l6 < 19L && !BigDecimal.overflowMultiply(bigDecimal.laside, BigDecimal.powerOfTenLL(l5)) && !BigDecimal.overflowMultiply(bigDecimal2.laside, BigDecimal.powerOfTenLL(l6))) {
                l2 = bigDecimal.laside * BigDecimal.powerOfTenLL(l5);
                if (l2 > (l = bigDecimal2.laside * BigDecimal.powerOfTenLL(l6))) {
                    return 1;
                }
                if (l2 < l) {
                    return -1;
                }
                return 0;
            }
        }
        if (l5 >= 0L && l6 < 0L && l4 > -l6) {
            l = l3 + l5;
            l2 = l4 + l6;
            if (l > l2) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l2 > l) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            long l11 = bigDecimal.laside * BigDecimal.powerOfTenLL(l5);
            if (l11 > bigDecimal2.laside / BigDecimal.powerOfTenLL(-l6)) {
                return 1;
            }
            if (l11 < bigDecimal2.laside / BigDecimal.powerOfTenLL(-l6)) {
                return -1;
            }
            long l12 = bigDecimal2.laside % BigDecimal.powerOfTenLL(-l6);
            if (0L == l12) {
                return 0;
            }
            if (0L < l12) {
                return -1;
            }
            return 1;
        }
        if (l6 >= 0L && l5 < 0L && l3 > -l5) {
            l = l3 + l5;
            l2 = l4 + l6;
            if (l > l2) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l2 > l) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            long l13 = bigDecimal2.laside * BigDecimal.powerOfTenLL(l6);
            if (l13 > bigDecimal.laside / BigDecimal.powerOfTenLL(-l5)) {
                return -1;
            }
            if (l13 < bigDecimal.laside / BigDecimal.powerOfTenLL(-l5)) {
                return 1;
            }
            long l14 = bigDecimal.laside % BigDecimal.powerOfTenLL(-l5);
            if (0L == l14) {
                return 0;
            }
            if (0L < l14) {
                return 1;
            }
            return -1;
        }
        BigDecimal bigDecimal3 = BigDecimal.clone(bigDecimal2);
        bigDecimal3.laside *= -1L;
        BigDecimal bigDecimal4 = new BigDecimal();
        return bigDecimal.longAdd(bigDecimal3, bigDecimal4, MathContext.UNLIMITED, true).signum();
    }

    private static final int slCompareTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        long l;
        long l2;
        int n = bigDecimal.signum();
        int n2 = bigDecimal2.signum();
        if ((long)n == 0L && (long)n2 == 0L) {
            return 0;
        }
        if ((long)n == 0L && (long)n2 < 0L) {
            return 1;
        }
        if ((long)n == 0L && (long)n2 > 0L) {
            return -1;
        }
        if ((long)n < 0L && (long)n2 >= 0L) {
            return -1;
        }
        if ((long)n > 0L && (long)n2 <= 0L) {
            return 1;
        }
        boolean bl = n == 1 && n2 == 1;
        long l3 = bigDecimal.precision();
        long l4 = bigDecimal2.precision();
        long l5 = bigDecimal.exp;
        long l6 = bigDecimal2.exp;
        if (l3 == l4) {
            if (l5 > l6) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l5 < l6) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            return bigDecimal.bi.compareTo(bigDecimal2.bi);
        }
        if (l3 + l5 <= 0L && l4 + l6 > 0L) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        if (l3 + l5 > 0L && l4 + l6 <= 0L) {
            if (bl) {
                return 1;
            }
            return -1;
        }
        if (l3 + l5 <= 0L && l4 + l6 <= 0L) {
            l2 = -(l3 + l5);
            l = -(l4 + l6);
            if (l2 > l) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            if (l2 < l) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
        }
        if (l5 >= 0L && l6 >= 0L) {
            if (l3 + l5 > l4 + l6) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l3 + l5 < l4 + l6) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
        }
        if (l5 >= 0L && l6 < 0L && l4 > -l6) {
            l = l3 + l5;
            l2 = l4 + l6;
            if (l > l2) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l2 > l) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
        } else if (l6 >= 0L && l5 < 0L && l3 > -l5) {
            l = l3 + l5;
            l2 = l4 + l6;
            if (l > l2) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (l2 > l) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
        }
        BigDecimal bigDecimal3 = BigDecimal.clone(bigDecimal2);
        bigDecimal3.bi = bigDecimal3.bi.negate();
        return bigDecimal.slAdd(bigDecimal3, null, MathContext.UNLIMITED, true).signum();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (this == bigDecimal) {
            return true;
        }
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            return this.laside == bigDecimal.laside && this.exp == bigDecimal.exp;
        }
        return this.unscaledValue().equals(bigDecimal.unscaledValue()) && this.scale() == bigDecimal.scale();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int precision() {
        int n = this.flags;
        if ((n & 0x10) != 0) {
            return (n & 0xFFFFFF80) >> 7;
        }
        if ((n & 3) == 0) {
            n |= 0x10;
            n &= 0x7F;
            int n2 = BigDecimal.DFPSignificance(this.laside);
            if (n2 < 0) {
                long l = BigDecimal.DFPBCDDigits(this.laside);
                if (l == 10L) {
                    l = BigDecimal.extractDFPDigitsBCD(this.laside);
                }
                int n3 = Long.numberOfLeadingZeros(l);
                n3 >>= 2;
                if ((n3 = 16 - n3) == 0) {
                    ++n3;
                }
                this.flags = n |= n3 << 7;
                return n3;
            }
            if (n2 == 0) {
                ++n2;
            }
            this.flags = n |= n2 << 7;
            return n2;
        }
        if ((this.flags & 3) == 2) {
            int n4 = BigDecimal.precisionBI(this.bi);
            if (n4 <= 0x1FFFFFF) {
                n |= 0x10;
                n &= 0x7F;
                n |= n4 << 7;
            }
            this.flags = n;
            return n4;
        }
        int n5 = BigDecimal.numDigits(this.laside);
        n |= 0x10;
        n &= 0x7F;
        this.flags = n |= n5 << 7;
        return n5;
    }

    private static final int precisionBI(BigInteger bigInteger) {
        int n = 0;
        while (bigInteger.mag.length > 1) {
            bigInteger = bigInteger.divide(BigDecimal.powerOfTenBI(9L));
            n += 9;
        }
        if (bigInteger.mag.length == 1) {
            n += BigDecimal.numDigitsBI(bigInteger.mag[0]);
        } else if (bigInteger.mag.length == 0) {
            ++n;
        }
        return n;
    }

    public int scale() {
        if ((this.flags & 3) == 0) {
            if ((this.flags & 8) != 0) {
                return -this.exp;
            }
            this.flags |= 8;
            int n = BigDecimal.DFPExponent(this.laside);
            this.exp = n == 1000 ? BigDecimal.extractDFPExponent(this.laside) - 398 : n - 398;
        }
        return -this.exp;
    }

    public int signum() {
        int n = this.flags;
        if ((n & 3) == 0) {
            if ((n & 4) != 0) {
                int n2 = n & 0x60;
                n2 <<= 25;
                return n2 >>= 30;
            }
            n |= 4;
            if ((this.laside & Long.MIN_VALUE) == Long.MIN_VALUE) {
                this.flags = n |= 0x60;
                return -1;
            }
            long l = BigDecimal.DFPBCDDigits(this.laside);
            if (l == 10L) {
                if (this.isDFPZero()) {
                    this.flags = n &= 0xFFFFFF9F;
                    return 0;
                }
                n &= 0xFFFFFF9F;
                this.flags = n |= 0x20;
                return 1;
            }
            if (l != 0L) {
                n &= 0xFFFFFF9F;
                this.flags = n |= 0x20;
                return 1;
            }
            this.flags = n &= 0xFFFFFF9F;
            return 0;
        }
        if ((this.flags & 3) == 2) {
            return this.bi.signum();
        }
        return (int)(this.laside >> 63) | (int)(-this.laside >>> 63);
    }

    public BigDecimal ulp() {
        BigDecimal bigDecimal = new BigDecimal();
        bigDecimal.laside = 1L;
        bigDecimal.flags |= 1;
        bigDecimal.flags |= 0x10;
        bigDecimal.flags |= 0x80;
        bigDecimal.exp = -this.scale();
        return bigDecimal;
    }

    public BigInteger unscaledValue() {
        if ((this.flags & 3) == 0) {
            long l = BigDecimal.DFPUnscaledValue(this.laside);
            if (l != Long.MAX_VALUE) {
                return BigInteger.valueOf(l);
            }
            l = BigDecimal.DFPBCDDigits(this.laside);
            if (l == 10L) {
                l = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            if (l == 0L) {
                return BigInteger.ZERO;
            }
            long l2 = 0L;
            int n = 0;
            while (l != 0L) {
                l2 += (l & 0xFL) * BigDecimal.powerOfTenLL(n++);
                l >>>= 4;
            }
            return BigInteger.valueOf((long)this.signum() * l2);
        }
        if ((this.flags & 3) == 1) {
            return BigInteger.valueOf(this.laside);
        }
        return this.bi;
    }

    public BigDecimal pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative power: " + n);
        }
        return this.pow(n, MathContext.UNLIMITED);
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        int n2 = -999999999;
        int n3 = 999999999;
        int n4 = 0;
        BigDecimal bigDecimal = this;
        BigDecimal bigDecimal2 = null;
        int n5 = n;
        boolean bl = false;
        int n6 = 0;
        if (n > n3 || n < n2) {
            throw new ArithmeticException("Too large a power: " + n);
        }
        if (mathContext.getPrecision() == 0 && n < 0) {
            throw new ArithmeticException("Negative power " + n);
        }
        if (mathContext.getPrecision() > 0 && BigDecimal.numDigits(n) > mathContext.getPrecision()) {
            throw new ArithmeticException("Too many digits: " + n);
        }
        if (n == 0) {
            return ONE;
        }
        if ((bigDecimal.flags & 2) == 2 || (bigDecimal.flags & 1) == 1) {
            if (bigDecimal.signum() == 0) {
                if (n >= 0) {
                    BigDecimal bigDecimal3 = BigDecimal.clone(this);
                    long l = -bigDecimal3.exp * n;
                    if (-l < Integer.MIN_VALUE || -l > Integer.MAX_VALUE) {
                        throw new ArithmeticException("BigDecimal scale outside legal range: " + l);
                    }
                    bigDecimal3.exp *= n;
                    return bigDecimal3;
                }
                throw new ArithmeticException("Dividing by 0");
            }
        } else if (bigDecimal.signum() == 0) {
            if (n >= 0) {
                BigDecimal bigDecimal4 = BigDecimal.clone(this);
                bigDecimal4.DFPToLL();
                if ((long)(-bigDecimal4.exp * n) < Integer.MIN_VALUE || (long)(-bigDecimal4.exp * n) > Integer.MAX_VALUE) {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + -bigDecimal4.exp * n);
                }
                bigDecimal4.exp *= n;
                return bigDecimal4;
            }
            new ArithmeticException("Dividing by 0");
        }
        if (mathContext.getPrecision() > 0) {
            n4 = mathContext.getPrecision() + BigDecimal.numDigits(n) + 1;
        }
        MathContext mathContext2 = new MathContext(n4, mathContext.getRoundingMode());
        bigDecimal2 = new BigDecimal();
        bigDecimal2.bi = BigInteger.ONE;
        bigDecimal2.flags |= 0x10;
        bigDecimal2.flags |= 0x80;
        bigDecimal2.flags |= 2;
        BigDecimal bigDecimal5 = bigDecimal;
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal5.DFPToBI();
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        bl = false;
        n6 = 1;
        while (true) {
            if ((n5 += n5) < 0) {
                bl = true;
                bigDecimal2.longMultiply(bigDecimal5, null, mathContext2, true);
            }
            if (n6 == 31) break;
            if (bl) {
                bigDecimal2.longMultiply(bigDecimal2, null, mathContext2, true);
            }
            n6 = (short)(n6 + 1);
        }
        if (n < 0) {
            bigDecimal2 = ONE.divide(bigDecimal2, mathContext2);
        }
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal2;
    }

    public BigDecimal movePointLeft(int n) {
        long l = 0L;
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if ((this.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        if ((l = (long)bigDecimal.scale() + (long)n) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + l);
            }
        }
        bigDecimal.exp = (int)(-l);
        if (l < 0L) {
            return bigDecimal.setScale(0, true);
        }
        return bigDecimal;
    }

    public BigDecimal movePointRight(int n) {
        long l;
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if ((this.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        if ((l = (long)bigDecimal.scale() - (long)n) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + l);
            }
        }
        bigDecimal.exp = (int)(-l);
        if (l < 0L) {
            return bigDecimal.setScale(0, true);
        }
        return bigDecimal;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        long l;
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
        }
        if ((l = (long)(-bigDecimal.exp) - (long)n) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + l);
            }
        }
        BigDecimal bigDecimal2 = BigDecimal.clone(bigDecimal);
        bigDecimal2.exp = (int)(-l);
        return bigDecimal2;
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, false);
    }

    private BigDecimal setScale(int n, boolean bl) {
        int n2 = this.scale();
        if (n2 == n) {
            if (!bl) {
                return BigDecimal.clone(this);
            }
            return this;
        }
        BigDecimal bigDecimal = this;
        if (!bl) {
            bigDecimal = new BigDecimal();
        }
        int n3 = 0;
        if ((this.flags & 3) == 0) {
            if (-n >= -398 && -n <= 369) {
                n3 = bigDecimal.DFPSetScale(this.laside, -n + 398, false, 0, true);
                if (n3 == 1) {
                    if (bigDecimal.isDFPZero()) {
                        bigDecimal.laside &= Long.MAX_VALUE;
                        bigDecimal.flags |= 4;
                        bigDecimal.flags &= 0xFFFFFF9F;
                    } else {
                        bigDecimal.flags |= 4;
                        bigDecimal.flags |= this.signum() << 5 & 0x60;
                    }
                    bigDecimal.flags |= 8;
                    bigDecimal.exp = -n;
                    bigDecimal.flags &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                if (n3 == 0) {
                    throw new ArithmeticException("Requires rounding: " + n);
                }
                BigDecimal.clone(bigDecimal, this);
                bigDecimal.DFPToBI();
                bigDecimal = bigDecimal.slSetScale(n, true);
            } else {
                BigDecimal.clone(bigDecimal, this);
                bigDecimal.DFPToBI();
                bigDecimal = bigDecimal.slSetScale(n, true);
            }
        } else {
            BigDecimal.clone(bigDecimal, this);
            bigDecimal = bigDecimal.longSetScale(n, true);
        }
        return bigDecimal;
    }

    private final BigDecimal longSetScale(int n, boolean bl) {
        int n2 = -this.exp;
        BigDecimal bigDecimal = this;
        if (!bl) {
            bigDecimal = BigDecimal.clone(this);
        }
        if (this.signum() == 0) {
            bigDecimal.flags &= 0xFFFFFFEF;
            bigDecimal.exp = -n;
            return bigDecimal;
        }
        int n3 = bigDecimal.flags;
        if ((n3 & 1) == 1) {
            if (n2 < n) {
                long l = 0L;
                l = n2 == 0 ? (long)bigDecimal.exp + (long)n : (long)n - (long)n2;
                if (l > 18L) {
                    bigDecimal.LLToBI();
                    if (l > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale oveflow");
                    }
                    bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
                    bigDecimal.exp = -n;
                    n3 = bigDecimal.flags;
                    bigDecimal.flags = n3 &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                long l2 = BigDecimal.powerOfTenLL(l);
                if (!BigDecimal.overflowMultiply(bigDecimal.laside, l2)) {
                    bigDecimal.laside *= l2;
                    bigDecimal.exp = -n;
                    bigDecimal.flags = n3 &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                bigDecimal.LLToBI();
                if (l > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale oveflow");
                }
                bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
                bigDecimal.exp = -n;
                n3 = bigDecimal.flags;
                bigDecimal.flags = n3 &= 0xFFFFFFEF;
                return bigDecimal;
            }
            long l = (long)n2 - (long)n;
            if (l > (long)bigDecimal.precision()) {
                throw new ArithmeticException("Requires rounding: " + n);
            }
            if (l > 18L) {
                if (bigDecimal.laside != 0L) {
                    throw new ArithmeticException("Requires rounding: " + n);
                }
                bigDecimal.laside = 0L;
                bigDecimal.exp = -n;
                bigDecimal.flags = n3 &= 0xFFFFFFEF;
                return bigDecimal;
            }
            long l3 = bigDecimal.laside % BigDecimal.powerOfTenLL(l);
            if (l3 != 0L) {
                throw new ArithmeticException("Requires rounding: " + n);
            }
            bigDecimal.laside /= BigDecimal.powerOfTenLL(l);
            bigDecimal.exp = -n;
            bigDecimal.flags = n3 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        return bigDecimal.slSetScale(n, false);
    }

    private final BigDecimal slSetScale(int n, boolean bl) {
        int n2 = -this.exp;
        BigDecimal bigDecimal = this;
        if (!bl) {
            bigDecimal = BigDecimal.clone(this);
        }
        if (this.signum() == 0) {
            bigDecimal.exp = -n;
            bigDecimal.flags &= 0xFFFFFFEF;
            return bigDecimal;
        }
        int n3 = bigDecimal.flags;
        if (n2 < n) {
            long l = 0L;
            l = n2 == 0 ? (long)bigDecimal.exp + (long)n : (long)n - (long)n2;
            if (l > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
            bigDecimal.exp = -n;
            bigDecimal.flags = n3 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        long l = (long)n2 - (long)n;
        if (l > (long)bigDecimal.precision()) {
            throw new ArithmeticException("Requires rounding: " + n);
        }
        l = Math.min((long)this.precision(), l);
        BigInteger[] bigIntegerArray = null;
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Scale oveflow");
        }
        bigIntegerArray = bigDecimal.bi.divideAndRemainder(BigDecimal.powerOfTenBI(l));
        if (bigIntegerArray[1].signum() != 0) {
            throw new ArithmeticException("Requires rounding: " + n);
        }
        bigDecimal.bi = bigIntegerArray[0];
        bigDecimal.exp = -n;
        bigDecimal.flags = n3 &= 0xFFFFFFEF;
        return bigDecimal;
    }

    public BigDecimal setScale(int n, RoundingMode roundingMode) {
        return this.setScale(n, roundingMode.ordinal());
    }

    public BigDecimal setScale(int n, int n2) {
        RoundingMode.valueOf(n2);
        int n3 = this.scale();
        if (n3 == n) {
            return BigDecimal.clone(this);
        }
        BigDecimal bigDecimal = new BigDecimal();
        boolean bl = false;
        int n4 = 0;
        if ((this.flags & 3) == 0) {
            if (-n >= -398 && -n <= 369) {
                if (n2 == 7) {
                    n4 = bigDecimal.DFPSetScale(this.laside, -n + 398, false, 0, false);
                    if (n4 == 1) {
                        if (bigDecimal.isDFPZero()) {
                            bigDecimal.laside &= Long.MAX_VALUE;
                            bigDecimal.flags |= 4;
                            bigDecimal.flags &= 0xFFFFFF9F;
                        } else {
                            bigDecimal.flags |= 4;
                            bigDecimal.flags |= this.signum() << 5 & 0x60;
                        }
                        bigDecimal.flags |= 8;
                        bigDecimal.exp = -n;
                        bl = true;
                    }
                } else {
                    if (n2 == 6) {
                        n2 = 0;
                    } else if (n2 == 0) {
                        n2 = 6;
                    }
                    n4 = bigDecimal.DFPSetScale(this.laside, -n + 398, true, n2, false);
                    if (n4 == 1) {
                        if (bigDecimal.isDFPZero()) {
                            bigDecimal.laside &= Long.MAX_VALUE;
                            bigDecimal.flags |= 4;
                            bigDecimal.flags &= 0xFFFFFF9F;
                        } else {
                            bigDecimal.flags |= 4;
                            bigDecimal.flags |= this.signum() << 5 & 0x60;
                        }
                        bigDecimal.flags |= 8;
                        bigDecimal.exp = -n;
                        bl = true;
                    }
                }
                if (!bl) {
                    BigDecimal.clone(bigDecimal, this);
                    bigDecimal.DFPToBI();
                    bigDecimal = bigDecimal.slSetScale(n, n2, true);
                }
            } else {
                BigDecimal.clone(bigDecimal, this);
                bigDecimal.DFPToBI();
                bigDecimal = bigDecimal.slSetScale(n, n2, true);
            }
        } else {
            BigDecimal.clone(bigDecimal, this);
            bigDecimal = bigDecimal.longSetScale(n, n2, true);
        }
        bigDecimal.flags &= 0xFFFFFFEF;
        if (!BigDecimal.DFPHWAvailable() && (this.flags & 3) == 2) {
            bigDecimal.BIToLL();
        } else if (BigDecimal.DFPHWAvailable()) {
            if ((bigDecimal.flags & 3) == 2 && bigDecimal.bi.compareTo(MAXDFP64) <= 0 && bigDecimal.bi.compareTo(MINDFP64) >= 0 && bigDecimal.exp <= 369 && bigDecimal.exp >= -398) {
                long l = bigDecimal.bi.longValue();
                bigDecimal.DFPLongExpConstructor(l, bigDecimal.exp + 398, 0, 0, 0, false);
                bigDecimal.flags &= 0xFFFFFFFC;
                bigDecimal.flags |= 8;
                bigDecimal.flags |= 4;
                bigDecimal.flags = bigDecimal.bi.signum() < 0 ? (bigDecimal.flags |= 0x60) : (bigDecimal.bi.signum() > 0 ? (bigDecimal.flags |= 0x20) : (bigDecimal.flags &= 0xFFFFFF9F));
            } else if ((bigDecimal.flags & 3) == 1 && bigDecimal.laside <= 9999999999999999L && bigDecimal.laside >= -9999999999999999L && bigDecimal.exp <= 369 && this.exp >= -398) {
                int n5 = bigDecimal.signum();
                bigDecimal.DFPLongExpConstructor(bigDecimal.laside, bigDecimal.exp + 398, 0, 0, 0, false);
                bigDecimal.flags &= 0xFFFFFFFC;
                bigDecimal.flags |= 8;
                bigDecimal.flags |= 4;
                bigDecimal.flags = n5 < 0 ? (bigDecimal.flags |= 0x60) : (n5 > 0 ? (bigDecimal.flags |= 0x20) : (bigDecimal.flags &= 0xFFFFFF9F));
            }
        }
        return bigDecimal;
    }

    private final BigDecimal longSetScale(int n, int n2, boolean bl) {
        long l = -((long)this.exp);
        BigDecimal bigDecimal = this;
        long l2 = 0L;
        if (!bl) {
            bigDecimal = BigDecimal.clone(this);
        }
        int n3 = bigDecimal.flags;
        if (this.signum() == 0) {
            bigDecimal.exp = -n;
            bigDecimal.flags = n3 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        if ((n3 & 1) == 1) {
            if (l <= (long)n) {
                long l3 = 0L;
                l3 = l == 0L ? (long)bigDecimal.exp + (long)n : (long)n - l;
                if (l3 > 18L) {
                    bigDecimal.LLToBI();
                    if (l3 > Integer.MAX_VALUE) {
                        throw new ArithmeticException("Scale oveflow");
                    }
                    bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l3));
                    bigDecimal.exp = -n;
                    bigDecimal.flags &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                long l4 = BigDecimal.powerOfTenLL(l3);
                if (!BigDecimal.overflowMultiply(bigDecimal.laside, l4)) {
                    bigDecimal.laside *= l4;
                    bigDecimal.exp = -n;
                    bigDecimal.flags &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                bigDecimal.LLToBI();
                if (l3 > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Scale oveflow");
                }
                bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l3));
                bigDecimal.exp = -n;
                bigDecimal.flags &= 0xFFFFFFEF;
                return bigDecimal;
            }
            long l5 = l - (long)n;
            l2 = (long)bigDecimal.precision() - l5;
            bigDecimal.roundLL(l2, n2, true);
            if (bigDecimal.exp != -n) {
                if (!BigDecimal.overflowMultiply(bigDecimal.laside, 10L)) {
                    bigDecimal.laside *= 10L;
                    --bigDecimal.exp;
                    bigDecimal.flags &= 0xFFFFFFEF;
                    return bigDecimal;
                }
                bigDecimal.LLToBI();
                bigDecimal.bi = bigDecimal.bi.multiply(BigInteger.TEN);
                --bigDecimal.exp;
                bigDecimal.flags &= 0xFFFFFFEF;
                return bigDecimal;
            }
            return bigDecimal;
        }
        return bigDecimal.slSetScale(n, n2, false);
    }

    private final BigDecimal slSetScale(int n, int n2, boolean bl) {
        long l = -((long)this.exp);
        BigDecimal bigDecimal = this;
        long l2 = 0L;
        if (!bl) {
            bigDecimal = BigDecimal.clone(this);
        }
        bigDecimal.flags &= 0xFFFFFFEF;
        if (this.signum() == 0) {
            bigDecimal.exp = -n;
            return bigDecimal;
        }
        if (l <= (long)n) {
            long l3 = 0L;
            l3 = l == 0L ? (long)bigDecimal.exp + (long)n : (long)n - l;
            if (l3 > Integer.MAX_VALUE) {
                throw new ArithmeticException("Scale oveflow");
            }
            bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l3));
            bigDecimal.exp = -n;
            return bigDecimal;
        }
        long l4 = l - (long)n;
        l2 = (long)bigDecimal.precision() - l4;
        bigDecimal.roundBI(l2, n2, true);
        if (bigDecimal.exp != -n) {
            bigDecimal.bi = bigDecimal.bi.multiply(BigInteger.TEN);
            --bigDecimal.exp;
            return bigDecimal;
        }
        return bigDecimal;
    }

    public BigDecimal stripTrailingZeros() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = this;
        if ((this.flags & 3) == 0) {
            bigDecimal2 = BigDecimal.clone(this);
            bigDecimal2.DFPToLL();
            bigDecimal = bigDecimal2;
        } else {
            bigDecimal = BigDecimal.clone(bigDecimal2);
        }
        if (bigDecimal.signum() == 0) {
            return bigDecimal;
        }
        bigDecimal.flags &= 0xFFFFFFEF;
        if ((bigDecimal2.flags & 3) == 1) {
            int n = 0;
            long l = bigDecimal.laside;
            if (l < 0L) {
                l *= -1L;
            }
            if (l < Integer.MAX_VALUE) {
                int n2 = (int)l;
                byte by = 0;
                while ((by = (byte)(n2 - ((BigDecimal.uDivideByTen(n2) << 1) + (BigDecimal.uDivideByTen(n2) << 3)))) == 0) {
                    n2 = BigDecimal.uDivideByTen(n2);
                    ++n;
                }
                bigDecimal.laside = bigDecimal.laside < 0L ? (long)(-n2) : (long)n2;
            } else {
                byte by = 0;
                while ((by = (byte)(l - ((l / 10L << 1) + (l / 10L << 3)))) == 0) {
                    l /= 10L;
                    ++n;
                }
                bigDecimal.laside = bigDecimal.laside < 0L ? -l : l;
            }
            bigDecimal.exp += n;
            return bigDecimal;
        }
        int n = 0;
        BigInteger bigInteger = bigDecimal.bi;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ONE;
        while ((bigInteger2 = (bigInteger3 = bigInteger).remainder(BigInteger.TEN)).signum() == 0) {
            ++n;
            bigInteger = bigInteger.divide(BigInteger.TEN);
        }
        bigDecimal.bi = bigInteger;
        bigDecimal.exp += n;
        return bigDecimal;
    }

    public String toString() {
        long l = -((long)this.scale());
        int n = this.flags;
        int n2 = this.precision();
        if ((n & 1) == 1 && -l > 0L && l >= (long)(-5 - n2) && -l < (long)n2 && -l <= 19L) {
            char c;
            char c2;
            int n3 = this.signum();
            long l2 = this.laside;
            int n4 = 1 + n2;
            int n5 = 0;
            if (n3 == -1) {
                ++n4;
                l2 *= -1L;
            }
            if (l == Integer.MIN_VALUE) {
                l = -l;
            }
            char[] cArray = n4 <= 22 ? (char[])thLocalToString.get() : new char[n4];
            if (n3 == -1) {
                cArray[n5++] = 45;
            }
            int n6 = (int)((long)n4 - -l - 1L);
            byte by = 0;
            int n7 = n4 - 1;
            while (l2 > Integer.MAX_VALUE) {
                long l3 = l2;
                by = (byte)(l3 - (((l2 /= 100L) << 6) + (l2 << 5) + (l2 << 2)));
                c2 = doubleDigitsOnes[by];
                c = doubleDigitsTens[by];
                if (n7 == n6) {
                    cArray[n7--] = 46;
                }
                cArray[n7--] = c2;
                if (n7 == n6) {
                    cArray[n7--] = 46;
                }
                cArray[n7--] = c;
            }
            int n8 = (int)l2;
            while (n8 != 0) {
                int n9 = n8;
                by = (byte)(n9 - (((n8 /= 100) << 6) + (n8 << 5) + (n8 << 2)));
                c2 = doubleDigitsOnes[by];
                c = doubleDigitsTens[by];
                if (n7 == n6) {
                    cArray[n7--] = 46;
                }
                cArray[n7--] = c2;
                if (n7 == n6) {
                    cArray[n7--] = 46;
                }
                if (n7 < n5) break;
                cArray[n7--] = c;
            }
            return new String(cArray, 0, n4);
        }
        if (-l >= 0L && l >= (long)(-5 - n2)) {
            if (-l == 0L) {
                if ((n & 3) == 0) {
                    long l4 = BigDecimal.DFPUnscaledValue(this.laside);
                    if (l4 == Long.MAX_VALUE) {
                        l4 = BigDecimal.DFPBCDDigits(this.laside);
                        if (l4 == 10L) {
                            l4 = BigDecimal.extractDFPDigitsBCD(this.laside);
                        }
                        long l5 = 0L;
                        int n10 = 0;
                        while (l4 != 0L) {
                            l5 += (l4 & 0xFL) * BigDecimal.powerOfTenLL(n10++);
                            l4 >>>= 4;
                        }
                        return Long.toString(l5 * (long)this.signum());
                    }
                    return Long.toString(l4);
                }
                if ((n & 1) == 1) {
                    return Long.toString(this.laside);
                }
                return this.bi.toString();
            }
            int n11 = this.signum();
            if ((n & 3) == 0) {
                if (-l < (long)n2) {
                    int n12 = 1 + n2;
                    if (n11 == -1) {
                        ++n12;
                    }
                    return new String(this.prePaddedStringDFP(n11, n2), 0, n12);
                }
                int n13 = 2 - (int)l;
                if (n11 == -1) {
                    ++n13;
                }
                return new String(this.prePaddedStringDFP(n11, n2), 0, n13);
            }
            if ((n & 1) == 1) {
                int n14 = 2 - (int)l;
                if (n11 == -1) {
                    ++n14;
                }
                return new String(this.prePaddedString(n11, n2), 0, n14);
            }
            if (-l < (long)n2) {
                int n15 = 1 + n2;
                if (n11 == -1) {
                    ++n15;
                }
                return new String(this.prePaddedString(n11, n2), 0, n15);
            }
            int n16 = 2 - (int)l;
            if (n11 == -1) {
                ++n16;
            }
            return new String(this.prePaddedString(n11, n2), 0, n16);
        }
        long l6 = l + (long)n2 - 1L;
        int n17 = 0;
        if (this.signum() == -1) {
            ++n17;
        }
        ++n17;
        if (n2 > 1) {
            ++n17;
            n17 += n2 - 1;
        }
        ++n17;
        if (l != 0L) {
            ++n17;
        }
        int n18 = BigDecimal.numDigits(l6);
        n17 += n18;
        if ((n & 3) == 0) {
            return new String(this.toStringExpDFP(n17), 0, n17);
        }
        if ((n & 1) == 1) {
            return new String(this.toStringExpLL(n17), 0, n17);
        }
        return new String(this.toStringExpBI(n17), 0, n17);
    }

    private final char[] toStringExpDFP(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = BigDecimal.DFPBCDDigits(this.laside);
        if (l2 == 10L) {
            l2 = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        long l3 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l3);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        if (this.signum() == -1) {
            cArray[n5++] = 45;
        }
        cArray[n5++] = (char)(BigDecimal.digitAtBCD(l2, n3, 0) | 0x30);
        if (n3 > 1) {
            cArray[n5++] = 46;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                cArray[n5++] = (char)(BigDecimal.digitAtBCD(l2, n3, n2 + 1) | 0x30);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l3, n4, n2) | 0x30);
        }
        return cArray;
    }

    private final char[] toStringExpLL(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l2);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        if (this.signum() == -1) {
            cArray[n5++] = 45;
        }
        cArray[n5++] = (char)(BigDecimal.digitAt(this.laside, n3, 0) | 0x30);
        if (n3 > 1) {
            cArray[n5++] = 46;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                cArray[n5++] = (char)(BigDecimal.digitAt(this.laside, n3, n2 + 1) | 0x30);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l2, n4, n2) | 0x30);
        }
        return cArray;
    }

    private final char[] toStringExpBI(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l2);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        String string = this.bi.toString();
        int n6 = 0;
        if (this.bi.signum() == -1) {
            cArray[n5++] = 45;
        }
        if (this.bi.signum() >= 0) {
            cArray[n5++] = string.charAt(0);
            n6 = 0;
        } else {
            cArray[n5++] = string.charAt(1);
            n6 = 1;
        }
        if (n3 > 1) {
            cArray[n5++] = 46;
            if (this.bi.signum() < 0) {
                ++n3;
            }
            for (n2 = n6; n2 < n3 - 1; ++n2) {
                cArray[n5++] = string.charAt(n2 + 1);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l2, n4, n2) | 0x30);
        }
        return cArray;
    }

    public String toEngineeringString() {
        boolean bl;
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        int n = bigDecimal.flags;
        long l = bigDecimal.exp;
        if (l == Integer.MIN_VALUE) {
            l = -l;
        }
        int n2 = bigDecimal.precision();
        byte by = (byte)this.signum();
        if (-l >= 0L && l >= (long)(-5 - n2)) {
            if (-l == 0L) {
                if ((n & 1) == 1) {
                    return Long.toString(bigDecimal.laside);
                }
                return bigDecimal.bi.toString();
            }
            if (-l < (long)n2) {
                if ((n & 1) == 1) {
                    long l2 = 1 + n2;
                    if (by == -1) {
                        ++l2;
                    }
                    return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l2);
                }
                long l3 = 1 + n2;
                if (by == -1) {
                    ++l3;
                }
                return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l3);
            }
            long l4 = -l - (long)n2;
            if ((n & 1) == 1) {
                long l5 = 2L + l4 + (long)n2;
                if (by == -1) {
                    ++l5;
                }
                return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l5);
            }
            long l6 = 2L + l4 + (long)n2;
            if (by == -1) {
                ++l6;
            }
            return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l6);
        }
        long l7 = l + (long)bigDecimal.precision() - 1L;
        int n3 = (int)l7 % 3;
        boolean bl2 = bl = this.signum() == 0;
        if (bl) {
            int n4 = n3;
            if (n4 != 0) {
                if (n4 < 0) {
                    n3 = -n4 + 1;
                    l7 += (long)(-n4);
                } else {
                    n3 = 1 + (3 - n4);
                    l7 += (long)(3 - n4);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('0');
                if (n3 > 1) {
                    stringBuilder.append('.');
                }
                for (int i = n3 - 1; i > 0; --i) {
                    stringBuilder.append('0');
                }
                if (l7 < 0L) {
                    stringBuilder.append('E');
                    stringBuilder.append('-');
                    stringBuilder.append(-l7);
                } else if (l7 > 0L) {
                    stringBuilder.append('E');
                    stringBuilder.append('+');
                    stringBuilder.append(l7);
                }
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (l7 < 0L) {
                stringBuilder.append('0');
                stringBuilder.append('E');
                stringBuilder.append('-');
                stringBuilder.append(-l7);
                return stringBuilder.toString();
            }
            if (l7 > 0L) {
                stringBuilder.append('0');
                stringBuilder.append('E');
                stringBuilder.append('+');
                stringBuilder.append(l7);
                return stringBuilder.toString();
            }
            return "0";
        }
        if (n3 < 0) {
            n3 = 3 + n3;
        }
        l7 -= (long)n3;
        ++n3;
        int n5 = n2;
        char[] cArray = n5 <= 22 ? (char[])thLocalToString.get() : new char[n5];
        if ((n & 1) == 1) {
            int n6;
            long l8 = bigDecimal.laside;
            if (l8 < 0L) {
                l8 *= -1L;
            }
            byte by2 = 0;
            int n7 = n2;
            if (l8 <= Integer.MAX_VALUE) {
                int n8 = 0;
                int n9 = (int)l8;
                for (n6 = n7 - 1; n6 >= 0; --n6) {
                    n8 = n9;
                    n9 = BigDecimal.uDivideByTen(n9);
                    by2 = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                    cArray[n6] = (char)(by2 | 0x30);
                }
            } else {
                long l9 = 0L;
                for (n6 = n7 - 1; n6 >= 0; --n6) {
                    l9 = l8;
                    by2 = (byte)(l9 - (((l8 /= 10L) << 3) + (l8 << 1)));
                    cArray[n6] = (char)(by2 | 0x30);
                }
            }
        } else {
            int n10 = 0;
            String string = bigDecimal.bi.abs().toString();
            for (n10 = 0; n10 < string.length(); ++n10) {
                cArray[n10] = (char)(string.charAt(n10) | 0x30);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.signum() == -1) {
            stringBuilder.append('-');
        }
        if (n3 >= n5) {
            stringBuilder.append(cArray, 0, n5);
            for (int i = n3 - n5; i > 0; --i) {
                stringBuilder.append('0');
            }
        } else {
            stringBuilder.append(cArray, 0, n3).append('.').append(cArray, n3, n5 - n3);
        }
        if (l7 < 0L) {
            stringBuilder.append('E');
            stringBuilder.append('-');
            stringBuilder.append(-l7);
        } else if (l7 > 0L) {
            stringBuilder.append('E');
            stringBuilder.append('+');
            stringBuilder.append(l7);
        }
        return stringBuilder.toString();
    }

    public String toPlainString() {
        String string;
        boolean bl;
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        int n = bigDecimal.flags;
        byte by = (byte)this.signum();
        boolean bl2 = bl = by == 0;
        if (bigDecimal.exp == 0) {
            string = (n & 1) == 1 ? Long.toString(bigDecimal.laside) : bigDecimal.bi.toString();
        } else if (bigDecimal.exp > 0) {
            if (bl) {
                string = new String("0");
            } else {
                char[] cArray = new char[bigDecimal.exp];
                Arrays.fill(cArray, '0');
                if ((n & 1) == 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(Long.toString(bigDecimal.laside));
                    stringBuilder.append(cArray);
                    string = stringBuilder.toString();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(bigDecimal.bi.toString());
                    stringBuilder.append(cArray);
                    string = stringBuilder.toString();
                }
            }
        } else {
            int n2 = bigDecimal.precision();
            long l = bigDecimal.exp;
            if (l == Integer.MIN_VALUE) {
                l = -l;
            }
            if (-l < (long)n2) {
                if ((n & 1) == 1) {
                    long l2 = 1 + n2;
                    if (by == -1) {
                        ++l2;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l2);
                } else {
                    long l3 = 1 + n2;
                    if (by == -1) {
                        ++l3;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l3);
                }
            } else {
                long l4 = -l - (long)n2;
                if ((n & 1) == 1) {
                    long l5 = 2L + l4 + (long)n2;
                    if (by == -1) {
                        ++l5;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l5);
                } else {
                    long l6 = 2L + l4 + (long)n2;
                    if (by == -1) {
                        ++l6;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l6);
                }
            }
        }
        return string;
    }

    private final char[] prePaddedStringDFP(int n, int n2) {
        char[] cArray;
        long l;
        int n3 = -this.scale();
        int n4 = 0;
        if (n == -1) {
            n4 = 1;
        }
        if ((l = BigDecimal.DFPBCDDigits(this.laside)) == 10L) {
            l = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        if (-n3 < n2) {
            int n5 = 0;
            int n6 = n4 + 1 + n2;
            cArray = n6 <= 22 ? (char[])thLocalToString.get() : new char[n6];
            int n7 = 0;
            int n8 = n6 - -n3 - 1;
            if (n4 != 0) {
                cArray[n7++] = 45;
            }
            int n9 = 0;
            for (n5 = n6 - 1; n5 > n8; --n5) {
                n9 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n5] = (char)(n9 | 0x30);
            }
            cArray[n5--] = 46;
            while (n5 >= n7) {
                n9 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n5] = (char)(n9 | 0x30);
                --n5;
            }
        } else {
            int n10 = -n3 - n2;
            int n11 = n4 + 1 + 1 + n10 + n2;
            cArray = n11 <= 22 ? (char[])thLocalToString.get() : new char[n11];
            int n12 = 0;
            int n13 = 0;
            Arrays.fill(cArray, 0, n11, '0');
            if (n4 != 0) {
                cArray[n12++] = 45;
            }
            int n14 = ++n12;
            ++n12;
            cArray[n14] = 46;
            n12 += -n3 - n2;
            int n15 = 0;
            for (n13 = n11 - 1; n13 >= n12; --n13) {
                n15 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n13] = (char)(n15 | 0x30);
            }
        }
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final char[] prePaddedString(int n, int n2) {
        char[] cArray;
        long l;
        boolean bl = n == 0;
        int n3 = 0;
        if (n == -1) {
            n3 = 1;
        }
        if ((l = (long)this.exp) == Integer.MIN_VALUE) {
            l = -l;
        }
        int n4 = this.flags;
        if (-l < (long)n2) {
            if ((n4 & 3) == 1) {
                long l2;
                long l3 = n3 + 1 + n2;
                cArray = l3 <= 22L ? (char[])thLocalToString.get() : new char[(int)l3];
                int n5 = 0;
                int n6 = (int)(l3 - -l - 1L);
                if (n3 != 0) {
                    cArray[n5++] = 45;
                }
                if ((l2 = this.laside) < 0L) {
                    l2 *= -1L;
                }
                byte by = 0;
                int n7 = 0;
                if (l2 <= Integer.MAX_VALUE) {
                    int n8 = 0;
                    int n9 = (int)l2;
                    for (n7 = (int)(l3 - 1L); n7 > n6; --n7) {
                        n8 = n9;
                        n9 = BigDecimal.uDivideByTen(n9);
                        by = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                    }
                    cArray[n7--] = 46;
                    while (n7 >= n5) {
                        n8 = n9;
                        n9 = BigDecimal.uDivideByTen(n9);
                        by = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                        --n7;
                    }
                    return cArray;
                } else {
                    long l4 = 0L;
                    for (n7 = (int)(l3 - 1L); n7 > n6; --n7) {
                        l4 = l2;
                        by = (byte)(l4 - (((l2 /= 10L) << 3) + (l2 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                    }
                    cArray[n7--] = 46;
                    while (n7 >= n5) {
                        l4 = l2;
                        by = (byte)(l4 - (((l2 /= 10L) << 3) + (l2 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                        --n7;
                    }
                }
                return cArray;
            } else {
                long l5;
                String string = this.bi.toString();
                int n10 = string.length();
                if (n == -1) {
                    --n10;
                }
                cArray = (l5 = (long)(n3 + 1 + n10)) <= 22L ? (char[])thLocalToString.get() : new char[(int)l5];
                int n11 = 0;
                int n12 = (int)(l5 - -l - 1L);
                if (n3 != 0) {
                    cArray[n11++] = 45;
                }
                int n13 = 0;
                int n14 = string.length() - 1;
                for (n13 = (int)(l5 - 1L); n13 > n12; --n13) {
                    cArray[n13] = (char)(string.charAt(n14--) | 0x30);
                }
                cArray[n13--] = 46;
                while (n13 >= n11) {
                    cArray[n13] = (char)(string.charAt(n14--) | 0x30);
                    --n13;
                }
            }
            return cArray;
        } else {
            long l6 = -l - (long)n2;
            int n15 = 0;
            if ((n4 & 3) == 1) {
                char c;
                char c2;
                int n16 = n2;
                long l7 = (long)(n3 + 1 + 1) + l6 + (long)n16;
                cArray = l7 <= 22L ? (char[])thLocalToString.get() : new char[(int)l7];
                int n17 = 0;
                long l8 = 0L;
                byte by = 0;
                Arrays.fill(cArray, 0, (int)l7, '0');
                if (n3 != 0) {
                    cArray[n17++] = 45;
                }
                int n18 = ++n17;
                ++n17;
                cArray[n18] = 46;
                n17 = (int)((long)n17 + (-l - (long)n16));
                if (bl) return cArray;
                long l9 = this.laside;
                if (l9 < 0L) {
                    l9 *= -1L;
                }
                int n19 = (int)(l7 - 1L);
                while (l9 > Integer.MAX_VALUE) {
                    l8 = l9;
                    by = (byte)(l8 - (((l9 /= 100L) << 6) + (l9 << 5) + (l9 << 2)));
                    c2 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n19--] = c2;
                    cArray[n19--] = c;
                }
                int n20 = (int)l9;
                while (n20 != 0) {
                    int n21 = n20;
                    by = (byte)(n21 - (((n20 /= 100) << 6) + (n20 << 5) + (n20 << 2)));
                    c2 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n19--] = c2;
                    if (n19 < n17) return cArray;
                    cArray[n19--] = c;
                }
                return cArray;
            } else {
                long l10;
                String string = this.bi.toString();
                int n22 = string.length();
                if (n == -1) {
                    --n22;
                }
                cArray = (l10 = (long)(n3 + 1 + 1) + l6 + (long)n22) <= 22L ? (char[])thLocalToString.get() : new char[(int)l10];
                int n23 = 0;
                Arrays.fill(cArray, 0, (int)l10, '0');
                if (n3 != 0) {
                    cArray[n23++] = 45;
                }
                int n24 = ++n23;
                ++n23;
                cArray[n24] = 46;
                n23 = (int)((long)n23 + (-l - (long)n22));
                if (bl) return cArray;
                int n25 = (int)(l10 - 1L);
                n15 = string.length() - 1;
                while (n25 >= n23) {
                    cArray[n25--] = string.charAt(n15--);
                }
            }
        }
        return cArray;
    }

    public static BigDecimal valueOf(double d) {
        return new BigDecimal(new Double(d).toString());
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public static BigDecimal valueOf(long l, int n) {
        if (l == 0L && n == 0) {
            return ZERO;
        }
        if (l == 1L && n == 0) {
            return ONE;
        }
        if (l == 10L && n == 0) {
            return TEN;
        }
        BigDecimal bigDecimal = new BigDecimal();
        int n2 = 0;
        if (BigDecimal.DFPHWAvailable()) {
            if (l == 0L && n == 0) {
                bigDecimal.constructDFPZero();
                return bigDecimal;
            }
            if (l <= 9999999999999999L && l >= -9999999999999999L && -n >= -398 && -n <= 369) {
                bigDecimal.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false);
                n2 |= 8;
                bigDecimal.exp = -n;
                n2 |= 4;
                if (l < 0L) {
                    n2 |= 0x60;
                } else if (l > 0L) {
                    n2 |= 0x20;
                }
                bigDecimal.flags = n2;
                return bigDecimal;
            }
        }
        if (l != Long.MIN_VALUE) {
            n2 |= 1;
            bigDecimal.laside = l;
            bigDecimal.exp = -n;
        } else {
            n2 |= 2;
            bigDecimal.bi = BigInteger.valueOf(l);
            bigDecimal.exp = -n;
        }
        bigDecimal.flags = n2;
        return bigDecimal;
    }

    private static final void clone(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        bigDecimal.flags = bigDecimal2.flags;
        bigDecimal.exp = bigDecimal2.exp;
        bigDecimal.laside = bigDecimal2.laside;
        bigDecimal.bi = bigDecimal2.bi;
    }

    private static final BigDecimal clone(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal();
        bigDecimal2.flags = bigDecimal.flags;
        bigDecimal2.exp = bigDecimal.exp;
        bigDecimal2.laside = bigDecimal.laside;
        bigDecimal2.bi = bigDecimal.bi;
        return bigDecimal2;
    }

    public BigDecimal round(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if (mathContext.getPrecision() > 0) {
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal.roundDFP(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            } else if ((bigDecimal.flags & 2) == 2) {
                bigDecimal.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
            } else {
                bigDecimal.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
            }
        }
        return bigDecimal;
    }

    private final void roundDFP(int n, int n2) {
        if (this.precision() > n) {
            long l = BigDecimal.DFPBCDDigits(this.laside);
            if (l == 10L) {
                l = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            if (n2 == 7 && !BigDecimal.allzeroBCD(l, this.precision() - n)) {
                throw new ArithmeticException("Rounding mode unnecessary, but rounding changes value");
            }
            if (n2 == 6) {
                n2 = 0;
            } else if (n2 == 0) {
                n2 = 6;
            }
            if (!this.DFPRound(this.laside, n, n2)) {
                this.DFPToLL();
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
                this.roundLL(n, n2, false);
            } else {
                this.flags |= 0x10;
                this.flags &= 0x7F;
                this.flags |= n << 7;
                this.flags &= 0xFFFFFFF7;
            }
            if ((this.flags & 3) == 0 && this.isDFPZero()) {
                this.laside &= Long.MAX_VALUE;
            }
        }
    }

    private final void roundBI(long l, int n, boolean bl) {
        long l2 = 0L;
        long l3 = (long)this.precision() - l;
        if (l3 <= 0L) {
            return;
        }
        if (!bl && l == 0L) {
            return;
        }
        l2 = (long)this.exp + l3;
        int n2 = this.signum();
        BigInteger bigInteger = this.bi;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        int n3 = 0;
        if (l > 0L) {
            BigInteger[] bigIntegerArray = null;
            bigIntegerArray = bigInteger.divideAndRemainder(BigDecimal.powerOfTenBI(l3));
            this.bi = bigIntegerArray[0];
            bigInteger2 = bigIntegerArray[1];
            n3 = bigIntegerArray[1].divide(BigDecimal.powerOfTenBI(l3 - 1L)).byteValue();
            bigInteger3 = bigIntegerArray[1].remainder(BigDecimal.powerOfTenBI(l3 - 1L));
        } else {
            this.bi = BigInteger.ZERO;
            if (l == 0L) {
                bigInteger2 = bigInteger.remainder(BigDecimal.powerOfTenBI(l3));
                n3 = bigInteger2.divide(BigDecimal.powerOfTenBI(l3 - 1L)).byteValue();
                bigInteger3 = bigInteger2.remainder(BigDecimal.powerOfTenBI(l3 - 1L));
            } else {
                bigInteger2 = bigInteger;
                n3 = 0;
                bigInteger3 = bigInteger;
            }
        }
        if (n2 == -1) {
            n3 = (byte)(n3 * -1);
        }
        if (bigInteger3.signum() < 0) {
            bigInteger3 = bigInteger3.abs();
        }
        this.flags &= 0xFFFFFFEF;
        int n4 = 0;
        if (n == 0) {
            if (bigInteger2.signum() != 0) {
                n4 = n2;
            }
        } else if (n != 1) {
            if (n == 2) {
                if (n2 == 1 && (n3 != 0 || bigInteger3.signum() != 0)) {
                    n4 = n2;
                }
            } else if (n == 3) {
                if (n2 == -1 && (n3 != 0 || bigInteger3.signum() != 0)) {
                    n4 = n2;
                }
            } else if (n == 4) {
                if (n3 >= 5) {
                    n4 = n2;
                } else if (n3 == 5 && bigInteger3.signum() > 0) {
                    n4 = n2;
                }
            } else if (n == 5) {
                if (n3 > 5) {
                    n4 = n2;
                } else if (n3 == 5 && bigInteger3.signum() > 0) {
                    n4 = n2;
                }
            } else if (n == 6) {
                if (n3 > 5) {
                    n4 = n2;
                } else if (n3 == 5) {
                    if (bigInteger3.signum() != 0) {
                        n4 = n2;
                    } else if (this.bi.abs().remainder(BigInteger.TEN).byteValue() % 2 == 1) {
                        n4 = n2;
                    }
                }
            } else if (n == 7) {
                if (n3 != 0 || bigInteger3.signum() != 0) {
                    throw new ArithmeticException("Rounding necessary");
                }
            } else {
                throw new IllegalArgumentException("Bad round value: " + n);
            }
        }
        if (n4 != 0) {
            if (n2 == 0) {
                if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + -l2);
                }
                this.bi = BigInteger.ONE;
                this.flags |= 4;
                this.flags &= 0x7F;
                this.flags |= 0x80;
                this.exp = (int)l2;
            } else {
                BigInteger bigInteger4 = n4 == 1 ? this.bi.add(BigInteger.ONE) : this.bi.subtract(BigInteger.ONE);
                int n5 = BigDecimal.precisionBI(bigInteger4);
                if (this.precision() < n5) {
                    this.flags &= 0xFFFFFFEF;
                    ++l2;
                    bigInteger4 = bigInteger4.divide(BigInteger.TEN);
                }
                this.bi = bigInteger4;
                if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                    throw new ArithmeticException("BigDecimal scale outside legal range: " + -l2);
                }
                this.exp = (int)l2;
            }
        } else {
            if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                throw new ArithmeticException("BigDecimal scale outside legal range: " + -l2);
            }
            this.exp = (int)l2;
        }
    }

    private final void roundLL(long l, int n, boolean bl) {
        byte by = 0;
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = false;
        int n3 = this.precision();
        long l5 = (long)n3 - l;
        if (l5 <= 0L) {
            return;
        }
        if (!bl && l == 0L) {
            return;
        }
        l4 = (long)this.exp + l5;
        int n4 = this.signum();
        long l6 = this.laside;
        if (l6 < 0L) {
            l6 *= -1L;
        }
        if (l > 0L) {
            by = (byte)BigDecimal.digitAt(l6, n3, (int)l);
            l2 = l6 % BigDecimal.powerOfTenLL(l5 - 1L);
            this.laside = l6 / BigDecimal.powerOfTenLL(l5);
            this.flags &= 0x7F;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
        } else {
            this.laside = 0L;
            if (l == 0L) {
                by = (byte)BigDecimal.digitAt(l6, n3, 0);
                l2 = l6 % BigDecimal.powerOfTenLL(l5 - 1L);
            } else {
                by = 0;
                l2 = l6;
            }
            this.flags &= 0x7F;
            this.flags |= 0x80;
        }
        this.flags &= 0xFFFFFFEF;
        if (n == 4) {
            if (by >= 5) {
                n2 = n4;
            } else if (by == 5 && l2 != 0L) {
                n2 = n4;
            }
        } else if (n == 5) {
            if (by > 5) {
                n2 = n4;
            } else if (by == 5 && l2 != 0L) {
                n2 = n4;
            }
        } else if (n == 6) {
            if (by > 5) {
                n2 = n4;
            } else if (by == 5) {
                if (l2 != 0L) {
                    n2 = n4;
                } else if (BigDecimal.digitAt(this.laside, BigDecimal.numDigits(this.laside), BigDecimal.numDigits(this.laside) - 1) % 2 == 1) {
                    n2 = n4;
                }
            }
        } else if (n != 1) {
            if (n == 0) {
                if (by != 0 || l2 != 0L) {
                    n2 = n4;
                }
            } else if (n == 2) {
                if (n4 == 1 && (by != 0 || l2 != 0L)) {
                    n2 = n4;
                }
            } else if (n == 3) {
                if (n4 == -1 && (by != 0 || l2 != 0L)) {
                    n2 = n4;
                }
            } else if (n == 7) {
                if (by != 0 || l2 != 0L) {
                    throw new ArithmeticException("Rounding necessary");
                }
            } else {
                throw new IllegalArgumentException("Bad round value: " + n);
            }
        }
        if (n2 != 0) {
            if (n4 == 0) {
                this.laside = 1L;
                this.flags &= 0x7F;
                this.flags |= 0x80;
            } else {
                if (n4 == -1) {
                    n2 *= -1;
                }
                if (!BigDecimal.overflowAdd(this.laside, n2)) {
                    l3 = this.laside + (long)n2;
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.laside = l6;
                    this.LLToBI();
                    this.roundBI(l, n, bl);
                    return;
                }
                if (BigDecimal.numDigits(l3) > this.precision()) {
                    ++l4;
                    this.laside = l3 / 10L;
                } else {
                    this.laside = l3;
                }
            }
        }
        if (-l4 < Integer.MIN_VALUE || -l4 > Integer.MAX_VALUE) {
            throw new ArithmeticException("BigDecimal scale outside legal range: " + -l4);
        }
        this.exp = (int)l4;
        this.flags &= 0x7F;
        this.flags |= BigDecimal.numDigits(this.laside) << 7;
        if (n4 == -1) {
            this.laside *= -1L;
        }
    }

    private static final long roundPostLLDivision(long l, int n, long l2, long l3, int n2) {
        if (n2 == 0) {
            if (l3 > 0L) {
                if (BigDecimal.overflowAdd(l, 1L)) {
                    return -1L;
                }
                ++l;
            }
        } else if (n2 != 1) {
            if (n2 == 2) {
                if (l3 > 0L && n == 1) {
                    if (BigDecimal.overflowAdd(l, 1L)) {
                        return -1L;
                    }
                    ++l;
                }
            } else if (n2 == 3) {
                if (l3 > 0L && n == -1) {
                    if (BigDecimal.overflowAdd(l, 1L)) {
                        return -1L;
                    }
                    ++l;
                }
            } else if (n2 == 4) {
                if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * l3 >= l2) {
                        if (BigDecimal.overflowAdd(l, 1L)) {
                            return -1L;
                        }
                        ++l;
                    }
                } else {
                    if (BigDecimal.overflowAdd(l, 1L)) {
                        return -1L;
                    }
                    ++l;
                }
            } else if (n2 == 5) {
                if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * l3 > l2) {
                        if (BigDecimal.overflowAdd(l, 1L)) {
                            return -1L;
                        }
                        ++l;
                    }
                } else {
                    if (BigDecimal.overflowAdd(l, 1L)) {
                        return -1L;
                    }
                    ++l;
                }
            } else if (n2 == 6) {
                if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * l3 > l2) {
                        if (BigDecimal.overflowAdd(l, 1L)) {
                            return -1L;
                        }
                        ++l;
                    } else if (2L * l3 >= l2 && l % 10L % 2L == 1L) {
                        if (BigDecimal.overflowAdd(l, 1L)) {
                            return -1L;
                        }
                        ++l;
                    }
                } else {
                    if (BigDecimal.overflowAdd(l, 1L)) {
                        return -1L;
                    }
                    ++l;
                }
            } else if (n2 == 7 && l3 != 0L) {
                throw new ArithmeticException("Rounding unnecessary for inexact result");
            }
        }
        return l;
    }

    private static final BigInteger roundPostSlowDivision(BigInteger bigInteger, int n, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        if (n2 == 0) {
            if (bigInteger3.signum() > 0) {
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
        } else if (n2 != 1) {
            if (n2 == 2) {
                if (bigInteger3.signum() > 0 && n == 1) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 3) {
                if (bigInteger3.signum() > 0 && n == -1) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 4) {
                if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) >= 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 5) {
                if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) > 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 6) {
                if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) > 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                } else if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) >= 0 && bigInteger.mod(BigInteger.TEN).mod(new BigInteger("2")).compareTo(BigInteger.ONE) == 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 7 && bigInteger3.signum() != 0) {
                throw new ArithmeticException("Rounding unnecessary for inexact result");
            }
        }
        return bigInteger;
    }

    private static final boolean allzeroBCD(long l, int n) {
        long l2 = -1L;
        return ((l2 >>>= (64 - n) * 4) & l) == 0L;
    }

    private final BigDecimal finish(int n, int n2) {
        if (n > 0 && this.precision() > n) {
            if ((this.flags & 3) == 0) {
                this.roundDFP(n, n2);
            } else if ((this.flags & 3) == 2) {
                this.roundBI(n, n2, false);
            } else {
                this.roundLL(n, n2, false);
            }
        }
        return this;
    }

    private static final BigInteger powerOfTenBI(long l) {
        if (l > -1L && l <= 18L) {
            return powersOfTenBI[(int)l];
        }
        char[] cArray = new char[(int)l + 1];
        Arrays.fill(cArray, '0');
        cArray[0] = 49;
        return new BigInteger(cArray);
    }

    private static final long powerOfTenLL(long l) {
        if (l > -1L && l <= 18L) {
            return powersOfTenLL[(int)l];
        }
        return -1L;
    }

    private static final long toLongForm(char[] cArray) {
        long l = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            l *= 10L;
            l += (long)(cArray[i] - 48);
        }
        return l;
    }

    private final void BIToLL() {
        if (this.bi.bitLength() < 63) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
            this.laside = this.bi.longValue();
            this.bi = null;
        }
    }

    private final void LLToBI() {
        if ((this.flags & 3) == 1) {
            this.bi = BigInteger.valueOf(this.laside);
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private final void DFPToLL() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
            this.exp = 0;
            this.laside = 0L;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            int n = this.signum();
            this.exp = -this.scale();
            int n2 = this.precision();
            this.flags &= 0xFFFFFFEF;
            this.flags |= 0x10;
            this.flags |= n2 << 7;
            long l = BigDecimal.DFPUnscaledValue(this.laside);
            if (l == Long.MAX_VALUE) {
                l = BigDecimal.DFPBCDDigits(this.laside);
                if (l == 10L) {
                    l = BigDecimal.extractDFPDigitsBCD(this.laside);
                }
                long l2 = 0L;
                int n3 = 0;
                while (l != 0L) {
                    l2 += (l & 0xFL) * BigDecimal.powerOfTenLL(n3++);
                    l >>>= 4;
                }
                this.laside = l2 * (long)n;
            } else {
                this.laside = l;
            }
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
        }
    }

    private final void DFPToBI() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
            this.exp = 0;
            this.bi = BigInteger.ZERO;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            this.exp = -this.scale();
            this.bi = this.unscaledValue();
            int n = this.precision();
            this.flags |= 0x10;
            this.flags |= n << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private static final int numDigitsBI(int n) {
        if (n < 0) {
            return 10;
        }
        if (n < 1000000000) {
            if (n < 100000000) {
                if (n < 10000) {
                    if (n < 100) {
                        if (n < 10) {
                            return 1;
                        }
                        return 2;
                    }
                    if (n < 1000) {
                        return 3;
                    }
                    return 4;
                }
                if (n < 1000000) {
                    if (n < 100000) {
                        return 5;
                    }
                    return 6;
                }
                if (n < 10000000) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        return 10;
    }

    private static final int numDigits(long l) {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (n == 0) {
            if (n2 < 0) {
                return 10;
            }
            if (n2 < 1000000000) {
                if (n2 < 100000000) {
                    if (n2 < 10000) {
                        if (n2 < 100) {
                            if (n2 < 10) {
                                return 1;
                            }
                            return 2;
                        }
                        if (n2 < 1000) {
                            return 3;
                        }
                        return 4;
                    }
                    if (n2 < 1000000) {
                        if (n2 < 100000) {
                            return 5;
                        }
                        return 6;
                    }
                    if (n2 < 10000000) {
                        return 7;
                    }
                    return 8;
                }
                return 9;
            }
            return 10;
        }
        if (l == Long.MIN_VALUE || l == Long.MAX_VALUE) {
            return 19;
        }
        if (l < 0L) {
            l *= -1L;
        }
        if (l < 1000000000L) {
            if (l < 100000000L) {
                if (l < 10000L) {
                    if (l < 100L) {
                        if (l < 10L) {
                            return 1;
                        }
                        return 2;
                    }
                    if (l < 1000L) {
                        return 3;
                    }
                    return 4;
                }
                if (l < 1000000L) {
                    if (l < 100000L) {
                        return 5;
                    }
                    return 6;
                }
                if (l < 10000000L) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        if (l < 10000000000L) {
            return 10;
        }
        if (l < 100000000000000L) {
            if (l < 1000000000000L) {
                if (l < 100000000000L) {
                    return 11;
                }
                return 12;
            }
            if (l < 10000000000000L) {
                return 13;
            }
            return 14;
        }
        if (l < 10000000000000000L) {
            if (l < 1000000000000000L) {
                return 15;
            }
            return 16;
        }
        if (l < 100000000000000000L) {
            return 17;
        }
        if (l < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    private static final int digitAt(long l, int n, int n2) {
        if (l < 0L) {
            l *= -1L;
        }
        if (n2 > n - 1) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n - n2 - 1;
        long l2 = l;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                l2 = l / 10L;
                break;
            }
            case 2: {
                l2 = l / 100L;
                break;
            }
            case 3: {
                l2 = l / 1000L;
                break;
            }
            case 4: {
                l2 = l / 10000L;
                break;
            }
            case 5: {
                l2 = l / 100000L;
                break;
            }
            case 6: {
                l2 = l / 1000000L;
                break;
            }
            case 7: {
                l2 = l / 10000000L;
                break;
            }
            case 8: {
                l2 = l / 100000000L;
                break;
            }
            case 9: {
                l2 = l / 1000000000L;
                break;
            }
            case 10: {
                l2 = l / 10000000000L;
                break;
            }
            case 11: {
                l2 = l / 100000000000L;
                break;
            }
            case 12: {
                l2 = l / 1000000000000L;
                break;
            }
            case 13: {
                l2 = l / 10000000000000L;
                break;
            }
            case 14: {
                l2 = l / 100000000000000L;
                break;
            }
            case 15: {
                l2 = l / 1000000000000000L;
                break;
            }
            case 16: {
                l2 = l / 10000000000000000L;
                break;
            }
            case 17: {
                l2 = l / 100000000000000000L;
                break;
            }
            case 18: {
                l2 = l / 1000000000000000000L;
            }
        }
        if (l2 <= Integer.MAX_VALUE) {
            int n4;
            int n5 = n4 = (int)l2;
            n4 = BigDecimal.uDivideByTen(n4);
            return n5 - ((n4 << 3) + (n4 << 1));
        }
        long l3 = l2;
        return (int)(l3 - (((l2 /= 10L) << 3) + (l2 << 1)));
    }

    private static final int digitAtBCD(long l, int n, int n2) {
        int n3 = n - n2 - 1;
        switch (n3) {
            case 0: {
                return (int)(l & 0xFL);
            }
            case 1: {
                return (int)((l & 0xF0L) >>> 4);
            }
            case 2: {
                return (int)((l & 0xF00L) >>> 8);
            }
            case 3: {
                return (int)((l & 0xF000L) >>> 12);
            }
            case 4: {
                return (int)((l & 0xF0000L) >>> 16);
            }
            case 5: {
                return (int)((l & 0xF00000L) >>> 20);
            }
            case 6: {
                return (int)((l & 0xF000000L) >>> 24);
            }
            case 7: {
                return (int)((l & 0xF0000000L) >>> 28);
            }
            case 8: {
                return (int)((l & 0xF00000000L) >>> 32);
            }
            case 9: {
                return (int)((l & 0xF000000000L) >>> 36);
            }
            case 10: {
                return (int)((l & 0xF0000000000L) >>> 40);
            }
            case 11: {
                return (int)((l & 0xF00000000000L) >> 44);
            }
            case 12: {
                return (int)((l & 0xF000000000000L) >>> 48);
            }
            case 13: {
                return (int)((l & 0xF0000000000000L) >>> 52);
            }
            case 14: {
                return (int)((l & 0xF00000000000000L) >>> 56);
            }
            case 15: {
                return (int)((l & 0xF000000000000000L) >>> 60);
            }
        }
        return 0;
    }

    private static final boolean overflowAdd(long l, long l2) {
        long l3 = Long.MIN_VALUE;
        long l4 = 0L;
        byte by = 0;
        l4 = (l ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
        return (by = (byte)((l4 &= (l ^ l4) + l2 ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) >>> 63)) == 1;
    }

    private static final boolean overflowMultiply(long l, long l2) {
        if (l < 0L) {
            l *= -1L;
        }
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if (l == 0L || l2 == 0L) {
            return false;
        }
        if (l == 1L || l2 == 1L) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        n = Long.numberOfLeadingZeros(l) - 1;
        return n + (n2 = Long.numberOfLeadingZeros(l2) - 1) < 63;
    }

    private static final int uDivideByTen(int n) {
        int n2 = (n >> 1) + (n >> 2);
        n2 += n2 >> 4;
        n2 += n2 >> 8;
        n2 += n2 >> 16;
        return n2 + ((n -= (n2 >>= 3) * 10) + 6 >> 4);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("intLong", Long.MIN_VALUE);
        putField.put("scale", -this.exp);
        putField.put("intVal", this.unscaledValue());
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        BigInteger bigInteger = (BigInteger)getField.get("intVal", null);
        int n = getField.get("scale", 0);
        if (bigInteger == null) {
            throw new IOException("Referenced field was null");
        }
        this.bigIntegerConstructor(bigInteger, n, MathContext.UNLIMITED);
    }

    private static final byte[] comboinit() {
        byte[] byArray = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 1, 5, 9, 13, 17, 21, 25, 29, 2, 6, 10, 14, 18, 22, 26, 30, 32, 36, 33, 37, 34, 38};
        return byArray;
    }

    private static final short[] dpd2bcdinit() {
        short[] sArray = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 128, 129, 2048, 2049, 2176, 2177, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 144, 145, 2064, 2065, 2192, 2193, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 130, 131, 2080, 2081, 2056, 2057, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 146, 147, 2096, 2097, 2072, 2073, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 132, 133, 2112, 2113, 136, 137, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 148, 149, 2128, 2129, 152, 153, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 134, 135, 2144, 2145, 2184, 2185, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 150, 151, 2160, 2161, 2200, 2201, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 384, 385, 2304, 2305, 2432, 2433, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 400, 401, 2320, 2321, 2448, 2449, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 386, 387, 2336, 2337, 2312, 2313, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 402, 403, 2352, 2353, 2328, 2329, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 388, 389, 2368, 2369, 392, 393, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 404, 405, 2384, 2385, 408, 409, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 390, 391, 2400, 2401, 2440, 2441, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 406, 407, 2416, 2417, 2456, 2457, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 640, 641, 2050, 2051, 2178, 2179, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 656, 657, 2066, 2067, 2194, 2195, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 642, 643, 2082, 2083, 2088, 2089, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 658, 659, 2098, 2099, 2104, 2105, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 644, 645, 2114, 2115, 648, 649, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 660, 661, 2130, 2131, 664, 665, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 646, 647, 2146, 2147, 2184, 2185, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 662, 663, 2162, 2163, 2200, 2201, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 896, 897, 2306, 2307, 2434, 2435, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 912, 913, 2322, 2323, 2450, 2451, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 898, 899, 2338, 2339, 2344, 2345, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 914, 915, 2354, 2355, 2360, 2361, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 900, 901, 2370, 2371, 904, 905, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 916, 917, 2386, 2387, 920, 921, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 902, 903, 2402, 2403, 2440, 2441, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 918, 919, 2418, 2419, 2456, 2457, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1152, 1153, 2052, 2053, 2180, 2181, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1168, 1169, 2068, 2069, 2196, 2197, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1154, 1155, 2084, 2085, 2120, 2121, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1170, 1171, 2100, 2101, 2136, 2137, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1156, 1157, 2116, 2117, 1160, 1161, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1172, 1173, 2132, 2133, 1176, 1177, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1158, 1159, 2148, 2149, 2184, 2185, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1174, 1175, 2164, 2165, 2200, 2201, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1408, 1409, 2308, 2309, 2436, 2437, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1424, 1425, 2324, 2325, 2452, 2453, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1410, 1411, 2340, 2341, 2376, 2377, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1426, 1427, 2356, 2357, 2392, 2393, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1412, 1413, 2372, 2373, 1416, 1417, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1428, 1429, 2388, 2389, 1432, 1433, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1414, 1415, 2404, 2405, 2440, 2441, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1430, 1431, 2420, 2421, 2456, 2457, 1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1664, 1665, 2054, 2055, 2182, 2183, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1680, 1681, 2070, 2071, 2198, 2199, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1666, 1667, 2086, 2087, 2152, 2153, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1682, 1683, 2102, 2103, 2168, 2169, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1668, 1669, 2118, 2119, 1672, 1673, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1684, 1685, 2134, 2135, 1688, 1689, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 1670, 1671, 2150, 2151, 2184, 2185, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1686, 1687, 2166, 2167, 2200, 2201, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1920, 1921, 2310, 2311, 2438, 2439, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1936, 1937, 2326, 2327, 2454, 2455, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1922, 1923, 2342, 2343, 2408, 2409, 1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848, 1849, 1938, 1939, 2358, 2359, 2424, 2425, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1924, 1925, 2374, 2375, 1928, 1929, 1872, 1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880, 1881, 1940, 1941, 2390, 2391, 1944, 1945, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1926, 1927, 2406, 2407, 2440, 2441, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1942, 1943, 2422, 2423, 2456, 2457};
        return sArray;
    }

    private static final long extractDFPDigitsBCD(long l) {
        int n = 0;
        if (l == 2465720795985346560L) {
            return 0L;
        }
        n = (int)(l >>> 58);
        n &= 0x1F;
        long l2 = l & 0x3FFFFFFFFFFFFL;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < 5; ++i) {
            l4 = DPD2BCD[(int)((l2 & 0x3FF0000000000L) >>> 40)];
            l3 <<= 12;
            l3 |= l4;
            l2 <<= 10;
        }
        return l3 |= (long)(doubleDFPComboField[n] >>> 2) << 60;
    }

    private static final int extractDFPExponent(long l) {
        byte by = 0;
        by = (byte)(l >>> 58);
        short s = (short)(l >>> 50);
        s = (short)(s & 0xFF);
        byte by2 = (byte)(doubleDFPComboField[by] & 3);
        short s2 = by2;
        s2 = (short)(s2 << 8);
        s2 = (short)(s2 | s);
        return s2;
    }

    private final void constructDFPZero() {
        this.laside = 2465720795985346560L;
        this.flags |= 4;
        this.flags |= 0x10;
        this.flags |= 0x80;
        this.flags |= 8;
    }

    private final boolean isDFPZero() {
        if (this.laside == 2465720795985346560L) {
            return true;
        }
        return (this.laside & 0x3FFFFFFFFFFFFL) == 0L && (this.laside >>> 58 & 7L) == 0L;
    }

    private static final boolean DFPHWAvailable() {
        return false;
    }

    private final boolean DFPIntConstructor(int n, int n2, int n3, int n4) {
        return false;
    }

    private final boolean DFPLongConstructor(long l, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPLongExpConstructor(long l, int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    private final boolean DFPScaledAdd(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPAdd(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPScaledSubtract(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPSubtract(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPScaledMultiply(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPMultiply(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final int DFPScaledDivide(long l, long l2, int n, int n2, int n3) {
        return -1;
    }

    private final int DFPDivide(long l, long l2, boolean bl, int n, int n2, int n3) {
        return -1;
    }

    private final boolean DFPRound(long l, int n, int n2) {
        return false;
    }

    private static final int DFPCompareTo(long l, long l2) {
        return -2;
    }

    private static final long DFPBCDDigits(long l) {
        return 10L;
    }

    private static final int DFPSignificance(long l) {
        return -1;
    }

    private static final int DFPExponent(long l) {
        return 1000;
    }

    private final int DFPSetScale(long l, int n, boolean bl, int n2, boolean bl2) {
        return -1;
    }

    private static final long DFPUnscaledValue(long l) {
        return Long.MAX_VALUE;
    }
}

