/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.RSAPrivateCrtKey;
import com.ibm.crypto.fips.provider.RSAPrivateKey;
import com.ibm.crypto.fips.provider.RSAPublicKey;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public final class RSAKeyFactory
extends KeyFactorySpi
implements AlgorithmStatus {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean a;
    private static String[] z;

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[10] + n3 + z[14]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[12] + n5 + z[13]);
        }
        if (a && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[11]);
        }
    }

    static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    public boolean isFipsApproved() {
        return true;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey a(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey b(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected KeySpec a(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[8]);
                Class<?> clazz3 = Class.forName(z[6]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[4]);
                Class<?> clazz5 = Class.forName(z[3]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPrivateExponent());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[9]);
                Class<?> clazz7 = Class.forName(z[3]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            throw new InvalidKeySpecException(z[7]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[5] + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(z[2]);
        }
        if (key instanceof java.security.interfaces.RSAPublicKey || key instanceof java.security.interfaces.RSAPrivateCrtKey || key instanceof java.security.interfaces.RSAPrivateKey) {
            return key;
        }
        throw new InvalidKeyException(z[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block186: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block185: {
                char[] cArray3;
                Object var0;
                block184: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block183: {
                        char[] cArray5;
                        block182: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block181: {
                                char[] cArray7;
                                block180: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block179: {
                                        char[] cArray9;
                                        block178: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block177: {
                                                char[] cArray11;
                                                block176: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block175: {
                                                        char[] cArray13;
                                                        block174: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block173: {
                                                                char[] cArray15;
                                                                block172: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block171: {
                                                                        char[] cArray17;
                                                                        block170: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block169: {
                                                                                char[] cArray19;
                                                                                block168: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block167: {
                                                                                        char[] cArray21;
                                                                                        block166: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block165: {
                                                                                                char[] cArray23;
                                                                                                block164: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block163: {
                                                                                                        char[] cArray25;
                                                                                                        block162: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block161: {
                                                                                                                char[] cArray27;
                                                                                                                block160: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block159: {
                                                                                                                        char[] cArray29;
                                                                                                                        block158: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block157: {
                                                                                                                                char[] cArray31;
                                                                                                                                block156: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block155: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block154: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block153: {
                                                                                                                                                stringArray = new String[17];
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray35 = "&0.\f6\u001d1?\u000e/\u000e**\\-\n'o\u000f6\n=&\u001a/\f?;\u0015)\u0001do".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n37 = cArray35.length;
                                                                                                                                                cArray34 = cArray35;
                                                                                                                                                n36 = n37;
                                                                                                                                                if (n37 <= 1) break block153;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block154;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray36 = cArray34;
                                                                                                                                                char[] cArray37 = cArray34;
                                                                                                                                                int n38 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n39;
                                                                                                                                                    char c2 = cArray36[n38];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n39 = 111;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n39 = 94;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n39 = 79;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n39 = 124;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n39 = 70;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray36[n38] = (char)(c2 ^ n39);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray37;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray37 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n38 = n36;
                                                                                                                                                    cArray36 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[0] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray38 = "&0.\f6\u001d1?\u000e/\u000e**\\-\n'o\u000f6\n=&\u001a/\f?;\u0015)\u0001".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n40 = cArray38.length;
                                                                                                                                        cArray32 = cArray38;
                                                                                                                                        n34 = n40;
                                                                                                                                        if (n40 <= 1) break block155;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block156;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray39 = cArray32;
                                                                                                                                        char[] cArray40 = cArray32;
                                                                                                                                        int n41 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n42;
                                                                                                                                            char c3 = cArray39[n41];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n42 = 111;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n42 = 94;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n42 = 79;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n42 = 124;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n42 = 70;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray39[n41] = (char)(c3 ^ n42);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray40;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray40 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n41 = n34;
                                                                                                                                            cArray39 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[1] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray41 = "$;6\\1\u000e-o\u00123\u00032".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n43 = cArray41.length;
                                                                                                                                cArray30 = cArray41;
                                                                                                                                n32 = n43;
                                                                                                                                if (n43 <= 1) break block157;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block158;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray42 = cArray30;
                                                                                                                                char[] cArray43 = cArray30;
                                                                                                                                int n44 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n45;
                                                                                                                                    char c4 = cArray42[n44];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n45 = 111;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n45 = 94;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n45 = 79;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n45 = 124;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n45 = 70;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray42[n44] = (char)(c4 ^ n45);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray43;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray43 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n44 = n32;
                                                                                                                                    cArray42 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[2] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray44 = "\u0005?9\u001dh\u001c;,\t4\u0006*6R5\u001f;,R\u0016$\u001d\u001cD\u0003\u0001= \u0018#\u000b\u0015*\u0005\u0015\u001f;,".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n46 = cArray44.length;
                                                                                                                        cArray28 = cArray44;
                                                                                                                        n30 = n46;
                                                                                                                        if (n46 <= 1) break block159;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block160;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray45 = cArray28;
                                                                                                                        char[] cArray46 = cArray28;
                                                                                                                        int n47 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n48;
                                                                                                                            char c5 = cArray45[n47];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n48 = 111;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n48 = 94;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n48 = 79;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n48 = 124;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n48 = 70;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray45[n47] = (char)(c5 ^ n48);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray46;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray46 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n47 = n30;
                                                                                                                            cArray45 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[3] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray47 = "\u0005?9\u001dh\u001c;,\t4\u0006*6R5\u001f;,R\u0014<\u001f\u001f\u000e/\u0019?;\u0019\u0005\u001d*\u0004\u0019?<.*\u001f".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n49 = cArray47.length;
                                                                                                                cArray26 = cArray47;
                                                                                                                n28 = n49;
                                                                                                                if (n49 <= 1) break block161;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block162;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray48 = cArray26;
                                                                                                                char[] cArray49 = cArray26;
                                                                                                                int n50 = n4;
                                                                                                                while (true) {
                                                                                                                    int n51;
                                                                                                                    char c6 = cArray48[n50];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n51 = 111;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n51 = 94;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n51 = 79;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n51 = 124;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n51 = 70;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray48[n50] = (char)(c6 ^ n51);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray49;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray49 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n50 = n28;
                                                                                                                    cArray48 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[4] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray50 = ":0<\t6\u001f1=\b#\u000b~$\u0019?O-?\u0019%\u00068&\u001f'\u001b7 \u0012|O".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n52 = cArray50.length;
                                                                                                        cArray24 = cArray50;
                                                                                                        n26 = n52;
                                                                                                        if (n52 <= 1) break block163;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block164;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray51 = cArray24;
                                                                                                        char[] cArray52 = cArray24;
                                                                                                        int n53 = n4;
                                                                                                        while (true) {
                                                                                                            int n54;
                                                                                                            char c7 = cArray51[n53];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n54 = 111;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n54 = 94;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n54 = 79;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n54 = 124;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n54 = 70;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray51[n53] = (char)(c7 ^ n54);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray52;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray52 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n53 = n26;
                                                                                                            cArray51 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[5] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray53 = "\u0005?9\u001dh\u001c;,\t4\u0006*6R5\u001f;,R\u001eZnv9(\f1+\u0019\"$;6/6\n=".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n55 = cArray53.length;
                                                                                                cArray22 = cArray53;
                                                                                                n24 = n55;
                                                                                                if (n55 <= 1) break block165;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block166;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray54 = cArray22;
                                                                                                char[] cArray55 = cArray22;
                                                                                                int n56 = n4;
                                                                                                while (true) {
                                                                                                    int n57;
                                                                                                    char c8 = cArray54[n56];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n57 = 111;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n57 = 94;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n57 = 79;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n57 = 124;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n57 = 70;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray54[n56] = (char)(c8 ^ n57);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray55;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray55 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n56 = n24;
                                                                                                    cArray54 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[6] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray56 = "&0.\f6\u001d1?\u000e/\u000e**\\-\n'o\b?\u001f;".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n58 = cArray56.length;
                                                                                        cArray20 = cArray56;
                                                                                        n22 = n58;
                                                                                        if (n58 <= 1) break block167;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block168;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray57 = cArray20;
                                                                                        char[] cArray58 = cArray20;
                                                                                        int n59 = n4;
                                                                                        while (true) {
                                                                                            int n60;
                                                                                            char c9 = cArray57[n59];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n60 = 111;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n60 = 94;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n60 = 79;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n60 = 124;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n60 = 70;
                                                                                                }
                                                                                            }
                                                                                            cArray57[n59] = (char)(c9 ^ n60);
                                                                                            ++n4;
                                                                                            cArray20 = cArray58;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray58 = cArray20;
                                                                                            n21 = n22;
                                                                                            n59 = n22;
                                                                                            cArray57 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[7] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray59 = "\u0005?9\u001dh\u001c;,\t4\u0006*6R5\u001f;,R\u0014<\u001f\u001f\t$\u00037,7#\u0016\r?\u0019%".toCharArray();
                                                                                n4 = 0;
                                                                                int n61 = cArray59.length;
                                                                                cArray18 = cArray59;
                                                                                n20 = n61;
                                                                                if (n61 <= 1) break block169;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block170;
                                                                            }
                                                                            do {
                                                                                char[] cArray60 = cArray18;
                                                                                char[] cArray61 = cArray18;
                                                                                int n62 = n4;
                                                                                while (true) {
                                                                                    int n63;
                                                                                    char c10 = cArray60[n62];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n63 = 111;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n63 = 94;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n63 = 79;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n63 = 124;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n63 = 70;
                                                                                        }
                                                                                    }
                                                                                    cArray60[n62] = (char)(c10 ^ n63);
                                                                                    ++n4;
                                                                                    cArray18 = cArray61;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray61 = cArray18;
                                                                                    n19 = n20;
                                                                                    n62 = n20;
                                                                                    cArray60 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[8] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray62 = "\u0005?9\u001dh\u001c;,\t4\u0006*6R5\u001f;,R\u0014<\u001f\u001f\u000e/\u0019?;\u0019\r\n'\u001c\f#\f".toCharArray();
                                                                        n4 = 0;
                                                                        int n64 = cArray62.length;
                                                                        cArray16 = cArray62;
                                                                        n18 = n64;
                                                                        if (n64 <= 1) break block171;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block172;
                                                                    }
                                                                    do {
                                                                        char[] cArray63 = cArray16;
                                                                        char[] cArray64 = cArray16;
                                                                        int n65 = n4;
                                                                        while (true) {
                                                                            int n66;
                                                                            char c11 = cArray63[n65];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n66 = 111;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n66 = 94;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n66 = 79;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n66 = 124;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n66 = 70;
                                                                                }
                                                                            }
                                                                            cArray63[n65] = (char)(c11 ^ n66);
                                                                            ++n4;
                                                                            cArray16 = cArray64;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray64 = cArray16;
                                                                            n17 = n18;
                                                                            n65 = n18;
                                                                            cArray63 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[9] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray65 = "=\r\u000e\\-\n'<\\+\u001a-;\\$\n~.\bf\u0003;.\u000f2O".toCharArray();
                                                                n4 = 0;
                                                                int n67 = cArray65.length;
                                                                cArray14 = cArray65;
                                                                n16 = n67;
                                                                if (n67 <= 1) break block173;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block174;
                                                            }
                                                            do {
                                                                char[] cArray66 = cArray14;
                                                                char[] cArray67 = cArray14;
                                                                int n68 = n4;
                                                                while (true) {
                                                                    int n69;
                                                                    char c12 = cArray66[n68];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n69 = 111;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n69 = 94;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n69 = 79;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n69 = 124;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n69 = 70;
                                                                        }
                                                                    }
                                                                    cArray66[n68] = (char)(c12 ^ n69);
                                                                    ++n4;
                                                                    cArray14 = cArray67;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray67 = cArray14;
                                                                    n15 = n16;
                                                                    n68 = n16;
                                                                    cArray66 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[10] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray68 = "=\r\u000e\\#\u0017. \u0012#\u0001*<\\%\u000e0o\u001e#O0 \\*\u00000(\u00194O*'\u001d(Oh{\\$\u0006*<\\f\u00068o\u0011)\u000b+#\t5O7<\\!\u001d;.\b#\u001d~;\u0014'\u0001~|Lq]~-\u00152\u001c".toCharArray();
                                                        n4 = 0;
                                                        int n70 = cArray68.length;
                                                        cArray12 = cArray68;
                                                        n14 = n70;
                                                        if (n70 <= 1) break block175;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block176;
                                                    }
                                                    do {
                                                        char[] cArray69 = cArray12;
                                                        char[] cArray70 = cArray12;
                                                        int n71 = n4;
                                                        while (true) {
                                                            int n72;
                                                            char c13 = cArray69[n71];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n72 = 111;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n72 = 94;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n72 = 79;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n72 = 124;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n72 = 70;
                                                                }
                                                            }
                                                            cArray69[n71] = (char)(c13 ^ n72);
                                                            ++n4;
                                                            cArray12 = cArray70;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray70 = cArray12;
                                                            n13 = n14;
                                                            n71 = n14;
                                                            cArray69 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[11] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray71 = "=\r\u000e\\-\n'<\\+\u001a-;\\$\n~!\u0013f\u00031!\u001b#\u001d~;\u0014'\u0001~".toCharArray();
                                                n4 = 0;
                                                int n73 = cArray71.length;
                                                cArray10 = cArray71;
                                                n12 = n73;
                                                if (n73 <= 1) break block177;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block178;
                                            }
                                            do {
                                                char[] cArray72 = cArray10;
                                                char[] cArray73 = cArray10;
                                                int n74 = n4;
                                                while (true) {
                                                    int n75;
                                                    char c14 = cArray72[n74];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n75 = 111;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n75 = 94;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n75 = 79;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n75 = 124;
                                                            break;
                                                        }
                                                        default: {
                                                            n75 = 70;
                                                        }
                                                    }
                                                    cArray72[n74] = (char)(c14 ^ n75);
                                                    ++n4;
                                                    cArray10 = cArray73;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray73 = cArray10;
                                                    n11 = n12;
                                                    n74 = n12;
                                                    cArray72 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[12] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray74 = "O<&\b5".toCharArray();
                                        n4 = 0;
                                        int n76 = cArray74.length;
                                        cArray8 = cArray74;
                                        n10 = n76;
                                        if (n76 <= 1) break block179;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block180;
                                    }
                                    do {
                                        char[] cArray75 = cArray8;
                                        char[] cArray76 = cArray8;
                                        int n77 = n4;
                                        while (true) {
                                            int n78;
                                            char c15 = cArray75[n77];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n78 = 111;
                                                    break;
                                                }
                                                case 1: {
                                                    n78 = 94;
                                                    break;
                                                }
                                                case 2: {
                                                    n78 = 79;
                                                    break;
                                                }
                                                case 3: {
                                                    n78 = 124;
                                                    break;
                                                }
                                                default: {
                                                    n78 = 70;
                                                }
                                            }
                                            cArray75[n77] = (char)(c15 ^ n78);
                                            ++n4;
                                            cArray8 = cArray76;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray76 = cArray8;
                                            n9 = n10;
                                            n77 = n10;
                                            cArray75 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[13] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray77 = "O<&\b5O2 \u0012!".toCharArray();
                                n4 = 0;
                                int n79 = cArray77.length;
                                cArray6 = cArray77;
                                n8 = n79;
                                if (n79 <= 1) break block181;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block182;
                            }
                            do {
                                char[] cArray78 = cArray6;
                                char[] cArray79 = cArray6;
                                int n80 = n4;
                                while (true) {
                                    int n81;
                                    char c16 = cArray78[n80];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n81 = 111;
                                            break;
                                        }
                                        case 1: {
                                            n81 = 94;
                                            break;
                                        }
                                        case 2: {
                                            n81 = 79;
                                            break;
                                        }
                                        case 3: {
                                            n81 = 124;
                                            break;
                                        }
                                        default: {
                                            n81 = 70;
                                        }
                                    }
                                    cArray78[n80] = (char)(c16 ^ n81);
                                    ++n4;
                                    cArray6 = cArray79;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray79 = cArray6;
                                    n7 = n8;
                                    n80 = n8;
                                    cArray78 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[14] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray80 = "\u001b,:\u0019".toCharArray();
                        n4 = 0;
                        int n82 = cArray80.length;
                        cArray4 = cArray80;
                        n6 = n82;
                        if (n82 <= 1) break block183;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block184;
                    }
                    do {
                        char[] cArray81 = cArray4;
                        char[] cArray82 = cArray4;
                        int n83 = n4;
                        while (true) {
                            int n84;
                            char c17 = cArray81[n83];
                            switch (n4 % 5) {
                                case 0: {
                                    n84 = 111;
                                    break;
                                }
                                case 1: {
                                    n84 = 94;
                                    break;
                                }
                                case 2: {
                                    n84 = 79;
                                    break;
                                }
                                case 3: {
                                    n84 = 124;
                                    break;
                                }
                                default: {
                                    n84 = 70;
                                }
                            }
                            cArray81[n83] = (char)(c17 ^ n84);
                            ++n4;
                            cArray4 = cArray82;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray82 = cArray4;
                            n5 = n6;
                            n83 = n6;
                            cArray81 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[15] = new String(cArray3).intern();
                var0 = null;
                char[] cArray83 = "\f1\"R/\r3a\u001f4\u0016.;\u0013h\u001f, \n/\u000b;=R4\n-;\u000e/\f*\u001d/\u0007*&?\u0013(\n0;".toCharArray();
                n4 = 0;
                int n85 = cArray83.length;
                cArray2 = cArray83;
                n3 = n85;
                if (n85 <= 1) break block185;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block186;
            }
            do {
                char[] cArray84 = cArray2;
                char[] cArray85 = cArray2;
                int n86 = n4;
                while (true) {
                    int n87;
                    char c18 = cArray84[n86];
                    switch (n4 % 5) {
                        case 0: {
                            n87 = 111;
                            break;
                        }
                        case 1: {
                            n87 = 94;
                            break;
                        }
                        case 2: {
                            n87 = 79;
                            break;
                        }
                        case 3: {
                            n87 = 124;
                            break;
                        }
                        default: {
                            n87 = 70;
                        }
                    }
                    cArray84[n86] = (char)(c18 ^ n87);
                    ++n4;
                    cArray2 = cArray85;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray85 = cArray2;
                    n2 = n3;
                    n86 = n3;
                    cArray84 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[16] = new String(cArray).intern();
        z = stringArray;
        a = z[15].equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[16], z[15])));
    }
}

