/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.jvm.j9.dump.indexsupport.NodeAbstract;
import org.xml.sax.Attributes;

public class NodeGPF
extends NodeAbstract {
    private ImageProcess _process;
    private static final int J9PORT_SIG_FLAG_SIGSEGV = 4;
    private static final int J9PORT_SIG_FLAG_SIGBUS = 8;
    private static final int J9PORT_SIG_FLAG_SIGILL = 16;
    private static final int J9PORT_SIG_FLAG_SIGFPE = 32;
    private static final int J9PORT_SIG_FLAG_SIGTRAP = 64;
    private static final int J9PORT_SIG_FLAG_SIGQUIT = 1024;
    private static final int J9PORT_SIG_FLAG_SIGABRT = 2048;
    private static final int J9PORT_SIG_FLAG_SIGTERM = 4096;
    private static final int J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 262176;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 524320;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0x100020;

    public NodeGPF(ImageProcess imageProcess, Attributes attributes) {
        long l = NodeGPF._longFromString(attributes.getValue("nativeFailingThread"));
        imageProcess.setFaultingThreadID(l);
        this._process = imageProcess;
    }

    public void stringWasParsed(String string) {
        int n = (int)NodeGPF._longByResolvingRawKey(string, "Signal_Number");
        if (0 == n) {
            n = this.resolveGenericSignal((int)NodeGPF._longByResolvingRawKey(string, "J9Generic_Signal"));
        }
        this._process.setSignalNumber(n);
    }

    private int resolveGenericSignal(int n) {
        if ((n & 0x400) != 0) {
            return 3;
        }
        if ((n & 0x10) != 0) {
            return 4;
        }
        if ((n & 0x40) != 0) {
            return 5;
        }
        if ((n & 0x800) != 0) {
            return 6;
        }
        if ((n & 0x20) != 0) {
            if (n == 262176) {
                return 35;
            }
            if (n == 524320) {
                return 36;
            }
            if (n == 0x100020) {
                return 37;
            }
            return 8;
        }
        if ((n & 8) != 0) {
            return 10;
        }
        if ((n & 4) != 0) {
            return 11;
        }
        if ((n & 0x1000) != 0) {
            return 15;
        }
        return n;
    }
}

