/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public abstract class CoreReaderSupport
implements ICoreFileReader {
    private DumpReader _reader;
    private IAbstractAddressSpace _addressSpace = null;

    protected abstract MemoryRange[] getMemoryRangesAsArray();

    protected abstract boolean isLittleEndian();

    protected abstract boolean is64Bit();

    public CoreReaderSupport(DumpReader dumpReader) {
        this._reader = dumpReader;
    }

    protected int coreReadInt() throws IOException {
        return this._reader.readInt();
    }

    protected void coreSeek(long l) throws IOException {
        this._reader.seek(l);
    }

    protected long coreReadLong() throws IOException {
        return this._reader.readLong();
    }

    protected long coreReadAddress() throws IOException {
        return this._reader.readAddress();
    }

    protected short coreReadShort() throws IOException {
        return this._reader.readShort();
    }

    protected byte coreReadByte() throws IOException {
        return this._reader.readByte();
    }

    protected byte[] coreReadBytes(int n) throws IOException {
        return this._reader.readBytes(n);
    }

    public IAbstractAddressSpace getAddressSpace() {
        if (null == this._addressSpace) {
            MemoryRange[] memoryRangeArray = this.getMemoryRangesAsArray();
            this._addressSpace = null == memoryRangeArray ? null : new DumpReaderAddressSpace(memoryRangeArray, this._reader, this.isLittleEndian(), this.is64Bit());
        }
        return this._addressSpace;
    }

    public boolean isTruncated() {
        return false;
    }

    protected long coreGetPosition() throws IOException {
        return this._reader.getPosition();
    }

    protected boolean coreCheckOffset(long l) throws IOException {
        boolean bl;
        long l2 = this.coreGetPosition();
        try {
            this.coreSeek(l);
            this.coreReadByte();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.coreSeek(l2);
        return bl;
    }
}

