/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class CommonAddressSpace
implements IAbstractAddressSpace {
    private static final int BUFFER_MAX = 4096;
    private static final int MEMORY_CHECK_THRESHOLD = 0x100000;
    private MemoryRange[] _translations;
    private Integer _lastTranslationUsed = new Integer(0);
    private boolean _isLittleEndian;
    private boolean _is64Bit;
    private int lastAsid;
    private int[] _is64BitAsid;

    protected CommonAddressSpace(MemoryRange[] memoryRangeArray, boolean bl, boolean bl2) {
        this._translations = CommonAddressSpace._sortRanges(memoryRangeArray);
        this._isLittleEndian = bl;
        this._is64Bit = bl2;
        this.set64Bitness();
    }

    private static MemoryRange[] _sortRanges(MemoryRange[] memoryRangeArray) {
        Arrays.sort(memoryRangeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                MemoryRange memoryRange = (MemoryRange)object;
                MemoryRange memoryRange2 = (MemoryRange)object2;
                return CommonAddressSpace.compareAddress(memoryRange.getAsid(), memoryRange.getVirtualAddress(), memoryRange2.getAsid(), memoryRange2.getVirtualAddress());
            }
        });
        return memoryRangeArray;
    }

    private void set64Bitness() {
        if (!this._is64Bit) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this._translations.length; ++i) {
            if (this._translations[i].getVirtualAddress() + this._translations[i].getSize() < 0x100000000L) continue;
            int n2 = this._translations[i].getAsid();
            int[] nArray = new int[n + 1];
            for (int j = 0; j < n; ++j) {
                nArray[j] = this._is64BitAsid[j];
            }
            nArray[n] = n2;
            this._is64BitAsid = nArray;
            ++n;
            while (i < this._translations.length && this._translations[i].getAsid() == n2) {
                ++i;
            }
        }
    }

    public Iterator getMemoryRanges() {
        return Arrays.asList(this._translations).iterator();
    }

    protected MemoryRange _residentRange(int n, long l) throws MemoryAccessException {
        int n2 = CommonAddressSpace.findWhichMemoryRange(n, l, this._translations, this._lastTranslationUsed, true);
        if (n2 >= 0) {
            return this._translations[n2];
        }
        throw new MemoryAccessException(n, l);
    }

    protected static int findWhichMemoryRange(int n, long l, MemoryRange[] memoryRangeArray, Integer n2, boolean bl) {
        int n3 = -1;
        int n4 = n2;
        int n5 = n4 + 1;
        if (n4 < memoryRangeArray.length && memoryRangeArray[n4].contains(n, l) && (memoryRangeArray[n4].isInCoreFile() || !memoryRangeArray[n4].isInCoreFile() && memoryRangeArray[n4].getLibraryReader() != null)) {
            n3 = n4;
        } else if (n5 < memoryRangeArray.length && memoryRangeArray[n5].contains(n, l) && (memoryRangeArray[n4].isInCoreFile() || !memoryRangeArray[n4].isInCoreFile() && memoryRangeArray[n4].getLibraryReader() != null)) {
            n3 = n5;
        } else {
            int n6;
            long l2;
            int n7;
            int n8 = memoryRangeArray.length - 1;
            int n9 = 0;
            while (n9 <= n8) {
                n7 = n9 + (n8 - n9 >>> 1);
                l2 = memoryRangeArray[n7].getVirtualAddress();
                n6 = memoryRangeArray[n7].getAsid();
                if (CommonAddressSpace.compareAddress(n, l, n6, l2) >= 0) {
                    if (CommonAddressSpace.compareAddress(n, l, n6, l2 + memoryRangeArray[n7].getSize()) < 0 && (memoryRangeArray[n7].isInCoreFile() || !memoryRangeArray[n7].isInCoreFile() && memoryRangeArray[n7].getLibraryReader() != null)) {
                        n3 = n7;
                        break;
                    }
                    n9 = n7 + 1;
                    continue;
                }
                n8 = n7 - 1;
            }
            if (-1 == n3 && bl) {
                for (n7 = 0; n7 < n9; ++n7) {
                    l2 = memoryRangeArray[n7].getVirtualAddress();
                    n6 = memoryRangeArray[n7].getAsid();
                    if (CommonAddressSpace.compareAddress(n, l, n6, l2) < 0 || CommonAddressSpace.compareAddress(n, l, n6, l2 + memoryRangeArray[n7].getSize()) >= 0 || !memoryRangeArray[n7].isInCoreFile() && (memoryRangeArray[n7].isInCoreFile() || memoryRangeArray[n7].getLibraryReader() == null)) continue;
                    n3 = n7;
                    break;
                }
            }
        }
        if (-1 != n3) {
            n2 = new Integer(n3);
        }
        return n3;
    }

    protected static int compareAddress(int n, long l, int n2, long l2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        if (l == l2) {
            return 0;
        }
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return l < l2 ? -1 : 1;
        }
        return l < l2 ? 1 : -1;
    }

    private boolean isMemoryAccessible(int n, long l, int n2) {
        long l2;
        boolean bl = false;
        long l3 = 0L;
        int n3 = CommonAddressSpace.findWhichMemoryRange(n, l, this._translations, this._lastTranslationUsed, true);
        if (n3 == -1) {
            return bl;
        }
        long l4 = this._translations[n3].getVirtualAddress() + this._translations[n3].getSize();
        if (l4 >= (l2 = l + (long)n2)) {
            bl = true;
        } else {
            l3 = l4 - l;
            for (int i = n3 + 1; i < this._translations.length; ++i) {
                long l5 = this._translations[i].getVirtualAddress();
                long l6 = this._translations[i].getSize();
                long l7 = l5 + l6;
                if (l5 == l4) {
                    if ((l3 += l6) >= (long)n2) {
                        bl = true;
                        break;
                    }
                } else {
                    if (l5 >= l4) break;
                    if (l7 < l4) continue;
                    if ((l3 += l7 - l4) >= (long)n2) {
                        bl = true;
                        break;
                    }
                }
                l4 = l7;
            }
        }
        return bl;
    }

    public byte[] getMemoryBytes(long l, int n) {
        return this.getMemoryBytes(this.lastAsid, l, n);
    }

    public byte[] getMemoryBytes(int n, long l, int n2) {
        boolean bl = true;
        this.lastAsid = n;
        byte[] byArray = null;
        if (n2 < 0) {
            return null;
        }
        if (0L != l) {
            if (n2 > 0x100000) {
                bl = this.isMemoryAccessible(0, l, n2);
            }
            if (bl) {
                byArray = new byte[n2];
                try {
                    this.getBytesAt(n, l, byArray);
                }
                catch (MemoryAccessException memoryAccessException) {
                    byArray = null;
                }
            }
        }
        return byArray;
    }

    public long findPattern(byte[] byArray, int n, long l) {
        int n2 = 4096;
        int n3 = 0 == n ? 1 : n;
        if (n2 < n3) {
            n2 = n3;
        } else if (0 != n2 % n3) {
            n2 -= n2 % n3;
        }
        long l2 = -1L;
        Iterator iterator = this.getMemoryRanges();
        while (-1L == l2 && iterator.hasNext()) {
            MemoryRange memoryRange = (MemoryRange)iterator.next();
            if (memoryRange.getAsid() < this.lastAsid) continue;
            if (memoryRange.getAsid() > this.lastAsid) {
                l = 0L;
            }
            l2 = this.findPatternInRange(byArray, n3, l, memoryRange, n2);
        }
        if (l2 == -1L) {
            this.lastAsid = 0;
        }
        return l2;
    }

    private static int match(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        for (int i = n2; i < byArray2.length && n3 < byArray.length; ++i, ++n3) {
            if (byArray2[i] == byArray[n3]) continue;
            return 0;
        }
        return n3;
    }

    private long findPatternInRange(byte[] byArray, int n, long l, MemoryRange memoryRange, int n2) {
        if (memoryRange.getVirtualAddress() >= l || memoryRange.contains(l)) {
            long l2 = l;
            if (l2 < memoryRange.getVirtualAddress()) {
                l2 = memoryRange.getVirtualAddress();
            }
            if (0L != l2 % (long)n) {
                l2 += (long)n - l2 % (long)n;
            }
            long l3 = memoryRange.getVirtualAddress() + memoryRange.getSize();
            int n3 = memoryRange.getAsid();
            int n4 = 0;
            long l4 = -1L;
            while (l2 < l3) {
                long l5;
                long l6 = l3 - l2;
                long l7 = l5 = (long)n2 < l6 ? (long)n2 : l6;
                if (0L != l2) {
                    byte[] byArray2 = this.getMemoryBytes(n3, l2, (int)l5);
                    if (null != byArray2) {
                        if (0 != n4) {
                            n4 = CommonAddressSpace.match(byArray, n4, byArray2, 0);
                        }
                        for (int i = 0; i < byArray2.length && 0 == n4; i += n) {
                            l4 = l2 + (long)i;
                            n4 = CommonAddressSpace.match(byArray, 0, byArray2, i);
                        }
                        if (byArray.length == n4) {
                            return l4;
                        }
                    }
                } else {
                    System.err.println("Looking for address 0");
                }
                l2 += l5;
            }
        }
        return -1L;
    }

    public long getLongAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[8];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return 0xFF00000000000000L & (long)byArray[0] << 56 | 0xFF000000000000L & (long)byArray[1] << 48 | 0xFF0000000000L & (long)byArray[2] << 40 | 0xFF00000000L & (long)byArray[3] << 32 | 0xFF000000L & (long)byArray[4] << 24 | 0xFF0000L & (long)byArray[5] << 16 | 0xFF00L & (long)byArray[6] << 8 | 0xFFL & (long)byArray[7];
    }

    public int getIntAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[4];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
    }

    public short getShortAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[2];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return (short)((0xFF & byArray[0]) << 8 | 0xFF & byArray[1]);
    }

    public byte getByteAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[1];
        this.getBytesAt(n, l, byArray);
        return byArray[0];
    }

    private void _byteSwap(byte[] byArray) {
        if (this._isLittleEndian) {
            int n = byArray.length / 2;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[byArray.length - 1 - i];
                byArray[byArray.length - 1 - i] = byArray[i];
                byArray[i] = by;
            }
        }
    }

    public long getPointerAt(int n, long l) throws MemoryAccessException {
        long l2 = 0L;
        l2 = this.bytesPerPointer(n) == 8 ? this.getLongAt(n, l) : 0xFFFFFFFFL & (long)this.getIntAt(n, l);
        return l2;
    }

    public abstract int getBytesAt(int var1, long var2, byte[] var4) throws MemoryAccessException;

    public int bytesPerPointer(int n) {
        if (!this._is64Bit || this._is64BitAsid == null) {
            return 4;
        }
        for (int i = 0; i < this._is64BitAsid.length; ++i) {
            if (this._is64BitAsid[i] != n) continue;
            return 8;
        }
        return 4;
    }
}

