/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.krb5.internal.crypto.Des3EType;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.n;
import com.ibm.security.krb5.internal.crypto.p;
import com.ibm.security.krb5.internal.crypto.q;
import com.ibm.security.krb5.internal.crypto.r;
import com.ibm.security.krb5.internal.crypto.x;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Arrays;

public class EncryptionKey
implements Cloneable {
    public static EncryptionKey NULL_KEY;
    private int a;
    private byte[] b;
    private Integer c;
    public static final int KEYTYPE_DEFAULT;
    private static String[] z;

    private static int a() {
        int n2 = 16;
        try {
            int[] nArray = Config.getInstance().defaultEtype(z[1]);
            if (nArray != null && nArray.length > 0) {
                if (EncryptedData.isSupportedEncType(nArray[0])) {
                    n2 = nArray[0];
                    if (Krb5Debug.on(9)) {
                        Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
                        krb5Debug.out(9, z[5] + EncryptedData.encTypeToString(n2));
                    }
                } else if (Krb5Debug.on(9)) {
                    Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
                    krb5Debug.out(9, z[3] + nArray[0]);
                }
            }
        }
        catch (Exception exception) {
            n2 = 16;
        }
        return n2;
    }

    public synchronized int getEType() {
        return this.a;
    }

    public final Integer getKeyVersionNumber() {
        return this.c;
    }

    public final byte[] getBytes() {
        byte[] byArray = null;
        if (this.b != null) {
            byArray = new byte[this.b.length];
            System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        }
        return byArray;
    }

    public int getKeyType() {
        return this.a;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.b, this.a, this.c);
    }

    public static EncryptionKey acquireSecretKey(PrincipalName principalName, String string) throws KrbException, IOException {
        KeyTab keyTab;
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[0]);
        }
        if ((keyTab = KeyTab.getInstance(string)) == null) {
            return null;
        }
        return keyTab.readServiceKey(principalName);
    }

    public EncryptionKey(byte[] byArray, int n2, Integer n3) {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[6], new Integer[]{new Integer(n2)});
        }
        this.a = n2;
        this.c = n3;
        if (byArray != null) {
            this.b = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.b, 0, this.b.length);
        }
    }

    public EncryptionKey(int n2, byte[] byArray) {
        this(byArray, n2, null);
    }

    public EncryptionKey(byte[] byArray) {
        this(byArray, KEYTYPE_DEFAULT, null);
    }

    public EncryptionKey(String string) throws KrbCryptoException {
        this.a = KEYTYPE_DEFAULT;
        this.b = this.a(string, this.a);
    }

    public EncryptionKey(String string, String string2) throws KrbCryptoException {
        this.a = KEYTYPE_DEFAULT;
        this.b = this.a(string, string2, this.a);
    }

    public EncryptionKey(String string, String string2, int n2) throws KrbCryptoException {
        this.a = n2;
        this.b = this.a(string, string2, this.a);
    }

    public EncryptionKey(String string, String string2, int n2, byte[] byArray) throws KrbCryptoException {
        this.a = n2;
        this.b = EncryptionKey.a(string, string2, this.a, byArray);
    }

    public EncryptionKey(String string, int n2, Integer n3) throws KrbCryptoException {
        this.b = this.a(string, n2);
        this.a = n2;
        this.c = n3;
    }

    public EncryptionKey(String string, int n2, String string2, Integer n3) throws KrbCryptoException {
        this.b = this.a(string, string2, n2);
        this.a = n2;
        this.c = n3;
    }

    public EncryptionKey(EncryptionKey encryptionKey) throws KrbCryptoException {
        this.b = (byte[])encryptionKey.b.clone();
        this.a = encryptionKey.a;
    }

    public EncryptionKey(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.b = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    static int a(byte[] byArray) {
        int n2 = 4;
        int n3 = 0;
        while (--n2 >= 0) {
            n3 <<= 8;
            n3 |= byArray[n2] & 0xFF;
        }
        return n3;
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.a);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public synchronized void destroy() {
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                this.b[i2] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptionKey(derValue2);
    }

    public void writeKey(b b2) throws IOException {
        b2.b(this.a);
        b2.b(this.a);
        b2.a(this.b.length);
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            b2.c(this.b[i2]);
        }
    }

    private byte[] a(String string, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[6], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (n2 == 16) {
                return Des3EType.stringToKey(string);
            }
            return n.c(string);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return x.b(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return q.b(string);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return r.b(string);
        }
        return new byte[0];
    }

    private byte[] a(String string, String string2, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[6], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (string2 == null) {
                I18NException.throwIllegalArgumentException(z[7]);
            }
            if (n2 == 16) {
                return Des3EType.stringToKey(string, string2);
            }
            return n.c(string + string2);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return x.b(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return q.a(string, string2);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return r.a(string, string2);
        }
        return new byte[0];
    }

    private static byte[] a(String string, String string2, int n2, byte[] byArray) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[6], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (string2 == null) {
                I18NException.throwIllegalArgumentException(z[7]);
            }
            if (n2 == 16) {
                Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
                krb5Debug.out(9, z[8] + string + z[10] + string2);
                return Des3EType.stringToKey(string, string2);
            }
            Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
            krb5Debug.out(9, z[9] + string + z[10] + string2);
            return n.c(string + string2);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return x.b(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            int n3 = 4096;
            if (byArray != null) {
                n3 = EncryptionKey.a(byArray);
            }
            return q.a(string, string2, n3);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            int n4 = 4096;
            if (byArray != null) {
                n4 = EncryptionKey.a(byArray);
            }
            return r.a(string, string2, n4);
        }
        return new byte[0];
    }

    public static EncryptionKey[] acquireSecretKeys(String string, String string2, boolean bl, int n2, byte[] byArray) throws KrbException {
        int[] nArray = p.a(z[1]);
        if (nArray == null) {
            nArray = p.d();
        }
        if (bl && n2 != 0 && p.b(n2)) {
            nArray = new int[]{n2};
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!p.b(nArray[i2])) continue;
            encryptionKeyArray[i2] = new EncryptionKey(EncryptionKey.a(string, string2, nArray[i2], byArray), nArray[i2], null);
        }
        return encryptionKeyArray;
    }

    public static EncryptionKey findKey(int n2, EncryptionKey[] encryptionKeyArray) throws KrbException {
        int n3;
        int n4;
        for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
            n3 = encryptionKeyArray[n4].getEType();
            if (!p.b(n3) || n2 != n3) continue;
            return encryptionKeyArray[n4];
        }
        if (n2 == 1 || n2 == 3) {
            for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
                n3 = encryptionKeyArray[n4].getEType();
                if (n3 != 1 && n3 != 3) continue;
                return new EncryptionKey(n2, encryptionKeyArray[n4].getBytes());
            }
        }
        return null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + Arrays.hashCode(this.b);
        n2 = 37 * n2 + this.c;
        return 37 * n2 + this.a;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey encryptionKey = (EncryptionKey)object;
        return this.a == encryptionKey.getKeyType() && Arrays.equals(this.b, encryptionKey.getBytes());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block120: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block119: {
                char[] cArray3;
                Object var0;
                block118: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block117: {
                        char[] cArray5;
                        block116: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block115: {
                                char[] cArray7;
                                block114: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block113: {
                                        char[] cArray9;
                                        block112: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block111: {
                                                char[] cArray11;
                                                block110: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block109: {
                                                        char[] cArray13;
                                                        block108: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block107: {
                                                                char[] cArray15;
                                                                block106: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block105: {
                                                                        char[] cArray17;
                                                                        block104: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block103: {
                                                                                char[] cArray19;
                                                                                block102: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block101: {
                                                                                        char[] cArray21;
                                                                                        block100: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block99: {
                                                                                                stringArray = new String[11];
                                                                                                var0 = null;
                                                                                                char[] cArray23 = "2 ,>T\u0019,".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n25 = cArray23.length;
                                                                                                cArray22 = cArray23;
                                                                                                n24 = n25;
                                                                                                if (n25 <= 1) break block99;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block100;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray24 = cArray22;
                                                                                                char[] cArray25 = cArray22;
                                                                                                int n26 = n4;
                                                                                                while (true) {
                                                                                                    int n27;
                                                                                                    char c2 = cArray24[n26];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n27 = 124;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n27 = 85;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n27 = 64;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n27 = 82;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n27 = 31;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray24[n26] = (char)(c2 ^ n27);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray25;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray25 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n26 = n24;
                                                                                                    cArray24 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[0] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray26 = "\u00180&3j\u0010!\u001f&t\b\n%<|\b,07l".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n28 = cArray26.length;
                                                                                        cArray20 = cArray26;
                                                                                        n22 = n28;
                                                                                        if (n28 <= 1) break block101;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block102;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray27 = cArray20;
                                                                                        char[] cArray28 = cArray20;
                                                                                        int n29 = n4;
                                                                                        while (true) {
                                                                                            int n30;
                                                                                            char c3 = cArray27[n29];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n30 = 124;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n30 = 85;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n30 = 64;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n30 = 82;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n30 = 31;
                                                                                                }
                                                                                            }
                                                                                            cArray27[n29] = (char)(c3 ^ n30);
                                                                                            ++n4;
                                                                                            cArray20 = cArray28;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray28 = cArray20;
                                                                                            n21 = n22;
                                                                                            n29 = n22;
                                                                                            cArray27 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[1] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray29 = "Fu".toCharArray();
                                                                                n4 = 0;
                                                                                int n31 = cArray29.length;
                                                                                cArray18 = cArray29;
                                                                                n20 = n31;
                                                                                if (n31 <= 1) break block103;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block104;
                                                                            }
                                                                            do {
                                                                                char[] cArray30 = cArray18;
                                                                                char[] cArray31 = cArray18;
                                                                                int n32 = n4;
                                                                                while (true) {
                                                                                    int n33;
                                                                                    char c4 = cArray30[n32];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n33 = 124;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n33 = 85;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n33 = 64;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n33 = 82;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n33 = 31;
                                                                                        }
                                                                                    }
                                                                                    cArray30[n32] = (char)(c4 ^ n33);
                                                                                    ++n4;
                                                                                    cArray18 = cArray31;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray31 = cArray18;
                                                                                    n19 = n20;
                                                                                    n32 = n20;
                                                                                    cArray30 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[2] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray32 = "Bk~rZ\u001262+o\b</<T\u0019,lrH=\u0007\u000e\u001bQ;umrj\u0012&5\"o\u0013'47{\\0.1?\b,07?\u0015;`1p\u00123)5%\\".toCharArray();
                                                                        n4 = 0;
                                                                        int n34 = cArray32.length;
                                                                        cArray16 = cArray32;
                                                                        n18 = n34;
                                                                        if (n34 <= 1) break block105;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block106;
                                                                    }
                                                                    do {
                                                                        char[] cArray33 = cArray16;
                                                                        char[] cArray34 = cArray16;
                                                                        int n35 = n4;
                                                                        while (true) {
                                                                            int n36;
                                                                            char c5 = cArray33[n35];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n36 = 124;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n36 = 85;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n36 = 64;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n36 = 82;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n36 = 31;
                                                                                }
                                                                            }
                                                                            cArray33[n35] = (char)(c5 ^ n36);
                                                                            ++n4;
                                                                            cArray16 = cArray34;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray34 = cArray16;
                                                                            n17 = n18;
                                                                            n35 = n18;
                                                                            cArray33 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[3] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray35 = "9;# f\f!)=q709h".toCharArray();
                                                                n4 = 0;
                                                                int n37 = cArray35.length;
                                                                cArray14 = cArray35;
                                                                n16 = n37;
                                                                if (n37 <= 1) break block107;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block108;
                                                            }
                                                            do {
                                                                char[] cArray36 = cArray14;
                                                                char[] cArray37 = cArray14;
                                                                int n38 = n4;
                                                                while (true) {
                                                                    int n39;
                                                                    char c6 = cArray36[n38];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n39 = 124;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n39 = 85;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n39 = 64;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n39 = 82;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n39 = 31;
                                                                        }
                                                                    }
                                                                    cArray36[n38] = (char)(c6 ^ n39);
                                                                    ++n4;
                                                                    cArray14 = cArray37;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray37 = cArray14;
                                                                    n15 = n16;
                                                                    n38 = n16;
                                                                    cArray36 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[4] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray38 = "Bk~rZ\u001262+o\b</<T\u0019,zr|\u0013;&;x\\1%4~\t94rt\u0019,`&f\f0`;l\\".toCharArray();
                                                        n4 = 0;
                                                        int n40 = cArray38.length;
                                                        cArray12 = cArray38;
                                                        n14 = n40;
                                                        if (n40 <= 1) break block109;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block110;
                                                    }
                                                    do {
                                                        char[] cArray39 = cArray12;
                                                        char[] cArray40 = cArray12;
                                                        int n41 = n4;
                                                        while (true) {
                                                            int n42;
                                                            char c7 = cArray39[n41];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n42 = 124;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n42 = 85;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n42 = 64;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n42 = 82;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n42 = 31;
                                                                }
                                                            }
                                                            cArray39[n41] = (char)(c7 ^ n42);
                                                            ++n4;
                                                            cArray12 = cArray40;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray40 = cArray12;
                                                            n13 = n14;
                                                            n41 = n14;
                                                            cArray39 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[5] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray41 = ">4$\u0019z\u0005\u00019\"z".toCharArray();
                                                n4 = 0;
                                                int n43 = cArray41.length;
                                                cArray10 = cArray41;
                                                n12 = n43;
                                                if (n43 <= 1) break block111;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block112;
                                            }
                                            do {
                                                char[] cArray42 = cArray10;
                                                char[] cArray43 = cArray10;
                                                int n44 = n4;
                                                while (true) {
                                                    int n45;
                                                    char c8 = cArray42[n44];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n45 = 124;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n45 = 85;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n45 = 64;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n45 = 82;
                                                            break;
                                                        }
                                                        default: {
                                                            n45 = 31;
                                                        }
                                                    }
                                                    cArray42[n44] = (char)(c8 ^ n45);
                                                    ++n4;
                                                    cArray10 = cArray43;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray43 = cArray10;
                                                    n11 = n12;
                                                    n44 = n12;
                                                    cArray42 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[6] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray44 = "2 ,>L\u001d94".toCharArray();
                                        n4 = 0;
                                        int n46 = cArray44.length;
                                        cArray8 = cArray44;
                                        n10 = n46;
                                        if (n46 <= 1) break block113;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block114;
                                    }
                                    do {
                                        char[] cArray45 = cArray8;
                                        char[] cArray46 = cArray8;
                                        int n47 = n4;
                                        while (true) {
                                            int n48;
                                            char c9 = cArray45[n47];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n48 = 124;
                                                    break;
                                                }
                                                case 1: {
                                                    n48 = 85;
                                                    break;
                                                }
                                                case 2: {
                                                    n48 = 64;
                                                    break;
                                                }
                                                case 3: {
                                                    n48 = 82;
                                                    break;
                                                }
                                                default: {
                                                    n48 = 31;
                                                }
                                            }
                                            cArray45[n47] = (char)(c9 ^ n48);
                                            ++n4;
                                            cArray8 = cArray46;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray46 = cArray8;
                                            n9 = n10;
                                            n47 = n10;
                                            cArray45 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[7] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray47 = "\\\u0001(;l\\<3r[\u0019&srt\u0019,lro\u001d&3%p\u000e1}".toCharArray();
                                n4 = 0;
                                int n49 = cArray47.length;
                                cArray6 = cArray47;
                                n8 = n49;
                                if (n49 <= 1) break block115;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block116;
                            }
                            do {
                                char[] cArray48 = cArray6;
                                char[] cArray49 = cArray6;
                                int n50 = n4;
                                while (true) {
                                    int n51;
                                    char c10 = cArray48[n50];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n51 = 124;
                                            break;
                                        }
                                        case 1: {
                                            n51 = 85;
                                            break;
                                        }
                                        case 2: {
                                            n51 = 64;
                                            break;
                                        }
                                        case 3: {
                                            n51 = 82;
                                            break;
                                        }
                                        default: {
                                            n51 = 31;
                                        }
                                    }
                                    cArray48[n50] = (char)(c10 ^ n51);
                                    ++n4;
                                    cArray6 = cArray49;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray49 = cArray6;
                                    n7 = n8;
                                    n50 = n8;
                                    cArray48 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[8] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray50 = "\\\u0001(;l\\<3r[\u0019&`9z\u0005y`\"~\u000f&7=m\u0018h".toCharArray();
                        n4 = 0;
                        int n52 = cArray50.length;
                        cArray4 = cArray50;
                        n6 = n52;
                        if (n52 <= 1) break block117;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block118;
                    }
                    do {
                        char[] cArray51 = cArray4;
                        char[] cArray52 = cArray4;
                        int n53 = n4;
                        while (true) {
                            int n54;
                            char c11 = cArray51[n53];
                            switch (n4 % 5) {
                                case 0: {
                                    n54 = 124;
                                    break;
                                }
                                case 1: {
                                    n54 = 85;
                                    break;
                                }
                                case 2: {
                                    n54 = 64;
                                    break;
                                }
                                case 3: {
                                    n54 = 82;
                                    break;
                                }
                                default: {
                                    n54 = 31;
                                }
                            }
                            cArray51[n53] = (char)(c11 ^ n54);
                            ++n4;
                            cArray4 = cArray52;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray52 = cArray4;
                            n5 = n6;
                            n53 = n6;
                            cArray51 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[9] = new String(cArray3).intern();
                var0 = null;
                char[] cArray53 = "\\u33s\bh".toCharArray();
                n4 = 0;
                int n55 = cArray53.length;
                cArray2 = cArray53;
                n3 = n55;
                if (n55 <= 1) break block119;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block120;
            }
            do {
                char[] cArray54 = cArray2;
                char[] cArray55 = cArray2;
                int n56 = n4;
                while (true) {
                    int n57;
                    char c12 = cArray54[n56];
                    switch (n4 % 5) {
                        case 0: {
                            n57 = 124;
                            break;
                        }
                        case 1: {
                            n57 = 85;
                            break;
                        }
                        case 2: {
                            n57 = 64;
                            break;
                        }
                        case 3: {
                            n57 = 82;
                            break;
                        }
                        default: {
                            n57 = 31;
                        }
                    }
                    cArray54[n56] = (char)(c12 ^ n57);
                    ++n4;
                    cArray2 = cArray55;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray55 = cArray2;
                    n2 = n3;
                    n56 = n3;
                    cArray54 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[10] = new String(cArray).intern();
        z = stringArray;
        NULL_KEY = new EncryptionKey(new byte[0], 0, new Integer(0));
        KEYTYPE_DEFAULT = EncryptionKey.a();
    }
}

