/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineDumpOptionChecker {
    private final Logger logger;
    private final Collection<String> commandLineOptions;
    private Set<String> problematicOptions;
    private Set<String> dumpTypesDisabledOptions;
    private Set<String> reducedSignalOptions;
    private boolean noCoreMmapIsPresent = false;
    private static final String[] OPTIONS_WHICH_STOP_DUMPS = new String[]{"-Xdump:none"};
    private static final String[] OPTIONS_WHICH_REDUCE_SIGNALS = new String[]{"-Xrs", "-Xnosigcatch", "-Xnosigchain"};

    public CommandLineDumpOptionChecker(Logger logger, Collection<String> commands) throws IllegalArgumentException {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        if (commands == null) {
            throw new IllegalArgumentException("commands is null");
        }
        this.logger = logger;
        this.commandLineOptions = commands;
    }

    public Level getReportPriority() {
        Level level = null;
        this.populateProblematicOptions();
        if (this.problematicOptions != null && this.problematicOptions.size() > 0) {
            level = Level.WARNING;
        } else if (this.reducedSignalOptions != null && this.reducedSignalOptions.size() > 0) {
            level = Level.WARNING;
        } else if (this.dumpTypesDisabledOptions != null && this.dumpTypesDisabledOptions.size() > 0) {
            level = Level.WARNING;
        } else if (this.noCoreMmapIsPresent) {
            level = Level.WARNING;
        }
        return level;
    }

    private void populateProblematicOptions() {
        StringBuffer optionsSB = new StringBuffer();
        for (String option : this.commandLineOptions) {
            optionsSB.append(option + " ");
        }
        this.logger.fine("checking command line options: " + optionsSB.toString());
        for (String option : OPTIONS_WHICH_STOP_DUMPS) {
            if (!this.commandLineOptions.contains(option)) continue;
            if (this.problematicOptions == null) {
                this.problematicOptions = new HashSet<String>();
            }
            this.problematicOptions.add(option);
        }
        for (String option : OPTIONS_WHICH_REDUCE_SIGNALS) {
            if (!this.commandLineOptions.contains(option)) continue;
            if (this.reducedSignalOptions == null) {
                this.reducedSignalOptions = new HashSet<String>();
            }
            this.reducedSignalOptions.add(option);
        }
        for (String option : this.commandLineOptions) {
            if (option.startsWith("-Xdump")) {
                if (option.contains("none") && !option.contains("-Xdump:none")) {
                    this.initialiseDisabledDumpTypeOptions();
                    this.dumpTypesDisabledOptions.add(option);
                }
                if (!option.contains("CEEDUMP") || option.contains("IEATDUMP")) continue;
                this.initialiseDisabledDumpTypeOptions();
                this.dumpTypesDisabledOptions.add(option);
                continue;
            }
            if (!"-Xdisablejavadump".equals(option)) continue;
            this.initialiseDisabledDumpTypeOptions();
            this.dumpTypesDisabledOptions.add(option);
        }
        for (String option : this.commandLineOptions) {
            if (!option.startsWith("-Xshareclasses") || !option.contains("noCoreMmap")) continue;
            this.noCoreMmapIsPresent = true;
        }
    }

    private void initialiseDisabledDumpTypeOptions() {
        if (this.dumpTypesDisabledOptions == null) {
            this.dumpTypesDisabledOptions = new HashSet<String>();
        }
    }

    public String getReport() {
        String osName;
        String template;
        this.populateProblematicOptions();
        StringBuffer report = new StringBuffer();
        if (this.problematicOptions != null) {
            String template2;
            if (this.problematicOptions.size() == 1) {
                template2 = Messages.getString("CommandLineDumpOptionChecker.one.bad.option");
                report.append(MessageFormat.format(template2, this.problematicOptions.toArray()));
            } else if (this.problematicOptions.size() == 2) {
                template2 = Messages.getString("CommandLineDumpOptionChecker.two.bad.options");
                report.append(MessageFormat.format(template2, this.problematicOptions.toArray()));
            } else if (this.problematicOptions.size() == 3) {
                template2 = Messages.getString("CommandLineDumpOptionChecker.three.bad.options");
                report.append(MessageFormat.format(template2, this.problematicOptions.toArray()));
            } else {
                StringBuffer options = new StringBuffer();
                Iterator<String> it = this.problematicOptions.iterator();
                while (it.hasNext()) {
                    options.append(options);
                    if (!it.hasNext()) continue;
                    options.append(Messages.getString("CommandLineDumpOptionChecker.comma"));
                }
                template = Messages.getString("CommandLineDumpOptionChecker.many.bad.options");
                report.append(MessageFormat.format(template, options));
            }
        }
        if (this.reducedSignalOptions != null) {
            for (String option : this.reducedSignalOptions) {
                template = Messages.getString("CommandLineDumpOptionChecker.dump.signals");
                report.append(MessageFormat.format(template, option));
            }
        }
        if (this.dumpTypesDisabledOptions != null) {
            for (String option : this.dumpTypesDisabledOptions) {
                template = Messages.getString("CommandLineDumpOptionChecker.dump.types.turned.off");
                report.append(MessageFormat.format(template, option));
            }
        }
        if (this.noCoreMmapIsPresent && (osName = System.getProperty("os.name")).contains("AIX")) {
            report.append(Messages.getString("CommandLineDumpOptionChecker.noCoreMmap.warning"));
        }
        if (report.length() == 0) {
            report.append(Messages.getString("CommandLineDumpOptionChecker.all.fine"));
        }
        return report.toString();
    }
}

