/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int FOCUS_FORCED = 8;
    static final int BACKGROUND = 16;
    static final int FOREGROUND = 32;
    static final int PARENT_BACKGROUND = 64;
    static final int THEME_BACKGROUND = 128;
    static final int LAYOUT_NEEDED = 256;
    static final int LAYOUT_CHANGED = 512;
    static final int LAYOUT_CHILD = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int FOREIGN_HANDLE = 8192;
    static final int DRAG_DETECT = 16384;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_PRESS = 1;
    static final int BUTTON_RELEASE = 2;
    static final int EXPOSURE = 3;
    static final int ENTER_WINDOW = 4;
    static final int FOCUS_CHANGE = 5;
    static final int KEY_PRESS = 6;
    static final int KEY_RELEASE = 7;
    static final int LEAVE_WINDOW = 8;
    static final int ACTIVATE_CALLBACK = 9;
    static final int ARM_CALLBACK = 10;
    static final int BROWSE_SELECTION_CALLBACK = 11;
    static final int CASCADING_CALLBACK = 12;
    static final int DECREMENT_CALLBACK = 13;
    static final int DEFAULT_ACTION_CALLBACK = 14;
    static final int DRAG_CALLBACK = 15;
    static final int EXTENDED_SELECTION_CALLBACK = 16;
    static final int HELP_CALLBACK = 17;
    static final int INCREMENT_CALLBACK = 18;
    static final int MODIFY_VERIFY_CALLBACK = 19;
    static final int PAGE_DECREMENT_CALLBACK = 20;
    static final int PAGE_INCREMENT_CALLBACK = 21;
    static final int TO_BOTTOM_CALLBACK = 22;
    static final int TO_TOP_CALLBACK = 23;
    static final int VALUE_CHANGED_CALLBACK = 24;
    static final int NON_MASKABLE = 25;
    static final int POINTER_MOTION = 26;
    static final int STRUCTURE_NOTIFY = 27;
    static final int MAP_CALLBACK = 28;
    static final int UNMAP_CALLBACK = 29;
    static final int DELETE_WINDOW = 30;
    static final int EXPOSURE_CALLBACK = 31;
    static final int MULTIPLE_SELECTION_CALLBACK = 32;
    static final int PROPERTY_CHANGE = 33;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.hookEvents();
        this.register();
        this.manageChildren();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0) {
            OS.XtDestroyWidget(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void enableHandle(boolean enabled, int widgetHandle) {
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(widgetHandle, argList, argList.length / 2);
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    static char fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        char mnemonic = '\u0000';
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == '\u0000') {
                mnemonic = buffer[i];
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    int focusProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    String getCodePage() {
        return null;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void manageChildren() {
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void propagateHandle(boolean enabled, int widgetHandle, int cursor) {
        int xDisplay = OS.XtDisplay(widgetHandle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(widgetHandle);
        if (xWindow == 0) {
            return;
        }
        int event_mask = OS.XtBuildEventMask(widgetHandle);
        int do_not_propagate_mask = 79;
        if (!enabled) {
            event_mask &= ~(do_not_propagate_mask | 0x10 | 0x20);
            do_not_propagate_mask = 0;
        }
        int mask = 22528;
        XSetWindowAttributes attributes = new XSetWindowAttributes();
        attributes.event_mask = event_mask;
        attributes.do_not_propagate_mask = do_not_propagate_mask;
        attributes.cursor = cursor;
        OS.XChangeWindowAttributes(xDisplay, xWindow, mask, attributes);
    }

    void redrawHandle(int x, int y, int width, int height, boolean redrawAll, int widgetHandle) {
        int display = OS.XtDisplay(widgetHandle);
        if (display == 0) {
            return;
        }
        int window = OS.XtWindow(widgetHandle);
        if (window == 0) {
            return;
        }
        if (redrawAll) {
            OS.XClearArea(display, window, 0, 0, 0, 0, true);
        } else if (width > 0 && height > 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            int[] argList = nArray;
            OS.XtGetValues(widgetHandle, argList, argList.length / 2);
            if (x < argList[1] && y < argList[3] && x + width > 0 && y + height > 0) {
                OS.XClearArea(display, window, x, y, width, height, true);
            }
        }
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        this.display.addWidget(this.handle, this);
    }

    void release(boolean destroy) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    boolean setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, XKeyEvent xEvent) {
        char[] result;
        if (xEvent.keycode == 0) {
            return false;
        }
        byte[] buffer = new byte[5];
        int[] keysym = new int[1];
        OS.XLookupString(xEvent, buffer, buffer.length, keysym, null);
        boolean isNull = this.display.fixKey(keysym, buffer, xEvent.state);
        if (keysym[0] != 0) {
            event.keyCode = Display.translateKey(keysym[0]);
        }
        if (event.keyCode == 0) {
            char[] result2;
            byte[] buffer1 = new byte[5];
            int[] keysym1 = new int[1];
            int oldState = xEvent.state;
            xEvent.state = 0;
            OS.XLookupString(xEvent, buffer1, buffer1.length, keysym1, null);
            xEvent.state = oldState;
            if (buffer1[0] != 0 && (result2 = Converter.mbcsToWcs(null, buffer1)).length != 0) {
                event.keyCode = result2[0];
            }
        }
        if (buffer[0] != 0 && (result = Converter.mbcsToWcs(null, buffer)).length != 0) {
            event.character = result[0];
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(event, xEvent.state);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendIMKeyEvent(int type, XKeyEvent xEvent) {
        return this.sendIMKeyEvent(type, xEvent, 0);
    }

    boolean sendIMKeyEvent(int type, XKeyEvent xEvent, int textHandle) {
        byte[] testBuffer;
        int testLength;
        byte[] buffer = new byte[512];
        int[] status = new int[1];
        int[] unused = new int[1];
        int focusHandle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        int length = OS.XmImMbLookupString(focusHandle, xEvent, buffer, buffer.length, unused, status);
        if (status[0] == -1) {
            buffer = new byte[length];
            length = OS.XmImMbLookupString(focusHandle, xEvent, buffer, length, unused, status);
        }
        if (length == 0) {
            return true;
        }
        char[] chars = Converter.mbcsToWcs(null, buffer);
        int index = 0;
        int count = 0;
        while (index < chars.length) {
            if (chars[index] == '\u0000') {
                chars[count] = '\u0000';
                break;
            }
            Event event = new Event();
            event.time = xEvent.time;
            event.character = chars[index];
            this.setInputState(event, xEvent.state);
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
            if (event.doit) {
                chars[count++] = chars[index];
            }
            ++index;
        }
        if (count == 0) {
            return false;
        }
        if (textHandle != 0 && ((testLength = OS.XmImMbLookupString(textHandle, xEvent, testBuffer = new byte[5], testBuffer.length, unused, unused)) == 0 || index != count)) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.XmTextGetSelectionPosition(textHandle, start, end);
            if (start[0] == end[0]) {
                start[0] = end[0] = OS.XmTextGetInsertionPosition(textHandle);
            }
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            if (index != count) {
                buffer = Converter.wcsToMbcs(this.getCodePage(), chars, true);
            }
            OS.XmTextReplace(textHandle, start[0], end[0], buffer);
            int position = start[0] + count;
            OS.XmTextSetInsertionPosition(textHandle, position);
            this.display.setWarnings(warnings);
            return false;
        }
        return true;
    }

    boolean sendKeyEvent(int type, XKeyEvent xEvent) {
        Event event = new Event();
        event.time = xEvent.time;
        if (!this.setKeyState(event, xEvent)) {
            return true;
        }
        Widget control = this;
        if ((this.state & 2) != 0 && (this.style & 0x80000) != 0) {
            control = this.display.getFocusControl();
        }
        if (control != null) {
            control.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        }
        return event.doit;
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(char key, int keysym, XKeyEvent xEvent, boolean doit) {
        return false;
    }

    boolean translateMnemonic(char key, int keysym, XKeyEvent xEvent) {
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        return false;
    }

    boolean XmProcessTraversal(int widget, int direction) {
        Display display = this.display;
        boolean oldFocusOut = display.postFocusOut;
        display.postFocusOut = true;
        boolean result = OS.XmProcessTraversal(widget, direction);
        display.postFocusOut = oldFocusOut;
        if (!display.postFocusOut) {
            display.focusEvent = 16;
            display.runFocusOutEvents();
            display.focusEvent = 0;
        }
        return result;
    }

    int hoverProc(int widget) {
        return 0;
    }

    int timerProc(int id) {
        return 0;
    }

    int windowProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        switch (client_data) {
            case 1: {
                return this.XButtonPress(w, client_data, call_data, continue_to_dispatch);
            }
            case 2: {
                return this.XButtonRelease(w, client_data, call_data, continue_to_dispatch);
            }
            case 4: {
                return this.XEnterWindow(w, client_data, call_data, continue_to_dispatch);
            }
            case 3: {
                return this.XExposure(w, client_data, call_data, continue_to_dispatch);
            }
            case 5: {
                return this.XFocusChange(w, client_data, call_data, continue_to_dispatch);
            }
            case 6: {
                return this.XKeyPress(w, client_data, call_data, continue_to_dispatch);
            }
            case 7: {
                return this.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
            }
            case 8: {
                return this.XLeaveWindow(w, client_data, call_data, continue_to_dispatch);
            }
            case 33: {
                return this.XPropertyChange(w, client_data, call_data, continue_to_dispatch);
            }
            case 9: {
                return this.XmNactivateCallback(w, client_data, call_data);
            }
            case 10: {
                return this.XmNarmCallback(w, client_data, call_data);
            }
            case 11: {
                return this.XmNbrowseSelectionCallback(w, client_data, call_data);
            }
            case 12: {
                return this.XmNcascadingCallback(w, client_data, call_data);
            }
            case 13: {
                return this.XmNdecrementCallback(w, client_data, call_data);
            }
            case 14: {
                return this.XmNdefaultActionCallback(w, client_data, call_data);
            }
            case 15: {
                return this.XmNdragCallback(w, client_data, call_data);
            }
            case 16: {
                return this.XmNextendedSelectionCallback(w, client_data, call_data);
            }
            case 17: {
                return this.XmNhelpCallback(w, client_data, call_data);
            }
            case 18: {
                return this.XmNincrementCallback(w, client_data, call_data);
            }
            case 19: {
                return this.XmNmodifyVerifyCallback(w, client_data, call_data);
            }
            case 32: {
                return this.XmNmultipleSelectionCallback(w, client_data, call_data);
            }
            case 20: {
                return this.XmNpageDecrementCallback(w, client_data, call_data);
            }
            case 21: {
                return this.XmNpageIncrementCallback(w, client_data, call_data);
            }
            case 22: {
                return this.XmNtoBottomCallback(w, client_data, call_data);
            }
            case 23: {
                return this.XmNtoTopCallback(w, client_data, call_data);
            }
            case 24: {
                return this.XmNvalueChangedCallback(w, client_data, call_data);
            }
            case 25: {
                return this.XNonMaskable(w, client_data, call_data, continue_to_dispatch);
            }
            case 26: {
                return this.XPointerMotion(w, client_data, call_data, continue_to_dispatch);
            }
            case 27: {
                return this.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
            }
            case 28: {
                return this.XmNmapCallback(w, client_data, call_data);
            }
            case 29: {
                return this.XmNunmapCallback(w, client_data, call_data);
            }
            case 30: {
                return this.WM_DELETE_WINDOW(w, client_data, call_data);
            }
            case 31: {
                return this.XmNexposureCallback(w, client_data, call_data);
            }
        }
        return 0;
    }

    int WM_DELETE_WINDOW(int w, int client_data, int call_data) {
        return 0;
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XEnterWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        boolean doit = true;
        doit = xEvent.keycode != 0 ? this.sendKeyEvent(1, xEvent) : this.sendIMKeyEvent(1, xEvent);
        if (!doit) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        if (!this.sendKeyEvent(2, xEvent)) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XLeaveWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XPropertyChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNarmCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNbrowseSelectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNcascadingCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdecrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdefaultActionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdragCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNexposureCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNextendedSelectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNincrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNmapCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNmodifyVerifyCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNmultipleSelectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNpageDecrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNpageIncrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNtoBottomCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNtoTopCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNunmapCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XNonMaskable(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }
}

