/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items = new TabItem[0];
    int selectedIndex = -1;
    int xClient;
    int yClient;
    int imageHeight = -1;
    int topTabIndex = 0;
    boolean scrollButtonDown = false;
    boolean inDispose = false;
    String toolTipText;
    static final int SCROLL_BUTTON_SIZE = 20;
    static final int CLIENT_MARGIN_WIDTH = 2;
    static final int SELECTED_TAB_TOP_EXPANSION = 2;
    static final int SELECTED_TAB_HORIZONTAL_EXPANSION = 2;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TabFolder.this.handleEvents(event);
            }
        };
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(32, listener);
        this.addListener(9, listener);
        this.addListener(31, listener);
        this.addListener(1, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (this.items.length > 0) {
            TabItem lastItem = this.items[this.items.length - 1];
            int border = this.getBorderWidth();
            int width = lastItem.x + lastItem.width + border * 2 + 4 + 4;
            size.x = Math.max(width, size.x);
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int trimX = x - border - 2 - 2;
        int trimY = y - border - 2 - 2;
        int tabHeight = 0;
        if (this.items.length > 0) {
            TabItem item = this.items[0];
            tabHeight = item.y + item.height;
        }
        int trimWidth = width + border * 2 + 4 + 4;
        int trimHeight = height + tabHeight + border * 2 + 4 + 4;
        return new Rectangle(trimX, trimY - tabHeight, trimWidth, trimHeight);
    }

    void createChild(TabItem item, int index) {
        boolean isTabScrolling = this.isTabScrolling();
        if (index < 0 || index > this.getItemCount()) {
            this.error(6);
        }
        item.parent = this;
        TabItem[] newItems = new TabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        this.layoutItems();
        this.redrawTabs();
        if (this.isTabScrolling() != isTabScrolling && !isTabScrolling) {
            this.redrawScrollButtons();
        }
        if (this.getItemCount() == 1) {
            this.setSelection(0, true);
        }
    }

    void destroyChild(TabItem item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new TabItem[0];
            this.selectedIndex = -1;
            this.topTabIndex = 0;
            if (!this.inDispose) {
                Control control = item.control;
                if (control != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
                this.redraw();
            }
        } else {
            TabItem[] newItems = new TabItem[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            this.items = newItems;
            if (this.selectedIndex == index) {
                if (!this.inDispose) {
                    Control control = item.control;
                    if (control != null && !control.isDisposed()) {
                        control.setVisible(false);
                    }
                    this.selectedIndex = -1;
                    this.setSelection(Math.max(0, index - 1), true);
                }
            } else if (this.selectedIndex > index) {
                --this.selectedIndex;
            }
            if (this.topTabIndex == this.items.length) {
                --this.topTabIndex;
            }
        }
        if (this.topTabIndex > 0 && !this.isTabScrolling()) {
            this.topTabIndex = 0;
        }
        if (!this.inDispose) {
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void doDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        while (this.items.length > 0) {
            if (this.items[this.items.length - 1] == null) continue;
            this.items[this.items.length - 1].dispose();
        }
    }

    void drawArrow(GC gc, int xPos, int yPos, int size, boolean left) {
        int arrowWidth = size / 4;
        int[] arrow = new int[6];
        if (!left) {
            arrowWidth *= -1;
        }
        arrow[0] = xPos + (size + arrowWidth) / 2;
        arrow[1] = yPos + size / 4;
        arrow[2] = arrow[0];
        arrow[3] = arrow[1] + size / 2;
        arrow[4] = arrow[0] - arrowWidth;
        arrow[5] = yPos + size / 2;
        gc.setBackground(this.getForeground());
        gc.fillPolygon(arrow);
        gc.setBackground(this.getBackground());
    }

    void drawBorder(Event event) {
        GC gc = event.gc;
        Rectangle clientArea = this.getClientArea();
        int wClient = clientArea.width;
        int hClient = clientArea.height;
        Color HighlightShadow = this.display.getSystemColor(20);
        Color LightShadow = this.display.getSystemColor(19);
        gc.setForeground(HighlightShadow);
        int x = this.xClient - 2;
        int y = this.yClient - 2;
        gc.drawLine(x, this.yClient + hClient + 2, x, y + 1);
        gc.setForeground(LightShadow);
        gc.drawLine(x + 1, this.yClient + hClient + 2, x + 1, y + 1);
        gc.setForeground(HighlightShadow);
        if (this.selectedIndex == -1) {
            gc.setForeground(LightShadow);
            gc.drawLine(x + 1, y + 1, this.xClient + wClient + 2, y + 1);
        } else {
            TabItem item = this.items[this.selectedIndex];
            gc.setForeground(LightShadow);
            if (this.selectedIndex > 0) {
                gc.drawLine(x + 1, y + 1, item.x - 1 + 2, y + 1);
            }
            gc.drawLine(item.x + item.width, y + 1, this.xClient + wClient + 2, y + 1);
        }
        gc.setForeground(this.display.getSystemColor(21));
        x = this.xClient - 2;
        y = this.yClient + hClient + 2;
        int x1 = this.xClient + wClient + 2;
        gc.drawLine(x, y, x1, y);
        int y1 = this.yClient - 2 + 1;
        gc.drawLine(x1, y, x1, y1);
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(++x, --y, --x1, y);
        gc.drawLine(x1, y - 1, x1, ++y1);
        gc.setForeground(this.getForeground());
    }

    void drawPlainButton(GC gc, int xPos, int yPos, int size) {
        Color rightBottomColor = this.getForeground();
        Color leftTopColor = this.display.getSystemColor(18);
        Color rightBottomInnerColor = this.display.getSystemColor(17);
        Color leftTopInnerColor = this.display.getSystemColor(19);
        int upper = yPos;
        int left = xPos;
        int lower = yPos + size - 1;
        int right = xPos + size - 1;
        if (this.scrollButtonDown) {
            rightBottomColor = this.display.getSystemColor(19);
            leftTopColor = this.display.getSystemColor(17);
            rightBottomInnerColor = this.display.getSystemColor(18);
            leftTopInnerColor = this.getForeground();
        }
        gc.fillRectangle(left, upper, right - left, lower - upper);
        gc.setForeground(rightBottomColor);
        gc.drawLine(right, upper, right, lower);
        gc.drawLine(left, lower, right, lower);
        gc.setForeground(leftTopColor);
        gc.drawLine(left, upper, left, lower - 1);
        gc.drawLine(left, upper, right - 1, upper);
        gc.setForeground(rightBottomInnerColor);
        gc.drawLine(--right, ++upper, right, --lower);
        gc.drawLine(++left, lower, right, lower);
        gc.setForeground(leftTopInnerColor);
        gc.drawLine(left, upper, left, lower - 1);
        gc.drawLine(left, upper, right - 1, upper);
        gc.setForeground(this.getForeground());
    }

    void drawScrollButtons(Event event) {
        Rectangle buttonArea = this.getScrollButtonArea();
        int buttonSize = buttonArea.width / 2;
        this.drawPlainButton(event.gc, buttonArea.x, buttonArea.y, buttonSize);
        this.drawPlainButton(event.gc, buttonArea.x + buttonSize, buttonArea.y, buttonSize);
        if (this.scrollButtonDown) {
            this.drawArrow(event.gc, buttonArea.x, buttonArea.y, buttonSize, true);
            this.drawArrow(event.gc, buttonArea.x + buttonSize + 1, buttonArea.y, buttonSize + 1, false);
        } else {
            this.drawArrow(event.gc, buttonArea.x - 1, buttonArea.y - 1, buttonSize, true);
            this.drawArrow(event.gc, buttonArea.x + buttonSize, buttonArea.y - 1, buttonSize, false);
        }
    }

    void ensureRightFreeSpaceUsed() {
        if (this.topTabIndex > 0 && !this.isTabScrolling()) {
            this.topTabIndex = 0;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void ensureVisible(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this.items.length) {
            return;
        }
        if (!this.isTabScrolling()) {
            return;
        }
        if (tabIndex < this.topTabIndex) {
            this.topTabIndex = tabIndex;
            this.layoutItems();
            this.redrawTabs();
            return;
        }
        int rightEdge = this.getScrollButtonArea().x;
        TabItem tabItem = this.items[tabIndex];
        while (tabItem.x + tabItem.width > rightEdge && tabIndex != this.topTabIndex) {
            ++this.topTabIndex;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void focus(Event e) {
        if (this.selectedIndex == -1) {
            return;
        }
        TabItem tab = this.items[this.selectedIndex];
        this.redraw(tab.x, tab.y, tab.width, tab.height);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        if (this.yClient == 0) {
            this.layoutItems();
        }
        clientArea.x = this.xClient;
        clientArea.y = this.yClient;
        clientArea.width = Math.max(0, clientArea.width - (this.xClient + 2 + 1));
        clientArea.height = Math.max(0, clientArea.height - (this.yClient + 2 + 1));
        return clientArea;
    }

    int getImageHeight() {
        return this.imageHeight;
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int count = this.items.length;
        int index = 0;
        while (index < count) {
            TabItem item = this.items[index];
            Rectangle bounds = item.getBounds();
            if (bounds.contains(point)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        TabItem[] tabItems = new TabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    Rectangle getScrollButtonArea() {
        return new Rectangle(super.getClientArea().width - 40, 2, 40, 20);
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        if (this.selectedIndex == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[this.selectedIndex]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selectedIndex;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 12: {
                this.doDispose(event);
                break;
            }
            case 9: {
                this.paint(event);
                break;
            }
            case 3: {
                this.mouseDown(event);
                break;
            }
            case 4: {
                this.mouseUp(event);
                break;
            }
            case 32: {
                this.mouseHover(event);
                break;
            }
            case 31: {
                this.traversal(event);
                break;
            }
            case 15: 
            case 16: {
                this.focus(event);
                break;
            }
            case 1: {
                this.keyDown(event);
                break;
            }
        }
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isLeftButtonHit(Event event) {
        Rectangle buttonArea = this.getScrollButtonArea();
        buttonArea.width /= 2;
        return this.isTabScrolling() && event.button == 1 && buttonArea.contains(event.x, event.y);
    }

    boolean isRightButtonHit(Event event) {
        Rectangle buttonArea = this.getScrollButtonArea();
        int buttonSize = buttonArea.width / 2;
        buttonArea.x += buttonSize;
        buttonArea.width = buttonSize;
        return this.isTabScrolling() && event.button == 1 && buttonArea.contains(event.x, event.y);
    }

    boolean isTabScrolling() {
        boolean isVisible = false;
        if (this.items.length > 0) {
            TabItem tabItem = this.items[this.items.length - 1];
            int tabStopX = tabItem.x + tabItem.width;
            tabItem = this.items[0];
            if (tabStopX - tabItem.x > super.getClientArea().width) {
                isVisible = true;
            }
        }
        return isVisible;
    }

    void itemChanged(TabItem item) {
        Image itemImage = item.getImage();
        boolean isTabScrolling = this.isTabScrolling();
        if (this.imageHeight == -1 && itemImage != null) {
            this.imageHeight = itemImage.getBounds().height;
        }
        this.layoutItems();
        this.redrawTabs();
        if (this.isTabScrolling() != isTabScrolling && !isTabScrolling) {
            this.redrawScrollButtons();
        }
    }

    void keyDown(Event event) {
        int count = this.items.length;
        if (count <= 1) {
            return;
        }
        switch (event.keyCode) {
            case 0x1000004: {
                if (this.selectedIndex >= this.items.length - 1) break;
                this.setSelection(this.selectedIndex + 1, true);
                break;
            }
            case 0x1000003: {
                if (this.selectedIndex <= 0) break;
                this.setSelection(this.selectedIndex - 1, true);
                break;
            }
            case 0x1000007: {
                if (this.selectedIndex <= 0) break;
                this.setSelection(0, true);
                break;
            }
            case 0x1000008: {
                if (this.selectedIndex >= count - 1) break;
                this.setSelection(count - 1, true);
            }
        }
    }

    void layoutItems() {
        TabItem tab;
        int x = 2;
        int y = 2;
        int tabHeight = 0;
        GC gc = new GC(this);
        int i = this.topTabIndex - 1;
        while (i >= 0) {
            tab = this.items[i];
            tab.width = tab.preferredWidth(gc);
            tab.height = tab.preferredHeight(gc);
            tab.x = x -= tab.width;
            tab.y = y;
            if (tab.height > tabHeight) {
                tabHeight = tab.height;
            }
            --i;
        }
        x = 2;
        i = this.topTabIndex;
        while (i < this.items.length) {
            tab = this.items[i];
            tab.x = x;
            tab.y = y;
            tab.width = tab.preferredWidth(gc);
            tab.height = tab.preferredHeight(gc);
            x += tab.width;
            if (tab.height > tabHeight) {
                tabHeight = tab.height;
            }
            ++i;
        }
        gc.dispose();
        this.xClient = 2;
        this.yClient = 2 + tabHeight;
        TabItem[] selection = this.getSelection();
        if (selection.length > 0) {
            selection[0].expand(2, 2, 2, 0);
        }
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            while (index < this.items.length) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == this.items.length) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.items.length) {
            char mnemonic = this.getMnemonic(this.items[i].getText());
            if (mnemonic != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic) && this.forceFocus()) {
                if (i != this.selectedIndex) {
                    this.setSelection(i, true);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    void mouseDown(Event event) {
        if (this.isLeftButtonHit(event)) {
            this.scrollButtonDown = true;
            this.redrawHitButton(event);
            this.scrollLeft();
        } else if (this.isRightButtonHit(event)) {
            this.scrollButtonDown = true;
            this.redrawHitButton(event);
            this.scrollRight();
        } else {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].getBounds().contains(new Point(event.x, event.y))) {
                    this.forceFocus();
                    this.setSelection(i, true);
                    return;
                }
                ++i;
            }
        }
    }

    void mouseHover(Event event) {
        String current = super.getToolTipText();
        if (this.toolTipText == null) {
            Point point = new Point(event.x, event.y);
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].getBounds().contains(point)) {
                    String string = this.items[i].getToolTipText();
                    if (string != null && !string.equals(current)) {
                        super.setToolTipText(string);
                    }
                    return;
                }
                ++i;
            }
            if (current != null) {
                super.setToolTipText(null);
            }
            return;
        }
        if (!this.toolTipText.equals(current)) {
            super.setToolTipText(this.toolTipText);
        }
    }

    void mouseUp(Event event) {
        if (this.scrollButtonDown && event.button == 1) {
            this.scrollButtonDown = false;
            this.redrawHitButton(event);
        }
    }

    void paint(Event event) {
        int i = 0;
        while (i < this.getItemCount()) {
            if (i != this.selectedIndex && event.getBounds().intersects(this.items[i].getBounds())) {
                this.items[i].paint(event.gc, false);
            }
            ++i;
        }
        this.drawBorder(event);
        if (this.selectedIndex != -1) {
            this.items[this.selectedIndex].paint(event.gc, true);
        }
        if (this.isTabScrolling()) {
            this.drawScrollButtons(event);
        }
    }

    void redraw(int x, int y, int width, int height) {
        Rectangle buttonArea = this.getScrollButtonArea();
        boolean fixScrollButtons = false;
        if (this.isTabScrolling()) {
            if (x > buttonArea.x) {
                x = buttonArea.x;
                fixScrollButtons = true;
            }
            if (x + width > buttonArea.x) {
                width = buttonArea.x - x;
                fixScrollButtons = true;
            }
        }
        this.redraw(x, y, width, height, false);
        if (fixScrollButtons) {
            this.redraw(buttonArea.x, 0, buttonArea.width, buttonArea.y, false);
            if (buttonArea.height < this.getClientArea().y) {
                int redrawY = buttonArea.y + buttonArea.height;
                this.redraw(buttonArea.x, redrawY, buttonArea.width, this.getClientArea().y - redrawY, false);
            }
        }
    }

    void redrawHitButton(Event event) {
        Rectangle scrollButtonArea = this.getScrollButtonArea();
        int scrollButtonWidth = scrollButtonArea.width / 2;
        if (this.isLeftButtonHit(event)) {
            this.redraw(scrollButtonArea.x, scrollButtonArea.y, scrollButtonWidth, scrollButtonArea.height, false);
        } else if (this.isRightButtonHit(event)) {
            this.redraw(scrollButtonArea.x + scrollButtonWidth, scrollButtonArea.y, scrollButtonWidth, scrollButtonArea.height, false);
        }
    }

    void redrawScrollButtons() {
        Rectangle scrollButtonArea = this.getScrollButtonArea();
        this.redraw(scrollButtonArea.x, scrollButtonArea.y, scrollButtonArea.width, scrollButtonArea.height, false);
    }

    void redrawSelectionChange(int oldSelection, int newSelection) {
        TabItem tab;
        if (oldSelection != -1) {
            tab = this.items[oldSelection];
            this.redraw(tab.x - 2, tab.y - 2, tab.width + 4, tab.height + 2);
        }
        if (newSelection != -1) {
            tab = this.items[newSelection];
            this.redraw(tab.x, tab.y, tab.width, tab.height);
        }
        this.update();
    }

    void redrawTabs() {
        this.redraw(0, 0, super.getClientArea().width, this.getClientArea().y);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.items.length) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    void resize() {
        Control control;
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
        this.ensureRightFreeSpaceUsed();
    }

    void scrollLeft() {
        if (this.topTabIndex > 0) {
            --this.topTabIndex;
            this.layoutItems();
            this.redrawTabs();
        }
    }

    void scrollRight() {
        if (this.items.length > 0 && this.topTabIndex < this.items.length - 1) {
            TabItem lastTabItem = this.items[this.items.length - 1];
            int tabStopX = lastTabItem.x + lastTabItem.width;
            if (tabStopX > super.getClientArea().width - 40) {
                ++this.topTabIndex;
                this.layoutItems();
                this.redrawTabs();
            }
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            this.resize();
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.layoutItems();
        this.redrawTabs();
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        this.setSelection(index, false);
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] selectedItems) {
        this.checkWidget();
        if (selectedItems == null) {
            this.error(4);
        }
        int index = -1;
        if (selectedItems.length > 0) {
            index = this.indexOf(selectedItems[0]);
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        Control control;
        if (this.selectedIndex == index) {
            return;
        }
        int oldIndex = this.selectedIndex;
        if (this.selectedIndex == index || index >= this.getItemCount()) {
            return;
        }
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        if (index < 0) {
            index = -1;
        }
        this.selectedIndex = index;
        this.layoutItems();
        this.ensureVisible(index);
        this.redrawSelectionChange(oldIndex, index);
        if (index >= 0 && (control = this.items[index].control) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (notify && this.selectedIndex != oldIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getSelection()[0];
            this.notifyListeners(13, event);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.toolTipText = string;
    }

    void traversal(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 128: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traversePage(boolean next) {
        int count = this.items.length;
        if (count == 0) {
            return false;
        }
        int index = this.selectedIndex;
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return true;
    }
}

