/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.setup.client.builder.internal;

import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.setup.client.builder.CategoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryBuilderImpl
extends CategoryBuilder {
    private IProjectAreaHandle fProjectArea;
    protected String fName = null;
    protected boolean fArchived = false;
    protected boolean fHidden = false;
    protected List<CategoryBuilderImpl> fChildren = new ArrayList<CategoryBuilderImpl>();
    protected ITeamAreaHandle fDefaultTeamArea = null;
    protected List<ITeamAreaHandle> fTeamAreas = new ArrayList<ITeamAreaHandle>();
    private CategoryBuilderImpl fParentCategoryBuilder;

    public CategoryBuilderImpl(ISetupContext projectSetupContext, IProjectAreaHandle projectArea) {
        this(projectSetupContext, projectArea, null);
    }

    private CategoryBuilderImpl(ISetupContext projectSetupContext, IProjectAreaHandle projectArea, CategoryBuilderImpl parentCategoryBuilder) {
        super(projectSetupContext);
        this.fProjectArea = projectArea;
        this.fParentCategoryBuilder = parentCategoryBuilder;
    }

    @Override
    public CategoryBuilder predefined(IPredefinedArtifact<ICategory> artifact) {
        this.setPredefined(artifact);
        this.name(artifact.getName());
        return this;
    }

    @Override
    public CategoryBuilder name(String name) {
        this.fName = this.decorateForTVT(name);
        return this;
    }

    @Override
    public CategoryBuilder archived() {
        this.fArchived = true;
        return this;
    }

    @Override
    public CategoryBuilder hidden() {
        this.fHidden = true;
        return this;
    }

    @Override
    public CategoryBuilder defaultTeamArea(ITeamAreaHandle teamArea) {
        this.fDefaultTeamArea = teamArea;
        return this;
    }

    @Override
    public CategoryBuilder defaultTeamArea(IPredefinedArtifact<ITeamArea> teamArea) {
        return this.defaultTeamArea((ITeamAreaHandle)this.getProjectSetupContext().getArtifact(teamArea));
    }

    @Override
    public CategoryBuilder teamArea(ITeamAreaHandle ... teamAreas) {
        this.fTeamAreas.addAll(Arrays.asList(teamAreas));
        return this;
    }

    @Override
    public CategoryBuilder teamArea(IPredefinedArtifact<ITeamArea> ... teamAreas) {
        IPredefinedArtifact<ITeamArea>[] iPredefinedArtifactArray = teamAreas;
        int n = teamAreas.length;
        int n2 = 0;
        while (n2 < n) {
            IPredefinedArtifact<ITeamArea> teamArea = iPredefinedArtifactArray[n2];
            this.fTeamAreas.add((ITeamAreaHandle)this.getProjectSetupContext().getArtifact(teamArea));
            ++n2;
        }
        return this;
    }

    @Override
    public CategoryBuilder subCategory() {
        CategoryBuilderImpl subCategoryBuilder = new CategoryBuilderImpl(this.getProjectSetupContext(), this.fProjectArea, this);
        this.fChildren.add(subCategoryBuilder);
        return subCategoryBuilder;
    }

    @Override
    public CategoryBuilder subCategoryDone() {
        return this.fParentCategoryBuilder;
    }

    protected ICategory doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doBuild((IWorkItemCommon)this.getProjectSetupContext().getClientLibrary(IWorkItemClient.class), null, monitor);
    }

    private ICategory doBuild(IWorkItemCommon workItemCommon, ICategory parentCategory, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory result = null;
        List findCategories = workItemCommon.findCategories(this.fProjectArea, ICategory.FULL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        for (ICategory category : findCategories) {
            if (!category.getName().equals(this.fName) || (category.getParentId() != null || parentCategory != null) && (category.getParentId() == null || parentCategory == null || !category.getParentId().equals((Object)parentCategory.getCategoryId()))) continue;
            result = category;
            break;
        }
        if (result == null) {
            result = parentCategory == null ? workItemCommon.createCategory(this.fProjectArea, this.fName, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : workItemCommon.createSubcategory((ICategoryHandle)parentCategory, this.fName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fTeamAreas.size() > 0) {
                result.getTeamAreas().addAll(this.fTeamAreas);
            }
            if (this.fDefaultTeamArea != null) {
                ((Category)result).doSetDefaultTeamArea(this.fDefaultTeamArea);
            }
            ((Category)result).setFiltered(this.fHidden);
            result.setArchived(this.fArchived);
            this.doApplyExtensions((IItem)result, monitor);
            workItemCommon.saveCategory(result, monitor);
            if (parentCategory != null) {
                this.doPostBuild((IItem)result);
            }
        }
        for (CategoryBuilderImpl subCategoryBuilder : this.fChildren) {
            subCategoryBuilder.doBuild(workItemCommon, result, monitor);
        }
        return result;
    }
}

