/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.setup.client.builder.internal;

import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.ILicenseAdminService;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.setup.client.builder.ContributorBuilder;
import com.ibm.team.repository.setup.client.builder.RTCCAL;
import com.ibm.team.workitem.setup.client.WorkItemSetupPlugin;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributorBuilderImpl
extends ContributorBuilder {
    protected String fName = null;
    protected String fEmail = null;
    protected String fLogin = null;
    protected List<String> fPermissions = null;
    protected URL fPhotoUrl;
    protected RTCCAL fCAL;

    public ContributorBuilderImpl(ISetupContext projectSetupContext) {
        super(projectSetupContext);
    }

    @Override
    public ContributorBuilder predefined(IPredefinedArtifact<IContributor> artifact) {
        this.setPredefined(artifact);
        this.name(artifact.getName());
        return this;
    }

    @Override
    public ContributorBuilder name(String name) {
        this.fName = name;
        return this;
    }

    @Override
    public ContributorBuilder email(String email) {
        this.fEmail = email;
        return this;
    }

    @Override
    public ContributorBuilder login(String login) {
        this.fLogin = login;
        return this;
    }

    @Override
    public ContributorBuilder permission(String role) {
        if (this.fPermissions == null) {
            this.fPermissions = new ArrayList<String>();
        }
        this.fPermissions.add(role);
        return this;
    }

    @Override
    public ContributorBuilder photo(URL photoUrl) {
        this.fPhotoUrl = photoUrl;
        return this;
    }

    @Override
    public ContributorBuilder cal(RTCCAL cal) {
        this.fCAL = cal;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    protected IContributor doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        block15: {
            teamRepository = this.getProjectSetupContext().getTeamRepository();
            try {
                return teamRepository.contributorManager().fetchContributorByUserId(this.fLogin, monitor);
            }
            catch (ItemNotFoundException v0) {
                result = (IContributor)IContributor.ITEM_TYPE.createItem((Object)teamRepository);
                result.setName(this.fName);
                result.setUserId(this.fLogin);
                result.setEmailAddress(this.fEmail);
                result = teamRepository.contributorManager().saveContributor(result, monitor);
                externalUserRegistryService = ((TeamRepository)teamRepository).getExternalUserRegistryService();
                externalUserRegistryService.addExternalUser(this.fLogin, this.fLogin, this.fName, this.fEmail, new String[0]);
                if (this.fPermissions == null) break block15;
                ** for (role : this.fPermissions)
            }
lbl-1000:
            // 1 sources

            {
                externalUserRegistryService.addToGroup(this.fLogin, role);
                continue;
            }
        }
        if (this.fPhotoUrl != null) {
            try {
                photoStream = this.fPhotoUrl.openStream();
                try {
                    photoContent = teamRepository.contentManager().storeContent("image/png", "us-ascii", photoStream, monitor);
                    details = (IContributorDetails)IContributorDetails.ITEM_TYPE.createItem((Object)teamRepository);
                    details.setPhoto(photoContent);
                    teamRepository.contributorManager().setContributorDetails((IContributorHandle)result, details, monitor);
                }
                finally {
                    photoStream.close();
                }
            }
            catch (IOException e) {
                WorkItemSetupPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.workitem.setup", "Can't add contributor picture", (Throwable)e));
            }
        }
        if (this.fCAL != null && (licenseService = (ILicenseAdminService)((IClientLibraryContext)teamRepository).getServiceInterface(ILicenseAdminService.class)) != null) {
            var10_11 = licenseTypes = licenseService.getLicenseTypes();
            var9_12 = licenseTypes.length;
            var8_10 = 0;
            while (var8_10 < var9_12) {
                licenseType = var10_11[var8_10];
                if (licenseType.getId().equals(this.fCAL.getId())) {
                    try {
                        licenseService.assignLicense((IContributorHandle)result, this.fCAL.getId());
                    }
                    catch (TeamRepositoryException v1) {
                    }
                    catch (IllegalArgumentException v2) {}
                    break;
                }
                ++var8_10;
            }
        }
        return result;
    }
}

