/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.workitempicker;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.workitempicker.Messages;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class WorkItemSelectionPopupDialog
extends PopupDialog {
    private static final String SETTINGS = "WorkItemSelectionPopupDialog";
    private static final String SETTINGS_KEY_OWNERFILTER = "ownerFilter";
    private static final String SETTINGS_KEY_STATEFILTER = "stateFilter";
    private IWorkbenchPage fPage;
    private Text fFilter;
    private FilterAction fOwnerFilter;
    private FilterAction fStateFilter;
    private WorkItemSelector fViewer;
    private Label fProgressLabel;
    private Object[] fResult = new Object[0];
    private ProjectAreaSelectionAction fProjectAreaSelector = new ProjectAreaSelectionAction("picker"){

        protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
            super.projectAreaSelected(projectAreaHandle);
            WorkItemSelectionPopupDialog.this.fFilter.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    WorkItemSelectionPopupDialog.this.fFilter.setEnabled(true);
                    WorkItemSelectionPopupDialog.this.updateViewer();
                }
            });
        }

        public boolean isEnabled() {
            return this.getConnectedProjectAreas().size() > 1;
        }
    };

    public WorkItemSelectionPopupDialog(Shell parent, IWorkbenchPage page) {
        super(parent, 0, true, true, true, true, null, null);
        this.fPage = page;
        this.fProjectAreaSelector.setText(Messages.WorkItemSelectionPopupDialog_PROJECT_AREA_SELECTION_LABEL);
        this.fOwnerFilter = new FilterAction();
        this.fOwnerFilter.setText(Messages.WorkItemSelectionPopupDialog_FILTER_MY_ASSIGNMENTS);
        this.fStateFilter = new FilterAction();
        this.fStateFilter.setText(Messages.WorkItemSelectionPopupDialog_FILTER_RESOLVED);
        this.readSettings();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings all = WorkItemRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = all.getSection(SETTINGS);
        if (result == null) {
            result = new DialogSettings(SETTINGS);
            all.addSection(result);
        }
        return result;
    }

    public void create() {
        super.create();
        if (this.fProjectAreaSelector.getProjectArea() == null || !((ITeamRepository)this.fProjectAreaSelector.getProjectArea().getOrigin()).loggedIn()) {
            this.fFilter.setText(Messages.WorkItemSelectionPopupDialog_NOT_CONNECTED_MESSAGE);
            this.fFilter.setEnabled(false);
        } else {
            this.fFilter.setEnabled(true);
            this.fFilter.setText("");
            this.refreshResults();
        }
    }

    protected Control getFocusControl() {
        return this.fFilter;
    }

    protected Control createTitleControl(Composite parent) {
        Composite titleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleArea.setLayout((Layout)layout);
        titleArea.setLayoutData((Object)new GridData(768));
        Font font = parent.getFont();
        this.fFilter = new Text(titleArea, 0);
        this.fFilter.setFont(font);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.fFilter.setLayoutData((Object)gd);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkItemSelectionPopupDialog.this.refreshResults();
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    WorkItemSelectionPopupDialog.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkItemSelectionPopupDialog.this.itemSelected();
            }
        });
        this.fProgressLabel = new Label(titleArea, 0);
        this.fProgressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fProgressLabel.setAlignment(131072);
        return titleArea;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        result.setFont(font);
        FontMetrics fontMetrics = null;
        GC gc = null;
        try {
            gc = new GC((Drawable)result);
            gc.setFont(font);
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)60);
        int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)15);
        this.createViewer(result, width, height);
        result.setLayoutData((Object)new GridData(1808));
        return result;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        dialogMenu.add((IAction)this.fOwnerFilter);
        dialogMenu.add((IAction)this.fStateFilter);
        dialogMenu.add((IAction)this.fProjectAreaSelector);
    }

    public boolean close() {
        this.writeSettings();
        boolean result = super.close();
        if (result && this.fProjectAreaSelector != null) {
            this.fProjectAreaSelector.dispose();
            this.fProjectAreaSelector = null;
        }
        return result;
    }

    private void createViewer(Composite result, int width, int height) {
        this.fViewer = new WorkItemSelector(this.fProjectAreaSelector.getProjectArea(), result, 768, "");
        this.fViewer.getTable().setBackground(result.getBackground());
        GridData gd = new GridData(1808);
        gd.widthHint = width;
        gd.heightHint = height;
        Table table = this.fViewer.getTable();
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkItemSelectionPopupDialog.this.itemSelected();
            }
        });
        this.fViewer.setProgressLabel(this.fProgressLabel);
    }

    private void updateViewer() {
        this.fViewer.stop();
        Table table = this.fViewer.getTable();
        Composite parent = table.getParent();
        Rectangle rect = table.getBounds();
        table.dispose();
        this.createViewer(parent, rect.width, rect.height);
        parent.layout();
        this.refreshResults();
    }

    private void refreshResults() {
        this.fViewer.setSearchParameters(this.fFilter.getText(), this.fOwnerFilter.isChecked(), !this.fStateFilter.isChecked());
    }

    private void itemSelected() {
        this.fResult = this.fViewer.getSelection();
        this.close();
        int i = 0;
        while (i < this.fResult.length) {
            WorkItemSelector.addToHistory((IWorkItemHandle)this.fResult[i]);
            WorkItemUI.openEditor(this.fPage, this.fResult[i]);
            ++i;
        }
    }

    private void readSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.fOwnerFilter.setChecked(settings.getBoolean(SETTINGS_KEY_OWNERFILTER));
        this.fStateFilter.setChecked(settings.getBoolean(SETTINGS_KEY_STATEFILTER));
    }

    private void writeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_KEY_OWNERFILTER, this.fOwnerFilter.isChecked());
        settings.put(SETTINGS_KEY_STATEFILTER, this.fStateFilter.isChecked());
    }

    private class FilterAction
    extends Action {
        private FilterAction() {
        }

        public int getStyle() {
            return 2;
        }

        public void run() {
            WorkItemSelectionPopupDialog.this.refreshResults();
        }
    }
}

