/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.workitempicker;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.ResultSize;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.LightWeightWorkItemCreationDialog;
import com.ibm.team.workitem.rcp.ui.LightweightWorkItemCreationContext;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.workitempicker.Messages;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelector;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class WorkItemSelectionDialog
extends SelectionStatusDialog {
    public static final boolean MULTIPLE_SELECTION = true;
    private static final String SETTINGS = "com.ibm.team.jface.workitempicker.WorkItemSelectionDialog";
    private static final String SETTINGS_KEY_OWNERFILTER = "ownerFilter";
    private static final String SETTINGS_KEY_STATEFILTER = "stateFilter";
    private static final IStatus INIT_STATUS = new Status(0, "com.ibm.team.workitem.rcp.ui", 0, "", null);
    private static final String ANY = Messages.WorkItemSelectionDialog_ANY_WORKITEM_TYPE;
    private boolean fMultipleSelection;
    private Text fFilter;
    private WorkItemSelector fViewer;
    private Label fProgressLabel;
    private Button fOwnerCheckBox;
    private Button fStateCheckBox;
    private IDialogSettings fSettings;
    private IProjectAreaHandle fProjectArea;
    private boolean fIsWorkItemCreation = false;
    private Set<UUID> fExcluded = Collections.emptySet();
    private boolean fCrossRepository = false;
    private IAction fPreCreationAction;
    private Runnable fPreCreationRunnable;
    private WorkItemOperation fPostCreationOperation;
    private String fInitialPattern;
    private CaretPosition fInitialPosition = CaretPosition.NONE;
    private ProjectAreaSelectionAction fProjectAreaSelectionAction = new ProjectAreaSelectionAction("picker"){

        protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
            WorkItemSelectionDialog.this.fProjectArea = projectAreaHandle;
            WorkItemSelectionDialog.this.fViewer.setProjectArea(WorkItemSelectionDialog.this.fProjectArea);
            WorkItemSelectionDialog.this.refreshResults();
        }
    };
    private DecoratedCombo fProjectAreaCombo;
    private DecoratedCombo fTypesCombo;
    private Map<UUID, List<IWorkItemType>> fTypesCache = new HashMap<UUID, List<IWorkItemType>>();
    private UIUpdaterJob fTypesJob;

    public static IWorkItemHandle getWorkItem(Shell parent) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, false);
        return dialog.getSingleWorkItem();
    }

    public static IWorkItemHandle[] getWorkItems(Shell parent) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, true);
        return dialog.getMultipleWorkItems();
    }

    public static IWorkItemHandle getWorkItem(Shell parent, ITeamRepository repository) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, repository, false);
        return dialog.getSingleWorkItem();
    }

    public static IWorkItemHandle[] getWorkItems(Shell parent, ITeamRepository repository) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, repository, true);
        return dialog.getMultipleWorkItems();
    }

    public static IWorkItemHandle getWorkItem(Shell parent, IProjectAreaHandle projectArea) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, projectArea, false);
        return dialog.getSingleWorkItem();
    }

    public static IWorkItemHandle[] getWorkItems(Shell parent, IProjectAreaHandle projectArea) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, projectArea, true);
        return dialog.getMultipleWorkItems();
    }

    public WorkItemSelectionDialog(Shell parent, boolean multi) {
        super(parent);
        this.init(multi);
        this.fProjectAreaSelectionAction.setInactiveOnDefault(true);
        this.fProjectArea = this.fProjectAreaSelectionAction.getProjectArea();
        this.fCrossRepository = true;
        this.updateTypesCache();
    }

    public WorkItemSelectionDialog(Shell parent, ITeamRepository repository, boolean multi) {
        super(parent);
        this.init(multi);
        this.fProjectAreaSelectionAction.restrictToRepository(repository);
        this.fProjectArea = this.fProjectAreaSelectionAction.getProjectArea();
        this.updateTypesCache();
    }

    public WorkItemSelectionDialog(Shell parent, IProjectAreaHandle projectArea, boolean multi) {
        super(parent);
        this.init(multi);
        this.fProjectArea = projectArea;
        if (projectArea != null) {
            this.fProjectAreaSelectionAction.restrictToRepository((ITeamRepository)projectArea.getOrigin());
        }
        this.updateTypesCache();
    }

    private void init(boolean multi) {
        this.fMultipleSelection = multi;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSettings = this.getDialogSettings();
        this.fProjectAreaSelectionAction.setText(Messages.WorkItemSelectionDialog_SELECT_PROJECT_AREA_ACTION);
    }

    public IWorkItemHandle getSingleWorkItem() {
        this.setTitle(Messages.WorkItemSelectionDialog_SINGLE_WORKITEM_TITLE);
        if (this.open() == 0) {
            IWorkItemHandle handle = (IWorkItemHandle)this.getFirstResult();
            if (handle != null) {
                WorkItemSelector.addToHistory(handle);
            }
            return handle;
        }
        return null;
    }

    public IWorkItemHandle[] getMultipleWorkItems() {
        this.setTitle(Messages.WorkItemSelectionDialog_MULTI_WORKITEM_TITLE);
        if (this.open() == 0) {
            IWorkItemHandle[] handles = (IWorkItemHandle[])this.getResult();
            WorkItemSelector.addToHistory(handles);
            return handles;
        }
        return WorkItemSelector.EMPTY_SELECTION;
    }

    public void setInitialPattern(String pattern, CaretPosition position) {
        this.fInitialPattern = pattern;
        this.fInitialPosition = position;
    }

    public void create() {
        super.create();
        this.updateInitialPattern();
        this.refreshResults();
    }

    private void updateInitialPattern() {
        if (this.fInitialPattern == null || this.fInitialPattern.trim().length() == 0) {
            return;
        }
        this.fFilter.setText(this.fInitialPattern);
        switch (this.fInitialPosition) {
            case START: {
                this.fFilter.setSelection(0, 0);
                break;
            }
            case END: {
                this.fFilter.setSelection(this.fInitialPattern.length(), this.fInitialPattern.length());
                break;
            }
            case FULL: {
                this.fFilter.setSelection(0, this.fInitialPattern.length());
            }
        }
    }

    protected Control getFocusControl() {
        return this.fFilter;
    }

    protected void createInputControl(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        headerLayout.verticalSpacing = 0;
        header.setLayout((Layout)headerLayout);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label = new Label(header, 0);
        label.setFont(parent.getFont());
        label.setText(Messages.WorkItemSelectionDialog_ID_TEXT_DESCRIPTION);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fProgressLabel = new Label(header, 131072);
        this.fProgressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createProjectAreaCombo(header);
        this.fFilter = new Text(parent, 2048);
        this.fFilter.setFont(parent.getFont());
        this.fFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkItemSelectionDialog.this.refreshResults();
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    WorkItemSelectionDialog.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkItemSelectionDialog.this.okPressed();
            }
        });
        label.addTraverseListener((TraverseListener)new DelegatingTraverseListener((Control)this.fFilter));
    }

    private void createProjectAreaCombo(Composite parent) {
        this.fProjectAreaCombo = new DecoratedCombo(parent, 8, 1);
        this.fProjectAreaCombo.getCombo().setVisibleItemCount(15);
        GridData data = new GridData(131072, 0x1000000, false, false);
        data.horizontalIndent = 10;
        this.fProjectAreaCombo.getLayoutControl().setLayoutData((Object)data);
        StandardLabelProvider labelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fProjectAreaCombo.setLabelProvider((ILabelProvider)labelProvider);
        ITeamRepository restricted = null;
        if (!this.fCrossRepository && this.fProjectArea != null) {
            restricted = (ITeamRepository)this.fProjectArea.getOrigin();
        }
        final Object[] valueSet = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(restricted).toArray();
        if (this.fProjectArea != null) {
            if (!ConnectedProjectAreaRegistry.getDefault().isConnectedProjectArea(this.fProjectArea)) {
                this.fProjectAreaCombo.setValue(Messages.WorkItemSelectionDialog_RESOLVING_PA);
                new UIUpdaterJob(Messages.WorkItemSelectionDialog_RESOLVING_PA){

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)WorkItemSelectionDialog.this.fProjectArea.getOrigin()).getClientLibrary(IAuditableClient.class);
                        IWorkItemCommon workItemCommon = (IWorkItemCommon)((ITeamRepository)WorkItemSelectionDialog.this.fProjectArea.getOrigin()).getClientLibrary(IWorkItemCommon.class);
                        try {
                            WorkItemSelectionDialog.this.fProjectArea = (IProjectAreaHandle)auditableClient.resolveAuditable((IAuditableHandle)WorkItemSelectionDialog.this.fProjectArea, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
                            WorkItemSelectionDialog.this.fTypesCache.put(WorkItemSelectionDialog.this.fProjectArea.getItemId(), workItemCommon.findWorkItemTypes(WorkItemSelectionDialog.this.fProjectArea, monitor));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (WorkItemSelectionDialog.this.fProjectArea instanceof IProjectArea) {
                            WorkItemSelectionDialog.this.configureCombo(WorkItemSelectionDialog.this.fProjectArea, valueSet);
                        } else {
                            WorkItemSelectionDialog.this.configureCombo(Messages.WorkItemSelectionDialog_ERROR_RETRIEVING_PA, valueSet);
                        }
                        WorkItemSelectionDialog.this.fProjectAreaCombo.getLayoutControl().getParent().layout(true);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                this.configureCombo(this.fProjectArea, valueSet);
            }
        } else if (valueSet.length > 0) {
            this.configureCombo(valueSet[0], valueSet);
        } else {
            this.configureCombo(Messages.WorkItemSelectionDialog_NO_PA_AVAILABLE, valueSet);
        }
    }

    private void configureCombo(Object value, Object[] valueSet) {
        this.fProjectAreaCombo.setValue(value);
        this.fProjectAreaCombo.setValueSet(valueSet);
        this.fProjectAreaCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkItemSelectionDialog.this.fProjectArea = (IProjectAreaHandle)WorkItemSelectionDialog.this.fProjectAreaCombo.getValue();
                WorkItemSelectionDialog.this.fViewer.setProjectArea(WorkItemSelectionDialog.this.fProjectArea);
                WorkItemSelectionDialog.this.refreshResults();
                WorkItemSelectionDialog.this.updateTypesCache();
            }
        });
    }

    private void updateEnablement() {
        char first;
        String pattern;
        boolean enabled = true;
        if (this.fFilter != null && !this.fFilter.isDisposed() && (pattern = this.fFilter.getText()).length() != 0 && ((first = pattern.charAt(0)) == '#' || Character.isDigit(first))) {
            try {
                String idText = first == '#' ? pattern.substring(1) : pattern;
                Integer.parseInt(idText);
                enabled = false;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.fProjectAreaCombo != null && !this.fProjectAreaCombo.getLayoutControl().isDisposed()) {
            this.fProjectAreaCombo.getCombo().setEnabled(enabled);
            this.fProjectAreaCombo.getImageControl().setEnabled(enabled);
        }
        if (this.fTypesCombo != null && !this.fTypesCombo.getLayoutControl().isDisposed()) {
            this.fTypesCombo.getCombo().setEnabled(enabled);
            this.fTypesCombo.getImageControl().setEnabled(enabled);
        }
        if (this.fOwnerCheckBox != null && !this.fOwnerCheckBox.isDisposed()) {
            this.fOwnerCheckBox.setEnabled(enabled);
        }
        if (this.fStateCheckBox != null && !this.fStateCheckBox.isDisposed()) {
            this.fStateCheckBox.setEnabled(enabled);
        }
    }

    private void updateTypesValueSet() {
        List<IWorkItemType> types;
        if (this.fTypesCombo == null || this.fTypesCombo.getLayoutControl().isDisposed()) {
            return;
        }
        ArrayList<String> valueSet = new ArrayList<String>();
        valueSet.add(ANY);
        List<IWorkItemType> list = types = this.fProjectArea != null ? this.fTypesCache.get(this.fProjectArea.getItemId()) : null;
        if (types != null) {
            valueSet.addAll(types);
        }
        this.fTypesCombo.setValueSet(valueSet.toArray());
        Object value = this.fTypesCombo.getValue();
        if (value instanceof IWorkItemType && !((IWorkItemType)value).getProjectArea().sameItemId((IItemHandle)this.fProjectArea)) {
            this.fTypesCombo.setValue(ANY);
        }
    }

    private void updateTypesCache() {
        if (this.fTypesJob == null) {
            this.fTypesJob = new UIUpdaterJob(Messages.WorkItemSelectionDialog_UPDATING_TYPES){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    if (WorkItemSelectionDialog.this.fProjectArea == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ITeamRepository restricted = (ITeamRepository)WorkItemSelectionDialog.this.fProjectArea.getOrigin();
                    IWorkItemCommon workItemCommon = (IWorkItemCommon)restricted.getClientLibrary(IWorkItemCommon.class);
                    List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(restricted);
                    for (IProjectAreaHandle pa : projectAreas) {
                        try {
                            List types = workItemCommon.findWorkItemTypes(pa, monitor);
                            WorkItemSelectionDialog.this.fTypesCache.put(pa.getItemId(), types);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                    }
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    WorkItemSelectionDialog.this.updateTypesValueSet();
                    return Status.OK_STATUS;
                }
            };
            this.fTypesJob.setSystem(true);
        }
        this.fTypesJob.schedule();
    }

    protected void createFilterControls(Composite result) {
        this.fTypesCombo = new DecoratedCombo(result, 8, 1);
        this.fTypesCombo.getCombo().setVisibleItemCount(15);
        GridDataFactory.fillDefaults().applyTo(this.fTypesCombo.getLayoutControl());
        LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources(), (Control)result);
        this.fTypesCombo.setLabelProvider((ILabelProvider)new LabelProvider((ResourceManager)manager){
            private final /* synthetic */ ResourceManager val$manager;
            {
                this.val$manager = resourceManager;
            }

            public Image getImage(Object element) {
                if (element instanceof IWorkItemType && ((IWorkItemType)element).getIconURL() != null) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.val$manager, (ImageDescriptor)WorkItemUI.getImageDescriptor(((IWorkItemType)element).getIconURL()));
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IWorkItemType) {
                    return ((IWorkItemType)element).getDisplayName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }
        });
        this.updateTypesValueSet();
        this.fTypesCombo.setValue(ANY);
        this.fTypesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = WorkItemSelectionDialog.this.fTypesCombo.getValue();
                if (value instanceof IWorkItemType) {
                    WorkItemSelectionDialog.this.fViewer.setWorkItemType((IWorkItemType)value);
                } else {
                    WorkItemSelectionDialog.this.fViewer.setWorkItemType(null);
                }
                WorkItemSelectionDialog.this.refreshResults();
            }
        });
        this.fOwnerCheckBox = new Button(result, 32);
        this.fOwnerCheckBox.setText(Messages.WorkItemSelectionDialog_FILTER_MY_ASSIGNMENTS);
        this.fOwnerCheckBox.setSelection(this.getOwnerFilterSettings());
        GridDataFactory.fillDefaults().applyTo((Control)this.fOwnerCheckBox);
        this.fOwnerCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemSelectionDialog.this.refreshResults();
            }
        });
        this.fStateCheckBox = new Button(result, 32);
        this.fStateCheckBox.setText(Messages.WorkItemSelectionDialog_FILTER_RESOLVED);
        this.fStateCheckBox.setSelection(this.getStateFilterSettings());
        GridDataFactory.fillDefaults().applyTo((Control)this.fStateCheckBox);
        this.fStateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemSelectionDialog.this.refreshResults();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Font font = parent.getFont();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        FontMetrics fontMetrics = null;
        GC gc = null;
        try {
            gc = new GC((Drawable)result);
            gc.setFont(font);
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        this.createInputControl(result);
        Label label = new Label(result, 0);
        label.setText(Messages.WorkItemSelectionDialog_MATCHING_WORKITEMS_LABEL);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterComposite = new Composite(result, 0);
        GridLayout filterLayout = new GridLayout(3, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterLayout.verticalSpacing = 0;
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.createFilterControls(filterComposite);
        GridData gd = null;
        int flags = 2816;
        this.fViewer = new WorkItemSelector(this.fProjectArea, result, this.fMultipleSelection ? flags | 2 : flags, "");
        this.fViewer.setProgressLabel(this.fProgressLabel);
        if (!this.fExcluded.isEmpty()) {
            this.fViewer.addFilter(new IFilter(){

                public boolean select(Object element) {
                    if (element instanceof IWorkItemHandle) {
                        IWorkItemHandle handle = (IWorkItemHandle)element;
                        return !WorkItemSelectionDialog.this.fExcluded.contains(handle.getItemId());
                    }
                    return false;
                }
            });
        }
        this.fViewer.addStatusListener(new IElementSelectorStatusListener(){
            private boolean fIsError;

            public void reset() {
                this.started(null);
            }

            public void started(String message) {
                this.fIsError = false;
                WorkItemSelectionDialog.this.updateStatus(INIT_STATUS);
            }

            public void progress(String message, double actualWork, int totalWork) {
            }

            public void stopped() {
                if (!this.fIsError) {
                    String infoMessage;
                    int itemCount = WorkItemSelectionDialog.this.fViewer.getItemCount();
                    ResultSize resultSize = WorkItemSelectionDialog.this.fViewer.getLastResultSize();
                    if (!resultSize.isAccurate()) {
                        infoMessage = NLS.bind((String)Messages.WorkItemSelectionDialog_SHOWING_ESTIMATED, (Object)itemCount, (Object[])new Object[]{resultSize.getEstimatedTotal()});
                    } else if (itemCount < resultSize.getTotal()) {
                        infoMessage = NLS.bind((String)Messages.WorkItemSelectionDialog_SHOWING_X_OF_Y, (Object)itemCount, (Object[])new Object[]{resultSize.getTotal()});
                    } else {
                        ChoiceFormat choiceFormat = new ChoiceFormat(Messages.WorkItemSelectionDialog_WORKITEMSFOUND_CHOICEFORMAT);
                        String messageFormat = choiceFormat.format(itemCount);
                        infoMessage = NLS.bind((String)messageFormat, (Object)itemCount, (Object[])new Object[0]);
                    }
                    WorkItemSelectionDialog.this.updateStatus((IStatus)new Status(1, "com.ibm.team.workitem.rcp.ui", 1, infoMessage, null));
                }
            }

            public void error(CoreException e) {
                WorkItemSelectionDialog.this.updateStatus(e.getStatus());
                this.fIsError = true;
            }
        });
        label.addTraverseListener((TraverseListener)new DelegatingTraverseListener((Control)this.fViewer.getTable()));
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)80);
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)15);
        Table table = this.fViewer.getTable();
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemSelectionDialog.this.getOkButton().setEnabled(WorkItemSelectionDialog.this.fViewer.getTable().getSelectionCount() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkItemSelectionDialog.this.okPressed();
            }
        });
        Link createNewLink = new Link(result, 0);
        createNewLink.setText(NLS.bind((String)"<a>{0}</a>", (Object)Messages.WorkItemSelectionDialog_CREATE_WORKITEM_LINKTEXT, (Object[])new Object[0]));
        createNewLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (WorkItemSelectionDialog.this.fPreCreationAction != null) {
                    WorkItemSelectionDialog.this.fPreCreationAction.runWithEvent(event);
                    if (!event.doit) {
                        return;
                    }
                }
                WorkItemSelectionDialog.this.fIsWorkItemCreation = true;
                WorkItemSelectionDialog.this.okPressed();
            }
        });
        result.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)result);
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.work_item_selection_dialog");
        this.fFilter.setFocus();
        return result;
    }

    private void refreshResults() {
        this.updateEnablement();
        this.fViewer.setSearchParameters(this.fFilter.getText(), this.fOwnerCheckBox.getSelection(), !this.fStateCheckBox.getSelection());
    }

    protected void computeResult() {
        this.setSelectionResult(this.fViewer.getWorkItemHandles());
    }

    public Object[] getResult() {
        if (this.fIsWorkItemCreation) {
            IWorkItemHandle handle = this.createNewWorkItem();
            if (handle == null) {
                return WorkItemSelector.EMPTY_SELECTION;
            }
            return new IWorkItemHandle[]{handle};
        }
        return super.getResult();
    }

    private IWorkItemHandle createNewWorkItem() {
        if (this.fPreCreationRunnable != null) {
            try {
                this.fPreCreationRunnable.run();
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
        }
        if (this.fPostCreationOperation != null) {
            WorkItemUI.createWorkItem(this.getParentShell(), this.fProjectArea, this.fPostCreationOperation);
            return null;
        }
        if (this.fProjectArea == null) {
            this.fProjectArea = WorkItemUI.selectProjectArea(this.getParentShell());
        }
        if (this.fProjectArea == null) {
            return null;
        }
        LightweightWorkItemCreationContext context = new LightweightWorkItemCreationContext(this.fProjectArea);
        LightWeightWorkItemCreationDialog dialog = new LightWeightWorkItemCreationDialog(Display.getCurrent().getActiveShell(), context);
        if (dialog.open() == 0) {
            return dialog.getCreatedWorkItem();
        }
        return null;
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.fViewer.getSelection().length == 0) {
            this.getOkButton().setEnabled(false);
        } else {
            super.updateButtonsEnableState(status);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings all = WorkItemRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = all.getSection(SETTINGS);
        if (result == null) {
            result = new DialogSettings(SETTINGS);
            all.addSection(result);
        }
        return result;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        Point size = this.readSettingsSize();
        if (size != null) {
            result.x = Math.max(result.x, size.x);
            result.y = Math.max(result.y, size.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        Point location = this.readSettingsLocation();
        if (location != null) {
            int ye;
            result.x = location.x;
            result.y = location.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    public boolean close() {
        this.writeSettings();
        boolean result = super.close();
        if (result) {
            if (this.fProjectAreaSelectionAction != null) {
                this.fProjectAreaSelectionAction.dispose();
                this.fProjectAreaSelectionAction = null;
            }
            if (this.fTypesJob != null) {
                this.fTypesJob.cancel();
            }
        }
        return result;
    }

    public void setExcluded(IWorkItemHandle[] handles) {
        Assert.isNotNull((Object)handles);
        HashSet<UUID> collection = new HashSet<UUID>(handles.length);
        IWorkItemHandle[] iWorkItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemHandle handle = iWorkItemHandleArray[n2];
            collection.add(handle.getItemId());
            ++n2;
        }
        this.fExcluded = collection;
    }

    public void setPreCreationAction(IAction preCreationAction) {
        this.fPreCreationAction = preCreationAction;
    }

    public void setPreCreationRunnable(Runnable preCreationRunnable) {
        this.fPreCreationRunnable = preCreationRunnable;
    }

    public void setPostCreationOperation(WorkItemOperation postCreationOperation) {
        this.fPostCreationOperation = postCreationOperation;
    }

    private Point readSettingsLocation() {
        try {
            int x = this.fSettings.getInt("x");
            int y = this.fSettings.getInt("y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Point readSettingsSize() {
        try {
            int width = this.fSettings.getInt("width");
            int height = this.fSettings.getInt("height");
            return new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean getStateFilterSettings() {
        if (this.fSettings.get(SETTINGS_KEY_STATEFILTER) == null) {
            return false;
        }
        return this.fSettings.getBoolean(SETTINGS_KEY_STATEFILTER);
    }

    private boolean getOwnerFilterSettings() {
        if (this.fSettings.get(SETTINGS_KEY_OWNERFILTER) == null) {
            return true;
        }
        return this.fSettings.getBoolean(SETTINGS_KEY_OWNERFILTER);
    }

    private void writeSettings() {
        Point location = this.getShell().getLocation();
        this.fSettings.put("x", location.x);
        this.fSettings.put("y", location.y);
        Point size = this.getShell().getSize();
        this.fSettings.put("width", size.x);
        this.fSettings.put("height", size.y);
        this.fSettings.put(SETTINGS_KEY_OWNERFILTER, this.fOwnerCheckBox.getSelection());
        this.fSettings.put(SETTINGS_KEY_STATEFILTER, this.fStateCheckBox.getSelection());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaretPosition {
        NONE,
        START,
        END,
        FULL;

    }

    private static class DelegatingTraverseListener
    implements TraverseListener {
        private Control fFocusControl;

        public DelegatingTraverseListener(Control focusControl) {
            this.fFocusControl = focusControl;
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 128 && e.doit) {
                e.detail = 0;
                this.fFocusControl.setFocus();
            }
        }
    }
}

