/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.ImportWorkItemTemplateMainPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class WorkItemTemplateImportWizard
extends Wizard
implements IImportWizard {
    private File fFile;
    private IProjectAreaHandle fSelectedProject;

    public WorkItemTemplateImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ImagePool.WORKITEM_TEMPLATE_IMPORT_WIZARD);
        this.setWindowTitle(Messages.WorkItemTemplateImportWizard_TITLE);
        this.fSelectedProject = ConnectedProjectAreas.getInstance().getDefaultProjectArea(true);
        if (this.fSelectedProject == null) {
            this.fSelectedProject = ConnectedProjectAreas.getInstance().getDefaultProjectAreaFallback(true);
        }
    }

    public IProjectAreaHandle getSelectedProject() {
        return this.fSelectedProject;
    }

    void setSelectedProject(IProjectAreaHandle prj) {
        this.fSelectedProject = prj;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ImportWorkItemTemplateMainPage("WorkItemTemplateImportWizard.mainPage", Messages.WorkItemTemplateImportWizard_MAIN_PAGE_TITLE, null));
    }

    public boolean performFinish() {
        if (this.fFile != null) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                        try {
                            IProjectAreaHandle projectArea;
                            progress.beginTask("", 2);
                            String xmlContent = "";
                            try {
                                BufferedReader reader = new BufferedReader(new FileReader(WorkItemTemplateImportWizard.this.fFile));
                                String line = reader.readLine();
                                while (line != null) {
                                    xmlContent = String.valueOf(xmlContent) + line;
                                    line = reader.readLine();
                                }
                            }
                            catch (FileNotFoundException ex) {
                                throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                            }
                            catch (IOException ex) {
                                throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                            }
                            progress.worked(1);
                            if (xmlContent.length() > 0 && (projectArea = WorkItemTemplateImportWizard.this.getSelectedProject()) != null) {
                                try {
                                    ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
                                    IWorkItemTemplateClient templateClient = (IWorkItemTemplateClient)repository.getClientLibrary(IWorkItemTemplateClient.class);
                                    templateClient.importTemplate(xmlContent, projectArea, (IProgressMonitor)progress);
                                }
                                catch (TeamRepositoryException ex) {
                                    throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                                }
                            }
                            progress.worked(1);
                        }
                        finally {
                            progress.done();
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    throw new OperationCanceledException(ex.getLocalizedMessage());
                }
                WizardPage curPage = (WizardPage)this.getContainer().getCurrentPage();
                if (curPage != null) {
                    String reason = ex.getLocalizedMessage();
                    if (reason == null) {
                        curPage.setErrorMessage(Messages.NewWorkItemTemplateWizard_ERROR_ON_SAVE_TEMPLATE);
                    } else {
                        curPage.setErrorMessage(NLS.bind((String)Messages.NewWorkItemTemplateWizard_ERROR_REASON_SAVE_TEMPLATE, (Object)Messages.NewWorkItemTemplateWizard_ERROR_ON_SAVE_TEMPLATE, (Object[])new Object[]{reason}));
                    }
                    curPage.setPageComplete(false);
                }
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setImportFile(File file) {
        this.fFile = file;
    }
}

