/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.workitem.common.internal.template.WorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AbstractWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.NewWorkItemTemplateWizard;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SelectWorkItemsPage
extends AbstractWorkItemTemplatePage {
    private Text fNameText;
    private Text fDescriptionText;
    private CheckboxTableViewer fItemViewer;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;

    protected SelectWorkItemsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.NewWorkItemTemplateWizard_SELECT_WORKITEMS_PAGE_DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.initializeDialogUnits((Control)composite);
        Composite nameComp = this.createComposite(composite, 1, true, false);
        Label nameLabel = new Label(nameComp, 16640);
        nameLabel.setText(Messages.SelectWorkItemsPage_TEMPLATE_NAME_LABEL);
        this.fNameText = new Text(nameComp, 2052);
        this.fNameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SelectWorkItemsPage.this.updatePageComplete();
            }
        });
        Composite infoComp = this.createComposite(composite, 1, true, true);
        Label descriptionLabel = new Label(infoComp, 16640);
        descriptionLabel.setText(Messages.DefineTemplateAttributesPage_DESCRIPTION_LABEL);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fDescriptionText = new Text(infoComp, 2576);
        this.fDescriptionText.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.fDescriptionText.getLayoutData()).heightHint = 5 * this.fDescriptionText.getLineHeight();
        Composite itemComp = this.createComposite(composite, 3, true, true);
        Label listLabel = new Label(itemComp, 16640);
        listLabel.setText(Messages.SelectWorkItemsPage_WORK_ITEMS_LIST_LABEL);
        listLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)listLabel.getLayoutData()).horizontalSpan = 3;
        Composite tableComp = new Composite(itemComp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)tableComp.getLayoutData()).horizontalSpan = 3;
        Table itemTable = new Table(tableComp, 68146);
        itemTable.setLinesVisible(true);
        ((GridData)tableComp.getLayoutData()).heightHint = 10 * itemTable.getItemHeight();
        TableColumn nameCol = new TableColumn(itemTable, 16384);
        nameCol.setMoveable(false);
        nameCol.setResizable(false);
        nameCol.pack();
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)nameCol, (ColumnLayoutData)new ColumnWeightData(100, true));
        tableComp.setLayout((Layout)tableLayout);
        this.fItemViewer = new CheckboxTableViewer(itemTable);
        this.fItemViewer.setContentProvider((IContentProvider)new WorkItemContentProvider());
        this.fItemViewer.setLabelProvider((IBaseLabelProvider)new WorkItemLabelProvider());
        this.fItemViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SelectWorkItemsPage.this.fItemViewer.getTable().getItemCount() > 0) {
                    SelectWorkItemsPage.this.updatePageComplete();
                }
            }
        });
        this.fSelectAllButton = new Button(itemComp, 8);
        this.fSelectAllButton.setText(Messages.SelectWorkItemsPage_SELECT_ALL_ACTION);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectWorkItemsPage.this.fItemViewer.setAllChecked(true);
                SelectWorkItemsPage.this.updatePageComplete();
            }
        });
        this.setButtonLayoutData(this.fSelectAllButton);
        this.fDeselectAllButton = new Button(itemComp, 8);
        this.fDeselectAllButton.setText(Messages.SelectWorkItemsPage_DESELECT_ALL_ACTION);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectWorkItemsPage.this.fItemViewer.setAllChecked(false);
                SelectWorkItemsPage.this.updatePageComplete();
            }
        });
        this.setButtonLayoutData(this.fDeselectAllButton);
        this.fNameText.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.new_work_item_template_wizard_main_page");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateTemplate();
        IWorkItem[] inputItems = ((NewWorkItemTemplateWizard)this.getWizard()).getWorkItems();
        if (inputItems != null && inputItems.length > 0) {
            this.fNameText.setEnabled(true);
            this.fDescriptionText.setEnabled(true);
            this.fItemViewer.setInput((Object)inputItems);
            this.fItemViewer.setAllChecked(true);
            this.fSelectAllButton.setEnabled(true);
            this.fDeselectAllButton.setEnabled(true);
        } else {
            this.fNameText.setEnabled(false);
            this.fDescriptionText.setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
        }
    }

    private void updatePageComplete() {
        Object[] checkedItems = this.fItemViewer.getCheckedElements();
        String templateName = this.fNameText.getText().trim();
        this.setPageComplete(templateName.length() > 0 && checkedItems != null && checkedItems.length > 0);
    }

    void updateTemplate() {
        Object[] checkedItems = this.fItemViewer.getCheckedElements();
        String templateName = this.fNameText.getText().trim();
        WorkItemTemplateDescriptor template = ((NewWorkItemTemplateWizard)this.getWizard()).getTemplateDescriptor();
        if (template != null) {
            if (templateName.length() > 0) {
                template.setName(templateName);
            }
            template.setDescription(this.fDescriptionText.getText().trim());
            if (checkedItems != null && checkedItems.length > 0) {
                ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(checkedItems.length);
                Object[] objectArray = checkedItems;
                int n = checkedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Object curItem = objectArray[n2];
                    workItems.add((IWorkItemHandle)curItem);
                    ++n2;
                }
                template.setWorkItems(workItems);
            }
        }
        this.setPageComplete(templateName.length() > 0 && checkedItems != null && checkedItems.length > 0);
    }

    private static class WorkItemContentProvider
    implements IStructuredContentProvider {
        private WorkItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkItem[] || inputElement instanceof IWorkItemHandle[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

