/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AbstractWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.InstantiateWorkItemTemplateWizard;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectWorkItemTemplatePage
extends AbstractWorkItemTemplatePage {
    private TableViewer fTableViewer;
    private Text fInfoText;
    private Combo fProjectCombo;

    protected SelectWorkItemTemplatePage(IWorkItemTemplateHandle[] availableTemplates, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.InstantiateWorkItemTemplateWizard_SELECT_TEMPLATE_PAGE_DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.initializeDialogUnits((Control)composite);
        this.createProjectAreaCombo(composite);
        Composite itemComp = this.createComposite(composite, 1, true, true);
        Label listLabel = new Label(itemComp, 16640);
        listLabel.setText(Messages.SelectWorkItemTemplatePage_TEMPLATE_LIST_LABEL);
        listLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite tableComp = new Composite(itemComp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table templateTable = new Table(tableComp, 68116);
        templateTable.setLinesVisible(true);
        ((GridData)tableComp.getLayoutData()).heightHint = 5 * templateTable.getItemHeight();
        TableColumn nameCol = new TableColumn(templateTable, 16384);
        nameCol.setMoveable(false);
        nameCol.setResizable(false);
        nameCol.pack();
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)nameCol, (ColumnLayoutData)new ColumnWeightData(100, true));
        tableComp.setLayout((Layout)tableLayout);
        this.fTableViewer = new TableViewer(templateTable);
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && inputElement instanceof IWorkItemTemplateHandle[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof IWorkItemTemplateHandle) {
                    return ((IWorkItemTemplateHandle)element).getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                    InstantiateWorkItemTemplateWizard wizard = (InstantiateWorkItemTemplateWizard)SelectWorkItemTemplatePage.this.getWizard();
                    Object selTmpl = ((StructuredSelection)sel).getFirstElement();
                    if (!selTmpl.equals(wizard.getSelectedTemplate())) {
                        SelectWorkItemTemplatePage.this.updateSelection();
                    }
                }
            }
        });
        this.restoreTemplateList(false);
        Composite infoComp = this.createComposite(composite, 1, true, true);
        Label infoLabel = new Label(infoComp, 16640);
        infoLabel.setText(Messages.SelectWorkItemTemplatePage_INFO_TEXT_LABEL);
        infoLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fInfoText = new Text(infoComp, 2584);
        this.fInfoText.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.fInfoText.getLayoutData()).heightHint = 5 * this.fInfoText.getLineHeight();
        composite.pack();
        templateTable.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.instantiate_work_item_template_wizard_select_template_page");
        Point size = composite.computeSize(-1, -1);
        this.getControl().setSize(size);
        this.getShell().setMinimumSize(size);
    }

    public boolean canFlipToNextPage() {
        IWorkItemTemplateHandle template = ((InstantiateWorkItemTemplateWizard)this.getWizard()).getSelectedTemplate();
        return template != null && template.hasVariables();
    }

    public void setVisible(boolean visible) {
        InstantiateWorkItemTemplateWizard wizard = (InstantiateWorkItemTemplateWizard)this.getWizard();
        if (wizard.getProjectArea() == null) {
            this.setErrorMessage(Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_FETCHING_TEMPLATES);
            this.setPageComplete(false);
        }
        super.setVisible(visible);
    }

    private void createProjectAreaCombo(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.SelectWorkItemTemplatePage_PROJECT_AREAS_LABEL);
        this.fProjectCombo = new Combo(container, 2060);
        this.fProjectCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fProjectCombo.setVisibleItemCount(15);
        IProjectAreaHandle defaultProj = ((InstantiateWorkItemTemplateWizard)this.getWizard()).getProjectArea();
        final List<IProjectAreaHandle> connectedProjects = ProjectAreaPicker.getAllConnectedProjectAreas(true);
        SelectWorkItemTemplatePage.restoreValuesForCombo(connectedProjects, defaultProj, this.fProjectCombo);
        this.fProjectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                InstantiateWorkItemTemplateWizard wizard = (InstantiateWorkItemTemplateWizard)SelectWorkItemTemplatePage.this.getWizard();
                IProjectAreaHandle selProj = (IProjectAreaHandle)connectedProjects.get(SelectWorkItemTemplatePage.this.fProjectCombo.getSelectionIndex());
                if (selProj != null && !selProj.getItemId().equals((Object)wizard.getProjectArea().getItemId())) {
                    wizard.setProjectArea(selProj);
                    SelectWorkItemTemplatePage.this.restoreTemplateList(true);
                    SelectWorkItemTemplatePage.this.updateSelection();
                }
            }
        });
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.new_work_item_wizard_project_area_page");
    }

    private void restoreTemplateList(boolean refresh) {
        IWorkItemTemplateHandle[] input = ((InstantiateWorkItemTemplateWizard)this.getWizard()).getAvailableTemplates(refresh);
        if (input != null) {
            this.fTableViewer.setInput((Object)input);
        }
    }

    private static void restoreValuesForCombo(List<IProjectAreaHandle> areas, IProjectAreaHandle projectArea, Combo combo) {
        if (areas.size() == 0) {
            return;
        }
        int target = 0;
        int idx = 0;
        int length = areas.size();
        while (idx < length) {
            IProjectAreaHandle cur = areas.get(idx);
            combo.add(ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), cur));
            if (cur.getItemId().equals((Object)projectArea.getItemId())) {
                target = idx;
            }
            ++idx;
        }
        combo.select(target);
    }

    private void updateSelection() {
        InstantiateWorkItemTemplateWizard wizard = (InstantiateWorkItemTemplateWizard)this.getWizard();
        wizard.resetPageCompletion();
        wizard.resetErrorMessage();
        ISelection sel = this.fTableViewer.getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
            IWorkItemTemplateHandle selTemplate = (IWorkItemTemplateHandle)((IStructuredSelection)sel).getFirstElement();
            String info = selTemplate.getDescription();
            this.fInfoText.setText(info != null ? info : "");
            wizard.setSelectedTemplate(selTemplate);
            this.setPageComplete(true);
        } else {
            this.fInfoText.setText("");
            wizard.setSelectedTemplate(null);
            this.setPageComplete(false);
        }
    }
}

