/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AssignTemplateVariablesPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.SelectWorkItemTemplatePage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiateWorkItemTemplateWizard
extends Wizard
implements INewWizard {
    private IProjectAreaHandle fProjectArea;
    private IWorkItemTemplateHandle[] fAvailableTemplates;
    private IWorkItemTemplateHandle fSelectedTemplate;
    private Map<IAttributeVariable, Object> fAttributeVariableValues;

    public InstantiateWorkItemTemplateWizard() {
        this(InstantiateWorkItemTemplateWizard.getDefaultProjectArea());
    }

    public InstantiateWorkItemTemplateWizard(IProjectAreaHandle projectArea) {
        if (projectArea != null) {
            this.fProjectArea = projectArea;
        }
        this.setDefaultPageImageDescriptor(ImagePool.INSTANTIATE_WORKITEM_TEMPLATE_WIZARD);
        this.setWindowTitle(Messages.InstantiateWorkItemTemplateWizard_WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    void setProjectArea(IProjectAreaHandle prj) {
        this.fProjectArea = prj;
    }

    IWorkItemTemplateHandle[] getAvailableTemplates(boolean refresh) {
        if (this.fAvailableTemplates == null || refresh) {
            this.fAvailableTemplates = this.fetchAvailableTemplates();
        }
        return this.fAvailableTemplates != null ? this.fAvailableTemplates : new IWorkItemTemplateHandle[]{};
    }

    IWorkItemTemplateHandle getSelectedTemplate() {
        return this.fSelectedTemplate;
    }

    void setSelectedTemplate(IWorkItemTemplateHandle template) {
        this.fSelectedTemplate = template;
        this.fAttributeVariableValues = null;
    }

    void setAttributeVariableValue(IAttributeVariable variable, Object value) {
        if (this.fAttributeVariableValues == null) {
            this.fAttributeVariableValues = new HashMap<IAttributeVariable, Object>();
        }
        this.fAttributeVariableValues.put(variable, value);
    }

    Map<IAttributeVariable, Object> getAttributeVariableValues() {
        return this.fAttributeVariableValues != null ? this.fAttributeVariableValues : Collections.emptyMap();
    }

    public void addPages() {
        super.addPage((IWizardPage)new SelectWorkItemTemplatePage(this.fAvailableTemplates, "selectWorkItemTemplatePage", Messages.InstantiateWorkItemTemplateWizard_SELECT_TEMPLATE_PAGE_TITLE, null));
        super.addPage((IWizardPage)new AssignTemplateVariablesPage("assignTemplateVariablesPage", Messages.InstantiateWorkItemTemplateWizard_VARIABLES_PAGE_TITLE, null));
    }

    public boolean performFinish() {
        try {
            final ArrayList workItems = new ArrayList();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    try {
                        try {
                            progress.beginTask("", 2);
                            Map vars = InstantiateWorkItemTemplateWizard.this.fAttributeVariableValues != null ? InstantiateWorkItemTemplateWizard.this.fAttributeVariableValues : Collections.emptyMap();
                            ITeamRepository repository = (ITeamRepository)InstantiateWorkItemTemplateWizard.this.fProjectArea.getOrigin();
                            IWorkItemTemplateClient templateClient = (IWorkItemTemplateClient)repository.getClientLibrary(IWorkItemTemplateClient.class);
                            int[] itemIDs = templateClient.instantiateTemplate(InstantiateWorkItemTemplateWizard.this.fSelectedTemplate.getId(), vars, InstantiateWorkItemTemplateWizard.this.fProjectArea, (IProgressMonitor)progress);
                            progress.worked(1);
                            if (itemIDs != null && itemIDs.length > 0) {
                                IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                                SubProgressMonitor sub = new SubProgressMonitor((IProgressMonitor)progress, itemIDs.length);
                                int idx = 0;
                                while (idx < itemIDs.length) {
                                    if (sub.isCanceled()) break;
                                    workItems.add(client.findWorkItemById(itemIDs[idx], IWorkItem.DEFAULT_PROFILE, (IProgressMonitor)sub));
                                    sub.worked(1);
                                    ++idx;
                                }
                            }
                            progress.worked(1);
                        }
                        catch (TeamRepositoryException ex) {
                            throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            }
            WorkItemUI.showWorkItems(window, this.fProjectArea, this.fSelectedTemplate.getName(), workItems.toArray(new IWorkItemHandle[workItems.size()]));
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw new OperationCanceledException(ex.getLocalizedMessage());
            }
            WizardPage curPage = (WizardPage)this.getContainer().getCurrentPage();
            if (curPage != null) {
                String reason;
                String string = reason = ex instanceof InvocationTargetException && ex.getCause() != null ? ex.getCause().getLocalizedMessage() : ex.getLocalizedMessage();
                if (reason == null) {
                    curPage.setErrorMessage(Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_INSTANTIATE_TEMPLATE);
                } else {
                    curPage.setErrorMessage(NLS.bind((String)Messages.InstantiateWorkItemTemplateWizard_ERROR_REASON_INSTANTIATE_TEMPLATE, (Object)Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_INSTANTIATE_TEMPLATE, (Object[])new Object[]{reason}));
                }
                curPage.setPageComplete(false);
            }
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        if (this.fSelectedTemplate != null && !this.fSelectedTemplate.hasVariables()) {
            return true;
        }
        return super.canFinish();
    }

    void resetErrorMessage() {
        IWizardPage[] pages = this.getPages();
        if (pages != null) {
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage cur = iWizardPageArray[n2];
                ((WizardPage)cur).setErrorMessage(null);
                ++n2;
            }
        }
    }

    void resetPageCompletion() {
        IWizardPage[] pages = this.getPages();
        if (pages != null) {
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage cur = iWizardPageArray[n2];
                ((WizardPage)cur).setPageComplete(false);
                ++n2;
            }
        }
    }

    private IWorkItemTemplateHandle[] fetchAvailableTemplates() {
        HashSet result;
        block3: {
            result = new HashSet();
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                        try {
                            try {
                                progress.beginTask("", 3);
                                this.ensureValidLogin((IProgressMonitor)progress);
                                progress.worked(1);
                                ITeamRepository repository = (ITeamRepository)InstantiateWorkItemTemplateWizard.this.fProjectArea.getOrigin();
                                IWorkItemTemplateClient templateClient = (IWorkItemTemplateClient)repository.getClientLibrary(IWorkItemTemplateClient.class);
                                String[] templIDs = templateClient.getAvailableTemplates(InstantiateWorkItemTemplateWizard.this.fProjectArea, (IProgressMonitor)progress);
                                progress.worked(1);
                                SubProgressMonitor sub = new SubProgressMonitor((IProgressMonitor)progress, templIDs.length);
                                String[] stringArray = templIDs;
                                int n = templIDs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String curID = stringArray[n2];
                                    if (sub.isCanceled()) break;
                                    IWorkItemTemplateHandle curTempl = templateClient.getTemplate(curID, InstantiateWorkItemTemplateWizard.this.fProjectArea, (IProgressMonitor)sub);
                                    if (curTempl != null) {
                                        result.add(curTempl);
                                    }
                                    sub.worked(1);
                                    ++n2;
                                }
                                sub.done();
                                progress.worked(1);
                            }
                            catch (TeamRepositoryException ex) {
                                throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                            }
                        }
                        finally {
                            progress.done();
                        }
                    }

                    private void ensureValidLogin(IProgressMonitor monitor) throws TeamRepositoryException {
                        if (InstantiateWorkItemTemplateWizard.this.fProjectArea == null) {
                            throw new TeamRepositoryException(Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_FETCHING_TEMPLATES);
                        }
                        SubProgressMonitor subMon = new SubProgressMonitor(monitor, 1);
                        ITeamRepository repo = (ITeamRepository)InstantiateWorkItemTemplateWizard.this.fProjectArea.getOrigin();
                        if (!repo.loggedIn()) {
                            repo.login((IProgressMonitor)subMon);
                        }
                        subMon.done();
                    }
                });
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    throw new OperationCanceledException(ex.getLocalizedMessage());
                }
                WizardPage curPage = (WizardPage)this.getContainer().getCurrentPage();
                if (curPage == null) break block3;
                curPage.setErrorMessage(Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_FETCHING_TEMPLATES);
                curPage.setPageComplete(false);
            }
        }
        return result.toArray(new IWorkItemTemplateHandle[result.size()]);
    }

    private static IProjectAreaHandle getDefaultProjectArea() {
        IProjectAreaHandle result = ConnectedProjectAreas.getInstance().getDefaultProjectArea(true);
        if (result == null) {
            result = ConnectedProjectAreas.getInstance().getDefaultProjectAreaFallback(true);
        }
        return result;
    }
}

