/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AbstractWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.WorkItemTemplateImportWizard;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWorkItemTemplateMainPage
extends AbstractWorkItemTemplatePage {
    private static final String ALL_SUFFIX = ".*";
    private static final String XML_SUFFIX = ".xml";
    private Combo fProjectCombo;
    private Combo fFileCombo;

    protected ImportWorkItemTemplateMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ImportWorkItemTemplateWizard_MAIN_PAGE_DECRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, true);
        this.initializeDialogUnits((Control)composite);
        this.createFileGroup(composite);
        this.createProjectAreaCombo(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.import_work_item_template_wizard_main_page");
        this.updatePageComplete(false);
    }

    private void createFileGroup(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.ImportWorkItemTemplateWizard_FILE_LABEL);
        Composite fileComposite = this.createComposite(container, 2, true, false);
        this.fFileCombo = new Combo(fileComposite, 2052);
        this.fFileCombo.setVisibleItemCount(15);
        this.fFileCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportWorkItemTemplateMainPage.this.updatePageComplete(true);
            }
        });
        Button browseReadFile = new Button(fileComposite, 8);
        browseReadFile.setText(Messages.ImportWorkItemTemplateWizard_MAIN_PAGE_BROWSE_LABEL);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalIndent = 5;
        browseReadFile.setLayoutData((Object)gridData);
        browseReadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportWorkItemTemplateMainPage.this.onBrowseFile();
            }
        });
        this.setButtonLayoutData(browseReadFile);
    }

    private void createProjectAreaCombo(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.ImportWorkItemTemplateWizard_PROJECT_AREAS_LABEL);
        this.fProjectCombo = new Combo(container, 2060);
        this.fProjectCombo.setVisibleItemCount(15);
        this.fProjectCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        IProjectAreaHandle defaultProj = ((WorkItemTemplateImportWizard)this.getWizard()).getSelectedProject();
        final List<IProjectAreaHandle> connectedProjects = ProjectAreaPicker.getAllConnectedProjectAreas(true);
        ImportWorkItemTemplateMainPage.restoreValuesForCombo(connectedProjects, defaultProj, this.fProjectCombo);
        this.fProjectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                IProjectAreaHandle selProj = (IProjectAreaHandle)connectedProjects.get(ImportWorkItemTemplateMainPage.this.fProjectCombo.getSelectionIndex());
                ((WorkItemTemplateImportWizard)ImportWorkItemTemplateMainPage.this.getWizard()).setSelectedProject(selProj);
                ImportWorkItemTemplateMainPage.this.updatePageComplete(true);
            }
        });
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.new_work_item_wizard_project_area_page");
    }

    private void updatePageComplete(boolean showErrors) {
        if (!this.isControlCreated()) {
            return;
        }
        String message = null;
        if (this.fFileCombo.getText().length() == 0) {
            message = Messages.ImportWorkItemTemplateWizard_MAIN_PAGE_ERROR_ENTER_FILE;
        } else if (((WorkItemTemplateImportWizard)this.getWizard()).getSelectedProject() == null) {
            message = Messages.ImportWorkItemTemplateWizard_MAIN_PAGE_ERROR_SELECTED_PROJECT;
        }
        this.setPageComplete(message == null);
        this.setMessage(showErrors ? message : null, 2);
    }

    private void onBrowseFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String res = dialog.open();
        if (res != null) {
            Path path = new Path(dialog.getFilterPath());
            path = path.addTrailingSeparator();
            String fileName = dialog.getFileName();
            this.fFileCombo.add(String.valueOf(path.toOSString()) + fileName);
            int pos = this.fFileCombo.getItems().length - 1;
            if (pos >= 0) {
                this.fFileCombo.select(pos);
            }
            ((WorkItemTemplateImportWizard)this.getWizard()).setImportFile(new File(String.valueOf(path.toOSString()) + fileName));
            this.updatePageComplete(true);
        }
    }

    private static void restoreValuesForCombo(List<IProjectAreaHandle> areas, IProjectAreaHandle projectArea, Combo combo) {
        if (areas.size() == 0) {
            return;
        }
        int target = 0;
        int idx = 0;
        int length = areas.size();
        while (idx < length) {
            IProjectAreaHandle cur = areas.get(idx);
            combo.add(ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), cur));
            if (cur.getItemId().equals((Object)projectArea.getItemId())) {
                target = idx;
            }
            ++idx;
        }
        combo.select(target);
    }
}

