/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.team.workitem.common.internal.identifiers.IIdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IInternalAttributeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IInternalTypeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.template.AttributeVariable;
import com.ibm.team.workitem.common.internal.template.TemplateIdentifierRegistry;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AbstractWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.NewWorkItemTemplateWizard;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DefineTemplateVariablesPage
extends AbstractWorkItemTemplatePage {
    private Button fCategoryCheck;
    private Button fIterationCheck;

    protected DefineTemplateVariablesPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.NewWorkItemTemplateWizard_VARIABLES_PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, true);
        this.initializeDialogUnits((Control)composite);
        Group attrGroup = new Group(composite, 4);
        attrGroup.setText(Messages.DefineTemplateAttributesPage_VARIABLE_GROUP_LABEL);
        GridLayout layout = new GridLayout();
        attrGroup.setLayout((Layout)layout);
        attrGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fIterationCheck = new Button((Composite)attrGroup, 32);
        this.fIterationCheck.setText(Messages.DefineTemplateAttributesPage_CHECK_ITERATION_ACTION);
        this.fIterationCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DefineTemplateVariablesPage.this.updateTemplate();
                DefineTemplateVariablesPage.this.fIterationCheck.setFocus();
            }
        });
        this.setButtonLayoutData(this.fIterationCheck);
        this.fCategoryCheck = new Button((Composite)attrGroup, 32);
        this.fCategoryCheck.setText(Messages.DefineTemplateAttributesPage_CHECK_CATEGORY_ACTION);
        this.fCategoryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DefineTemplateVariablesPage.this.updateTemplate();
                DefineTemplateVariablesPage.this.fCategoryCheck.setFocus();
            }
        });
        this.setButtonLayoutData(this.fCategoryCheck);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.new_work_item_template_variables_page");
    }

    private void updateTemplate() {
        WorkItemTemplateDescriptor template = ((NewWorkItemTemplateWizard)this.getWizard()).getTemplateDescriptor();
        if (template != null) {
            Identifier pubType;
            Identifier pubAttr;
            IIdentifierMapping identifiers = IdentifierMapping.create(TemplateIdentifierRegistry.class);
            ArrayList<AttributeVariable> variables = new ArrayList<AttributeVariable>();
            if (this.fCategoryCheck.getSelection()) {
                pubAttr = identifiers.getPublicIdentifier(IInternalAttributeIdentifiers.WORKITEM_CATEGORY);
                pubType = identifiers.getPublicIdentifier(IInternalTypeIdentifiers.CATEGORY);
                variables.add(new AttributeVariable(pubAttr, pubType));
            }
            if (this.fIterationCheck.getSelection()) {
                pubAttr = identifiers.getPublicIdentifier(IInternalAttributeIdentifiers.WORKITEM_ITERATION);
                pubType = identifiers.getPublicIdentifier(IInternalTypeIdentifiers.ITERATION);
                variables.add(new AttributeVariable(pubAttr, pubType));
            }
            template.setVariables(variables.toArray(new IAttributeVariable[variables.size()]));
        }
    }
}

