/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.templates;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.identifiers.IIdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.template.TemplateIdentifierRegistry;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.ITemplateTypeIdentifiers;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ItemSelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.AbstractWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.InstantiateWorkItemTemplateWizard;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignTemplateVariablesPage
extends AbstractWorkItemTemplatePage {
    private Composite fComposite;
    private Map<IAttributeVariable, Object> fNullValues = new HashMap<IAttributeVariable, Object>();
    private IAttribute fCurrentAttribute;
    private Object fCurrentAttributeDefaultValue;

    protected AssignTemplateVariablesPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.InstantiateWorkItemTemplateWizard_VARIABLES_PAGE_DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.fComposite = this.createComposite(parent, 1, true, false);
        this.initializeDialogUnits((Control)this.fComposite);
        this.setControl((Control)this.fComposite);
        Dialog.applyDialogFont((Control)this.fComposite);
        HelpContextIds.hookHelpListener((Control)this.fComposite, "com.ibm.team.workitem.rcp.ui.instantiate_work_item_template_wizard_variables_page");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.createVariableWidgets();
        } else {
            Control[] controlArray = this.fComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cur = controlArray[n2];
                cur.dispose();
                ++n2;
            }
        }
    }

    private void createVariableWidgets() {
        IWorkItemTemplateHandle template = this.getParentWizard().getSelectedTemplate();
        List variables = null;
        if (template != null && template.hasVariables()) {
            variables = template.getVariables();
            Composite varComp = this.createComposite(this.fComposite, 3, true, false);
            for (final IAttributeVariable curVar : variables) {
                this.initializeAttributeAndValues(curVar);
                if (this.fCurrentAttribute == null) continue;
                Label varLabel = new Label(varComp, 0);
                varLabel.setLayoutData((Object)new GridData(32));
                varLabel.setText(NLS.bind((String)Messages.AssignTemplateVariablesPage_VARIABLE_LABEL, (Object)this.fCurrentAttribute.getDisplayName(), (Object[])new Object[0]));
                final Text varValue = new Text(varComp, 2056);
                varValue.setLayoutData((Object)new GridData(768));
                SimpleCategoryLabelProvider labelProvider = this.fCurrentAttribute.getAttributeType().equals("category") ? new SimpleCategoryLabelProvider() : (this.fCurrentAttribute.getAttributeType().equals("interval") ? new SimpleIterationLabelProvider() : new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
                Object curVarValue = this.getParentWizard().getAttributeVariableValues().get(curVar);
                if (curVarValue == null) {
                    curVarValue = this.fCurrentAttributeDefaultValue;
                }
                varValue.setText(labelProvider.getText(curVarValue));
                Button varBtn = new Button(varComp, 0);
                varBtn.setLayoutData((Object)new GridData(128));
                varBtn.setText(Messages.AssignTemplateVariablesPage_SELECT_BUTTON_LABEL);
                varBtn.addSelectionListener((SelectionListener)new SelectionAdapter((ILabelProvider)labelProvider){
                    private final /* synthetic */ ILabelProvider val$labelProvider;
                    {
                        this.val$labelProvider = iLabelProvider;
                    }

                    public void widgetSelected(SelectionEvent evt) {
                        try {
                            ICategory value = null;
                            if (curVar.getType().equals((Object)ITemplateTypeIdentifiers.CATEGORY)) {
                                value = ItemSelectionDialog.getCategory(AssignTemplateVariablesPage.this.getShell(), AssignTemplateVariablesPage.this.getParentWizard().getProjectArea(), null, value, false);
                            } else if (curVar.getType().equals((Object)ITemplateTypeIdentifiers.ITERATION)) {
                                value = ItemSelectionDialog.getIteration(AssignTemplateVariablesPage.this.getShell(), AssignTemplateVariablesPage.this.getParentWizard().getProjectArea(), null, (IIteration)value);
                            }
                            if (value != null) {
                                varValue.setText(this.val$labelProvider.getText((Object)value));
                                AssignTemplateVariablesPage.this.getParentWizard().setAttributeVariableValue(curVar, value);
                                AssignTemplateVariablesPage.this.updateVariableValues();
                            } else {
                                String error = String.valueOf(curVar.getType().getStringIdentifier()) + ": " + Messages.AssignTemplateVariablesPage_ERROR_ON_BINDING_VARIABLE;
                                AssignTemplateVariablesPage.this.setErrorMessage(error);
                                AssignTemplateVariablesPage.this.setPageComplete(false);
                            }
                        }
                        catch (OperationCanceledException operationCanceledException) {}
                    }
                });
                this.getParentWizard().setAttributeVariableValue(curVar, curVarValue);
            }
            this.updateVariableValues();
            varComp.pack();
        }
        Dialog.applyDialogFont((Control)this.fComposite);
        this.fComposite.getParent().layout(true, true);
    }

    protected void updateVariableValues() {
        Map<IAttributeVariable, Object> variableValues = this.getParentWizard().getAttributeVariableValues();
        if (variableValues != null && !variableValues.isEmpty()) {
            boolean result = true;
            for (Map.Entry<IAttributeVariable, Object> entry : variableValues.entrySet()) {
                Object nullValue;
                Object curValue = entry.getValue();
                if (!this.equals(curValue, nullValue = this.fNullValues.get(entry.getKey()))) continue;
                result = false;
                break;
            }
            this.setPageComplete(result);
        }
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        return left.equals(right);
    }

    private void initializeAttributeAndValues(final IAttributeVariable var) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IProjectAreaHandle projectArea = AssignTemplateVariablesPage.this.getParentWizard().getProjectArea();
                    ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    try {
                        try {
                            progress.beginTask("", 3);
                            String attrIdentifier = AssignTemplateVariablesPage.this.getInternalAttributeIdentifier(var).getStringIdentifier();
                            if (attrIdentifier != null) {
                                IWorkItemCommon itemClient = (IWorkItemCommon)repository.getClientLibrary(IWorkItemClient.class);
                                AssignTemplateVariablesPage.this.fCurrentAttribute = itemClient.findAttribute(projectArea, attrIdentifier, (IProgressMonitor)progress);
                                progress.worked(1);
                                IAuditableClient auditClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                                AssignTemplateVariablesPage.this.fCurrentAttributeDefaultValue = AssignTemplateVariablesPage.this.fCurrentAttribute.getDefaultValue((IAuditableCommon)auditClient, null, (IProgressMonitor)progress);
                                progress.worked(1);
                                AssignTemplateVariablesPage.this.fNullValues.put(var, AssignTemplateVariablesPage.this.fCurrentAttribute.getNullValue((IAuditableCommon)auditClient, (IProgressMonitor)progress));
                                progress.worked(1);
                            }
                        }
                        catch (TeamRepositoryException ex) {
                            throw new InvocationTargetException(ex, ex.getLocalizedMessage());
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw new OperationCanceledException(ex.getLocalizedMessage());
            }
            this.setErrorMessage(Messages.InstantiateWorkItemTemplateWizard_ERROR_ON_FETCHING_ATTRIBUTE_VALUES);
            this.setPageComplete(false);
        }
    }

    private Identifier<IItem> getInternalAttributeIdentifier(IAttributeVariable variable) throws IllegalArgumentException {
        IIdentifierMapping mapping = IdentifierMapping.create(TemplateIdentifierRegistry.class);
        Identifier result = null;
        if (variable.getIdentifier() != null) {
            result = mapping.getInternalIdentifier(variable.getIdentifier());
        }
        if (result == null) {
            throw new IllegalArgumentException(Messages.AssignTemplateVariablesPage_ERROR_ON_BINDING_VARIABLE);
        }
        return result;
    }

    private InstantiateWorkItemTemplateWizard getParentWizard() {
        return (InstantiateWorkItemTemplateWizard)this.getWizard();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CategoryComparator
    implements Comparator<Object> {
        private CategoryComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return Collator.getInstance().compare((String)o1, (String)o2);
            }
            if (!(o1 instanceof ICategory)) {
                return 1;
            }
            if (!(o2 instanceof ICategory)) {
                return -1;
            }
            ICategory category1 = (ICategory)o1;
            ICategory category2 = (ICategory)o2;
            if (category1.isUnassigned()) {
                return -1;
            }
            if (category2.isUnassigned()) {
                return 1;
            }
            return category1.getCategoryId().compareTo(category2.getCategoryId());
        }
    }

    private final class SimpleCategoryLabelProvider
    extends LabelProvider {
        private SimpleCategoryLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return DefaultModel.NULL_CATEGORY_NAME;
            }
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof CategoryId) {
                return CategoriesHelper.getHierarchicalName((CategoryId)((CategoryId)element));
            }
            ICategory category = (ICategory)element;
            String name = CategoriesHelper.getHierarchicalName((CategoryId)category.getCategoryId());
            if (name.equals("")) {
                return category.getName();
            }
            return name;
        }
    }

    private final class SimpleIterationLabelProvider
    extends LabelProvider {
        private SimpleIterationLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return IWorkItem.UNASSIGNED_TARGET_NAME;
            }
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof IIteration) {
                IIteration interval = (IIteration)element;
                return interval.getLabel();
            }
            return IWorkItem.UNASSIGNED_TARGET_NAME;
        }
    }
}

