/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.inport;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaImporter;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaLogStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.csv.CSVBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.SettingsHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.WizardHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.inport.ImportWorkItemsMainPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.inport.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class WorkItemImportWizard
extends Wizard
implements IImportWizard {
    private static final String MAIN_PAGE_ID = "workItemsImportMainPage";
    private ImportWorkItemsMainPage fMainPage;

    public WorkItemImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ImagePool.WORKITEM_IMPORT_WIZARD);
        this.setWindowTitle(Messages.WorkItemImportWizard_IMPORT_WORKITEMS);
    }

    public void addPages() {
        this.fMainPage = new ImportWorkItemsMainPage(MAIN_PAGE_ID, Messages.WorkItemImportWizard_IMPORT_WORKITEMS, null);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        IProjectAreaHandle projectArea = this.fMainPage.getProjectArea();
        BugzillaConfiguration.Mode importMode = this.fMainPage.getImportMode();
        String csvFile = this.fMainPage.getCSVFile();
        String[] csvFileList = this.fMainPage.getCSVFileList();
        String delimiter = this.fMainPage.getDelimiter();
        boolean useCustomMapping = this.fMainPage.useCustomMapping();
        String customMappingFile = this.fMainPage.getCustomMappingFile();
        String[] customMappingFileList = this.fMainPage.getCustomMappingFileList();
        SettingsHelper.saveWorkItemImportWizardSettings(projectArea != null ? projectArea.getItemId().getUuidValue() : null, importMode.name(), csvFile, csvFileList, delimiter, useCustomMapping, customMappingFile, customMappingFileList);
        if (!WizardHelper.requestUserConfirmation(this.getContainer().getShell(), projectArea, importMode != BugzillaConfiguration.Mode.CREATE)) {
            return false;
        }
        BugzillaConfiguration configuration = new BugzillaConfiguration(projectArea);
        configuration.setImportMode(importMode);
        if (!useCustomMapping) {
            customMappingFile = null;
        }
        IRunnableWithProgress runnable = this.getImportRunnable(configuration, csvFile, delimiter, customMappingFile);
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            Object status = null;
            status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.WorkItemImportWizard_ERROR_IMPORT_WORKITEMS, t);
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.WorkItemImportWizard_ERROR_IMPORT_WORKITEMS, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getImportRunnable(final BugzillaConfiguration configuration, final String csvFile, final String delim, final String customMappingFile) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (customMappingFile != null && new File(customMappingFile).exists()) {
                    try {
                        URL url = new File(customMappingFile).toURL();
                        BugzillaMapping customMapping = BugzillaMapping.readMapping((String)url.toString());
                        configuration.setMapping(customMapping);
                    }
                    catch (MalformedURLException x) {
                        throw new InvocationTargetException(x);
                    }
                    catch (TeamRepositoryException x) {
                        throw new InvocationTargetException(x);
                    }
                }
                try {
                    configuration.setMapping(BugzillaMapping.readDefaultMapping((BugzillaConfiguration)configuration, (IProgressMonitor)monitor));
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
                BugzillaImporter importer = new BugzillaImporter(configuration);
                BugzillaLogStatusMonitor statusMonitor = new BugzillaLogStatusMonitor();
                try {
                    importer.doImport((IBugRetrievalStrategy)new CSVBugRetrievalStrategy(csvFile, delim), (IBugzillaStatusMonitor)statusMonitor, monitor);
                }
                catch (OperationCanceledException x) {
                    IStatus status = statusMonitor.getStatus();
                    if (status.isOK()) {
                        throw x;
                    }
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                IStatus status = statusMonitor.getStatus();
                if (!status.isOK()) {
                    throw new InvocationTargetException(new CoreException(status));
                }
            }
        };
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

