/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.inport;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import com.ibm.team.workitem.rcp.core.internal.csv.CSVBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.SettingsHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.WizardHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.inport.Messages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;

public class ImportWorkItemsMainPage
extends WizardPage {
    public static final String MEMENTO_WORKITEM = "workitemimport";
    public static final String WORKITEM_IMPORT_SECTION = "workitemimportsection";
    public static final String MEMENTO_WORKITEM_CSV_READFILELIST = "importfilelistcsv";
    public static final String MEMENTO_WORKITEM_CSV_READFILE = "importfile";
    public static final String MEMENTO_WORKITEM_DELIMITER = "delimiter";
    public static final String MEMENTO_WORKITEM_IS_UPDATE = "isupdate";
    public static final String MEMENTO_WORKITEM_USE_CUSTOM_MAPPING = "usecustommapping";
    public static final String MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE = "custommappingfile";
    public static final String MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE_LIST = "custommappingfilelist";
    public static final String MEMENTO_WORKITEM_PROJECT_AREA = "projectarea";
    private static final String CSV_SUFFIX = ".csv";
    private static final String ALL_SUFFIX = ".*";
    private static final String XML_SUFFIX = ".xml";
    private static final String TAB = "\t";
    private static final String COMMA = ",";
    private static final String DEFAULT_MAPPING_FILE_NAME = "csv_mapping.xml";
    private Combo fCSVFileCombo;
    private Button fTabDelimiterCheck;
    private Button fCommaDelimiterCheck;
    private Button fUseCustomMapping;
    private Hyperlink fSaveDefaultCustomMappingLink;
    private Hyperlink fComputeCustomMappingLink;
    private Combo fCustomMappingFile;
    private Label fCustomMappingFileLabel;
    private Button fBrowseCustomMappingFile;
    private Combo fProjectAreaCombo;
    private Button fUpdateExistingCheck;
    private Button fCreateNewCheck;
    private IProjectAreaHandle[] fProjectAreas;
    private Button fOtherDelimiterCheck;
    private Text fOtherDelimiterInput;
    private Button fUpdateOrCreateCheck;

    protected ImportWorkItemsMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ImportWorkItemsMainPage_SPECIFY_CSV_FILE);
    }

    IProjectAreaHandle getProjectArea() {
        int index = this.fProjectAreaCombo.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fProjectAreas[index];
    }

    BugzillaConfiguration.Mode getImportMode() {
        if (this.fCreateNewCheck.getSelection()) {
            return BugzillaConfiguration.Mode.CREATE;
        }
        if (this.fUpdateExistingCheck.getSelection()) {
            if (this.fUpdateOrCreateCheck.getSelection()) {
                return BugzillaConfiguration.Mode.UPDATE_OR_CREATE;
            }
            return BugzillaConfiguration.Mode.UPDATE;
        }
        return BugzillaConfiguration.Mode.CREATE;
    }

    String getCSVFile() {
        return this.fCSVFileCombo.getText();
    }

    String[] getCSVFileList() {
        return this.fCSVFileCombo.getItems();
    }

    String getDelimiter() {
        if (this.fTabDelimiterCheck.getSelection()) {
            return TAB;
        }
        if (this.fCommaDelimiterCheck.getSelection()) {
            return COMMA;
        }
        String otherDelimiter = this.fOtherDelimiterInput.getText();
        return otherDelimiter.length() > 0 ? otherDelimiter : TAB;
    }

    boolean useCustomMapping() {
        return this.fUseCustomMapping.getSelection();
    }

    String getCustomMappingFile() {
        return this.fCustomMappingFile.getText();
    }

    String[] getCustomMappingFileList() {
        return this.fCustomMappingFile.getItems();
    }

    public void createControl(Composite parent) {
        Composite composite = WizardHelper.createComposite(parent, 1, true);
        this.initializeDialogUnits((Control)composite);
        this.createFileGroup(composite);
        this.createDestinationGroup(composite);
        this.createCustomDataMappingGroup(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.workitem_import_wizard_main_page");
        this.updatePageComplete(false);
    }

    private void createFileGroup(Composite composite) {
        Group locationGroup = new Group(composite, 0);
        locationGroup.setLayout((Layout)new GridLayout());
        locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        locationGroup.setText(Messages.ImportWorkItemsMainPage_GROUP_FILE);
        Composite fileComposite = WizardHelper.createComposite((Composite)locationGroup, 2, true);
        this.fCSVFileCombo = new Combo(fileComposite, 2052);
        this.fCSVFileCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        String[] readFiles = SettingsHelper.restoreListSettings(MEMENTO_WORKITEM_CSV_READFILELIST, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        String readFile = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CSV_READFILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        this.restoreValuesForCombo(readFiles, readFile, this.fCSVFileCombo);
        this.fCSVFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportWorkItemsMainPage.this.updatePageComplete();
            }
        });
        Button browseReadFile = new Button(fileComposite, 8);
        browseReadFile.setText(Messages.ImportWorkItemsMainPage_BROWSE);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalIndent = 5;
        browseReadFile.setLayoutData((Object)gridData);
        browseReadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportWorkItemsMainPage.this.onBrowseCSVFile();
            }
        });
        Composite delimContainer = new Composite(fileComposite, 0);
        delimContainer.setLayoutData((Object)new GridData(4, 2, false, false));
        delimContainer.setLayout((Layout)new GridLayout(5, false));
        ((GridLayout)delimContainer.getLayout()).marginWidth = 0;
        ((GridLayout)delimContainer.getLayout()).marginHeight = 0;
        Label delimLabel = new Label(delimContainer, 0);
        delimLabel.setText(Messages.ImportWorkItemsMainPage_DELIMITER);
        delimLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.fTabDelimiterCheck = new Button(delimContainer, 16);
        this.fTabDelimiterCheck.setText(Messages.ImportWorkItemsMainPage_TAB);
        this.fTabDelimiterCheck.setLayoutData((Object)new GridData(1, 2, false, false));
        this.fCommaDelimiterCheck = new Button(delimContainer, 16);
        this.fCommaDelimiterCheck.setText(Messages.ImportWorkItemsMainPage_COMMA);
        this.fCommaDelimiterCheck.setLayoutData((Object)new GridData(1, 2, false, false));
        this.fOtherDelimiterCheck = new Button(delimContainer, 16);
        this.fOtherDelimiterCheck.setText(Messages.ImportWorkItemsMainPage_OTHER);
        this.fOtherDelimiterCheck.setLayoutData((Object)new GridData(1, 2, false, false));
        this.fOtherDelimiterInput = new Text(delimContainer, 2052);
        this.fOtherDelimiterInput.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.fOtherDelimiterInput.getLayoutData()).widthHint = 64;
        this.fOtherDelimiterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsMainPage.this.fOtherDelimiterInput.setEnabled(ImportWorkItemsMainPage.this.fOtherDelimiterCheck.getSelection());
                if (ImportWorkItemsMainPage.this.fOtherDelimiterCheck.getSelection()) {
                    ImportWorkItemsMainPage.this.fOtherDelimiterInput.setFocus();
                }
            }
        });
        String delimiterSetting = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_DELIMITER, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (delimiterSetting == null) {
            delimiterSetting = TAB;
        }
        if (TAB.equals(delimiterSetting)) {
            this.fTabDelimiterCheck.setSelection(true);
        } else if (COMMA.equals(delimiterSetting)) {
            this.fCommaDelimiterCheck.setSelection(true);
        } else {
            this.fOtherDelimiterCheck.setSelection(true);
            this.fOtherDelimiterInput.setText(delimiterSetting);
        }
        this.fOtherDelimiterInput.setEnabled(this.fOtherDelimiterCheck.getSelection());
    }

    private void createDestinationGroup(Composite composite) {
        Group destinationGroup = new Group(composite, 0);
        destinationGroup.setLayout((Layout)new GridLayout(2, false));
        destinationGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        destinationGroup.setText(Messages.ImportWorkItemsMainPage_DESTINATION);
        this.fProjectAreas = WizardHelper.getLoggedInProjectAreas();
        String selectedProjectArea = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_PROJECT_AREA, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        WizardHelper.createLabel((Composite)destinationGroup, Messages.ImportWorkItemsMainPage_PROJECT_AREA);
        this.fProjectAreaCombo = WizardHelper.createProjectAreaCombo((Composite)destinationGroup, this.fProjectAreas, selectedProjectArea);
        Label infoLabel = new Label((Composite)destinationGroup, 64);
        infoLabel.setText(Messages.ImportWorkItemsMainPage_DESTINATION_INFO_MSG);
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        infoLabel.setLayoutData((Object)gridData);
        this.fCreateNewCheck = new Button((Composite)destinationGroup, 16);
        this.fCreateNewCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fCreateNewCheck.setText(Messages.ImportWorkItemsMainPage_CREATE_NEW_WORKITEMS);
        this.fUpdateExistingCheck = new Button((Composite)destinationGroup, 16);
        this.fUpdateExistingCheck.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.fUpdateExistingCheck.setText(Messages.ImportWorkItemsMainPage_UPDATE_EXISTING_WORKITEMS);
        this.fUpdateExistingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsMainPage.this.fUpdateOrCreateCheck.setEnabled(ImportWorkItemsMainPage.this.fUpdateExistingCheck.getSelection());
            }
        });
        this.fUpdateOrCreateCheck = new Button((Composite)destinationGroup, 32);
        this.fUpdateOrCreateCheck.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        ((GridData)this.fUpdateOrCreateCheck.getLayoutData()).horizontalIndent = 15;
        this.fUpdateOrCreateCheck.setText(Messages.ImportWorkItemsMainPage_ImportWorkItemsMainPage_UPDATE_OR_CREATE_WORKITEMS);
        String importMode = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_IS_UPDATE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (importMode == null || BugzillaConfiguration.Mode.CREATE.name().equals(importMode)) {
            this.fCreateNewCheck.setSelection(true);
        } else if (BugzillaConfiguration.Mode.UPDATE.name().equals(importMode) || BugzillaConfiguration.Mode.UPDATE_OR_CREATE.name().equals(importMode)) {
            this.fUpdateExistingCheck.setSelection(true);
        }
        if (BugzillaConfiguration.Mode.UPDATE_OR_CREATE.name().equals(importMode)) {
            this.fUpdateOrCreateCheck.setSelection(true);
        }
        this.fUpdateOrCreateCheck.setEnabled(this.fUpdateExistingCheck.getSelection());
        Label legendLabel = new Label((Composite)destinationGroup, 64);
        legendLabel.setText(Messages.ImportWorkItemsMainPage_UPDATE_LEGEND);
        legendLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        ((GridData)legendLabel.getLayoutData()).horizontalSpan = 2;
        ((GridData)legendLabel.getLayoutData()).widthHint = 64;
        ((GridData)legendLabel.getLayoutData()).verticalIndent = 5;
    }

    private void createCustomDataMappingGroup(Composite composite) {
        Group mappingGroup = new Group(composite, 0);
        mappingGroup.setLayout((Layout)new GridLayout(3, false));
        mappingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        mappingGroup.setText(Messages.ImportWorkItemsMainPage_CUSTOM_DATA_MAPPING);
        this.fUseCustomMapping = new Button((Composite)mappingGroup, 32);
        this.fUseCustomMapping.setText(Messages.ImportWorkItemsMainPage_USE_CUSTOM_MAPPING);
        this.fUseCustomMapping.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        boolean useCustomMapping = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_WORKITEM_USE_CUSTOM_MAPPING, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM));
        this.fUseCustomMapping.setSelection(useCustomMapping);
        this.fUseCustomMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWorkItemsMainPage.this.updateUseCustomMappingEnablement();
                ImportWorkItemsMainPage.this.updatePageComplete();
            }
        });
        this.fSaveDefaultCustomMappingLink = new Hyperlink((Composite)mappingGroup, 0);
        this.fSaveDefaultCustomMappingLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.fSaveDefaultCustomMappingLink.setText(Messages.ImportWorkItemsMainPage_SAVE_DEFAULT_AS_TITLE);
        this.fSaveDefaultCustomMappingLink.setToolTipText(Messages.ImportWorkItemsMainPage_SAVE_DEFAULT_AS_MESSAGE);
        this.fSaveDefaultCustomMappingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ImportWorkItemsMainPage.this.onSaveDefaultMapping();
            }
        });
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
        hyperlinkGroup.add(this.fSaveDefaultCustomMappingLink);
        this.fComputeCustomMappingLink = new Hyperlink((Composite)mappingGroup, 0);
        this.fComputeCustomMappingLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.fComputeCustomMappingLink.setText(Messages.ImportWorkItemsMainPage_COMPUTE_FROM_DATA);
        this.fComputeCustomMappingLink.setToolTipText(Messages.ImportWorkItemsMainPage_COMPUTE_FROM_DATA_DETAIL);
        this.fComputeCustomMappingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ImportWorkItemsMainPage.this.onComputeMapping();
            }
        });
        hyperlinkGroup.add(this.fComputeCustomMappingLink);
        Composite indentOptionsComposite2 = WizardHelper.createIndentedComposite((Composite)mappingGroup, 3, 15);
        ((GridData)indentOptionsComposite2.getLayoutData()).horizontalSpan = 3;
        ((GridData)indentOptionsComposite2.getLayoutData()).grabExcessHorizontalSpace = true;
        this.fCustomMappingFileLabel = WizardHelper.createLabel(indentOptionsComposite2, Messages.ImportWorkItemsMainPage_XML_FILE);
        this.fCustomMappingFile = new Combo(indentOptionsComposite2, 2052);
        this.fCustomMappingFile.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] customMappingFiles = SettingsHelper.restoreListSettings(MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE_LIST, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        String customMappingFile = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        this.restoreValuesForCombo(customMappingFiles, customMappingFile, this.fCustomMappingFile);
        this.fCustomMappingFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportWorkItemsMainPage.this.updatePageComplete();
            }
        });
        this.fBrowseCustomMappingFile = new Button(indentOptionsComposite2, 8);
        this.fBrowseCustomMappingFile.setText(Messages.ImportWorkItemsMainPage_BROWSE_LABEL);
        GridData gridData = new GridData(256);
        gridData.horizontalIndent = 5;
        this.fBrowseCustomMappingFile.setLayoutData((Object)gridData);
        this.fBrowseCustomMappingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportWorkItemsMainPage.this.onBrowseCustomMapping();
            }
        });
        this.updateUseCustomMappingEnablement();
    }

    private void restoreValuesForCombo(String[] files, String file, Combo combo) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    combo.add(files[i]);
                }
                ++i;
            }
        }
        if (file != null) {
            String[] fileItems = combo.getItems();
            int i = 0;
            while (i < fileItems.length) {
                if (fileItems[i].equals(file)) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    private void updatePageComplete() {
        this.updatePageComplete(true);
    }

    private void updatePageComplete(boolean showErrors) {
        if (!this.isControlCreated()) {
            return;
        }
        String error = null;
        if (this.fCSVFileCombo.getText().length() == 0) {
            error = Messages.ImportWorkItemsMainPage_ERROR_ENTER_CSV_FILE;
        } else if (this.fProjectAreas.length == 0) {
            error = Messages.ImportWorkItemsMainPage_ERROR_CONNECT_PA;
        } else if (this.fUseCustomMapping.getSelection() && this.fCustomMappingFile.getText().length() == 0) {
            error = Messages.ImportWorkItemsMainPage_ERROR_ENTER_CUSTOM_MAPPING_FILE;
        }
        this.setPageComplete(error == null);
        this.setErrorMessage(showErrors ? error : null);
    }

    private void updateUseCustomMappingEnablement() {
        boolean enabled = this.fUseCustomMapping.getSelection();
        this.fCustomMappingFileLabel.setEnabled(enabled);
        this.fCustomMappingFile.setEnabled(enabled);
        this.fBrowseCustomMappingFile.setEnabled(enabled);
    }

    private void openFile(File file) {
        if (file.exists()) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && workbench.getWorkbenchWindows().length > 0) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null && window.getPages().length > 0) {
                        page = window.getPages()[0];
                    }
                    if (page != null) {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath())));
                    }
                }
            }
            catch (PartInitException x) {
                WorkItemRCPUIPlugin.getDefault().log(x.getLocalizedMessage(), x);
            }
        }
    }

    private void onBrowseCSVFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        String fileString = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CSV_READFILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (fileString != null) {
            Path restorePath = new Path(fileString);
            dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
            dialog.setFileName(restorePath.lastSegment());
        }
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        String res = dialog.open();
        if (res != null) {
            Path path = new Path(dialog.getFilterPath());
            path = path.addTrailingSeparator();
            String fileName = dialog.getFileName();
            this.fCSVFileCombo.add(String.valueOf(path.toOSString()) + fileName);
            int pos = this.fCSVFileCombo.getItems().length - 1;
            if (pos >= 0) {
                this.fCSVFileCombo.select(pos);
            }
            this.updatePageComplete();
        }
    }

    private void onBrowseCustomMapping() {
        FileDialog dialog = new FileDialog(this.getShell());
        String fileString = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (fileString != null) {
            Path restorePath = new Path(fileString);
            dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
            dialog.setFileName(restorePath.lastSegment());
        }
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String res = dialog.open();
        if (res != null) {
            Path path = new Path(dialog.getFilterPath());
            path = path.addTrailingSeparator();
            String fileName = dialog.getFileName();
            if (!fileName.endsWith(XML_SUFFIX)) {
                fileName = fileName.concat(XML_SUFFIX);
            }
            this.fCustomMappingFile.add(String.valueOf(path.toOSString()) + fileName);
            int pos = this.fCustomMappingFile.getItems().length - 1;
            if (pos >= 0) {
                this.fCustomMappingFile.select(pos);
            }
            this.updatePageComplete();
        }
    }

    private void onSaveDefaultMapping() {
        if (this.getProjectArea() == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String fileString = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (fileString != null) {
            Path restorePath = new Path(fileString);
            dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
            dialog.setFileName(restorePath.lastSegment());
        } else {
            dialog.setFileName(DEFAULT_MAPPING_FILE_NAME);
        }
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String res = dialog.open();
        String fileName = dialog.getFileName();
        if (res != null && fileName.length() > 0) {
            String filePath;
            File file;
            Path path = new Path(dialog.getFilterPath());
            path = path.addTrailingSeparator();
            if (!fileName.endsWith(XML_SUFFIX)) {
                fileName = fileName.concat(XML_SUFFIX);
            }
            if ((file = new File(filePath = String.valueOf(path.toOSString()) + fileName)).exists()) {
                String message = NLS.bind((String)Messages.ImportWorkItemsMainPage_FILE_EXISTS, (Object)fileName, (Object[])new Object[0]);
                MessageDialog md = new MessageDialog(this.getShell(), Messages.ImportWorkItemsMainPage_SAVE_DEFAULT_MAPPING, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (md.open() != 0) {
                    return;
                }
            }
            final BugzillaConfiguration configuration = new BugzillaConfiguration(this.getProjectArea());
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        block18: {
                            monitor.beginTask(Messages.ImportWorkItemsMainPage_DEFAULT_MAPPING_PROGRESS_MSG, -1);
                            InputStream in = null;
                            try {
                                try {
                                    BugzillaMapping mapping;
                                    try {
                                        mapping = BugzillaMapping.readDefaultMapping((BugzillaConfiguration)configuration, (IProgressMonitor)monitor);
                                    }
                                    catch (TeamRepositoryException e1) {
                                        throw new InvocationTargetException(e1, e1.getMessage());
                                    }
                                    if (monitor.isCanceled()) break block18;
                                    FileWriter writer = null;
                                    try {
                                        writer = new FileWriter(file);
                                        try {
                                            mapping.write((Writer)writer, true, monitor);
                                        }
                                        catch (TeamRepositoryException e) {
                                            throw new InvocationTargetException(e, e.getMessage());
                                        }
                                        writer.close();
                                    }
                                    finally {
                                        if (writer != null) {
                                            writer.close();
                                        }
                                    }
                                }
                                catch (IOException y) {
                                    throw new InvocationTargetException(y, y.getMessage());
                                }
                            }
                            finally {
                                monitor.done();
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException y) {
                                        throw new InvocationTargetException(y, y.getMessage());
                                    }
                                }
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE, null, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE_DETAIL, e.getCause() != null ? e.getCause() : e));
                return;
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE, null, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE_DETAIL, (Throwable)e));
                return;
            }
            this.openFile(file);
        }
    }

    private void onComputeMapping() {
        if (!this.isPageComplete()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ImportWorkItemsMainPage_INFORMATION_INCOMPLETE, (String)Messages.ImportWorkItemsMainPage_INFORMATION_INCOMPLETE_DETAIL);
            return;
        }
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String fileString = SettingsHelper.restoreSettings(MEMENTO_WORKITEM_CUSTOM_MAPPING_FILE, WORKITEM_IMPORT_SECTION, MEMENTO_WORKITEM);
        if (fileString != null) {
            Path restorePath = new Path(fileString);
            dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
            dialog.setFileName(restorePath.lastSegment());
        } else {
            dialog.setFileName(DEFAULT_MAPPING_FILE_NAME);
        }
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String res = dialog.open();
        String fileName = dialog.getFileName();
        if (res != null && fileName.length() > 0) {
            String filePath;
            File file;
            Path path = new Path(dialog.getFilterPath());
            path = path.addTrailingSeparator();
            if (!fileName.endsWith(XML_SUFFIX)) {
                fileName = fileName.concat(XML_SUFFIX);
            }
            if ((file = new File(filePath = String.valueOf(path.toOSString()) + fileName)).exists()) {
                String message = NLS.bind((String)Messages.ImportWorkItemsMainPage_FILE_EXISTS, (Object)fileName, (Object[])new Object[0]);
                MessageDialog md = new MessageDialog(this.getShell(), Messages.ImportWorkItemsMainPage_COMPUTE_MAPPING_FROM_DATA, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (md.open() != 0) {
                    return;
                }
            }
            try {
                final String csvFile = this.getCSVFile();
                final String delimiter = this.getDelimiter();
                final IProjectAreaHandle projectArea = this.getProjectArea();
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ImportWorkItemsMainPage_COMPUTE_MAPPING_FROM_DATA, -1);
                        BugzillaMapping defaultMapping = null;
                        try {
                            defaultMapping = BugzillaMapping.readDefaultMapping((BugzillaConfiguration)new BugzillaConfiguration(projectArea), (IProgressMonitor)monitor);
                        }
                        catch (TeamRepositoryException e) {
                            WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
                        }
                        OutputStreamWriter writer = null;
                        try {
                            try {
                                BugzillaMapping mapping = BugzillaMapping.createCustomMapping();
                                CSVBugRetrievalStrategy strategy = new CSVBugRetrievalStrategy(csvFile, delimiter);
                                Iterator iterator = strategy.getIterator();
                                HashMap<String, ArrayList<String>> handledAttributes = new HashMap<String, ArrayList<String>>();
                                while (iterator.hasNext()) {
                                    ReportData data = strategy.getData((String)iterator.next());
                                    Map values = data.getValues();
                                    Set entries = values.entrySet();
                                    for (Map.Entry entry : entries) {
                                        String sourceId = (String)entry.getKey();
                                        if ("bug_id".equals(sourceId)) continue;
                                        ArrayList<String> attributeValues = (ArrayList<String>)handledAttributes.get(sourceId);
                                        if (attributeValues == null) {
                                            attributeValues = new ArrayList<String>();
                                            handledAttributes.put(sourceId, attributeValues);
                                        }
                                        attributeValues.add((String)entry.getValue());
                                    }
                                }
                                Set entries = handledAttributes.entrySet();
                                Map defaultAttributeMappingsBySourceId = defaultMapping != null ? defaultMapping.getAttributeMappingsBySourceId() : Collections.emptyMap();
                                for (Map.Entry entry : entries) {
                                    String sourceId = (String)entry.getKey();
                                    String targetId = (String)entry.getKey();
                                    BugzillaMapping.AttributeMapping defaultAttributeMapping = (BugzillaMapping.AttributeMapping)defaultAttributeMappingsBySourceId.get(sourceId);
                                    if (defaultAttributeMapping != null && defaultAttributeMapping.getTargetId() != null) {
                                        targetId = defaultAttributeMapping.getTargetId();
                                    }
                                    BugzillaMapping.AttributeMapping attrMapping = new BugzillaMapping.AttributeMapping(mapping, sourceId, targetId);
                                    List attributeValues = (List)entry.getValue();
                                    for (String value : attributeValues) {
                                        BugzillaMapping.ValueMapping valueMapping;
                                        if (value.length() <= 0) continue;
                                        String valueSourceId = value;
                                        String valueTargetId = value;
                                        if (defaultAttributeMapping != null && (valueMapping = defaultAttributeMapping.getValueMapping(valueSourceId)) != null && valueMapping.getTargetId() != null) {
                                            valueTargetId = valueMapping.getTargetId();
                                        }
                                        valueMapping = new BugzillaMapping.ValueMapping(valueSourceId, valueTargetId, true);
                                        valueMapping.setInUse(true);
                                        attrMapping.addValueMapping(valueMapping);
                                    }
                                }
                                writer = new FileWriter(filePath);
                                mapping.write((Writer)writer, true, monitor);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (BugzillaException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE, null, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE_DETAIL, e.getCause() != null ? e.getCause() : e));
                return;
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE, null, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.ImportWorkItemsMainPage_ERROR_SAVING_FILE_DETAIL, e.getCause() != null ? e.getCause() : e));
                return;
            }
            this.openFile(file);
        }
    }
}

