/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.export;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.internal.util.ValidationUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.WorkItemExportWizardContext;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class WorkItemExportWizardMainPage
extends WizardPage {
    public static final String PAGE_NAME = "com.ibm.team.workitem.rcp.ui.ExportWizardMainPage";
    private WorkItemExportWizardContext fContext;
    private boolean fIsInitialized;
    private Text fQueryText;
    private ComboViewer fFormatCombo;
    private Combo fDestinationCombo;
    private Button fBrowseQueryButton;
    private Button fOverWriteCheckBox;
    private Button fOpenCheckBox;
    private ILabelProvider fExportDescriptorLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            IExportDescriptor descriptor = (IExportDescriptor)element;
            return NLS.bind((String)Messages.WorkItemExportWizardMainPage_COMBO_LABEL_FORMAT, (Object)descriptor.getDescription(), (Object[])new Object[]{descriptor.getExtension()});
        }
    };

    public WorkItemExportWizardMainPage(WorkItemExportWizardContext context) {
        super(PAGE_NAME, Messages.WorkItemExportWizardMainPage_PAGE_TITLE, ImagePool.WORKITEM_EXPORT_WIZARD);
        this.setDescription(Messages.WorkItemExportWizardMainPage_PAGE_DESCRIPTION);
        this.fContext = context;
        this.fIsInitialized = false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(7, 7).applyTo(composite);
        this.createQueryPart(composite);
        this.createFileFormatPart(composite);
        this.createDestinationPart(composite);
        this.createOptionsPart(composite);
        this.setControl((Control)composite);
        this.updateControls();
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.work_item_export_wizard_main_page");
    }

    private void createOptionsPart(Composite composite) {
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText(Messages.WorkItemExportWizardMainPage_OPTIONS_GROUP_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)optionsGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)optionsGroup);
        this.fOverWriteCheckBox = new Button((Composite)optionsGroup, 32);
        this.fOverWriteCheckBox.setText(Messages.WorkItemExportWizardMainPage_OVERWRITE_QUERSTION);
        this.fOverWriteCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardMainPage.this.updateOverWrite();
            }
        });
        this.fOpenCheckBox = new Button((Composite)optionsGroup, 32);
        this.fOpenCheckBox.setText(Messages.WorkItemExportWizardMainPage_OPEN_QUESTION);
        this.fOpenCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardMainPage.this.updateOpenAutomatically();
            }
        });
    }

    private void createDestinationPart(Composite composite) {
        this.createLabel(composite, Messages.WorkItemExportWizardMainPage_DESTINATION_LABEL);
        this.fDestinationCombo = new Combo(composite, 4);
        this.fDestinationCombo.setItems(this.fContext.getFilePaths());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDestinationCombo);
        Button browseDestinationButton = new Button(composite, 0);
        browseDestinationButton.setText(Messages.WorkItemExportWizardMainPage_BROWSE_DESTINATION_BUTTON);
        browseDestinationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WorkItemExportWizardMainPage.this.getShell(), 8192);
                dialog.setFilterExtensions(WorkItemExportWizardMainPage.this.getFileExtensions());
                dialog.setFileName(WorkItemExportWizardMainPage.this.getFileNameProposal());
                String filePath = dialog.open();
                if (filePath != null) {
                    WorkItemExportWizardMainPage.this.updateFilePath(filePath);
                }
            }
        });
    }

    private void createFileFormatPart(Composite composite) {
        this.createLabel(composite, Messages.WorkItemExportWizardMainPage_FORMAT_LABEL);
        this.fFormatCombo = new ComboViewer(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fFormatCombo.getControl());
        this.fFormatCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fFormatCombo.setLabelProvider((IBaseLabelProvider)this.fExportDescriptorLabelProvider);
        this.fFormatCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    WorkItemExportWizardMainPage.this.updateFileFormat((IExportDescriptor)selection.getFirstElement());
                }
            }
        });
        this.createLabel(composite, "");
    }

    private void createQueryPart(Composite composite) {
        this.createLabel(composite, Messages.WorkItemExportWizardMainPage_QUERY_LABEL);
        this.fQueryText = new Text(composite, 2056);
        this.fQueryText.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fQueryText);
        this.fBrowseQueryButton = new Button(composite, 0);
        this.fBrowseQueryButton.setText(Messages.WorkItemExportWizardMainPage_BROWSE_QUERY_BUTTON);
        this.fBrowseQueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IQueryDescriptorHandle handle;
                QuerySelectionDialog dialog = new QuerySelectionDialog(WorkItemExportWizardMainPage.this.getShell());
                dialog.setAllowMultiple(false);
                dialog.setTitle(Messages.WorkItemExportWizardMainPage_SELECT_QUERY_DIALOG_TITLE);
                if (dialog.open() == 0 && (handle = (IQueryDescriptorHandle)dialog.getFirstResult()) != null) {
                    WorkItemExportWizardMainPage.this.updateQuery(handle);
                }
            }
        });
    }

    private Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        label.setText(text);
        return label;
    }

    private String[] getFileExtensions() {
        String extension = this.getFileExtension();
        if (extension != null) {
            return new String[]{"*" + extension, "*.*"};
        }
        return new String[]{"*.*"};
    }

    private String getFileExtension() {
        IExportDescriptor descriptor = this.fContext.getExportDescriptor();
        if (descriptor != null) {
            return descriptor.getExtension();
        }
        return null;
    }

    private String getFileNameProposal() {
        if (this.fContext.getQuery() != null) {
            String name = ValidationUtils.removePunctuation((String)this.fContext.getQuery().getName());
            String extension = this.getFileExtension();
            if (extension != null) {
                return String.valueOf(name) + extension;
            }
            return String.valueOf(name) + ".txt";
        }
        return Messages.WorkItemExportWizardMainPage_DEFAULT_FILENAME;
    }

    public void setVisible(boolean visible) {
        if (!this.fIsInitialized) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    WorkItemExportWizardMainPage.this.initializeContext();
                }
            });
        }
        super.setVisible(visible);
    }

    private void initializeContext() {
        IStatus status = this.fContext.initialize((IRunnableContext)this.getContainer());
        this.updateProposedFilePath();
        this.updateFromStatus(status);
        this.fIsInitialized = true;
        this.fDestinationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkItemExportWizardMainPage.this.updateFilePath(WorkItemExportWizardMainPage.this.fDestinationCombo.getText());
            }
        });
    }

    private void updateFileFormat(IExportDescriptor exportDescriptor) {
        this.fContext.setFileFormat(exportDescriptor);
        this.updateProposedFileExtension();
        this.updateControls();
        this.updateWizardState();
    }

    private void updateFilePath(String filePath) {
        this.fContext.setFilePath(filePath);
        this.updateControls();
        this.updateWizardState();
    }

    private void updateOverWrite() {
        this.fContext.setOverwrite(this.fOverWriteCheckBox.getSelection());
    }

    private void updateOpenAutomatically() {
        this.fContext.setOpenAutomatically(this.fOpenCheckBox.getSelection());
    }

    private void updateQuery(IQueryDescriptorHandle handle) {
        IStatus status = this.fContext.updateQueryDependencies(handle, (IRunnableContext)this.getWizard().getContainer());
        this.updateProposedFilePath();
        this.updateFromStatus(status);
    }

    private void updateProposedFilePath() {
        String currentPath = this.fContext.getFilePath();
        if (currentPath != null && currentPath.trim().length() > 0) {
            IPath path = Path.fromOSString((String)currentPath);
            path = path.removeLastSegments(1);
            path = path.append(this.getFileNameProposal());
            this.fContext.setFilePath(path.toOSString());
        }
    }

    private void updateProposedFileExtension() {
        String currentPath = this.fContext.getFilePath();
        String extension = this.getFileExtension();
        if (currentPath != null && currentPath.trim().length() > 0 && extension != null && extension.trim().length() > 1) {
            Path path = new Path(currentPath);
            path = path.removeFileExtension();
            path = path.addFileExtension(extension.substring(1));
            this.fContext.setFilePath(path.toOSString());
        }
    }

    private void updateFromStatus(IStatus status) {
        if (status.isOK()) {
            this.updateControls();
            this.updateWizardState();
        } else {
            this.setErrorMessage(status.getMessage());
        }
    }

    private void updateControls() {
        if (this.fContext.isInitialized()) {
            this.fQueryText.setText(this.fContext.getQuery().getName());
            List<IExportDescriptor> exportDescriptors = this.fContext.getExportDescriptors();
            if (this.fFormatCombo.getInput() != exportDescriptors) {
                this.fFormatCombo.setInput(exportDescriptors);
                this.fFormatCombo.getControl().setEnabled(true);
            }
            IStructuredSelection formatSelection = (IStructuredSelection)this.fFormatCombo.getSelection();
            if (this.fContext.getExportDescriptor() != formatSelection.getFirstElement()) {
                this.fFormatCombo.setSelection((ISelection)new StructuredSelection((Object)this.fContext.getExportDescriptor()), true);
            }
        } else {
            this.fQueryText.setText(Messages.WorkItemExportWizardMainPage_EMPTY_QUERY_MESSAGE);
            this.fFormatCombo.getControl().setEnabled(false);
        }
        if (!this.fDestinationCombo.getText().equals(this.fContext.getFilePath())) {
            this.fDestinationCombo.setText(this.fContext.getFilePath() != null ? this.fContext.getFilePath() : "");
        }
        this.fOverWriteCheckBox.setSelection(this.fContext.overWriteExisting());
        this.fOpenCheckBox.setSelection(this.fContext.openAutomatically());
    }

    private void updateWizardState() {
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }
}

