/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.export;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.QueryClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.QueryTypeRegistry;
import com.ibm.team.workitem.rcp.ui.internal.util.RepositoryOperationRunnable;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemExportWizardContext {
    private static final String SETTINGS_OVERWRITE = "overwrite";
    private static final String SETTINGS_OPEN_AUTOMATICALLY = "openAutomatically";
    private static final String SETTINGS_EXPORT_FORMAT = "exportFormat";
    private static final String SETTINGS_FILE_PATH_HISTORY = "filePathHistory";
    private static final String SETTINGS_COLUMNS = "columns";
    private static final String SETTINGS_ID_COLUMNS = "idColumns";
    private static final List<String> FILTERED_ATTRIBUTES = Arrays.asList(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY, IWorkItem.APPROVALS_PROPERTY);
    private IQueryDescriptorHandle fQueryDescriptorContext;
    private Configuration fConfiguration;
    private String[] fFilePaths;
    private String fFilePath;
    private boolean fOverwrite;
    private boolean fOpenAutomatically;
    private IDialogSettings fDialogSettings;

    public WorkItemExportWizardContext(IQueryDescriptorHandle handle) {
        this.fQueryDescriptorContext = handle;
    }

    public IStatus initialize(IRunnableContext context) {
        if (this.fConfiguration == null && this.fQueryDescriptorContext != null) {
            return this.updateQueryDependencies(this.fQueryDescriptorContext, context);
        }
        return Status.OK_STATUS;
    }

    public IStatus initializeColumns(IRunnableContext context) {
        final Configuration configuration = this.fConfiguration;
        if (configuration == null) {
            return Status.CANCEL_STATUS;
        }
        if (configuration.getAllAttributes() != null) {
            return Status.OK_STATUS;
        }
        RepositoryOperationRunnable<List<IQueryableAttribute>> runnable = new RepositoryOperationRunnable<List<IQueryableAttribute>>(){

            @Override
            protected List<IQueryableAttribute> performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(Messages.WorkItemExportWizardContext_LOADING_COLUMNS, 100);
                    IQueryDescriptor query = configuration.getQuery();
                    IQueryType type = QueryTypeRegistry.getQueryType((String)query.getQueryType());
                    IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)type.getQueryItemType());
                    IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)query, IAuditableClient.class);
                    List list = factory.findAllAttributes(query.getProjectArea(), (IAuditableCommon)auditableClient, monitor);
                    return list;
                }
                finally {
                    monitor.done();
                }
            }
        };
        List attributes = (List)runnable.run(context);
        IStatus status = runnable.getStatus();
        if (status.isOK()) {
            this.fConfiguration.setAttributes(attributes);
        }
        return status;
    }

    public IStatus updateQueryDependencies(final IQueryDescriptorHandle handle, IRunnableContext context) {
        final Configuration oldConfiguration = this.fConfiguration;
        if (oldConfiguration != null && oldConfiguration.getQuery().sameItemId((IItemHandle)handle)) {
            return Status.OK_STATUS;
        }
        RepositoryOperationRunnable<Configuration> runnable = new RepositoryOperationRunnable<Configuration>(){

            @Override
            protected Configuration performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    List exportDescriptors;
                    List<IQueryableAttribute> attributes;
                    monitor.beginTask(Messages.WorkItemExportWizardContext_LOADING_CONFIGURATION, 100);
                    IAuditableClient client = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)handle, IAuditableClient.class);
                    IQueryDescriptor descriptor = (IQueryDescriptor)client.resolveAuditable((IAuditableHandle)handle, IQueryDescriptor.FULL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    List<IQueryableAttribute> list = attributes = oldConfiguration != null ? oldConfiguration.getAllAttributes() : null;
                    if (oldConfiguration != null && !oldConfiguration.getProjectArea().sameItemId((IItemHandle)descriptor.getProjectArea())) {
                        attributes = null;
                    }
                    List list2 = exportDescriptors = oldConfiguration != null ? oldConfiguration.getExportDescriptors() : null;
                    if (oldConfiguration == null || oldConfiguration.getRepository() != descriptor.getOrigin()) {
                        QueryClient queryClient = (QueryClient)ClientUtils.getClientLibrary((IItemHandle)handle, IQueryClient.class);
                        exportDescriptors = queryClient.fetchExportDescriptors((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    String exportDescriptorId = oldConfiguration != null && oldConfiguration.getExportDescriptor() != null ? oldConfiguration.getExportDescriptor().getId() : WorkItemExportWizardContext.this.fDialogSettings.get(WorkItemExportWizardContext.SETTINGS_EXPORT_FORMAT);
                    Configuration configuration = new Configuration(descriptor, attributes, exportDescriptors, exportDescriptorId, WorkItemExportWizardContext.this.getSelectedColumnMemento(handle), WorkItemExportWizardContext.this.getSelectedIdColumnMemento(handle));
                    return configuration;
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.fConfiguration = (Configuration)runnable.run(context);
        return runnable.getStatus();
    }

    private Set<String> getSelectedIdColumnMemento(IQueryDescriptorHandle query) {
        String[] columns;
        IDialogSettings querySection = this.fDialogSettings.getSection(query.getItemId().getUuidValue());
        if (querySection != null && (columns = querySection.getArray(SETTINGS_ID_COLUMNS)) != null) {
            return new HashSet<String>(Arrays.asList(columns));
        }
        return Collections.emptySet();
    }

    private List<String> getSelectedColumnMemento(IQueryDescriptorHandle query) {
        String[] columns;
        IDialogSettings querySection = this.fDialogSettings.getSection(query.getItemId().getUuidValue());
        if (querySection != null && (columns = querySection.getArray(SETTINGS_COLUMNS)) != null) {
            return Arrays.asList(columns);
        }
        return Collections.emptyList();
    }

    public IQueryDescriptor getQuery() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getQuery();
        }
        return null;
    }

    public IExportDescriptor getExportDescriptor() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getExportDescriptor();
        }
        return null;
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public String[] getFilePaths() {
        return this.fFilePaths;
    }

    public boolean overWriteExisting() {
        return this.fOverwrite;
    }

    public boolean openAutomatically() {
        return this.fOpenAutomatically;
    }

    public void setFilePath(String filePath) {
        this.fFilePath = filePath;
    }

    public void setOverwrite(boolean overwrite) {
        this.fOverwrite = overwrite;
    }

    public void setOpenAutomatically(boolean openAutomatically) {
        this.fOpenAutomatically = openAutomatically;
    }

    public void setFileFormat(IExportDescriptor exportDescriptor) {
        if (this.fConfiguration != null) {
            this.fConfiguration.setExportDescriptor(exportDescriptor);
        }
    }

    public boolean isInitialized() {
        return this.fConfiguration != null;
    }

    public List<IExportDescriptor> getExportDescriptors() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getExportDescriptors();
        }
        return Collections.emptyList();
    }

    public List<IQueryableAttribute> getAllAttributes() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getAllAttributes();
        }
        return null;
    }

    public void addColumns(List<IQueryableAttribute> attributes) {
        if (this.fConfiguration != null) {
            this.fConfiguration.addColumns(attributes, Collections.<String>emptySet());
        }
    }

    public void moveColumns(List<Column> columns, int offset) {
        if (this.fConfiguration != null) {
            this.fConfiguration.moveColumns(columns, offset);
        }
    }

    public void removeColumns(List<Column> columns) {
        if (this.fConfiguration != null) {
            this.fConfiguration.removeColumns(columns);
        }
    }

    public List<Column> getSelectedColumns() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getSelectedColumns();
        }
        return null;
    }

    public ITeamRepository getTeamRepository() {
        if (this.fConfiguration != null) {
            return this.fConfiguration.getRepository();
        }
        return null;
    }

    void restoreState(IDialogSettings dialogSettings) {
        String openAutomatically;
        this.fFilePaths = dialogSettings.getArray(SETTINGS_FILE_PATH_HISTORY);
        if (this.fFilePaths == null) {
            this.fFilePaths = new String[0];
        }
        if (this.fFilePaths.length > 0) {
            this.fFilePath = this.fFilePaths[0];
        }
        this.fOpenAutomatically = (openAutomatically = dialogSettings.get(SETTINGS_OPEN_AUTOMATICALLY)) != null ? Boolean.valueOf(openAutomatically) : true;
        String overwrite = dialogSettings.get(SETTINGS_OVERWRITE);
        this.fOverwrite = overwrite != null ? Boolean.valueOf(overwrite) : false;
        this.fDialogSettings = dialogSettings;
    }

    void saveState(IDialogSettings dialogSettings) {
        List<Column> selectedColumns;
        if (this.getExportDescriptor() != null) {
            dialogSettings.put(SETTINGS_EXPORT_FORMAT, this.getExportDescriptor().getId());
        }
        if (this.fFilePath != null) {
            ArrayList<String> filePaths = new ArrayList<String>();
            filePaths.addAll(Arrays.asList(this.fFilePaths));
            filePaths.remove(this.fFilePath);
            filePaths.add(0, this.fFilePath);
            List mruHistory = filePaths.subList(0, Math.min(filePaths.size(), 10));
            dialogSettings.put(SETTINGS_FILE_PATH_HISTORY, mruHistory.toArray(new String[mruHistory.size()]));
        }
        if (!(selectedColumns = this.getSelectedColumns()).isEmpty()) {
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> idColumns = new ArrayList<String>();
            for (Column column : selectedColumns) {
                columns.add(column.attribute.getIdentifier());
                if (column.showLabel) continue;
                idColumns.add(column.attribute.getIdentifier());
            }
            IDialogSettings columnSettings = dialogSettings.addNewSection(this.getQuery().getItemId().getUuidValue());
            columnSettings.put(SETTINGS_COLUMNS, columns.toArray(new String[columns.size()]));
            columnSettings.put(SETTINGS_ID_COLUMNS, idColumns.toArray(new String[idColumns.size()]));
        }
        dialogSettings.put(SETTINGS_OPEN_AUTOMATICALLY, this.fOpenAutomatically);
        dialogSettings.put(SETTINGS_OVERWRITE, this.fOverwrite);
    }

    public static class Column
    implements IAdaptable {
        public IQueryableAttribute attribute;
        public boolean showLabel;

        public Column(IQueryableAttribute att) {
            this.attribute = att;
            this.showLabel = true;
        }

        public Object getAdapter(Class adapter) {
            if (IQueryableAttribute.class.equals((Object)adapter)) {
                return this.attribute;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Configuration {
        private final IQueryDescriptor fQuery;
        private final List<IExportDescriptor> fExportDescriptors;
        private IExportDescriptor fExportDescriptor;
        private Map<String, IQueryableAttribute> fAttributeMap;
        private List<Column> fSelectedColumns;
        private List<String> fColumnMemento;
        private Set<String> fIdColumnMemento;

        private Configuration(IQueryDescriptor query, List<IQueryableAttribute> attributes, List<IExportDescriptor> exportDescriptors, String exportDescriptorId, List<String> columnMemento, Set<String> idColumnMemento) {
            Assert.isNotNull((Object)query);
            Assert.isNotNull(exportDescriptors);
            Assert.isNotNull(columnMemento);
            Assert.isNotNull(idColumnMemento);
            this.fQuery = query;
            this.fExportDescriptors = exportDescriptors;
            this.fColumnMemento = columnMemento;
            this.fIdColumnMemento = idColumnMemento;
            this.fExportDescriptor = this.findDefaultDescriptor(exportDescriptorId, exportDescriptors);
            this.setAttributes(attributes);
        }

        public IQueryDescriptor getQuery() {
            return this.fQuery;
        }

        public ITeamRepository getRepository() {
            return (ITeamRepository)this.fQuery.getOrigin();
        }

        public IProjectAreaHandle getProjectArea() {
            return this.fQuery.getProjectArea();
        }

        public List<IQueryableAttribute> getAllAttributes() {
            if (this.fAttributeMap != null) {
                return new ArrayList<IQueryableAttribute>(this.fAttributeMap.values());
            }
            return null;
        }

        public List<Column> getSelectedColumns() {
            return this.fSelectedColumns;
        }

        public void addColumns(List<IQueryableAttribute> attributes, Set<String> idColumns) {
            for (IQueryableAttribute queryableAttribute : attributes) {
                Column column = new Column(queryableAttribute);
                if (idColumns.contains(queryableAttribute.getIdentifier())) {
                    column.showLabel = false;
                }
                this.fSelectedColumns.add(column);
            }
        }

        public void removeColumns(List<Column> columns) {
            this.fSelectedColumns.removeAll(columns);
        }

        public void moveColumns(List<Column> columns, int offset) {
            ArrayList<Column> toBeMoved = new ArrayList<Column>(columns);
            if (offset > 0) {
                Collections.reverse(toBeMoved);
            }
            for (Column column : toBeMoved) {
                int index = this.fSelectedColumns.indexOf(column);
                int newIndex = index + offset;
                if (newIndex <= -1 || newIndex >= this.fSelectedColumns.size()) continue;
                this.fSelectedColumns.remove(index);
                this.fSelectedColumns.add(newIndex, column);
            }
        }

        public List<IExportDescriptor> getExportDescriptors() {
            return this.fExportDescriptors;
        }

        public void setExportDescriptor(IExportDescriptor exportDescriptor) {
            this.fExportDescriptor = exportDescriptor;
        }

        public IExportDescriptor getExportDescriptor() {
            return this.fExportDescriptor;
        }

        private IExportDescriptor findDefaultDescriptor(String id, List<IExportDescriptor> exportDescriptors) {
            if (!exportDescriptors.isEmpty()) {
                if (id != null) {
                    for (IExportDescriptor descriptor : exportDescriptors) {
                        if (!id.equals(descriptor.getId())) continue;
                        return descriptor;
                    }
                }
                return exportDescriptors.get(0);
            }
            return null;
        }

        private void setAttributes(List<IQueryableAttribute> allAttributes) {
            this.fSelectedColumns = new ArrayList<Column>();
            this.fAttributeMap = null;
            if (allAttributes != null) {
                HashMap<String, IQueryableAttribute> attributeMap = new HashMap<String, IQueryableAttribute>();
                for (IQueryableAttribute queryableAttribute : allAttributes) {
                    if (FILTERED_ATTRIBUTES.contains(queryableAttribute.getIdentifier())) continue;
                    attributeMap.put(queryableAttribute.getIdentifier(), queryableAttribute);
                }
                ArrayList<IQueryableAttribute> selectedAttributes = new ArrayList<IQueryableAttribute>();
                List selectedColumns = this.fColumnMemento;
                if (selectedColumns.isEmpty()) {
                    selectedColumns = QueryUtils.getColumnIdentifiers((Expression)this.fQuery.getExpression());
                }
                if (selectedColumns.isEmpty()) {
                    selectedColumns = this.getFactory().getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet.EXPORT);
                }
                for (String column : selectedColumns) {
                    IQueryableAttribute attribute = attributeMap.get(column);
                    if (attribute == null) continue;
                    selectedAttributes.add(attribute);
                }
                this.fAttributeMap = attributeMap;
                this.addColumns(selectedAttributes, this.fIdColumnMemento);
            }
        }

        private IQueryableAttributeFactory getFactory() {
            IQueryType type = QueryTypeRegistry.getQueryType((String)this.fQuery.getQueryType());
            return QueryableAttributes.getFactory((IItemType)type.getQueryItemType());
        }
    }
}

