/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.export;

import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeSelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.export.WorkItemExportWizardContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemExportWizardAttributePage
extends WizardPage {
    public static final String PAGE_NAME = "com.ibm.team.workitem.rcp.ui.ExportWizardAttributePage";
    private static final String[] REPRESENTATION_LITERALS = new String[]{Messages.WorkItemExportWizardAttributePage_LABEL_LITERAL, Messages.WorkItemExportWizardAttributePage_INETRNAL_VALUE_LITERAL};
    private WorkItemExportWizardContext fContext;
    private boolean fIsInitialized;
    private TableViewer fTableViewer;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;

    public WorkItemExportWizardAttributePage(WorkItemExportWizardContext context) {
        super(PAGE_NAME, Messages.WorkItemExportWizardAttributePage_PAGE_TITLE, ImagePool.WORKITEM_EXPORT_WIZARD);
        this.setDescription(Messages.WorkItemExportWizardAttributePage_PAGE_DESCRIPTION);
        this.fContext = context;
        this.fIsInitialized = false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(7, 7).applyTo(composite);
        this.createAttributeTable(composite);
        this.createButtons(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.work_item_export_wizard_attribute_page");
    }

    private void createButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        Button addAttributeButton = new Button(buttonComposite, 0);
        addAttributeButton.setText(Messages.WorkItemExportWizardAttributePage_ADD_COLUMNS_BUTTON);
        addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardAttributePage.this.addColumns();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addAttributeButton);
        Button removeButton = new Button(buttonComposite, 0);
        removeButton.setText(Messages.WorkItemExportWizardAttributePage_REMOVE_COLUMNS_BUTTON);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardAttributePage.this.removeSelectedColumns();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeButton);
        Button moveUpButton = new Button(buttonComposite, 0);
        moveUpButton.setText(Messages.WorkItemExportWizardAttributePage_MOVE_UP_BUTTON);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardAttributePage.this.moveSelectedColumns(-1);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)moveUpButton);
        Button moveDownButton = new Button(buttonComposite, 0);
        moveDownButton.setText(Messages.WorkItemExportWizardAttributePage_MOVE_DOWN_BUTTON);
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemExportWizardAttributePage.this.moveSelectedColumns(1);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)moveDownButton);
        this.fRemoveButton = removeButton;
        this.fMoveUpButton = moveUpButton;
        this.fMoveDownButton = moveDownButton;
    }

    private void createAttributeTable(Composite composite) {
        TableViewer viewer = new TableViewer(composite, 68354);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkItemExportWizardAttributePage.this.updateButtonEnablement();
            }
        });
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout selectedTableLayout = new TableLayout();
        table.setLayout((Layout)selectedTableLayout);
        TableViewerColumn attributeColumn = new TableViewerColumn(viewer, 16384);
        attributeColumn.getColumn().setText(Messages.WorkItemExportWizardAttributePage_COLUMN_ATTRIBUTE);
        attributeColumn.setLabelProvider(QueryableAttributeLabelProvider.createCellLabelProvider());
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(65));
        TableViewerColumn optionColumn = new TableViewerColumn(viewer, 16384);
        optionColumn.getColumn().setText(Messages.WorkItemExportWizardAttributePage_COLUMN_SHOW);
        optionColumn.setLabelProvider((CellLabelProvider)new RepresentationLabelProvider());
        optionColumn.setEditingSupport((EditingSupport)new RepresentationEditingSupport(viewer));
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.fTableViewer = viewer;
    }

    public void setVisible(boolean visible) {
        if (!this.fIsInitialized) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    WorkItemExportWizardAttributePage.this.initializeColumns();
                }
            });
        }
        super.setVisible(visible);
    }

    private void initializeColumns() {
        IStatus status = this.fContext.initializeColumns((IRunnableContext)this.getContainer());
        if (status.isOK()) {
            this.fTableViewer.setInput(this.fContext.getSelectedColumns());
        } else {
            this.setErrorMessage(status.getMessage());
        }
        this.fIsInitialized = true;
    }

    private void addColumns() {
        String settingsKey = WorkItemExportWizardAttributePage.class.getName();
        QueryableAttributeSelectionDialog dialog = new QueryableAttributeSelectionDialog(this.getShell(), (ILabelProvider)new QueryableAttributeLabelProvider(), new QueryableAttributeContentProvider(false), settingsKey);
        dialog.setTitle(Messages.WorkItemExportWizardAttributePage_ADD_COLUMNS_DIALOG_TITLE);
        dialog.setFilteredAttributes(this.getCurrentAttributeIdentifiers());
        dialog.setInput(this.fContext.getAllAttributes());
        dialog.configureButtons(6);
        if (dialog.open() == 0) {
            this.fContext.addColumns(dialog.getSelectedAttributes());
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
        }
    }

    private void removeSelectedColumns() {
        this.fContext.removeColumns(this.getSelectedColumns());
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
    }

    private void moveSelectedColumns(int offset) {
        this.fContext.moveColumns(this.getSelectedColumns(), offset);
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
    }

    private void updateButtonEnablement() {
        int[] selectionIndices = this.fTableViewer.getTable().getSelectionIndices();
        int tableSize = this.fTableViewer.getTable().getItemCount();
        if (selectionIndices.length > 0) {
            Arrays.sort(selectionIndices);
            this.fRemoveButton.setEnabled(true);
            this.fMoveUpButton.setEnabled(selectionIndices[0] != 0);
            this.fMoveDownButton.setEnabled(selectionIndices[selectionIndices.length - 1] != tableSize - 1);
        } else {
            this.fRemoveButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
            this.fMoveDownButton.setEnabled(false);
        }
    }

    private List<String> getCurrentAttributeIdentifiers() {
        ArrayList<String> attributes = new ArrayList<String>();
        for (WorkItemExportWizardContext.Column column : this.fContext.getSelectedColumns()) {
            attributes.add(column.attribute.getIdentifier());
        }
        attributes.add("all");
        return attributes;
    }

    private List<WorkItemExportWizardContext.Column> getSelectedColumns() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        return selection.toList();
    }

    private static class RepresentationEditingSupport
    extends EditingSupport {
        private TableViewer fTableViewer;
        private CellEditor fCellEditor;

        public RepresentationEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.fTableViewer = viewer;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.fCellEditor == null) {
                this.fCellEditor = new ComboBoxCellEditor((Composite)this.fTableViewer.getTable(), REPRESENTATION_LITERALS, 8);
            }
            return this.fCellEditor;
        }

        protected Object getValue(Object element) {
            WorkItemExportWizardContext.Column column = (WorkItemExportWizardContext.Column)element;
            return column.showLabel ? 0 : 1;
        }

        protected void setValue(Object element, Object value) {
            WorkItemExportWizardContext.Column column = (WorkItemExportWizardContext.Column)element;
            column.showLabel = value.equals(0);
            this.getViewer().update(element, null);
        }
    }

    private static class RepresentationLabelProvider
    extends CellLabelProvider {
        private RepresentationLabelProvider() {
        }

        public void update(ViewerCell cell) {
            WorkItemExportWizardContext.Column column = (WorkItemExportWizardContext.Column)cell.getElement();
            cell.setText(column.showLabel ? REPRESENTATION_LITERALS[0] : REPRESENTATION_LITERALS[1]);
        }
    }
}

