/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.BugzillaImportWizard;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.SettingsHelper;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.WizardHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;

public class ImportBugzillaMainPage
extends WizardPage {
    public static final String MEMENTO_BUGZILLA = "bugzillaimport";
    public static final String MEMENTO_BUGZILLA_ISBUGZILLAIMPORT = "isbugzillaimport";
    public static final String MEMENTO_BUGZILLA_READFILE = "importfile";
    public static final String MEMENTO_BUGZILLA_READFILELIST = "importfilelist";
    public static final String MEMENTO_BUGZILLA_URL = "url";
    public static final String MEMENTO_BUGZILLA_FROM = "from";
    public static final String MEMENTO_BUGZILLA_TO = "to";
    public static final String MEMENTO_BUGZILLA_USER = "user";
    public static final String MEMENTO_BUGZILLA_NEEDSAUTH = "needsauth";
    public static final String MEMENTO_BUGZILLA_AUTHMETHOD = "authmethod";
    public static final String MEMENTO_BUGZILLA_PROJECT_AREA = "projectarea";
    public static final String MEMENTO_BUGZILLA_SAVEXML = "savexml";
    public static final String MEMENTO_BUGZILLA_SAVEXMLNAME = "savexmlfile";
    public static final String MEMENTO_BUGZILLA_SAVEXMLLIST = "savexmlfilelist";
    public static final String MEMENTO_BUGZILLA_OVERWRITE = "overwrite";
    public static final String MEMENTO_BUGZILLA_PRODUCT = "product";
    public static final String MEMENTO_BUGZILLA_USE_CUSTOM_MAPPING = "usecustommapping";
    public static final String MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE = "custommappingfile";
    public static final String MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE_LIST = "custommappingfilelist";
    public static final String MEMENTO_BUGZILLA_IMPORTMETHOD = "importmethod";
    public static final String BUGZILLA_IMPORT_SECTION = "bugzillaimportsection";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String XML_SUFFIX = ".xml";
    private static final String DEFAULT_MAPPING_FILE_NAME = Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_SAVE_AS_FILE;
    private Button fImportFromBugzilla;
    private Button fImportFromFile;
    private Button fBrowseReadFile;
    private Combo fReadFileCombo;
    private Text fBugzillaURL;
    private Group fRangeGroup;
    private Button fImportSingle;
    private Button fImportRange;
    private Text fSingleBug;
    private Text fFromBug;
    private Label fToBugLabel;
    private Text fToBug;
    private Button fImportProduct;
    private Text fProductName;
    private Group fAuthGroup;
    private Button fAuthCheck;
    private Button fAuthMethodBasic;
    private Button fAuthMethodCookies;
    private Label fUserLabel;
    private Text fUserInput;
    private Label fPassLabel;
    private Text fPassInput;
    private Group fOptionsGroup;
    private Button fImportToProjectArea;
    private Label fProjectAreaLabel;
    private Combo fProjectAreaCombo;
    private Button fSaveXMLToFileSystem;
    private Label fWriteFileLabel;
    private Combo fWriteFileCombo;
    private Button fBrowseWriteFile;
    private Button fOverwrite;
    private Group fCustomMappingGroup;
    private Button fUseCustomMapping;
    private Label fCustomMappingFileLabel;
    private Combo fCustomMappingFile;
    private Button fBrowseCustomMappingFile;
    private IProjectAreaHandle[] fProjectAreas;
    private Hyperlink fSaveCustomMappingLink;
    private Hyperlink fComputeCustomMappingLink;

    public ImportBugzillaMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ImportBugzillaMainPage_SPECIFY_SOURCE_LOCATION);
    }

    public void createControl(Composite parent) {
        Composite composite = WizardHelper.createComposite(parent, 1, true);
        this.initializeDialogUnits((Control)composite);
        Group locationGroup = new Group(composite, 0);
        locationGroup.setLayout((Layout)new GridLayout());
        locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        locationGroup.setText(Messages.ImportBugzillaMainPage_LOCATION);
        Composite locationComposite = WizardHelper.createComposite((Composite)locationGroup, 3, true);
        this.fImportFromBugzilla = new Button(locationComposite, 16);
        this.fImportFromBugzilla.setText(Messages.ImportBugzillaMainPage_BUGZILLA_URL);
        this.fImportFromBugzilla.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fImportFromBugzilla.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.setDownloadMethodEnablement(true);
                ImportBugzillaMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fBugzillaURL = new Text(locationComposite, 2048);
        String servername = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_URL, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        if (servername != null) {
            this.fBugzillaURL.setText(servername);
        }
        this.fBugzillaURL.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fBugzillaURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fImportFromFile = new Button(locationComposite, 16);
        this.fImportFromFile.setText(Messages.ImportBugzillaMainPage_IMPORT_FROM_ZIP_FILE);
        this.fImportFromFile.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fImportFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.setDownloadMethodEnablement(false);
                ImportBugzillaMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fReadFileCombo = new Combo(locationComposite, 2052);
        this.fReadFileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] readFiles = SettingsHelper.restoreListSettings(MEMENTO_BUGZILLA_READFILELIST, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        String readFile = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_READFILE, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        this.restoreValuesForCombo(readFiles, readFile, this.fReadFileCombo);
        this.fReadFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        final Shell shell = super.getShell();
        this.fBrowseReadFile = new Button(locationComposite, 8);
        this.fBrowseReadFile.setText(Messages.ImportBugzillaMainPage_BROWSE);
        GridData gridData = new GridData(256);
        gridData.horizontalIndent = 5;
        this.fBrowseReadFile.setLayoutData((Object)gridData);
        this.fBrowseReadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell);
                String fileString = SettingsHelper.restoreSettings(ImportBugzillaMainPage.MEMENTO_BUGZILLA_READFILE, ImportBugzillaMainPage.BUGZILLA_IMPORT_SECTION, ImportBugzillaMainPage.MEMENTO_BUGZILLA);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                }
                dialog.setFilterExtensions(new String[]{"*.zip"});
                String res = dialog.open();
                if (res != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(ImportBugzillaMainPage.ZIP_SUFFIX)) {
                        fileName = fileName.concat(ImportBugzillaMainPage.ZIP_SUFFIX);
                    }
                    ImportBugzillaMainPage.this.fReadFileCombo.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = ImportBugzillaMainPage.this.fReadFileCombo.getItems().length - 1;
                    if (pos >= 0) {
                        ImportBugzillaMainPage.this.fReadFileCombo.select(pos);
                    }
                    ImportBugzillaMainPage.this.updatePageComplete();
                }
            }
        });
        this.fRangeGroup = new Group(composite, 0);
        this.fRangeGroup.setLayout((Layout)new GridLayout());
        this.fRangeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fRangeGroup.setText(Messages.ImportBugzillaMainPage_RANGE);
        Composite rangeComposite = WizardHelper.createComposite((Composite)this.fRangeGroup, 4, false);
        this.fImportSingle = new Button(rangeComposite, 16);
        this.fImportSingle.setText(Messages.ImportBugzillaMainPage_IMPORT_SINGLE_BUG);
        this.fImportSingle.setLayoutData((Object)new GridData(1, 1, true, false));
        this.fImportSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateFromToEnablement();
                ImportBugzillaMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fSingleBug = WizardHelper.createTextFieldWithSpan(rangeComposite, 3);
        this.fSingleBug.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fImportRange = new Button(rangeComposite, 16);
        this.fImportRange.setText(Messages.ImportBugzillaMainPage_IMPORT_MULTIPLE_BUGS_FROM);
        this.fImportRange.setLayoutData((Object)new GridData(1, 4, false, false));
        this.fImportRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateFromToEnablement();
                ImportBugzillaMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fFromBug = WizardHelper.createTextField(rangeComposite);
        this.fFromBug.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fToBugLabel = WizardHelper.createLabel(rangeComposite, Messages.ImportBugzillaMainPage_IMPORT_MULTIPLE_BUGS_TO);
        this.fToBug = WizardHelper.createTextField(rangeComposite);
        this.fToBug.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fImportProduct = new Button(rangeComposite, 16);
        this.fImportProduct.setText(Messages.ImportBugzillaMainPage_IMPORT_BUGS_WITH_PRODUCT);
        this.fImportProduct.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fImportProduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateFromToEnablement();
                ImportBugzillaMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fProductName = new Text(rangeComposite, 2048);
        this.fProductName.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        String productname = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_PRODUCT, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        if (productname != null) {
            this.fProductName.setText(productname);
        }
        this.fProductName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        String from = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_FROM, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        from = from == null ? "" : from;
        String to = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_TO, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        String string = to = to == null ? "" : to;
        if (from.equals(to)) {
            this.fSingleBug.setText(from);
            this.fImportSingle.setSelection(true);
            this.fSingleBug.setEnabled(true);
            this.fFromBug.setEnabled(false);
            this.fToBugLabel.setEnabled(false);
            this.fToBug.setEnabled(false);
        } else {
            this.fFromBug.setText(from);
            this.fToBug.setText(to);
            this.fImportRange.setSelection(true);
            this.fSingleBug.setEnabled(false);
            this.fFromBug.setEnabled(true);
            this.fToBugLabel.setEnabled(true);
            this.fToBug.setEnabled(true);
        }
        this.fAuthGroup = new Group(composite, 0);
        this.fAuthGroup.setLayout((Layout)new GridLayout());
        this.fAuthGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fAuthGroup.setText(Messages.ImportBugzillaMainPage_SERVER_AUTH);
        this.fAuthCheck = new Button((Composite)this.fAuthGroup, 32);
        this.fAuthCheck.setText(Messages.ImportBugzillaMainPage_SERVER_AUTH_REQUIRED);
        this.fAuthCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        boolean auth = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_NEEDSAUTH, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA));
        this.fAuthCheck.setSelection(auth);
        this.fAuthCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateCredentialEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite indentComposite = WizardHelper.createIndentedComposite((Composite)this.fAuthGroup, 1, 15);
        this.fAuthMethodBasic = new Button(indentComposite, 16);
        this.fAuthMethodBasic.setText(Messages.ImportBugzillaMainPage_SERVER_AUTH_BASIC);
        this.fAuthMethodBasic.setLayoutData((Object)new GridData(4, 4, true, false));
        String method = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_AUTHMETHOD, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        if (method == null) {
            this.fAuthMethodBasic.setSelection(true);
        } else {
            this.fAuthMethodBasic.setSelection(Boolean.valueOf(method).booleanValue());
        }
        this.fAuthMethodCookies = new Button(indentComposite, 16);
        this.fAuthMethodCookies.setText(Messages.ImportBugzillaMainPage_SERVER_AUTH_COOKIES);
        this.fAuthMethodCookies.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fAuthMethodCookies.setSelection(!this.fAuthMethodBasic.getSelection());
        Composite fCredentialsComposite = WizardHelper.createComposite(indentComposite, 2, false);
        this.fUserLabel = WizardHelper.createLabel(fCredentialsComposite, Messages.ImportBugzillaMainPage_SERVER_AUTH_USER);
        this.fUserInput = WizardHelper.createTextField(fCredentialsComposite);
        this.fUserInput.setLayoutData((Object)new GridData(4, 4, true, false));
        String user = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_USER, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        this.fUserInput.setText(user == null ? "" : user);
        this.fPassLabel = WizardHelper.createLabel(fCredentialsComposite, Messages.ImportBugzillaMainPage_SERVER_AUTH_PASSWORD);
        this.fPassInput = new Text(fCredentialsComposite, 0x400800);
        this.fPassInput.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fPassInput.setText("");
        this.fOptionsGroup = new Group(composite, 0);
        this.fOptionsGroup.setLayout((Layout)new GridLayout());
        this.fOptionsGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fOptionsGroup.setText(Messages.ImportBugzillaMainPage_OPTIONS);
        this.fImportToProjectArea = new Button((Composite)this.fOptionsGroup, 16);
        this.fImportToProjectArea.setText(Messages.ImportBugzillaMainPage_IMPORT_TO_PROJECT);
        this.fImportToProjectArea.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fProjectAreas = WizardHelper.getLoggedInProjectAreas();
        String selectedProjectArea = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_PROJECT_AREA, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        Composite indentOptionsComposite1 = WizardHelper.createIndentedComposite((Composite)this.fOptionsGroup, 3, 15);
        this.fProjectAreaLabel = WizardHelper.createLabel(indentOptionsComposite1, Messages.ImportBugzillaMainPage_IMPORT_TO_PROJECT_AREA);
        this.fProjectAreaCombo = WizardHelper.createProjectAreaCombo(indentOptionsComposite1, this.fProjectAreas, selectedProjectArea);
        this.fSaveXMLToFileSystem = new Button((Composite)this.fOptionsGroup, 16);
        this.fSaveXMLToFileSystem.setText(Messages.ImportBugzillaMainPage_IMPORT_TO_ZIP);
        this.fSaveXMLToFileSystem.setLayoutData((Object)new GridData(4, 1, true, false));
        boolean save = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_SAVEXML, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA));
        this.fSaveXMLToFileSystem.setSelection(save);
        this.fImportToProjectArea.setSelection(!save);
        this.fSaveXMLToFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateSaveXMLEnablement();
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        Composite indentOptionsComposite = WizardHelper.createIndentedComposite((Composite)this.fOptionsGroup, 1, 15);
        Composite optionsComposite = WizardHelper.createComposite(indentOptionsComposite, 3, true);
        this.fWriteFileLabel = WizardHelper.createLabel(optionsComposite, Messages.ImportBugzillaMainPage_IMPORT_TO_ZIP_FILE);
        this.fWriteFileCombo = new Combo(optionsComposite, 2052);
        this.fWriteFileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fWriteFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        String[] files = SettingsHelper.restoreListSettings(MEMENTO_BUGZILLA_SAVEXMLLIST, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        String file = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_SAVEXMLNAME, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        this.restoreValuesForCombo(files, file, this.fWriteFileCombo);
        this.fBrowseWriteFile = new Button(optionsComposite, 8);
        this.fBrowseWriteFile.setText(Messages.ImportBugzillaMainPage_BROWSE);
        gridData = new GridData(256);
        gridData.horizontalIndent = 5;
        this.fBrowseWriteFile.setLayoutData((Object)gridData);
        this.fBrowseWriteFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(ImportBugzillaMainPage.MEMENTO_BUGZILLA_SAVEXMLNAME, ImportBugzillaMainPage.BUGZILLA_IMPORT_SECTION, ImportBugzillaMainPage.MEMENTO_BUGZILLA);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                }
                String suggested = ImportBugzillaMainPage.this.createSuggestedFilename();
                dialog.setFileName(suggested);
                dialog.setFilterExtensions(new String[]{"*.zip"});
                String res = dialog.open();
                if (res != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(ImportBugzillaMainPage.ZIP_SUFFIX)) {
                        fileName = fileName.concat(ImportBugzillaMainPage.ZIP_SUFFIX);
                    }
                    ImportBugzillaMainPage.this.fWriteFileCombo.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = ImportBugzillaMainPage.this.fWriteFileCombo.getItems().length - 1;
                    if (pos >= 0) {
                        ImportBugzillaMainPage.this.fWriteFileCombo.select(pos);
                    }
                    ImportBugzillaMainPage.this.updatePageComplete();
                }
            }
        });
        this.fOverwrite = new Button(indentOptionsComposite, 32);
        this.fOverwrite.setText(Messages.ImportBugzillaMainPage_OVERWRITE_EXISTING_RESOURCES);
        this.fOverwrite.setLayoutData((Object)new GridData(4, 1, true, false));
        boolean overwrite = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_OVERWRITE, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA));
        this.fOverwrite.setSelection(overwrite);
        this.fCustomMappingGroup = new Group(composite, 0);
        this.fCustomMappingGroup.setLayout((Layout)new GridLayout(3, false));
        this.fCustomMappingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fCustomMappingGroup.setText(Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING);
        this.fUseCustomMapping = new Button((Composite)this.fCustomMappingGroup, 32);
        this.fUseCustomMapping.setText(Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_ENABLED);
        this.fUseCustomMapping.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        boolean useCustomMapping = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_USE_CUSTOM_MAPPING, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA));
        this.fUseCustomMapping.setSelection(useCustomMapping);
        this.fUseCustomMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportBugzillaMainPage.this.updateUseCustomMappingEnablement();
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fSaveCustomMappingLink = new Hyperlink((Composite)this.fCustomMappingGroup, 0);
        this.fSaveCustomMappingLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.fSaveCustomMappingLink.setText(Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_SAVE_AS);
        this.fSaveCustomMappingLink.setToolTipText(Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_SAVE_AS_TOOLTIP);
        this.fSaveCustomMappingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(ImportBugzillaMainPage.MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE, ImportBugzillaMainPage.BUGZILLA_IMPORT_SECTION, ImportBugzillaMainPage.MEMENTO_BUGZILLA);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                } else {
                    dialog.setFileName(DEFAULT_MAPPING_FILE_NAME);
                }
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String res = dialog.open();
                String fileName = dialog.getFileName();
                if (res != null && fileName.length() > 0) {
                    IOException x;
                    File file;
                    block31: {
                        String message;
                        MessageDialog md;
                        String filePath;
                        Path path = new Path(dialog.getFilterPath());
                        path = path.addTrailingSeparator();
                        if (!fileName.endsWith(ImportBugzillaMainPage.XML_SUFFIX)) {
                            fileName = fileName.concat(ImportBugzillaMainPage.XML_SUFFIX);
                        }
                        if ((file = new File(filePath = String.valueOf(path.toOSString()) + fileName)).exists() && (md = new MessageDialog(shell, Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_SAVE_AS_DIALOG_TITLE, null, message = NLS.bind((String)Messages.ImportBugzillaMainPage_FILE_EXISTS_OVERWRITE, (Object)fileName, (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                            return;
                        }
                        x = null;
                        BufferedInputStream in = null;
                        OutputStream out = null;
                        try {
                            try {
                                in = new BufferedInputStream(BugzillaMapping.getDefaultMappingURL().openStream());
                                out = new BufferedOutputStream(new FileOutputStream(file));
                                int b = ((InputStream)in).read();
                                while (b != -1) {
                                    out.write(b);
                                    b = ((InputStream)in).read();
                                }
                            }
                            catch (IOException y) {
                                x = y;
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (x != null) {
                        ErrorDialog.openError((Shell)shell, (String)Messages.ImportBugzillaMainPage_ERROR_SAVING_FILE_DIALOG_TITLE, null, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.ImportBugzillaMainPage_ERROR_SAVING_FILE, (Throwable)x));
                    } else {
                        ImportBugzillaMainPage.this.openFile(file);
                    }
                }
            }
        });
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
        hyperlinkGroup.add(this.fSaveCustomMappingLink);
        this.fComputeCustomMappingLink = new Hyperlink((Composite)this.fCustomMappingGroup, 0);
        this.fComputeCustomMappingLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.fComputeCustomMappingLink.setText(Messages.ImportBugzillaMainPage_COMPUTE_FROM_DATA);
        this.fComputeCustomMappingLink.setToolTipText(Messages.ImportBugzillaMainPage_COMPUTE_FROM_DATA_TOOLTIP);
        this.fComputeCustomMappingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!ImportBugzillaMainPage.this.isPageComplete()) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.ImportBugzillaMainPage_INFORMATION_INCOMPLETE_TITLE, (String)Messages.ImportBugzillaMainPage_INFORMATION_INCOMPLETE_MESSAGE);
                    return;
                }
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(ImportBugzillaMainPage.MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE, ImportBugzillaMainPage.BUGZILLA_IMPORT_SECTION, ImportBugzillaMainPage.MEMENTO_BUGZILLA);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                } else {
                    dialog.setFileName(DEFAULT_MAPPING_FILE_NAME);
                }
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String res = dialog.open();
                String fileName = dialog.getFileName();
                if (res != null && fileName.length() > 0) {
                    String message;
                    MessageDialog md;
                    String filePath;
                    File file;
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    if (!fileName.endsWith(ImportBugzillaMainPage.XML_SUFFIX)) {
                        fileName = fileName.concat(ImportBugzillaMainPage.XML_SUFFIX);
                    }
                    if ((file = new File(filePath = String.valueOf(path.toOSString()) + fileName)).exists() && (md = new MessageDialog(shell, Messages.ImportBugzillaMainPage_COMPUTE_FROM_DATA_TITLE, null, message = NLS.bind((String)Messages.ImportBugzillaMainPage_FILE_EXISTS_OVERWRITE, (Object)fileName, (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                        return;
                    }
                    BugzillaImportWizard.performOperation(ImportBugzillaMainPage.this.getContainer(), ImportBugzillaMainPage.this, filePath);
                    ImportBugzillaMainPage.this.openFile(file);
                }
            }
        });
        hyperlinkGroup.add(this.fComputeCustomMappingLink);
        Composite indentOptionsComposite2 = WizardHelper.createIndentedComposite((Composite)this.fCustomMappingGroup, 3, 15);
        ((GridData)indentOptionsComposite2.getLayoutData()).horizontalSpan = 3;
        ((GridData)indentOptionsComposite2.getLayoutData()).grabExcessHorizontalSpace = true;
        this.fCustomMappingFileLabel = WizardHelper.createLabel(indentOptionsComposite2, Messages.ImportBugzillaMainPage_CUSTOM_DATA_MAPPING_FILE);
        this.fCustomMappingFile = new Combo(indentOptionsComposite2, 2052);
        this.fCustomMappingFile.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] customMappingFiles = SettingsHelper.restoreListSettings(MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE_LIST, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        String customMappingFile = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        this.restoreValuesForCombo(customMappingFiles, customMappingFile, this.fCustomMappingFile);
        this.fCustomMappingFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportBugzillaMainPage.this.updatePageComplete();
            }
        });
        this.fBrowseCustomMappingFile = new Button(indentOptionsComposite2, 8);
        this.fBrowseCustomMappingFile.setText(Messages.ImportBugzillaMainPage_BROWSE);
        gridData = new GridData(256);
        gridData.horizontalIndent = 5;
        this.fBrowseCustomMappingFile.setLayoutData((Object)gridData);
        this.fBrowseCustomMappingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell);
                String fileString = SettingsHelper.restoreSettings(ImportBugzillaMainPage.MEMENTO_BUGZILLA_CUSTOM_MAPPING_FILE, ImportBugzillaMainPage.BUGZILLA_IMPORT_SECTION, ImportBugzillaMainPage.MEMENTO_BUGZILLA);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                }
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String res = dialog.open();
                if (res != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(ImportBugzillaMainPage.XML_SUFFIX)) {
                        fileName = fileName.concat(ImportBugzillaMainPage.XML_SUFFIX);
                    }
                    ImportBugzillaMainPage.this.fCustomMappingFile.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = ImportBugzillaMainPage.this.fCustomMappingFile.getItems().length - 1;
                    if (pos >= 0) {
                        ImportBugzillaMainPage.this.fCustomMappingFile.select(pos);
                    }
                    ImportBugzillaMainPage.this.updatePageComplete();
                }
            }
        });
        String downloadMethod = SettingsHelper.restoreSettings(MEMENTO_BUGZILLA_ISBUGZILLAIMPORT, BUGZILLA_IMPORT_SECTION, MEMENTO_BUGZILLA);
        downloadMethod = downloadMethod == null ? Boolean.TRUE.toString() : downloadMethod;
        boolean isBugzilla = Boolean.valueOf(downloadMethod);
        this.fImportFromBugzilla.setSelection(isBugzilla);
        this.setDownloadMethodEnablement(isBugzilla);
        this.fImportFromFile.setSelection(!isBugzilla);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.bugzilla_import_wizard_main_page");
        this.updatePageComplete(false);
    }

    private void restoreValuesForCombo(String[] files, String file, Combo combo) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    combo.add(files[i]);
                }
                ++i;
            }
        }
        if (file != null) {
            String[] fileItems = combo.getItems();
            int i = 0;
            while (i < fileItems.length) {
                if (fileItems[i].equals(file)) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    private void setRangeEnablement(boolean value) {
        this.fRangeGroup.setEnabled(value);
        this.fImportRange.setEnabled(value);
        this.fImportSingle.setEnabled(value);
        this.fSingleBug.setEnabled(value);
        this.fFromBug.setEnabled(value);
        this.fToBugLabel.setEnabled(value);
        this.fToBug.setEnabled(value);
        this.fImportProduct.setEnabled(value);
        this.fProductName.setEnabled(value);
        if (value) {
            this.updateFromToEnablement();
        }
    }

    private void updateFromToEnablement() {
        if (this.isFilterProduct()) {
            this.fSingleBug.setEnabled(false);
            this.fFromBug.setEnabled(false);
            this.fToBugLabel.setEnabled(false);
            this.fToBug.setEnabled(false);
            this.fProductName.setEnabled(true);
        } else {
            this.fSingleBug.setEnabled(this.fImportSingle.getSelection());
            this.fFromBug.setEnabled(!this.fImportSingle.getSelection());
            this.fToBugLabel.setEnabled(!this.fImportSingle.getSelection());
            this.fToBug.setEnabled(!this.fImportSingle.getSelection());
            this.fProductName.setEnabled(false);
        }
    }

    private void setCredentialEnablement(boolean value) {
        this.fAuthGroup.setEnabled(value);
        this.fUserLabel.setEnabled(value);
        this.fUserInput.setEnabled(value);
        this.fPassLabel.setEnabled(value);
        this.fPassInput.setEnabled(value);
        this.fAuthCheck.setEnabled(value);
        this.fAuthMethodBasic.setEnabled(value);
        this.fAuthMethodCookies.setEnabled(value);
        if (value) {
            this.updateCredentialEnablement();
        }
    }

    private void updateCredentialEnablement() {
        this.fUserLabel.setEnabled(this.fAuthCheck.getSelection());
        this.fUserInput.setEnabled(this.fAuthCheck.getSelection());
        this.fPassLabel.setEnabled(this.fAuthCheck.getSelection());
        this.fPassInput.setEnabled(this.fAuthCheck.getSelection());
        this.fAuthMethodBasic.setEnabled(this.fAuthCheck.getSelection());
        this.fAuthMethodCookies.setEnabled(this.fAuthCheck.getSelection());
    }

    private void setSaveXMLEnablement(boolean value) {
        this.fSaveXMLToFileSystem.setEnabled(value);
        if (!value) {
            this.fWriteFileLabel.setEnabled(value);
            this.fWriteFileCombo.setEnabled(value);
            this.fBrowseWriteFile.setEnabled(value);
            this.fOverwrite.setEnabled(value);
        }
        this.updateSaveXMLEnablement();
    }

    private void updateSaveXMLEnablement() {
        boolean saveXML = this.fSaveXMLToFileSystem.getSelection();
        this.fWriteFileLabel.setEnabled(saveXML);
        this.fWriteFileCombo.setEnabled(saveXML);
        this.fBrowseWriteFile.setEnabled(saveXML);
        this.fOverwrite.setEnabled(saveXML);
        this.fProjectAreaLabel.setEnabled(!saveXML);
        this.fProjectAreaCombo.setEnabled(!saveXML);
        this.fCustomMappingGroup.setEnabled(!saveXML);
        this.fSaveCustomMappingLink.setEnabled(!saveXML);
        this.fComputeCustomMappingLink.setEnabled(!saveXML);
        this.fUseCustomMapping.setEnabled(!saveXML);
        this.updateUseCustomMappingEnablement();
    }

    private void updateUseCustomMappingEnablement() {
        boolean enabled = !this.fSaveXMLToFileSystem.getSelection() && this.fUseCustomMapping.getSelection();
        this.fCustomMappingFileLabel.setEnabled(enabled);
        this.fCustomMappingFile.setEnabled(enabled);
        this.fBrowseCustomMappingFile.setEnabled(enabled);
    }

    private void setDownloadMethodEnablement(boolean value) {
        this.fReadFileCombo.setEnabled(!value);
        this.fBrowseReadFile.setEnabled(!value);
        this.fBugzillaURL.setEnabled(value);
        this.setRangeEnablement(value);
        this.setCredentialEnablement(value);
        this.setSaveXMLEnablement(value);
        if (!value) {
            this.fImportToProjectArea.setSelection(true);
            this.fSaveXMLToFileSystem.setSelection(false);
            this.updateSaveXMLEnablement();
        }
    }

    private String createSuggestedFilename() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmm");
        String now = format.format(new Date());
        if (this.isFilterProduct()) {
            return NLS.bind((String)Messages.ImportBugzillaMainPage_IMPORT_TO_ZIP_FILE__TIME_IMPORTED_PRODUCT_ZIP, (Object)now, (Object[])new Object[]{this.getProductName(), ZIP_SUFFIX});
        }
        if (!"".equals(this.getToBugId()) && !this.getToBugId().equals(this.getFromBugId())) {
            return NLS.bind((String)Messages.ImportBugzillaMainPage_IMPORT_TO_ZIP_FILE__TIME_IMPORTED_FROM_TO_ZIP, (Object)now, (Object[])new Object[]{this.getFromBugId(), this.getToBugId(), ZIP_SUFFIX});
        }
        return NLS.bind((String)Messages.ImportBugzillaMainPage_IMPORT_TO_ZIP_FILE__TIME_IMPORTED_BUGID_ZIP, (Object)now, (Object[])new Object[]{this.getFromBugId(), ZIP_SUFFIX});
    }

    private void openFile(File file) {
        if (file.exists()) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && workbench.getWorkbenchWindows().length > 0) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null && window.getPages().length > 0) {
                        page = window.getPages()[0];
                    }
                    if (page != null) {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath())));
                    }
                }
            }
            catch (PartInitException x) {
                WorkItemRCPUIPlugin.getDefault().log(x.getLocalizedMessage(), x);
            }
        }
    }

    private void updatePageComplete() {
        this.updatePageComplete(true);
    }

    private void updatePageComplete(boolean showErrors) {
        if (!this.isControlCreated()) {
            return;
        }
        String error = null;
        if (this.fImportToProjectArea.getSelection()) {
            error = this.validateOptions();
        }
        if (error == null) {
            error = this.validateLocation();
        }
        if (error == null) {
            error = this.validateRange();
        }
        if (error == null) {
            error = this.validateOptions();
        }
        if (error == null) {
            error = this.validateCustomMapping();
        }
        this.setPageComplete(error == null);
        this.setErrorMessage(showErrors ? error : null);
    }

    private String validateLocation() {
        if (this.fImportFromBugzilla.getSelection()) {
            try {
                new URL(this.fBugzillaURL.getText());
            }
            catch (MalformedURLException malformedURLException) {
                return Messages.ImportBugzillaMainPage_ENTER_VALID_URL;
            }
        } else if (this.fReadFileCombo.getText().length() == 0) {
            return Messages.ImportBugzillaMainPage_ENTER_VALID_SOURCE_FILE;
        }
        return null;
    }

    private String validateRange() {
        if (!this.fImportFromBugzilla.getSelection()) {
            return null;
        }
        if (this.fImportSingle.getSelection()) {
            if (!this.isPositiveInteger(this.fSingleBug.getText())) {
                return Messages.ImportBugzillaMainPage_ENTER_VALID_BUG_NUMBER;
            }
        } else if (this.fImportRange.getSelection()) {
            if (!this.isPositiveInteger(this.fFromBug.getText()) || !this.isPositiveInteger(this.fToBug.getText())) {
                return Messages.ImportBugzillaMainPage_ENTER_VALID_BUG_NUMBERS;
            }
            if (Integer.parseInt(this.fFromBug.getText()) > Integer.parseInt(this.fToBug.getText())) {
                return Messages.ImportBugzillaMainPage_ENTER_VALID_BUG_RANGE;
            }
        } else if (this.fProductName.getText().length() == 0) {
            return Messages.ImportBugzillaMainPage_ENTER_VALID_PRODUCT;
        }
        return null;
    }

    private String validateOptions() {
        if (this.fImportToProjectArea.getSelection()) {
            if (this.fProjectAreas.length == 0) {
                return Messages.ImportBugzillaMainPage_ENTER_VALID_PROJECT_AREA;
            }
        } else if (this.fWriteFileCombo.getText().length() == 0) {
            return Messages.ImportBugzillaMainPage_ENTER_VALID_DESTINATION_FILE;
        }
        return null;
    }

    private String validateCustomMapping() {
        if (this.fImportToProjectArea.getSelection() && this.fUseCustomMapping.getSelection() && this.fCustomMappingFile.getText().length() == 0) {
            return Messages.ImportBugzillaMainPage_ENTER_VALID_MAPPING_FILE;
        }
        return null;
    }

    private boolean isPositiveInteger(String string) {
        try {
            return Integer.parseInt(string) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isBugzillaImport() {
        return this.fImportFromBugzilla.getSelection();
    }

    public String getImportFile() {
        return this.fReadFileCombo.getText();
    }

    public String getBugzillaURL() {
        return this.fBugzillaURL.getText();
    }

    public String getUserName() {
        return this.fUserInput.getText();
    }

    public String getPassword() {
        return this.fPassInput.getText();
    }

    public boolean isBasicHTTPAuthentication() {
        return this.fAuthMethodBasic.getSelection();
    }

    public boolean isSaveXML() {
        return this.fSaveXMLToFileSystem.getSelection();
    }

    public IProjectAreaHandle getProjectArea() {
        int index = this.fProjectAreaCombo.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fProjectAreas[index];
    }

    public String getSaveFileName() {
        return this.fWriteFileCombo.getText();
    }

    public String[] getSaveFileList() {
        return this.fWriteFileCombo.getItems();
    }

    public String[] getImportFileList() {
        return this.fReadFileCombo.getItems();
    }

    public boolean isOverWrite() {
        return this.fOverwrite.getSelection();
    }

    public boolean isUseCustomMapping() {
        return this.fUseCustomMapping.getSelection();
    }

    public String getCustomMappingFile() {
        return this.fCustomMappingFile.getText();
    }

    public String[] getCustomMappingFileList() {
        return this.fCustomMappingFile.getItems();
    }

    public boolean needsAuthentication() {
        return this.fAuthCheck.getSelection();
    }

    public String getFromBugId() {
        if (this.fImportSingle.getSelection()) {
            return this.fSingleBug.getText();
        }
        return this.fFromBug.getText();
    }

    public String getToBugId() {
        if (this.fImportSingle.getSelection()) {
            return this.fSingleBug.getText();
        }
        return this.fToBug.getText();
    }

    public boolean isFilterProduct() {
        return this.fImportProduct.getSelection();
    }

    public String getProductName() {
        return this.fProductName.getText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fBugzillaURL.setFocus();
        }
    }
}

