/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.actions.ProjectAreaSelectionAction;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemSelectorHelper {
    private ITeamRepository fTeamRepository;
    private Control fControl;
    private WorkItemSelector fViewer;
    private Label fProgressLabel;
    private Text fFilter;
    private Set<IWorkItemHandle> fExcluded = new ItemHandleAwareHashSet();
    private ToolBar fToolBar;
    private ToolItem fToolItem;
    private ProjectAreaSelectionAction fProjectAreaSelectionAction = new ProjectAreaSelectionAction("default"){

        protected void projectAreaSelected(IProjectAreaHandle projectAreaHandle) {
            WorkItemSelectorHelper.this.fViewer.setProjectArea(projectAreaHandle);
            WorkItemSelectorHelper.this.refreshResults();
        }
    };

    public WorkItemSelectorHelper(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
        this.fProjectAreaSelectionAction.setText(Messages.WorkItemSelectorHelper_PROJECT_AREA);
        this.fProjectAreaSelectionAction.restrictToRepository(teamRepository);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.createInputControl(container);
        Label label = new Label(container, 0);
        label.setText(Messages.WorkItemSelectorHelper_MATCHING_WORK_ITEMS);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fViewer = new WorkItemSelector(this.fTeamRepository, container, 2816, "");
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.setProgressLabel(this.fProgressLabel);
        this.fViewer.addFilter(new IFilter(){

            public boolean select(Object element) {
                return !WorkItemSelectorHelper.this.fExcluded.contains(element);
            }
        });
        this.fControl = container;
    }

    public Control getControl() {
        return this.fControl;
    }

    private void createInputControl(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        headerLayout.verticalSpacing = 0;
        header.setLayout((Layout)headerLayout);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(header, 0);
        label.setFont(parent.getFont());
        label.setText(Messages.WorkItemSelectorHelper_CONTAINING_ID_OR_TEXT);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fProgressLabel = new Label(header, 131072);
        this.fProgressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createViewMenu(header);
        this.fFilter = new Text(parent, 2048);
        this.fFilter.setFont(parent.getFont());
        this.fFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkItemSelectorHelper.this.refreshResults();
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    WorkItemSelectorHelper.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label.addTraverseListener((TraverseListener)new DelegatingTraverseListener((Control)this.fFilter));
    }

    private void createViewMenu(Composite parent) {
        this.fToolBar = new ToolBar(parent, 0x800000);
        this.fToolItem = new ToolItem(this.fToolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.fToolBar.setLayoutData((Object)data);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fToolItem.setImage(JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.VIEW_MENU));
        this.fToolItem.setToolTipText(Messages.WorkItemSelectorHelper_PROJECT_AREA);
        this.fToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkItemSelectorHelper.this.showViewMenu();
            }
        });
    }

    private void showViewMenu() {
        Menu menu = this.fProjectAreaSelectionAction.getMenu((Control)this.fViewer.getTable());
        Rectangle bounds = this.fToolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.fToolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    public void refreshResults() {
        this.fViewer.setSearchParameters(this.fFilter.getText(), false, false);
    }

    public String getFilterText() {
        return this.fFilter.getText();
    }

    public void addOpenListener(IOpenEventListener listener) {
        OpenStrategy openStrategy = new OpenStrategy((Control)this.fViewer.getTable());
        openStrategy.addOpenListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fViewer.getTable().addSelectionListener(listener);
    }

    public void addStatusListener(IElementSelectorStatusListener listener) {
        this.fViewer.addStatusListener(listener);
    }

    public void setFocus() {
        this.fFilter.setFocus();
    }

    public void setProjectArea(IProjectAreaHandle projectArea) {
        this.fViewer.setProjectArea(projectArea);
    }

    public void setExcluded(Collection<IWorkItemHandle> handles) {
        this.fExcluded.clear();
        this.fExcluded.addAll(handles);
    }

    public List<IWorkItemHandle> getWorkItemHandles() {
        return Arrays.asList(this.fViewer.getWorkItemHandles());
    }

    public int getItemCount() {
        return this.fViewer.getItemCount();
    }

    public void dispose() {
        if (this.fProjectAreaSelectionAction != null) {
            this.fProjectAreaSelectionAction.dispose();
            this.fProjectAreaSelectionAction = null;
        }
    }

    private static class DelegatingTraverseListener
    implements TraverseListener {
        private Control fFocusControl;

        public DelegatingTraverseListener(Control focusControl) {
            this.fFocusControl = focusControl;
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 128 && e.doit) {
                e.detail = 0;
                this.fFocusControl.setFocus();
            }
        }
    }
}

