/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ProjectAreaConnectionPage;
import com.ibm.team.process.ide.ui.WizardContext;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewWorkItemAction;
import com.ibm.team.workitem.rcp.ui.internal.wizards.INewWorkItemWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.SelectProjectAreaWizardPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.SelectWorkItemTypeWizardPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWorkItemWizard
extends Wizard
implements INewWizard,
INewWorkItemWizardContext {
    private ITeamRepository fRestrictToRepository;
    private IProjectAreaHandle fProjectArea;
    private IWorkItemType fType;
    private String fTypeId;
    private boolean noDefaultArea = false;
    private SelectWorkItemTypeWizardPage fTypePage;
    private WizardContext fProjectAreaSelectionPageContext = new WizardContext();
    protected RepositorySelectionPage fRepositorySelectionPage;
    protected RepositoryCreationPage fRepositoryCreationPage;
    protected ProjectAreaConnectionPage fProjectAreaSelectionPage;
    private List<? extends IProjectAreaHandle> fConnectedAreas = null;
    private WorkItemOperation fPostCreationOperation;

    public NewWorkItemWizard() {
        this(null);
    }

    public NewWorkItemWizard(IProjectAreaHandle projectArea) {
        this(projectArea != null ? (ITeamRepository)projectArea.getOrigin() : null, projectArea);
    }

    public NewWorkItemWizard(ITeamRepository restrictToRepository, IProjectAreaHandle projectArea) {
        List projectAreas;
        this.fRestrictToRepository = restrictToRepository;
        Assert.isTrue((restrictToRepository == null || projectArea == null || restrictToRepository == projectArea.getOrigin() ? 1 : 0) != 0);
        this.noDefaultArea = ConnectedProjectAreas.getInstance().getDefaultProjectArea(true) == null;
        this.fProjectArea = projectArea;
        if (this.fProjectArea == null && (projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRestrictToRepository)).size() == 1) {
            this.fProjectArea = (IProjectAreaHandle)projectAreas.get(0);
        }
        this.setWindowTitle(Messages.NewWorkItemWizard_CREATE_NEW_WORK_ITEM_WINDOW);
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public void setProjectArea(IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
        if (this.noDefaultArea) {
            ConnectedProjectAreas.getInstance().setDefaultProjectArea(projectArea);
        }
    }

    @Override
    public List<IProjectAreaHandle> getAvailableProjectAreas() {
        List areas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRestrictToRepository);
        if (areas.isEmpty() && this.getToBeConnectedAreas() != null) {
            areas.addAll(this.getToBeConnectedAreas());
        }
        return areas;
    }

    @Override
    public IWorkItemType getType() {
        return this.fType;
    }

    @Override
    public String getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setType(IWorkItemType type) {
        this.fType = type;
        if (type != null) {
            this.fTypeId = type.getIdentifier();
        }
    }

    public IWizardPage getStartingPage() {
        if (this.fProjectArea != null && ((ITeamRepository)this.fProjectArea.getOrigin()).loggedIn()) {
            return this.fTypePage;
        }
        return super.getStartingPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectProjectAreaWizardPage(this));
        this.fTypePage = new SelectWorkItemTypeWizardPage(this);
        this.addPage((IWizardPage)this.fTypePage);
    }

    public boolean performFinish() {
        if (this.fConnectedAreas != null && this.fProjectAreaSelectionPage != null) {
            this.fProjectAreaSelectionPage.connectSelectedProjectAreas();
        }
        return NewWorkItemAction.createWorkItem(this.fProjectArea, this.fType, this.fPostCreationOperation);
    }

    private List<? extends IProjectAreaHandle> getToBeConnectedAreas() {
        return this.fConnectedAreas;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fTypePage && ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRestrictToRepository).isEmpty() && this.fProjectAreaSelectionPage != null) {
            return this.fProjectAreaSelectionPage;
        }
        return super.getPreviousPage(page);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fRepositorySelectionPage) {
            ITeamRepository repos = this.fRepositorySelectionPage.getTeamRepository();
            if (repos == null) {
                return this.fRepositoryCreationPage;
            }
            this.fProjectAreaSelectionPageContext.setTeamRepository(repos);
            return this.fProjectAreaSelectionPage;
        }
        if (page == this.fRepositoryCreationPage) {
            ITeamRepository repo = this.fRepositoryCreationPage.createRepository(true);
            if (repo != null) {
                this.fProjectAreaSelectionPageContext.setTeamRepository(repo);
                return this.fProjectAreaSelectionPage;
            }
            return null;
        }
        if (page == this.fProjectAreaSelectionPage) {
            this.fConnectedAreas = this.fProjectAreaSelectionPage.getSelectedProjectAreas();
            if (this.fConnectedAreas == null || this.fConnectedAreas.isEmpty()) {
                return null;
            }
            if (this.fRestrictToRepository != null) {
                this.fConnectedAreas = new ArrayList<IProjectAreaHandle>(this.fConnectedAreas);
                Iterator<? extends IProjectAreaHandle> iter = this.fConnectedAreas.iterator();
                while (iter.hasNext()) {
                    if (iter.next().getOrigin() == this.fRestrictToRepository) continue;
                    iter.remove();
                }
            }
            if (this.fConnectedAreas.size() == 1) {
                this.fProjectArea = this.fConnectedAreas.get(0);
                return super.getNextPage(page).getNextPage();
            }
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.fProjectArea != null && this.fType != null || super.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        boolean hasTeamRepository;
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        boolean bl = hasTeamRepository = repositories.length > 0;
        if (this.fRestrictToRepository == null && !hasTeamRepository) {
            this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.NewWorkItemWizard_CREATE_REPOSITORY_CONNECTION);
            this.addPage((IWizardPage)this.fRepositoryCreationPage);
            this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.NewWorkItemWizard_SELECT_REPOSITORY_CONNECTION);
            this.addPage((IWizardPage)this.fRepositorySelectionPage);
            this.fProjectAreaSelectionPage = new ProjectAreaConnectionPage(this.fProjectAreaSelectionPageContext);
            this.addPage((IWizardPage)this.fProjectAreaSelectionPage);
        } else if (ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRestrictToRepository).isEmpty()) {
            if (this.fRestrictToRepository == null && repositories.length > 1) {
                this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.NewWorkItemWizard_SELECT_REPOSITORY_CONNECTION);
                this.addPage((IWizardPage)this.fRepositorySelectionPage);
                this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.NewWorkItemWizard_CREATE_REPOSITORY_CONNECTION);
                this.addPage((IWizardPage)this.fRepositoryCreationPage);
            }
            this.fProjectAreaSelectionPageContext.setTeamRepository(this.fRestrictToRepository != null ? this.fRestrictToRepository : repositories[0]);
            this.fProjectAreaSelectionPage = new ProjectAreaConnectionPage(this.fProjectAreaSelectionPageContext);
            this.addPage((IWizardPage)this.fProjectAreaSelectionPage);
        }
    }

    public void setPostCreationOperation(WorkItemOperation postCreationOperation) {
        this.fPostCreationOperation = postCreationOperation;
    }
}

