/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkTypePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkWorkItemOperation;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import com.ibm.team.workitem.rcp.ui.internal.wizards.WorkItemSelectorHelper;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkWorkItemWizard
extends Wizard {
    private static final String SEARCH_OPERATION_NAME = Messages.LinkWorkItemWizard_SEARCHING_WORK_ITEMS;
    private static final String RESOLVE_OPERATION_NAME = Messages.LinkWorkItemWizard_RESOLVING_WORK_ITEMS;
    private static final String DIALOG_SETTINGS_KEY = "linkWorkItem";
    private static final String LINK_TYPE_KEY = "linkType";
    private static final String END_POINT_KEY = "endPoint";
    private IDialogSettings fDialogSettings;
    private ITeamRepository fTeamRepository;
    private List<IWorkItemHandle> fWorkItems;
    private IProjectAreaHandle fProjectArea;
    private IWorkItemHandle fOpposite;
    private LinkTypePage fLinkTypePage;

    public LinkWorkItemWizard(ITeamRepository teamRepository, List<IWorkItemHandle> workItems) {
        this.fTeamRepository = teamRepository;
        this.fWorkItems = workItems;
        this.setWindowTitle(Messages.LinkWorkItemWizard_LINK_TO_WORK_ITEM_WINDOW);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.fLinkTypePage = new LinkTypePage(this.fWorkItems.size() > 1, new IEndPointDescriptor[0]);
        this.addPage((IWizardPage)this.fLinkTypePage);
        this.addPage((IWizardPage)new ChooseWorkItemPage());
        this.loadSettings();
    }

    public IEndPointDescriptor getEndPoint() {
        return this.fLinkTypePage.getEndPoint();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (LinkWorkItemWizard.this.getEndPoint().isSingleValued()) {
                            for (IWorkItemHandle handle : LinkWorkItemWizard.this.fWorkItems) {
                                LinkWorkItemOperation.run(handle, LinkWorkItemWizard.this.getEndPoint(), Collections.singletonList(LinkWorkItemWizard.this.fOpposite), monitor);
                            }
                        } else if (WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)LinkWorkItemWizard.this.getEndPoint())) {
                            LinkWorkItemOperation.run(LinkWorkItemWizard.this.fOpposite, LinkWorkItemWizard.this.getEndPoint(), LinkWorkItemWizard.this.fWorkItems, monitor);
                        } else {
                            ILinkType linkType = LinkWorkItemWizard.this.getEndPoint().getLinkType();
                            IEndPointDescriptor opposite = LinkWorkItemWizard.this.getEndPoint() == linkType.getTargetEndPointDescriptor() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
                            LinkWorkItemOperation.run(LinkWorkItemWizard.this.fOpposite, opposite, LinkWorkItemWizard.this.fWorkItems, monitor);
                        }
                    }
                    catch (TeamRepositoryException x) {
                        throw new InvocationTargetException(x, x.getMessage());
                    }
                }
            });
            WorkItemSelector.addToHistory(this.fOpposite);
            this.storeSettings();
            return true;
        }
        catch (InterruptedException x) {
            LinkWorkItemWizard.handleStatus((WizardPage)this.getContainer().getCurrentPage(), LinkWorkItemOperation.LINK_OPERATION_NAME, (IStatus)new Status(8, "com.ibm.team.workitem.rcp.ui", x.getMessage(), (Throwable)x));
            return false;
        }
        catch (InvocationTargetException x) {
            LinkWorkItemWizard.handleStatus((WizardPage)this.getContainer().getCurrentPage(), LinkWorkItemOperation.LINK_OPERATION_NAME, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", x.getMessage(), (Throwable)x));
            return false;
        }
    }

    private static void handleStatus(WizardPage page, String operationName, IStatus status) {
        WorkItemRCPUIPlugin.getDefault().log(status);
        int type = Utils.getMessageProviderType(status);
        String message = status.getException() != null ? ExceptionDescription.findDescription((String)operationName, (Throwable)status.getException()).getSummary() : status.getMessage();
        page.setMessage(type != 0 ? message : null, type);
    }

    private void loadSettings() {
        String linkTypeId;
        this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings != null && this.fDialogSettings.get(LINK_TYPE_KEY) != null && ILinkTypeRegistry.INSTANCE.isRegistered(linkTypeId = this.fDialogSettings.get(LINK_TYPE_KEY))) {
            ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
            boolean isTarget = this.fDialogSettings.get(END_POINT_KEY) != null ? this.fDialogSettings.getBoolean(END_POINT_KEY) : true;
            this.fLinkTypePage.setEndPoint(isTarget ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor());
        }
    }

    private void storeSettings() {
        if (this.fDialogSettings == null) {
            this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fDialogSettings.put(LINK_TYPE_KEY, this.getEndPoint() != null ? this.getEndPoint().getLinkType().getLinkTypeId() : null);
        this.fDialogSettings.put(END_POINT_KEY, (this.getEndPoint() != null ? Boolean.valueOf(this.getEndPoint() == this.getEndPoint().getLinkType().getTargetEndPointDescriptor()) : null).booleanValue());
    }

    private class ChooseWorkItemPage
    extends WizardPage
    implements IPageChangedListener {
        private WorkItemSelectorHelper fPicker;

        public ChooseWorkItemPage() {
            super(Messages.LinkWorkItemWizard_CHOOSE_WORK_ITEM_PAGE, Messages.LinkWorkItemWizard_CHOOSE_WORK_ITEM_PAGE, null);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).addPageChangedListener((IPageChangedListener)this);
            }
            this.fPicker = new WorkItemSelectorHelper(LinkWorkItemWizard.this.fTeamRepository);
            this.fPicker.createControl(container);
            this.fPicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.fPicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List<IWorkItemHandle> handles = ChooseWorkItemPage.this.fPicker.getWorkItemHandles();
                    boolean canFinish = handles.size() == 1;
                    ChooseWorkItemPage.this.setPageComplete(canFinish);
                    if (canFinish) {
                        LinkWorkItemWizard.this.fOpposite = handles.get(0);
                    } else {
                        LinkWorkItemWizard.this.fOpposite = null;
                    }
                }
            });
            this.fPicker.addOpenListener(new IOpenEventListener(){

                public void handleOpen(SelectionEvent e) {
                    IWizardContainer container = ChooseWorkItemPage.this.getContainer();
                    if (container instanceof WizardDialog) {
                        WizardDialog dialog = (WizardDialog)container;
                        if (ChooseWorkItemPage.this.getWizard().canFinish() && ChooseWorkItemPage.this.getWizard().performFinish()) {
                            dialog.close();
                        }
                    }
                }
            });
            this.fPicker.addStatusListener(new IElementSelectorStatusListener(){
                private boolean fIsError;

                public void reset() {
                    this.started(null);
                }

                public void started(String message) {
                    this.fIsError = false;
                    LinkWorkItemWizard.handleStatus(ChooseWorkItemPage.this, SEARCH_OPERATION_NAME, Status.OK_STATUS);
                }

                public void progress(String message, double actualWork, int totalWork) {
                }

                public void stopped() {
                    if (!this.fIsError) {
                        if (ChooseWorkItemPage.this.fPicker.getFilterText().length() > 0) {
                            int itemCount = ChooseWorkItemPage.this.fPicker.getItemCount();
                            String infoMessage = NLS.bind((String)Messages.LinkWorkItemWizard_WORK_ITEMS_FOUND, (Object)itemCount, (Object[])new Object[0]);
                            LinkWorkItemWizard.handleStatus(ChooseWorkItemPage.this, SEARCH_OPERATION_NAME, (IStatus)new Status(1, "com.ibm.team.workitem.rcp.ui", 1, infoMessage, null));
                        } else {
                            LinkWorkItemWizard.handleStatus(ChooseWorkItemPage.this, SEARCH_OPERATION_NAME, Status.OK_STATUS);
                        }
                    }
                }

                public void error(CoreException e) {
                    LinkWorkItemWizard.handleStatus(ChooseWorkItemPage.this, SEARCH_OPERATION_NAME, e.getStatus());
                    this.fIsError = true;
                }
            });
            Link link = new Link(container, 0);
            link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            link.setText(NLS.bind((String)"<a>{0}</a>", (Object)Messages.LinkWorkItemWizard_CREATE_NEW_WORK_ITEM, (Object[])new Object[0]));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWizardContainer container = ChooseWorkItemPage.this.getContainer();
                    if (container instanceof WizardDialog) {
                        LinkWorkItemWizard.this.storeSettings();
                        WizardDialog dialog = (WizardDialog)container;
                        Shell shell = dialog.getShell();
                        dialog.close();
                        ILinkType linkType = LinkWorkItemWizard.this.getEndPoint().getLinkType();
                        IEndPointDescriptor opposite = LinkWorkItemWizard.this.getEndPoint() == linkType.getTargetEndPointDescriptor() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
                        WorkItemUI.createWorkItem(shell, LinkWorkItemWizard.this.fProjectArea, LinkWorkItemOperation.create(opposite, LinkWorkItemWizard.this.fWorkItems, false));
                    }
                }
            });
            this.setPageComplete(false);
            this.setControl((Control)container);
            Dialog.applyDialogFont((Control)container);
            HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.link_work_item_wizard_choose_work_item_page");
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.resolveData();
            } else {
                this.setPageComplete(false);
            }
            super.setVisible(visible);
        }

        private void resolveData() {
            try {
                ItemHandleAwareHashSet excluded = new ItemHandleAwareHashSet();
                this.getContainer().run(true, true, new IRunnableWithProgress((Set)excluded){
                    private final /* synthetic */ Set val$excluded;
                    {
                        this.val$excluded = set;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IWorkItemClient workItemClient = (IWorkItemClient)LinkWorkItemWizard.this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
                        IWorkItemWorkingCopyManager manager = workItemClient.createWorkingCopyManager(Messages.LinkWorkItemWizard_LINK_WORK_ITEM_WIZARD, false);
                        try {
                            try {
                                boolean first = true;
                                ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY), (boolean)true);
                                for (IWorkItemHandle workItem : LinkWorkItemWizard.this.fWorkItems) {
                                    ItemHandleAwareHashSet current = new ItemHandleAwareHashSet();
                                    current.add(workItem);
                                    manager.connect(workItem, profile, monitor);
                                    WorkItemWorkingCopy workingCopy = manager.getWorkingCopy(workItem);
                                    List references = workingCopy.getReferences().getReferences(LinkWorkItemWizard.this.getEndPoint());
                                    for (IReference reference : references) {
                                        if (!reference.isItemReference() || !(((IItemReference)reference).getReferencedItem() instanceof IWorkItemHandle)) continue;
                                        current.add((IWorkItemHandle)((IItemReference)reference).getReferencedItem());
                                    }
                                    if (first) {
                                        first = false;
                                        this.val$excluded.addAll(current);
                                    } else {
                                        ItemHandleAwareHashSet tmp = new ItemHandleAwareHashSet();
                                        tmp.addAll(this.val$excluded);
                                        tmp.removeAll((Collection<?>)current);
                                        this.val$excluded.removeAll((Collection<?>)tmp);
                                    }
                                    if (LinkWorkItemWizard.this.fProjectArea != null) continue;
                                    LinkWorkItemWizard.this.fProjectArea = workingCopy.getWorkItem().getProjectArea();
                                }
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x, x.getMessage());
                            }
                        }
                        finally {
                            manager.dispose();
                        }
                    }
                });
                this.fPicker.setProjectArea(LinkWorkItemWizard.this.fProjectArea);
                this.fPicker.setExcluded((Collection<IWorkItemHandle>)excluded);
                this.fPicker.refreshResults();
                LinkWorkItemWizard.handleStatus(this, RESOLVE_OPERATION_NAME, Status.OK_STATUS);
            }
            catch (InterruptedException x) {
                LinkWorkItemWizard.handleStatus(this, RESOLVE_OPERATION_NAME, (IStatus)new Status(8, "com.ibm.team.workitem.rcp.ui", x.getMessage(), (Throwable)x));
            }
            catch (InvocationTargetException x) {
                LinkWorkItemWizard.handleStatus(this, RESOLVE_OPERATION_NAME, (IStatus)new Status(4, "com.ibm.team.workitem.rcp.ui", x.getMessage(), (Throwable)x));
            }
        }

        public void pageChanged(PageChangedEvent event) {
            if (event.getSelectedPage() == this) {
                this.fPicker.setFocus();
            }
        }

        public void dispose() {
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
            }
            if (this.fPicker != null) {
                this.fPicker.dispose();
                this.fPicker = null;
            }
            super.dispose();
        }
    }

    public static class LinkWorkItemAction
    implements IObjectActionDelegate {
        private IWorkbenchPart fTargetPart;
        private ISelection fSelection;

        public void run(IAction action) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (this.fTargetPart == null && window == null || this.fSelection == null) {
                return;
            }
            if (!(this.fSelection instanceof IStructuredSelection) || this.fSelection.isEmpty()) {
                return;
            }
            ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
            for (Object element : ((IStructuredSelection)this.fSelection).toList()) {
                if (!(element instanceof IWorkItemHandle) || !handles.isEmpty() && ((IWorkItemHandle)handles.get(0)).getOrigin() != ((IWorkItemHandle)element).getOrigin()) continue;
                handles.add((IWorkItemHandle)element);
            }
            if (handles.isEmpty()) {
                return;
            }
            Shell shell = this.fTargetPart != null ? this.fTargetPart.getSite().getShell() : window.getShell();
            LinkWorkItemWizard wizard = new LinkWorkItemWizard((ITeamRepository)((IWorkItemHandle)handles.get(0)).getOrigin(), handles);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.open();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            this.fSelection = selection;
            if (action != null) {
                action.setEnabled(this.isEnabled(selection));
            }
        }

        private boolean isEnabled(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object next : structuredSelection) {
                    if (next instanceof IWorkItemHandle) {
                        IWorkItem workitem;
                        IWorkItemHandle handle = (IWorkItemHandle)next;
                        if (!handle.hasFullState() || !(workitem = (IWorkItem)handle.getFullState()).isNewItem()) continue;
                        return false;
                    }
                    return false;
                }
                return !structuredSelection.isEmpty();
            }
            return false;
        }

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fTargetPart = targetPart;
        }
    }
}

