/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkWorkItemOperation
extends WorkItemOperation {
    public static final String LINK_OPERATION_NAME = Messages.LinkWorkItemOperation_LINKING_WORK_ITEMS;
    private IEndPointDescriptor fEndPoint;
    private List<IWorkItemHandle> fTargets;
    private boolean fCommitChanges;

    public static void run(IWorkItemHandle workItem, IEndPointDescriptor endPoint, List<IWorkItemHandle> targets, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkWorkItemOperation operation = LinkWorkItemOperation.create(endPoint, targets, true);
        operation.run(workItem, monitor);
    }

    public static LinkWorkItemOperation create(IEndPointDescriptor endPoint, List<IWorkItemHandle> targets, boolean commitChanges) {
        return new LinkWorkItemOperation(endPoint, targets, commitChanges);
    }

    private LinkWorkItemOperation(IEndPointDescriptor endPoint, List<IWorkItemHandle> targets, boolean commitChanges) {
        super(LINK_OPERATION_NAME, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.emptyList(), (boolean)true));
        this.fEndPoint = endPoint;
        this.fTargets = targets;
        this.fCommitChanges = commitChanges;
    }

    protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItemReferences references = workingCopy.getReferences();
        List targets = this.fTargets.size() == 1 ? auditableClient.resolveAuditablesPermissionAware(this.fTargets, IWorkItem.SMALL_PROFILE, monitor) : auditableClient.resolveAuditables(this.fTargets, IWorkItem.SMALL_PROFILE, monitor);
        for (IWorkItem target : targets) {
            if (target == null || target.sameItemId((IItemHandle)workingCopy.getWorkItem())) continue;
            boolean found = false;
            IItemReference reference = WorkItemLinkTypes.createWorkItemReference((IWorkItem)target);
            for (IReference current : references.getReferences(this.fEndPoint)) {
                if (!current.sameDetailsExcludingCommentAs((IReference)reference)) continue;
                found = true;
                break;
            }
            if (found) continue;
            references.add(this.fEndPoint, (IReference)reference);
        }
    }

    protected void commit(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCommitChanges) {
            super.commit(workingCopies, monitor);
        }
    }
}

