/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.wizards;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.CopyToProjectOperation;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import com.ibm.team.workitem.rcp.ui.internal.wizards.CopyToProjectAreaOperation;
import com.ibm.team.workitem.rcp.ui.internal.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyToProjectAreaWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "copyToProjectArea";
    private static final String TARGET_AREA_KEY = "targetArea";
    private static final String MOVE_KEY = "move";
    private static final String RESOLVE_SOURCE_KEY = "resolveSource";
    private IDialogSettings fDialogSettings;
    private List<IWorkItemHandle> fWorkItems;
    private ITeamRepository fTeamRepository;
    private IProjectAreaHandle fTargetArea;
    private boolean fMove = false;
    private boolean fResolveSource = false;
    private boolean fMoveAttachments = true;
    private boolean fCopyAllowed = true;

    public CopyToProjectAreaWizard(List<IWorkItemHandle> workItems) {
        this.fWorkItems = workItems;
        this.fTeamRepository = this.findTeamRepository(this.fWorkItems);
        this.setWindowTitle(Messages.CopyToProjectAreaWizard_COPY_TO_PROJECT_AREA_WIZARD);
        this.setNeedsProgressMonitor(true);
        this.loadSettings();
    }

    private ITeamRepository findTeamRepository(List<IWorkItemHandle> workItems) {
        if (workItems.isEmpty()) {
            return null;
        }
        ITeamRepository teamRepository = (ITeamRepository)workItems.get(0).getOrigin();
        for (IWorkItemHandle workItem : workItems) {
            if (workItem.getOrigin() == teamRepository) continue;
            return null;
        }
        return teamRepository;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new ChooseProjectAreaPage());
        this.addPage((IWizardPage)new ConfirmProblemsPage());
    }

    private void setCopyAllowed(boolean allowed) {
        this.fCopyAllowed = allowed;
        if (!allowed) {
            this.fMove = true;
        }
    }

    public boolean performFinish() {
        try {
            String name = this.fMove ? Messages.CopyToProjectAreaWizard_MOVING : Messages.CopyToProjectAreaWizard_COPYING;
            final CopyToProjectAreaOperation operation = new CopyToProjectAreaOperation(name, this.fTargetArea, true, this.fMove, this.fResolveSource, this.fMoveAttachments);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        operation.run(CopyToProjectAreaWizard.this.fWorkItems.toArray(new IWorkItemHandle[CopyToProjectAreaWizard.this.fWorkItems.size()]), monitor);
                    }
                    catch (TeamRepositoryException x) {
                        throw new InvocationTargetException(x, x.getMessage());
                    }
                }
            });
            this.storeSettings();
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException x) {
            WorkItemRCPUIPlugin.getDefault().log(x.getMessage(), x);
            return false;
        }
    }

    private void loadSettings() {
        this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings != null && this.fDialogSettings.get(TARGET_AREA_KEY) != null) {
            this.fTargetArea = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle((Object)this.fTeamRepository, UUID.valueOf((String)this.fDialogSettings.get(TARGET_AREA_KEY)), null);
        }
        if (this.fDialogSettings != null && this.fDialogSettings.get(MOVE_KEY) != null) {
            this.fMove = this.fDialogSettings.getBoolean(MOVE_KEY);
        }
        if (this.fDialogSettings != null && this.fDialogSettings.get(RESOLVE_SOURCE_KEY) != null) {
            this.fResolveSource = this.fDialogSettings.getBoolean(RESOLVE_SOURCE_KEY);
        }
    }

    private void storeSettings() {
        if (this.fDialogSettings == null) {
            this.fDialogSettings = WorkItemRCPUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fDialogSettings.put(TARGET_AREA_KEY, this.fTargetArea != null ? this.fTargetArea.getItemId().getUuidValue() : null);
        this.fDialogSettings.put(MOVE_KEY, this.fMove);
        this.fDialogSettings.put(RESOLVE_SOURCE_KEY, this.fResolveSource);
    }

    private class ChooseProjectAreaPage
    extends WizardPage {
        private TableViewer fViewer;
        private Button fMoveRadio;
        private Button fCopyRadio;
        private Button fResolveSourceBox;
        private Button fMoveAttachmentsBox;

        public ChooseProjectAreaPage() {
            super(Messages.CopyToProjectAreaWizard_TARGET_PROJECT_AREA_PAGE, Messages.CopyToProjectAreaWizard_TARGET_PROJECT_AREA_PAGE, ImagePool.MOVE_COPY_WIZARD);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            container.setLayout((Layout)layout);
            Label label = new Label(container, 0);
            label.setText(Messages.CopyToProjectAreaWizard_PROJECT_AREAS_LABEL);
            this.fViewer = new TableViewer(container, 2820);
            this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
            this.fViewer.setSorter(new ViewerSorter());
            this.fViewer.setComparer((IElementComparer)new ItemComparer());
            label = new Label(container, 0);
            label.setText(Messages.CopyToProjectAreaWizard_OPTIONS_LABEL);
            this.fCopyRadio = new Button(container, 16);
            this.fCopyRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fCopyRadio.setText(Messages.CopyToProjectAreaWizard_COPY_OPTION);
            this.fCopyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CopyToProjectAreaWizard.this.fMove = !((Button)e.widget).getSelection();
                    ChooseProjectAreaPage.this.updateRadios();
                }
            });
            this.fResolveSourceBox = new Button(container, 32);
            GridData data = new GridData(16384, 0x1000000, false, false);
            data.horizontalIndent = 21;
            this.fResolveSourceBox.setLayoutData((Object)data);
            this.fResolveSourceBox.setText(Messages.CopyToProjectAreaWizard_RESOLVE_OPTION);
            this.fResolveSourceBox.setSelection(CopyToProjectAreaWizard.this.fResolveSource);
            this.fResolveSourceBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CopyToProjectAreaWizard.this.fResolveSource = ((Button)e.widget).getSelection();
                }
            });
            this.fMoveRadio = new Button(container, 16);
            this.fMoveRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fMoveRadio.setText(Messages.CopyToProjectAreaWizard_MOVE_OPTION);
            this.fMoveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CopyToProjectAreaWizard.this.fMove = ((Button)e.widget).getSelection();
                    ChooseProjectAreaPage.this.updateRadios();
                }
            });
            this.fMoveAttachmentsBox = new Button(container, 32);
            data = new GridData(16384, 0x1000000, false, false);
            data.horizontalIndent = 21;
            this.fMoveAttachmentsBox.setLayoutData((Object)data);
            this.fMoveAttachmentsBox.setText(Messages.CopyToProjectAreaWizard_MOVE_ATTACHMENTS_OPTION);
            this.fMoveAttachmentsBox.setSelection(CopyToProjectAreaWizard.this.fMoveAttachments);
            this.fMoveAttachmentsBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CopyToProjectAreaWizard.this.fMoveAttachments = ((Button)e.widget).getSelection();
                }
            });
            this.updateRadios();
            this.setPageComplete(false);
            this.setControl((Control)container);
            Dialog.applyDialogFont((Control)container);
            HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.copy_to_project_area_wizard_configuration_page");
        }

        private void updateRadios() {
            boolean move = CopyToProjectAreaWizard.this.fMove || !CopyToProjectAreaWizard.this.fCopyAllowed;
            this.fMoveRadio.setSelection(move);
            this.fMoveAttachmentsBox.setEnabled(move);
            this.fCopyRadio.setSelection(!move);
            this.fResolveSourceBox.setEnabled(!move);
            if (!CopyToProjectAreaWizard.this.fCopyAllowed) {
                this.fCopyRadio.setEnabled(false);
            }
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.computeProjectAreas();
            }
            super.setVisible(visible);
        }

        private void computeProjectAreas() {
            try {
                if (CopyToProjectAreaWizard.this.fWorkItems.isEmpty()) {
                    this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_NO_WORK_ITEMS_SELECTED);
                } else if (CopyToProjectAreaWizard.this.fTeamRepository == null) {
                    this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_WORK_ITEMS_FROM_MULTIPLE_REPOSITORIES);
                } else {
                    ItemHandleAwareHashSet projectAreas = new ItemHandleAwareHashSet((Collection)ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(CopyToProjectAreaWizard.this.fTeamRepository));
                    this.getContainer().run(true, true, new IRunnableWithProgress((Set)projectAreas){
                        private final /* synthetic */ Set val$projectAreas;
                        {
                            this.val$projectAreas = set;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                IAuditableClient auditableClient = (IAuditableClient)CopyToProjectAreaWizard.this.fTeamRepository.getClientLibrary(IAuditableClient.class);
                                IWorkItemClient workItemClient = (IWorkItemClient)CopyToProjectAreaWizard.this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
                                IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
                                ItemProfile projectAreaProfile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.PROJECT_AREA_PROPERTY});
                                List resolved = auditableClient.resolveAuditables(CopyToProjectAreaWizard.this.fWorkItems, projectAreaProfile, monitor);
                                int i = 0;
                                while (i < CopyToProjectAreaWizard.this.fWorkItems.size()) {
                                    if (CopyToProjectAreaWizard.this.fWorkItems.get(i) != null) {
                                        IWorkItemHandle handle = (IWorkItemHandle)CopyToProjectAreaWizard.this.fWorkItems.get(i);
                                        boolean exists = workingCopyManager.connectLocal(handle, projectAreaProfile);
                                        if (exists) {
                                            this.val$projectAreas.remove(workingCopyManager.getWorkingCopy(handle).getWorkItem().getProjectArea());
                                            workingCopyManager.disconnect(handle);
                                        } else {
                                            this.val$projectAreas.remove(((IWorkItem)resolved.get(i)).getProjectArea());
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x, x.getMessage());
                            }
                        }
                    });
                    if (projectAreas.isEmpty()) {
                        this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_NOT_CONNECTED_TO_OTHER_PROJECT_AREA);
                    } else {
                        this.fViewer.setLabelProvider((IBaseLabelProvider)new ProjectAreaPicker.ProjectAreaLabelProvider(new ArrayList<IProjectAreaHandle>((Collection<IProjectAreaHandle>)projectAreas)));
                        this.fViewer.setInput((Object)projectAreas);
                        this.fViewer.addOpenListener(new IOpenListener(){

                            public void open(OpenEvent event) {
                                ChooseProjectAreaPage.this.getContainer().showPage(ChooseProjectAreaPage.this.getNextPage());
                            }
                        });
                        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                                CopyToProjectAreaWizard.this.fTargetArea = (IProjectAreaHandle)selection.getFirstElement();
                            }
                        });
                        if (CopyToProjectAreaWizard.this.fTargetArea != null && projectAreas.contains(CopyToProjectAreaWizard.this.fTargetArea)) {
                            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)CopyToProjectAreaWizard.this.fTargetArea));
                        } else {
                            this.fViewer.setSelection((ISelection)new StructuredSelection(this.fViewer.getElementAt(0)));
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_CANCELED);
            }
            catch (InvocationTargetException x) {
                this.fViewer.setInput((Object)x.getMessage());
            }
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            this.setPageComplete(selection.getFirstElement() instanceof IProjectAreaHandle);
        }
    }

    private class ConfirmProblemsPage
    extends WizardPage {
        private TableViewer fViewer;

        public ConfirmProblemsPage() {
            super(Messages.CopyToProjectAreaWizard_COPY_PROBLEMS_PAGE, Messages.CopyToProjectAreaWizard_COPY_PROBLEMS_PAGE, ImagePool.MOVE_COPY_WIZARD);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            container.setLayout((Layout)layout);
            Composite composite = new Composite(container, 0){

                public Point computeSize(int hint, int hint2, boolean changed) {
                    Point size = super.computeSize(hint, hint2, changed);
                    size.x = 100;
                    return size;
                }
            };
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            composite.setLayout((Layout)new FillLayout());
            Label label = new Label(composite, 64);
            label.setText(Messages.CopyToProjectAreaWizard_COPY_PROBLEMS);
            this.fViewer = new TableViewer(container, 2820);
            this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.fViewer.setContentProvider((IContentProvider)new SimpleContentProvider());
            this.setPageComplete(false);
            this.setControl((Control)container);
            Dialog.applyDialogFont((Control)container);
            HelpContextIds.hookHelpListener((Control)container, "com.ibm.team.workitem.rcp.ui.copy_to_project_area_wizard_problem_page");
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.computeProblems();
            } else {
                this.setPageComplete(false);
            }
            super.setVisible(visible);
        }

        private void computeProblems() {
            try {
                final CopyToProjectAreaOperation preflight = new CopyToProjectAreaOperation(Messages.CopyToProjectAreaWizard_COMPUTING_PROBLEMS, CopyToProjectAreaWizard.this.fTargetArea, false, CopyToProjectAreaWizard.this.fMove, CopyToProjectAreaWizard.this.fResolveSource, CopyToProjectAreaWizard.this.fMoveAttachments);
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            preflight.run(CopyToProjectAreaWizard.this.fWorkItems.toArray(new IWorkItemHandle[CopyToProjectAreaWizard.this.fWorkItems.size()]), monitor);
                        }
                        catch (TeamRepositoryException x) {
                            throw new InvocationTargetException(x, x.getMessage());
                        }
                    }
                });
                List<CopyToProjectOperation.CopyProblem> problems = preflight.getCopyProblems();
                if (problems.isEmpty()) {
                    this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_NO_PROBLEMS);
                } else {
                    this.fViewer.setInput(problems);
                }
                this.setPageComplete(true);
            }
            catch (InterruptedException interruptedException) {
                this.fViewer.setInput((Object)Messages.CopyToProjectAreaWizard_CANCELED);
            }
            catch (InvocationTargetException x) {
                this.fViewer.setInput((Object)x.getMessage());
            }
        }
    }

    public static class CopyToProjectAreaAction
    implements IObjectActionDelegate {
        private IWorkbenchPart fTargetPart;
        private ISelection fSelection;
        private boolean fCopy = true;

        public void run(IAction action) {
            Object[] elements;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (this.fTargetPart == null && window == null || this.fSelection == null) {
                return;
            }
            if (!(this.fSelection instanceof IStructuredSelection) || this.fSelection.isEmpty()) {
                return;
            }
            ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
            Object[] objectArray = elements = ((IStructuredSelection)this.fSelection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IWorkItemHandle) {
                    handles.add((IWorkItemHandle)element);
                }
                ++n2;
            }
            if (handles.isEmpty()) {
                return;
            }
            Shell shell = this.fTargetPart != null ? this.fTargetPart.getSite().getShell() : window.getShell();
            CopyToProjectAreaWizard wizard = new CopyToProjectAreaWizard(handles);
            boolean copyAllowed = true;
            for (IWorkItemHandle handle : handles) {
                ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
                boolean connected = workingCopyManager.connectLocal(handle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]));
                if (!connected) continue;
                try {
                    WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
                    if (!workingCopy.getWorkItem().isNewItem()) continue;
                    copyAllowed = false;
                    break;
                }
                finally {
                    workingCopyManager.disconnect(handle);
                }
            }
            wizard.setCopyAllowed(this.fCopy && copyAllowed);
            new WizardDialog(shell, (IWizard)wizard).open();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            this.fSelection = selection;
        }

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fTargetPart = targetPart;
        }

        public void setCopyAllowed(boolean allowed) {
            this.fCopy = allowed;
        }
    }

    private static class SimpleContentProvider
    implements IStructuredContentProvider {
        private SimpleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

