/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.QueryClient;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemResolver {
    private final HashSet<ITeamRepository> fRepositories;
    private final Collection<String> fAttributeIdentifiers;
    private final ItemProfile<IWorkItem> fProfile;

    public WorkItemResolver(Collection<String> attributeIdentifiers) {
        this.fAttributeIdentifiers = attributeIdentifiers;
        this.fRepositories = new HashSet();
        this.fProfile = this.computeProfile(attributeIdentifiers);
    }

    public List<ResolvedWorkItem> resolve(List<IWorkItemHandle> elements, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository lastRepo = null;
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        ArrayList<ResolvedWorkItem> resolvedWorkItems = new ArrayList<ResolvedWorkItem>();
        for (IWorkItemHandle object : elements) {
            if (!(object instanceof IWorkItemHandle)) continue;
            IWorkItemHandle handle = object;
            ITeamRepository repository = (ITeamRepository)handle.getOrigin();
            if (lastRepo == null || lastRepo == repository) {
                handles.add(handle);
            } else {
                resolvedWorkItems.addAll(this.resolveWorkItems(lastRepo, handles, monitor));
                handles.clear();
            }
            if (lastRepo == null || lastRepo != repository) {
                this.fRepositories.add(repository);
            }
            lastRepo = repository;
        }
        if (!handles.isEmpty()) {
            resolvedWorkItems.addAll(this.resolveWorkItems(lastRepo, handles, monitor));
        }
        return resolvedWorkItems;
    }

    private List<ResolvedWorkItem> resolveWorkItems(ITeamRepository repository, List<IWorkItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryClient queryClient = (QueryClient)repository.getClientLibrary(IQueryClient.class);
        List workItems = queryClient.resolveAuditables(handles, this.getItemProfile(), monitor);
        return ResolvedWorkItem.resolve((List)workItems, (IProgressMonitor)monitor);
    }

    public Collection<ITeamRepository> getTeamRepositories() {
        return this.fRepositories;
    }

    public ItemProfile<IWorkItem> getItemProfile() {
        return this.fProfile;
    }

    private ItemProfile<IWorkItem> computeProfile(Collection<String> attributeIdentifiers) {
        HashSet<String> attributes = new HashSet<String>();
        attributes.addAll(IWorkItem.SMALL_PROFILE.getProperties());
        for (String identifier : attributeIdentifiers) {
            if (AttributeIdentifiers.ATTRIBUTE_LIST.contains(identifier)) {
                attributes.add(identifier);
                continue;
            }
            attributes.addAll(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
        }
        attributes.add(IWorkItem.ID_PROPERTY);
        attributes.add(IWorkItem.DESCRIPTION_PROPERTY);
        attributes.add(IWorkItem.SUMMARY_PROPERTY);
        attributes.add(IItem.MODIFIED_PROPERTY);
        attributes.add(IWorkItem.DURATION_PROPERTY);
        attributes.add(IWorkItem.DUE_DATE_PROPERTY);
        attributes.add(IWorkItem.TAGS_PROPERTY);
        attributes.add(IWorkItem.OWNER_PROPERTY);
        attributes.add(IWorkItem.CREATOR_PROPERTY);
        attributes.add(IWorkItem.STATE_PROPERTY);
        if (attributes.contains(IWorkItem.STATE_PROPERTY) || attributes.contains(IWorkItem.RESOLUTION_PROPERTY)) {
            attributes.add(IWorkItem.WORKFLOW_SURROGATE_PROPERTY);
        }
        return ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, attributes);
    }

    public boolean matches(Collection<String> identifiers) {
        return this.fAttributeIdentifiers.containsAll(identifiers);
    }
}

