/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AbstractWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ArrayWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemRetrievalStrategy;
import org.eclipse.core.runtime.Assert;

public class WorkItemArraySource
extends AbstractWorkItemSource {
    private IWorkItemHandle[] fHandles;
    private WorkItemRetrievalStrategy fRetrievalStrategy;
    private String fName;
    private IProjectAreaHandle fProjectArea;

    public WorkItemArraySource(IProjectAreaHandle projectArea, IWorkItemHandle[] workItems, String name) {
        this(projectArea, workItems, name, new ArrayWorkItemRetrievalStrategy(workItems));
    }

    public WorkItemArraySource(IProjectAreaHandle projectArea, IWorkItemHandle[] workItems, String name, WorkItemRetrievalStrategy strategy) {
        Assert.isNotNull((Object)workItems);
        this.fName = name;
        this.fHandles = workItems;
        this.fRetrievalStrategy = strategy;
        this.fProjectArea = projectArea;
    }

    public String getName() {
        return this.fName;
    }

    public ITeamRepository getTeamRepository() {
        if (this.fHandles.length > 0) {
            return (ITeamRepository)this.fHandles[0].getOrigin();
        }
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        return repositories.length > 0 ? repositories[0] : null;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public boolean isEditable() {
        return false;
    }

    public IWorkItemRetrievalStrategy getRetrievalStrategy() {
        return this.fRetrievalStrategy;
    }

    public Object getDefinition() {
        return this.fHandles;
    }

    public Expression getExpression() {
        return null;
    }
}

