/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IRetrievalListener;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.RetrievalEvent;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public abstract class ResultRetrievalStrategy
extends EventManager
implements IResultRetrievalStrategy {
    private RetrievalTask fRootTask;

    public void addListener(IRetrievalListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(IRetrievalListener listener) {
        this.removeListenerObject(listener);
    }

    public boolean isRetrieving(Object parent) {
        if (parent == null && this.fRootTask == null) {
            return false;
        }
        Job[] jobs = Job.getJobManager().find(parent == null ? this.fRootTask : parent);
        int i = 0;
        while (i < jobs.length) {
            if (4 == jobs[i].getState()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized int retrieve(Object parent) {
        if (parent != IResultModel.ROOT && this.avoidRetrieval(parent)) {
            return 0;
        }
        if (parent == IResultModel.ROOT || this.isRetrieved(parent)) {
            return this.getResultModel().getChildCount(parent);
        }
        this.markRetrieved(parent);
        this.scheduleRetrievalTask(this.getChildRetrievalTask(parent));
        return 0;
    }

    public synchronized void refresh() {
        this.cancelRetrieval(this);
        this.initialize();
        this.fRootTask = this.getRootRetrievalTask();
        this.scheduleRetrievalTask(this.fRootTask);
    }

    public synchronized void cancelRetrieval(Object parent) {
        Job.getJobManager().cancel(IResultModel.ROOT == parent ? this.fRootTask : parent);
    }

    protected void scheduleRetrievalTask(RetrievalTask task) {
        if (task == null) {
            return;
        }
        RetrievalJob job = new RetrievalJob(task, this);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                RetrievalJob job = (RetrievalJob)event.getJob();
                ResultRetrievalStrategy.this.fireRetrievalEvent(RetrievalEvent.getStartedEvent(ResultRetrievalStrategy.this, job.getTask().getParentElement()));
            }

            public void done(IJobChangeEvent event) {
                RetrievalJob job = (RetrievalJob)event.getJob();
                IStatus status = job.getTask().getStatus();
                RetrievalEvent retrievalEvent = 8 == status.getSeverity() ? RetrievalEvent.getCanceledEvent(ResultRetrievalStrategy.this, job.getTask().getParentElement()) : (4 == status.getSeverity() || 2 == status.getSeverity() ? RetrievalEvent.getFailedEvent(ResultRetrievalStrategy.this, job.getTask().getParentElement(), status) : RetrievalEvent.getFinishedEvent(ResultRetrievalStrategy.this, job.getTask().getParentElement(), job.getTask().getElapsedTime(), status));
                ResultRetrievalStrategy.this.fireRetrievalEvent(retrievalEvent);
            }
        });
        job.schedule();
    }

    protected void fireRetrievalEvent(RetrievalEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IRetrievalListener)listeners[i]).statusChanged(event);
            ++i;
        }
    }

    protected void fireProgressEvent(Object parentElement, int retrieved, int ofTotal) {
        this.fireRetrievalEvent(RetrievalEvent.getProgressEvent(this, parentElement, ofTotal, retrieved));
    }

    protected abstract RetrievalTask getRootRetrievalTask();

    protected abstract RetrievalTask getChildRetrievalTask(Object var1);

    protected abstract boolean avoidRetrieval(Object var1);

    protected abstract boolean isRetrieved(Object var1);

    protected abstract void markRetrieved(Object var1);

    protected abstract void initialize();

    private static class RetrievalJob
    extends FoundationJob {
        private RetrievalTask fTask;
        private ResultRetrievalStrategy fStrategy;

        public RetrievalJob(RetrievalTask task, ResultRetrievalStrategy strategy) {
            super(task.getDescription());
            this.fTask = task;
            this.fStrategy = strategy;
        }

        public boolean belongsTo(Object family) {
            return family == this.fStrategy || family == this.fTask || family == this.fTask.getParentElement();
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            this.fTask.run(monitor);
            return Status.OK_STATUS;
        }

        public RetrievalTask getTask() {
            return this.fTask;
        }
    }

    protected static abstract class RetrievalTask {
        private IStatus fStatus;
        private long fStartedTimestamp;
        private long fStoppedTimestamp;
        private Object fElement;

        public RetrievalTask(Object element) {
            this.fElement = element;
        }

        public abstract String getDescription();

        public abstract void retrieve(IProgressMonitor var1) throws TeamRepositoryException;

        public Object getParentElement() {
            return this.fElement;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }

        public long getElapsedTime() {
            if (this.fStartedTimestamp > 0L) {
                return (this.fStoppedTimestamp > 0L ? this.fStoppedTimestamp : System.currentTimeMillis()) - this.fStartedTimestamp;
            }
            return 0L;
        }

        /*
         * Loose catch block
         */
        public IStatus run(IProgressMonitor monitor) {
            block10: {
                this.fStatus = Status.OK_STATUS;
                try {
                    try {
                        this.started();
                        this.retrieve(monitor);
                        if (monitor.isCanceled()) {
                            this.fStatus = Status.CANCEL_STATUS;
                        }
                    }
                    catch (PermissionDeniedException permissionDeniedException) {
                        this.fStatus = new Status(2, "com.ibm.team.workitem.rcp.ui", Messages.ResultRetrievalStrategy_NO_PERMISSIONS);
                        this.stopped();
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        this.fStatus = new Status(2, "com.ibm.team.workitem.rcp.ui", Messages.ResultRetrievalStrategy_NOT_FOUND);
                        this.stopped();
                    }
                    catch (TeamRepositoryException e) {
                        this.fStatus = new Status(4, "com.ibm.team.workitem.rcp.ui", e.getLocalizedMessage(), (Throwable)e);
                        this.stopped();
                        break block10;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this.stopped();
                }
            }
            return this.fStatus;
        }

        private void started() {
            this.fStartedTimestamp = System.currentTimeMillis();
        }

        private void stopped() {
            this.fStoppedTimestamp = System.currentTimeMillis();
        }
    }
}

