/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModel;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultModelListener;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultModelChangedEvent;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultModelContentProvider
implements ILazyTreePathContentProvider,
IResultModelListener {
    private static boolean USE_WORKAROUND = "carbon".equals(SWT.getPlatform());
    private Runnable fRefreshRunnable = new Runnable(){

        public void run() {
            if (ResultModelContentProvider.this.fTreeViewer != null && !ResultModelContentProvider.this.fTreeViewer.getControl().isDisposed()) {
                ResultModelContentProvider.this.fTreeViewer.refresh();
            }
        }
    };
    private TreeViewer fTreeViewer;
    private IResultRetrievalStrategy fRetrievalStrategy;

    public void updateElement(TreePath parentPath, int index) {
        Object element = this.fRetrievalStrategy.getResultModel().getChild(parentPath.getLastSegment(), index);
        this.fTreeViewer.replace((Object)parentPath, index, element);
        int childCount = this.fRetrievalStrategy.retrieve(element);
        this.fTreeViewer.setChildCount((Object)parentPath.createChildPath(element), childCount);
    }

    public void updateChildCount(TreePath treePath, int currentChildCount) {
        int childCount = this.fRetrievalStrategy.retrieve(treePath.getLastSegment());
        this.fTreeViewer.setChildCount((Object)treePath, childCount);
    }

    public void updateHasChildren(TreePath path) {
        int childCount = this.fRetrievalStrategy.retrieve(path.getLastSegment());
        this.fTreeViewer.setHasChildren((Object)path, childCount > 0);
    }

    public TreePath[] getParents(Object element) {
        LinkedList<TreePath> parentPaths = new LinkedList<TreePath>();
        this.buildTreePaths(parentPaths, new TreePath(new Object[]{element}));
        int i = 0;
        TreePath[] parents = new TreePath[parentPaths.size()];
        for (TreePath treePath : parentPaths) {
            TreePath path = this.reverseTreePath(treePath).getParentPath();
            TreePath treePath2 = parents[i++] = path == null ? TreePath.EMPTY : path;
        }
        return parents;
    }

    private TreePath reverseTreePath(TreePath treePath) {
        Object[] segments = new Object[treePath.getSegmentCount()];
        int i = 0;
        while (i < treePath.getSegmentCount()) {
            segments[i] = treePath.getSegment(treePath.getSegmentCount() - i - 1);
            ++i;
        }
        return new TreePath(segments);
    }

    private void buildTreePaths(List<TreePath> paths, TreePath path) {
        Object[] parents = this.fRetrievalStrategy.getResultModel().getParents(path.getLastSegment());
        int i = 0;
        while (i < parents.length) {
            if (parents[i] == null || this.contains(path, parents[i])) {
                paths.add(path);
            } else {
                this.buildTreePaths(paths, path.createChildPath(parents[i]));
            }
            ++i;
        }
    }

    private boolean contains(TreePath path, Object object) {
        int i = 0;
        while (i < path.getSegmentCount()) {
            if (path.getSegment(i) == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fTreeViewer = (TreeViewer)viewer;
        this.removeListeners(this.fRetrievalStrategy);
        this.fRetrievalStrategy = (IResultRetrievalStrategy)newInput;
        this.addListeners(this.fRetrievalStrategy);
        if (this.fRetrievalStrategy != null && !this.fRetrievalStrategy.hasRun()) {
            this.fRetrievalStrategy.refresh();
        }
    }

    private void addListeners(IResultRetrievalStrategy strategy) {
        if (strategy != null) {
            strategy.getResultModel().addListener(this);
            strategy.connect();
        }
    }

    private void removeListeners(IResultRetrievalStrategy strategy) {
        if (strategy != null) {
            strategy.getResultModel().removeListener(this);
            strategy.disconnect();
        }
    }

    @Override
    public void modelChanged(final ResultModelChangedEvent event) {
        this.postUpdate(new Runnable(){

            public void run() {
                ResultModelContentProvider.this.handleEvent(event);
            }
        }, false);
    }

    public void dispose() {
        this.removeListeners(this.fRetrievalStrategy);
    }

    private void handleEvent(ResultModelChangedEvent event) {
        Object parent;
        if (this.fRetrievalStrategy == null) {
            return;
        }
        if (event.isType(2)) {
            if (event.getParent() == IResultModel.ROOT) {
                this.postDelayedRefresh();
            } else {
                this.fTreeViewer.update(event.getParent(), null);
            }
            return;
        }
        if (event.isType(3) || event.isType(4)) {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Object object = parent = event.getParent() == null ? this.fRetrievalStrategy : event.getParent();
        if (event.isType(5) && IResultModel.ROOT == event.getParent()) {
            this.fTreeViewer.setChildCount(parent, 0);
            this.fRetrievalStrategy.refresh();
        } else {
            int count = this.fRetrievalStrategy.getResultModel().getChildCount(event.getParent());
            this.fTreeViewer.setChildCount(parent, count);
            if (USE_WORKAROUND) {
                int sortDirection = this.fTreeViewer.getTree().getSortDirection();
                try {
                    this.fTreeViewer.getTree().setSortDirection(0);
                    this.fTreeViewer.refresh(event.getParent());
                }
                finally {
                    this.fTreeViewer.getTree().setSortDirection(sortDirection);
                }
            } else {
                this.fTreeViewer.refresh(event.getParent());
            }
        }
    }

    private void postUpdate(Runnable runnable, boolean forceAsync) {
        if (this.fTreeViewer == null) {
            return;
        }
        if (!forceAsync && Display.getCurrent() != null) {
            runnable.run();
            return;
        }
        Control tree = this.fTreeViewer.getControl();
        if (!tree.isDisposed()) {
            tree.getDisplay().asyncExec(runnable);
        }
    }

    private void postDelayedRefresh() {
        Control tree = this.fTreeViewer.getControl();
        if (!tree.isDisposed()) {
            tree.getDisplay().timerExec(500, this.fRefreshRunnable);
        }
    }
}

