/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.internal.queries.ExpressionDescriptionGenerator;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AbstractWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QueryWorkItemRetrievalStrategy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueryWorkItemSource
extends AbstractWorkItemSource {
    private Query fQuery;
    private IWorkItemRetrievalStrategy fRetrievalStrategy;
    private ExpressionDescriptionGenerator fGenerator;
    private boolean fIsResolved;

    public QueryWorkItemSource(Query query) {
        Assert.isNotNull((Object)query);
        this.fQuery = query;
        this.fRetrievalStrategy = new QueryWorkItemRetrievalStrategy(query.getTeamRepository(), query.getExpression(), query.getName());
        this.fIsResolved = false;
    }

    public String getName() {
        if (this.fGenerator != null) {
            return this.fGenerator.getDescription();
        }
        return this.fQuery.getName();
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        String name = this.fQuery.getName();
        if (name == null || name.length() == 0) {
            ExpressionDescriptionGenerator generator = new ExpressionDescriptionGenerator(this.getProjectArea(), this.fQuery.getExpression());
            generator.resolve(monitor);
            this.fGenerator = generator;
        }
        this.fIsResolved = true;
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    public ITeamRepository getTeamRepository() {
        return this.fQuery.getTeamRepository();
    }

    public IProjectAreaHandle getProjectArea() {
        return QueryUtils.getProjectArea((Expression)this.fQuery.getExpression());
    }

    public IWorkItemRetrievalStrategy getRetrievalStrategy() {
        return this.fRetrievalStrategy;
    }

    public Object getDefinition() {
        return this.fQuery;
    }

    public boolean isScored() {
        return QueryUtils.isFullTextExpression((Expression)this.fQuery.getExpression());
    }

    public QueryView getView(String defaultViewId) {
        return this.computeView(this.fQuery.getExpression(), defaultViewId, this.fQuery.getName());
    }

    public boolean isEditable() {
        return this.getProjectArea() != null && !this.containsUnsupportedExpressions(this.fQuery.getExpression());
    }

    public Expression getExpression() {
        return this.fQuery.getExpression();
    }
}

