/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.ui.internal.viewer.AbstractWorkItemSource;
import com.ibm.team.workitem.rcp.ui.internal.viewer.IWorkItemRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.QueryWorkItemRetrievalStrategy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class QueryDescriptorWorkItemSource
extends AbstractWorkItemSource {
    private IQueryDescriptorHandle fQueryDescriptorHandle;
    private IQueryDescriptor fQueryDescriptor;
    private IWorkItemRetrievalStrategy fRetrievalStrategy;
    private boolean fIsResolved = false;

    public QueryDescriptorWorkItemSource(IQueryDescriptorHandle queryDescriptorHandle) {
        this.fQueryDescriptorHandle = queryDescriptorHandle;
    }

    public Object getDefinition() {
        return this.fQueryDescriptorHandle;
    }

    public String getName() {
        Assert.isTrue((boolean)this.isResolved());
        return this.fQueryDescriptor.getName();
    }

    public IWorkItemRetrievalStrategy getRetrievalStrategy() {
        Assert.isTrue((boolean)this.isResolved());
        if (this.fRetrievalStrategy == null) {
            this.fRetrievalStrategy = new QueryWorkItemRetrievalStrategy(this.getTeamRepository(), this.fQueryDescriptor.getExpression(), this.fQueryDescriptor.getName());
        }
        return this.fRetrievalStrategy;
    }

    public ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fQueryDescriptorHandle.getOrigin();
    }

    public IProjectAreaHandle getProjectArea() {
        Assert.isTrue((boolean)this.isResolved());
        return this.fQueryDescriptor.getProjectArea();
    }

    public boolean isScored() {
        Assert.isTrue((boolean)this.isResolved());
        return QueryUtils.isFullTextExpression((Expression)this.fQueryDescriptor.getExpression());
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isResolved()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.QueryDescriptorWorkItemSource_FETCHING_QUERY, 10);
        IAuditableClient auditableClient = (IAuditableClient)this.getTeamRepository().getClientLibrary(IAuditableClient.class);
        this.fQueryDescriptor = (IQueryDescriptor)auditableClient.fetchCurrentAuditable((IAuditableHandle)this.fQueryDescriptorHandle, IQueryDescriptor.FULL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.fIsResolved = true;
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    public QueryView getView(String defaultViewId) {
        Assert.isTrue((boolean)this.isResolved());
        return this.computeView(this.fQueryDescriptor.getExpression(), defaultViewId, this.fQueryDescriptor.getItemId().getUuidValue());
    }

    public Expression getExpression() {
        Assert.isTrue((boolean)this.isResolved());
        return this.fQueryDescriptor.getExpression();
    }
}

