/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumnFactory;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeColumnManager {
    private AttributeColumnFactory fFactory;
    private List<AttributeColumn.Constraint> fConstraints;

    public void setConstraints(List<AttributeColumn.Constraint> constraints) {
        this.fConstraints = constraints;
    }

    public List<AttributeColumn> getAttributeColumns(ITeamRepository repository, IProjectAreaHandle projectAreaFilter, QueryView view) {
        this.initAttributeColumnFactory(repository, projectAreaFilter);
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>();
        QueryViewColumn[] queryViewColumnArray = view.getColumns();
        int n = queryViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryViewColumn viewColumn = queryViewColumnArray[n2];
            AttributeColumn column = this.fFactory.getColumn(viewColumn.getAttributeIdentifier());
            if (column != null) {
                columns.add(column);
            }
            ++n2;
        }
        this.applyConstraints(columns);
        return columns;
    }

    private void applyConstraints(ArrayList<AttributeColumn> columns) {
        for (AttributeColumn.Constraint constraint : this.fConstraints) {
            AttributeColumn column = this.fFactory.getColumn(constraint.getIdentifier());
            if (column == null) continue;
            columns.remove(column);
            if (constraint.getIndex() <= -1) continue;
            columns.add(constraint.getIndex(), column);
        }
    }

    private void initAttributeColumnFactory(final ITeamRepository repository, final IProjectAreaHandle projectArea) {
        try {
            WorkItemRCPUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AttributeColumnManager.this.fFactory = AttributeColumnFactory.getInstance(repository, projectArea, monitor);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.AttributeColumnManager_CANNOT_RESOLVE_ATTRIBUTES, e);
        }
        catch (InterruptedException interruptedException) {}
    }
}

