/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.viewer;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.ResultSize;
import com.ibm.team.workitem.rcp.ui.internal.viewer.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ResultRetrievalStrategy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.WorkItemRetrievalStrategy;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ArrayWorkItemRetrievalStrategy
extends WorkItemRetrievalStrategy {
    private IWorkItemHandle[] fHandles;
    private boolean fHasRun = false;

    public ArrayWorkItemRetrievalStrategy(IWorkItemHandle[] workItems) {
        Assert.isNotNull((Object)workItems);
        this.fHandles = workItems;
    }

    protected ResultRetrievalStrategy.RetrievalTask getRootRetrievalTask() {
        return new ResultRetrievalStrategy.RetrievalTask(null){

            public String getDescription() {
                return Messages.ArrayWorkItemRetrievalStrategy_RESOLVING_WORKITEMS;
            }

            public void retrieve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(Messages.ArrayWorkItemRetrievalStrategy_RESOLVING_WORKITEMS, 10);
                    ArrayWorkItemRetrievalStrategy.this.addWorkItems(null, Arrays.asList(ArrayWorkItemRetrievalStrategy.this.fHandles), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                finally {
                    monitor.done();
                    ArrayWorkItemRetrievalStrategy.this.fHasRun = true;
                }
            }
        };
    }

    public SortCriteria[] getSortCriteria() {
        return new SortCriteria[0];
    }

    public void setSortCriteria(SortCriteria[] criteria) {
    }

    public boolean hasRun() {
        return this.fHasRun;
    }

    public ResultSize getExpectedResultSize() {
        return new ResultSize(this.fHandles.length, -1);
    }
}

