/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryOperationRunnable<T> {
    private IStatus fStatus;

    public T run(IRunnableContext context) {
        try {
            final ArrayList result = new ArrayList(1);
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result.add(RepositoryOperationRunnable.this.performOperation(monitor));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.fStatus = Status.OK_STATUS;
            return (T)result.get(0);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = this.getErrorMessage(cause);
            if (message == null) {
                message = cause.getLocalizedMessage();
            }
            this.fStatus = new Status(4, "com.ibm.team.workitem.rcp.ui", message, cause);
            WorkItemRCPUIPlugin.getDefault().log(this.fStatus);
        }
        catch (InterruptedException interruptedException) {
            this.fStatus = Status.CANCEL_STATUS;
        }
        return null;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    protected String getErrorMessage(Throwable e) {
        return null;
    }

    protected abstract T performOperation(IProgressMonitor var1) throws TeamRepositoryException;
}

