/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.tags;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IGroupCount;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.tags.HistoryManager;
import com.ibm.team.workitem.rcp.ui.internal.tags.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class WorkItemTagView
extends ViewPart {
    private static final int LAYERS = 6;
    private static final String TAG_CLOUD_FOREGROUND_COLOR = "com.ibm.team.workitem.rcp.ui.tagColorForeground";
    private static int fgNumberOfOpenTagCloudView = 1;
    private final TagInfo fTagInfo = new TagInfo(6);
    private IQueryDescriptor fQueryDescriptor;
    private Composite fTagCloud;
    private ResourceManager fResourceManager;
    private FontDescriptor[] fFontDescriptors;
    private final ClickListener fClickListener = new ClickListener();
    private Action fRefreshAction;
    private Action fNewTagCloudAction;
    private HistoryManager fHistoryManager;
    private FoundationJob fLoadJob;

    public WorkItemTagView() {
        ++fgNumberOfOpenTagCloudView;
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 512);
        this.fTagCloud = new Composite((Composite)scrolled, 0);
        scrolled.setContent((Control)this.fTagCloud);
        this.fTagCloud.setBackground(this.fTagCloud.getDisplay().getSystemColor(25));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.wrap = true;
        rowLayout.spacing = 6;
        this.fTagCloud.setLayout((Layout)rowLayout);
        scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WorkItemTagView.this.updateTagCloudSize();
            }
        });
        this.addDropSupport((Control)this.fTagCloud);
        this.makeActions();
        this.contributeToActionBars();
        Link emptyInfo = new Link(this.fTagCloud, 0);
        emptyInfo.setBackground(emptyInfo.getDisplay().getSystemColor(25));
        emptyInfo.setText(Messages.WorkItemTagView_EMPTY_VIEW_DESCRIPTION);
        emptyInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WorkItemTagView.this.getViewSite().getPage().showView("com.ibm.team.process.rcp.ui.teamArtifactsNavigator", null, 1);
                }
                catch (PartInitException x) {
                    ErrorDialog.openError((Shell)WorkItemTagView.this.getViewSite().getShell(), (String)Messages.WorkItemTagView_PROBLEM_OPENING_TA_TITLE, (String)Messages.WorkItemTagView_PROBLEM_OPENING_TA_DESCRIPTION, (IStatus)x.getStatus());
                }
            }
        });
        this.updateDescription(null, -1);
        HelpContextIds.hookHelpListener((Control)scrolled, "com.ibm.team.workitem.rcp.ui.work_item_tag_view");
    }

    private void updateTagCloudSize() {
        Point parentSize = this.fTagCloud.getParent().getSize();
        Point cloudSize = this.fTagCloud.computeSize(parentSize.x, -1);
        this.fTagCloud.setSize(cloudSize.x, Math.max(cloudSize.y, parentSize.y));
    }

    private void addDropSupport(Control control) {
        DropTarget target = new DropTarget(control, 22);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                WorkItemTagView.this.onDrop(selection);
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = WorkItemTagView.this.getQueryDescriptor(LocalSelectionTransfer.getTransfer().getSelection()) == null ? 0 : 4;
            }
        });
    }

    private IQueryDescriptor getQueryDescriptor(ISelection selection) {
        Object[] elements = ((IStructuredSelection)selection).toArray();
        if (elements.length != 1) {
            return null;
        }
        if (elements[0] instanceof IQueryDescriptor) {
            return (IQueryDescriptor)elements[0];
        }
        return null;
    }

    public void onDrop(ISelection objSelection) {
        IQueryDescriptor descriptor = this.getQueryDescriptor(objSelection);
        if (descriptor != null) {
            this.fHistoryManager.setInput(descriptor);
        }
    }

    public void setInput(IQueryDescriptor descriptor) {
        this.fQueryDescriptor = descriptor;
        this.fRefreshAction.setEnabled(this.fQueryDescriptor != null);
        this.reloadQueries();
    }

    private void reloadQueries() {
        this.setContentDescription(NLS.bind((String)Messages.WorkItemTagView_COMPUTING_TAG_CLOUD_FOR, (Object)this.fQueryDescriptor.getName()));
        if (this.fLoadJob != null) {
            this.fLoadJob.cancel();
        }
        this.fLoadJob = new FoundationJob(Messages.WorkItemTagView_COMPUTING_TAG_CLOUD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(final IProgressMonitor monitor) {
                try {
                    final String[] name = new String[1];
                    final int[] size = new int[1];
                    if (WorkItemTagView.this.fQueryDescriptor != null && !monitor.isCanceled()) {
                        name[0] = WorkItemTagView.this.fQueryDescriptor.getName();
                        ITeamRepository teamRepository = (ITeamRepository)WorkItemTagView.this.fQueryDescriptor.getOrigin();
                        IQueryClient queryClient = (IQueryClient)teamRepository.getClientLibrary(IQueryClient.class);
                        List groupCounts = queryClient.getGroupCounts(WorkItemTagView.this.fQueryDescriptor.getProjectArea(), WorkItemTagView.this.fQueryDescriptor.getExpression(), IWorkItem.TAGS_PROPERTY, monitor);
                        size[0] = queryClient.countQueryResults(WorkItemTagView.this.fQueryDescriptor, monitor);
                        TagInfo tagInfo = WorkItemTagView.this.fTagInfo;
                        synchronized (tagInfo) {
                            WorkItemTagView.this.fTagInfo.clear();
                            for (IGroupCount groupCount : groupCounts) {
                                WorkItemTagView.this.fTagInfo.process(groupCount);
                            }
                        }
                    }
                    if (!monitor.isCanceled()) {
                        TagInfo tagInfo = WorkItemTagView.this.fTagInfo;
                        synchronized (tagInfo) {
                            WorkItemTagView.this.fTagInfo.clear();
                        }
                    }
                    if (WorkItemTagView.this.fTagCloud != null && !WorkItemTagView.this.fTagCloud.isDisposed() && !monitor.isCanceled()) {
                        WorkItemTagView.this.fTagCloud.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (!monitor.isCanceled()) {
                                    WorkItemTagView.this.updateView(name[0], size[0]);
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.rcp.tags", 0, x.getMessage(), (Throwable)x);
                }
            }
        };
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getViewSite().getAdapter(IWorkbenchSiteProgressService.class);
        service.schedule((Job)this.fLoadJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateView(String name, int size) {
        if (this.fTagCloud != null && !this.fTagCloud.isDisposed()) {
            this.fTagCloud.setRedraw(false);
            try {
                Control[] children;
                Control[] controlArray = children = this.fTagCloud.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    element.removeMouseListener((MouseListener)this.fClickListener);
                    element.dispose();
                    ++n2;
                }
                TagInfoEntry[] entries = null;
                TagInfo tagInfo = this.fTagInfo;
                synchronized (tagInfo) {
                    entries = this.fTagInfo.getEntries();
                }
                if (entries != null) {
                    TagInfoEntry[] tagInfoEntryArray = entries;
                    int n3 = entries.length;
                    n = 0;
                    while (n < n3) {
                        TagInfoEntry tagInfoEntry = tagInfoEntryArray[n];
                        final Label label = new Label(this.fTagCloud, 0);
                        label.setData((Object)tagInfoEntry);
                        label.setText(tagInfoEntry.toString());
                        label.setFont(this.getLayerFont(tagInfoEntry.layer));
                        label.setBackground(label.getDisplay().getSystemColor(25));
                        label.setForeground(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(TAG_CLOUD_FOREGROUND_COLOR));
                        label.setToolTipText(NLS.bind((String)Messages.WorkItemTagView_SHOW_WORKITEM_WITH_TAG, (Object)tagInfoEntry.tag));
                        label.addMouseListener((MouseListener)this.fClickListener);
                        label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){
                            private Cursor fOriginalCursor;

                            public void mouseExit(MouseEvent e) {
                                label.setCursor(this.fOriginalCursor);
                                this.fOriginalCursor = null;
                            }

                            public void mouseEnter(MouseEvent e) {
                                this.fOriginalCursor = label.getCursor();
                                label.setCursor(label.getDisplay().getSystemCursor(21));
                            }
                        });
                        ++n;
                    }
                }
            }
            finally {
                this.updateTagCloudSize();
                this.fTagCloud.layout(true);
                this.fTagCloud.setRedraw(true);
                this.updateDescription(name, size);
            }
        }
    }

    private void updateDescription(String queryName, int resultSize) {
        if (queryName == null || queryName.trim().length() == 0) {
            this.setContentDescription(Messages.WorkItemTagView_NO_QUERY);
        } else {
            this.setContentDescription(NLS.bind((String)Messages.WorkItemTagView_WORKITEMS_QUERYNAME, (Object)resultSize, (Object)queryName));
        }
    }

    private Font getLayerFont(int layer) {
        FontDescriptor descriptor;
        Font font;
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));
            Font defaultFont = JFaceResources.getDefaultFont();
            this.fFontDescriptors = new FontDescriptor[6];
            int i = 0;
            while (i < this.fFontDescriptors.length) {
                FontDescriptor descriptor2 = FontDescriptor.createFrom((Font)defaultFont);
                descriptor2 = descriptor2.setStyle(1);
                this.fFontDescriptors[i] = descriptor2 = descriptor2.increaseHeight(i * 2);
                ++i;
            }
        }
        if ((font = (Font)this.fResourceManager.find((DeviceResourceDescriptor)(descriptor = this.fFontDescriptors[layer]))) == null) {
            font = this.fResourceManager.createFont(descriptor);
        }
        return font;
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.fHistoryManager = null;
        if (this.fLoadJob != null) {
            this.fLoadJob.cancel();
        }
        super.dispose();
    }

    public void setFocus() {
        this.fTagCloud.setFocus();
    }

    private void makeActions() {
        this.fRefreshAction = new Action(){

            public void run() {
                WorkItemTagView.this.reloadQueries();
            }
        };
        this.fRefreshAction.setText(Messages.WorkItemTagView_REFRESH);
        this.fRefreshAction.setToolTipText(Messages.WorkItemTagView_REFRESH_CLOUD);
        this.fRefreshAction.setImageDescriptor(WorkItemRCPUIPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.fRefreshAction.setEnabled(false);
        this.fNewTagCloudAction = new Action(){

            public void run() {
                IWorkbenchPage page = WorkItemTagView.this.getViewSite().getPage();
                try {
                    String partId = WorkItemTagView.this.getViewSite().getId();
                    String secondaryId = NLS.bind((String)"{0}.{1}", (Object)partId, (Object)fgNumberOfOpenTagCloudView);
                    page.showView(partId, secondaryId, 1);
                }
                catch (PartInitException x) {
                    ErrorDialog.openError((Shell)WorkItemTagView.this.getViewSite().getShell(), (String)Messages.WorkItemTagView_PROBLEM_OPENING_CLOUD_TITLE, (String)Messages.WorkItemTagView_PROBLEM_OPENING_CLOUD_DESCRIPTION, (IStatus)x.getStatus());
                }
            }
        };
        this.fNewTagCloudAction.setText(Messages.WorkItemTagView_NEW_CLOUD_TAG);
        this.fNewTagCloudAction.setToolTipText(Messages.WorkItemTagView_NEW_CLOUD_TAG_TOOLTIP);
        this.fNewTagCloudAction.setImageDescriptor(WorkItemRCPUIPlugin.getImageDescriptor("icons/elcl16/crt_tagcloud.gif"));
        this.fNewTagCloudAction.setEnabled(true);
        this.fHistoryManager = new HistoryManager(this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.fNewTagCloudAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRefreshAction);
        this.fHistoryManager.installActions(manager);
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        private IAuditableClient getAuditableClient() {
            ITeamRepository repository = (ITeamRepository)WorkItemTagView.this.fQueryDescriptor.getOrigin();
            if (repository != null) {
                return (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
            }
            return null;
        }

        private IProjectAreaHandle getProjectArea(IProgressMonitor monitor) throws TeamRepositoryException {
            IQueryDescriptor handle = WorkItemTagView.this.fQueryDescriptor;
            if (handle != null) {
                IQueryDescriptor descriptor = (IQueryDescriptor)this.getAuditableClient().resolveAuditable((IAuditableHandle)handle, ItemProfile.createProfile((IItemType)IQueryDescriptor.ITEM_TYPE, (String[])new String[]{IQueryDescriptor.PROJECTAREA_PROPERTY}), monitor);
                return descriptor.getProjectArea();
            }
            return null;
        }

        public void mouseUp(MouseEvent e) {
            Object data = e.widget.getData();
            if (data instanceof TagInfoEntry) {
                final TagInfoEntry entry = (TagInfoEntry)data;
                FoundationJob job = new FoundationJob(Messages.WorkItemTagView_RUNNING_QUERY){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.WorkItemTagView_RUNNING_QUERY, 100);
                            IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
                            IQueryableAttribute tagAttribute = factory.findAttribute(ClickListener.this.getProjectArea((IProgressMonitor)new SubProgressMonitor(monitor, 200)), IWorkItem.TAGS_PROPERTY, (IAuditableCommon)ClickListener.this.getAuditableClient(), (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                            IQueryableAttribute idAttribute = factory.findAttribute(ClickListener.this.getProjectArea((IProgressMonitor)new SubProgressMonitor(monitor, 200)), IWorkItem.ID_PROPERTY, (IAuditableCommon)ClickListener.this.getAuditableClient(), (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                            Expression tagExpression = null;
                            if (entry.untagged) {
                                AttributeType tagType = AttributeTypes.getAttributeType((String)"tags");
                                tagExpression = this.createUntaggedExpression(tagAttribute, tagType);
                            } else {
                                tagExpression = new AttributeExpression(tagAttribute, AttributeOperation.EQUALS, (Object)entry.tag);
                            }
                            if (tagExpression != null) {
                                Term term = new Term(0, new Expression[]{WorkItemTagView.this.fQueryDescriptor.getExpression(), tagExpression});
                                SortCriteria sortById = new SortCriteria(idAttribute, true);
                                Statement statement = new Statement(new SelectClause(), (Expression)term, new SortCriteria[]{sortById});
                                QueriesUI.showQueryResults(WorkItemTagView.this.getSite().getWorkbenchWindow(), (ITeamRepository)WorkItemTagView.this.fQueryDescriptor.getOrigin(), entry.tag, (Expression)statement);
                            } else {
                                QueriesUI.showQueryResults(WorkItemTagView.this.getSite().getWorkbenchWindow(), (IQueryDescriptorHandle)WorkItemTagView.this.fQueryDescriptor);
                            }
                            return Status.OK_STATUS;
                        }
                        catch (TeamRepositoryException x) {
                            return new Status(4, "com.ibm.team.workitem.rcp.tags", 0, x.getMessage(), (Throwable)x);
                        }
                    }

                    private Expression createUntaggedExpression(IQueryableAttribute tagAttribute, AttributeType tagType) {
                        TagInfoEntry[] entries;
                        ArrayList<AttributeExpression> expression = new ArrayList<AttributeExpression>();
                        TagInfoEntry[] tagInfoEntryArray = entries = WorkItemTagView.this.fTagInfo.getEntries();
                        int n = entries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TagInfoEntry entry2 = tagInfoEntryArray[n2];
                            if (!entry2.untagged) {
                                expression.add(new AttributeExpression(tagAttribute, AttributeOperation.NOT_CONTAINS, (Object)entry2.tag));
                            }
                            ++n2;
                        }
                        if (!expression.isEmpty()) {
                            return new Term(0, expression.toArray(new Expression[expression.size()]));
                        }
                        return null;
                    }
                };
                job.schedule();
            }
        }
    }

    private static class TagInfo {
        private static String UNTAGGED = Messages.WorkItemTagView_UNTAGGED;
        private final HashMap<String, Integer> fInfoMap = new HashMap();
        private int fLowerBound;
        private int fUpperBound;
        private TagInfoEntry[] fCachedComputedEntries;
        private final int fNumberOfLayers;

        public TagInfo(int numberOfLayers) {
            this.fNumberOfLayers = numberOfLayers;
        }

        private void add(String tag, int count) {
            Integer oldCount = this.fInfoMap.get(tag);
            if (oldCount == null) {
                this.fInfoMap.put(tag, count);
            } else {
                this.fInfoMap.put(tag, oldCount + count);
            }
        }

        private TagInfoEntry[] computeEntries() {
            TagInfoEntry[] entries = new TagInfoEntry[this.fInfoMap.size()];
            Iterator<Map.Entry<String, Integer>> e = this.fInfoMap.entrySet().iterator();
            int i = 0;
            while (i < entries.length) {
                Map.Entry<String, Integer> entry = e.next();
                String tag = entry.getKey();
                int count = entry.getValue();
                entries[i] = new TagInfoEntry(tag, count, UNTAGGED.equals(tag));
                this.fLowerBound = this.fLowerBound == -1 ? count : Math.min(this.fLowerBound, count);
                this.fUpperBound = this.fUpperBound == -1 ? count : Math.max(this.fUpperBound, count);
                ++i;
            }
            final Collator coll = Collator.getInstance();
            coll.setStrength(1);
            Arrays.sort(entries, new Comparator<TagInfoEntry>(){

                @Override
                public int compare(TagInfoEntry entry1, TagInfoEntry entry2) {
                    return coll.compare(entry1.tag, entry2.tag);
                }
            });
            this.assignLayers(entries);
            return entries;
        }

        private void assignLayers(TagInfoEntry[] entries) {
            int layerSize = Math.max(1, (this.fUpperBound - this.fLowerBound) / this.fNumberOfLayers);
            TagInfoEntry[] tagInfoEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                TagInfoEntry tagInfoEntry = tagInfoEntryArray[n2];
                int layer = (tagInfoEntry.count - this.fLowerBound) / layerSize;
                tagInfoEntry.layer = Math.min(layer, this.fNumberOfLayers - 1);
                ++n2;
            }
        }

        public TagInfoEntry[] getEntries() {
            if (this.fCachedComputedEntries == null) {
                this.fCachedComputedEntries = this.computeEntries();
            }
            return this.fCachedComputedEntries;
        }

        public void clear() {
            this.fInfoMap.clear();
            this.fCachedComputedEntries = null;
            this.fLowerBound = -1;
            this.fUpperBound = -1;
        }

        public void process(IGroupCount groupCount) {
            SeparatedStringList tags = new SeparatedStringList(groupCount.getKey());
            int count = groupCount.getCount();
            if (!tags.isEmpty()) {
                for (String string : tags) {
                    this.add(string, count);
                }
            } else {
                this.add(UNTAGGED, count);
            }
        }
    }

    private static class TagInfoEntry {
        private static final String SEGMENT_CHARACTERS = "()";
        public String tag;
        public int count;
        public int layer;
        public boolean untagged;

        public TagInfoEntry(String tag, int count, boolean untagged) {
            this.tag = tag;
            this.count = count;
            this.untagged = untagged;
        }

        public String toString() {
            return TextProcessor.process((String)NLS.bind((String)Messages.WorkItemTagView_TAG_COUNT, (Object)this.tag, (Object)this.count), (String)SEGMENT_CHARACTERS);
        }
    }
}

