/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.tags;

import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.tags.Messages;
import com.ibm.team.workitem.rcp.ui.internal.tags.WorkItemTagView;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HistoryManager {
    public static final int HISTORY_SIZE = 20;
    private final LinkedList<IQueryDescriptor> fHistory = new LinkedList();
    private IQueryDescriptor fCurrent;
    private HistoryDropDownAction fHistoryDropDownAction;
    private final WorkItemTagView fView;

    public HistoryManager(WorkItemTagView view) {
        this.fView = view;
    }

    protected void refresh() {
        this.fHistoryDropDownAction.setEnabled(this.fHistory.size() > 0);
        this.fView.setInput(this.fCurrent);
    }

    public void installActions(IToolBarManager toolBarManager) {
        this.fHistoryDropDownAction = new HistoryDropDownAction();
        this.fHistoryDropDownAction.setEnabled(false);
        this.fHistoryDropDownAction.setText(Messages.HistoryManager_QUERY_HISTORY);
        this.fHistoryDropDownAction.setToolTipText(Messages.HistoryManager_QUERY_HISTORY_TOOLTIP);
        toolBarManager.add((IAction)this.fHistoryDropDownAction);
    }

    public void setInput(IQueryDescriptor descriptor) {
        if (descriptor != null) {
            this.fHistory.remove(descriptor);
            this.fHistory.add(0, descriptor);
            if (this.fHistory.size() > 20) {
                this.fHistory.removeLast();
            }
            this.fCurrent = descriptor;
        }
        this.refresh();
    }

    private class HistoryDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public HistoryDropDownAction() {
            this.setImageDescriptor(ImagePool.HISTORY_ENABLED_ICON);
            this.setDisabledImageDescriptor(ImagePool.HISTORY_DISABLED_ICON);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            for (IQueryDescriptor descriptor : HistoryManager.this.fHistory) {
                ShowQueryAction action = new ShowQueryAction(descriptor);
                action.setText(descriptor.getName());
                action.setChecked(HistoryManager.this.fCurrent != null && HistoryManager.this.fCurrent.equals((Object)descriptor));
                this.addActionToMenu(this.fMenu, action);
            }
            new MenuItem(this.fMenu, 2);
            Action clearHistoryAction = new Action(){

                public void run() {
                    HistoryManager.this.fHistory.clear();
                    HistoryDropDownAction.this.setEnabled(false);
                }
            };
            clearHistoryAction.setText(Messages.HistoryManager_CLEAR_HISTORY);
            this.addActionToMenu(this.fMenu, clearHistoryAction);
            return this.fMenu;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    class ShowQueryAction
    extends Action {
        private final IQueryDescriptor fDescriptor;

        public ShowQueryAction(IQueryDescriptor descriptor) {
            this.fDescriptor = descriptor;
        }

        public void run() {
            HistoryManager.this.fCurrent = this.fDescriptor;
            HistoryManager.this.refresh();
        }
    }
}

